source ("dislin.R")

n <- 100
zmat <- matrix (0, n, n)

fpi <- 3.1415926 / 180
stp <- 360.0 / (n - 1)
  
for (i in 1:n)
{ x <- (i - 1) * stp
  for (j in 1:n)
  { y <- (j - 1) * stp
    zmat [i,j] <- 2 * sin (x * fpi) * sin (y * fpi)
  }
}

Dislin.metafl ("xwin")
Dislin.disini ()
Dislin.pagera ()
Dislin.hwfont ()

Dislin.titlin ("3-D Colour Plot of the Function", 1)
Dislin.titlin ("F(X,Y) = 2 * SIN(X) * SIN(Y)", 3)
Dislin.name   ("X-axis", "X")
Dislin.name   ("Y-axis", "Y")
Dislin.name   ("Z-axis", "Z")

Dislin.axspos (300, 1850)
Dislin.ax3len (2200, 1400, 1400)

Dislin.intax  ()    
Dislin.autres (n, n)
Dislin.graf3  (0.0, 360.0, 0.0, 90.0, 0.0, 360.0, 0.0, 90.0,
              -2.0, 2.0, -2.0, 1.0)
Dislin.crvmat (zmat, n, n, 1, 1) 

Dislin.height (50)
Dislin.title  ()
Dislin.disfin ()
