#INCLUDE "dislin.bi"

DECLARE FUNCTION myfunc CDECL (BYVAL AS SINGLE, BYVAL AS SINGLE,  _
                               BYVAL as INTEGER) AS SINGLE

DIM AS SINGLE pi, stp, pi2
pi  = 3.1415927

Dislin.scrmod ("revers")
Dislin.metafl ("cons")
Dislin.setpag ("da4p")
Dislin.disini ()
Dislin.pagera ()
Dislin.complx ()

Dislin.titlin ("Surface Plot of the Parametric Function", 2)
Dislin.titlin ("[COS(t)*(3+COS(u)), SIN(t)*(3+COS(u)), SIN(u)]", 4)

Dislin.axspos (200, 2400)
Dislin.axslen (1800, 1800)

Dislin.name   ("X-axis", "X")
Dislin.name   ("Y-axis", "Y")
Dislin.name   ("Z-axis", "Z")
Dislin.intax  ()

Dislin.vkytit (-300)
Dislin.zscale (-1.0, 1.0)
Dislin.surmsh ("on")

Dislin.graf3d (-4.0 ,4.0, -4.0, 1.0, -4.0, 4.0, -4.0, 1.0, _
               -3.0, 3.0, -3.0, 1.0)
Dislin.height (40)
Dislin.title  ()

stp = 2 * pi / 30.0
pi2 = 2 * pi

Dislin.surfcp (@myfunc, 0.0, pi2, stp, 0.0, pi2, stp)
Dislin.disfin ()
END

FUNCTION myfunc CDECL (BYVAL x AS SINGLE, BYVAL y AS SINGLE,    _
                       BYVAL iopt AS INTEGER) AS SINGLE
DIM AS SINGLE xv
IF iopt = 1 THEN
  xv = cos (x) * (3 + cos (y))
ELSEIF iopt = 2 THEN
  xv = sin (x) * (3 + cos (y))
ELSE
  xv = sin (y)
END IF
return xv
END FUNCTION


