#INCLUDE "dislin.bi"

DIM AS INTEGER n = 300 
DIM AS SINGLE xray(n), y1ray(n), y2ray(n)
DIM AS SINGLE x, stp, fpi
DIM AS INTEGER i, ic

fpi = 3.1415926 / 180
stp = 360.0f / n
  
FOR i = 0 TO n
  xray(i) = i * stp
  x = xray(i) * fpi
  y1ray(i) =  sin (x)
  y2ray(i) =  cos (x)
NEXT i

Dislin.scrmod ("revers")
Dislin.metafl ("xwin")
Dislin.disini ()
Dislin.pagera ()
Dislin.complx ()

Dislin.axspos (450, 1800)
Dislin.axslen (2200, 1200)

Dislin.name ("X-axis", "X")
Dislin.name ("Y-axis", "Y")

Dislin.labdig (-1, "X")
Dislin.ticks (10, "Y")
Dislin.ticks (9, "X")

Dislin.titlin ("Demonstration of CURVE", 1)
Dislin.titlin ("SIN(X), COS(X)", 3)

ic = Dislin.intrgb  (0.95, 0.95, 0.95)
Dislin.axsbgd (ic)

Dislin.graf (0.0, 360.0, 0.0, 90.0, -1.0, 1.0, -1.0, 0.5)

Dislin.setrgb (0.7, 0.7, 0.7)
Dislin.grid (1, 1)

Dislin.color ("fore")
Dislin.height (50)
Dislin.title ()

Dislin.color ("red")
Dislin.curve (@xray(0), @y1ray(0), n + 1)
Dislin.color ("green")
Dislin.curve (@xray(0), @y2ray(0), n + 1)
Dislin.disfin ()
END