#INCLUDE "dislin.bi"

DIM AS INTEGER n = 60, m = 50 
DIM AS SINGLE xray(n), yray(m),zmat(n,m)
DIM AS STRING ctit1 = "Contour Plot"
DIM AS STRING ctit2 = "F(X,Y) = 2 * SIN(X) * SIN (Y)"
DIM AS SINGLE fpi, stpx, stpy, zlev
DIM AS INTEGER i, j

fpi  = 3.1415927 / 180.0
stpx = 360.0 / n
stpy = 360.0 / m

FOR i = 0 TO n
  xray(i) = i * stpx
  FOR j = 0 TO m
    yray(j) = j * stpy
    zmat(i,j) = 2 * sin(xray(i) * fpi) * sin(yray(j) * fpi)
  NEXT j
NEXT i

Dislin.scrmod ("revers")
Dislin.metafl ("cons")
Dislin.setpag ("da4p")
Dislin.disini ()
Dislin.pagera ()
Dislin.complx ()

Dislin.titlin (ctit1, 2)
Dislin.titlin (ctit2, 4)

Dislin.axspos (450, 2670)

Dislin.intax  ()
Dislin.name   ("X-axis", "X")
Dislin.name   ("Y-axis", "Y")
Dislin.graf  (0., 360., 0., 90., 0., 360., 0., 90.)

Dislin.height (30)
FOR i = 0 TO 8
  zlev = -2. + i * 0.5 
  IF i = 4 THEN
    Dislin.labels ("NONE", "CONTUR")
  ELSE
    Dislin.labels ("FLOAT", "CONTUR")
  END IF
  Dislin.setclr ((i+1) * 28)
  Dislin.contur (@xray(0), n + 1, @yray(0), m + 1, @zmat(0,0), zlev)
NEXT i

Dislin.color  ("FORE")
Dislin.height (50)
Dislin.title  ()
Dislin.disfin ()
END
