/* wptCurrWnd.cpp - Current window code
 *	Copyright (C) 2001-2004 Timo Schulz
 *
 * This file is part of WinPT.
 *
 * WinPT is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * WinPT is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with WinPT; if not, write to the Free Software Foundation, 
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include <windows.h>

#include "wptW32API.h"
#include "wptErrors.h"

#define KEYDOWN( vcode, scode ) keybd_event( (vcode), (scode), 0, 0 )
#define KEYUP( vcode, scode)	keybd_event( (vcode), (scode), KEYEVENTF_KEYUP, 0 )

    
extern HWND PTD_get_curr_hwnd( void );
extern BOOL PTD_keyb_send( UINT *keys, UINT n_keys );
int PTD_is_used( void );

static void
clip_clear( void )
{
    OpenClipboard( NULL );
    EmptyClipboard( );
    CloseClipboard( );
} /* clip_clear */


static int
clip_check( void )
{
    HANDLE clipmem;

    /* Arrrgg: it seems that we've to wait until the remote thread		  
       processed the message. W32 said it does, but I don't think so :-((. */
    Sleep( 400 );
		
    if( OpenClipboard( NULL ) == FALSE )    
	return WPTERR_CLIP_OPEN;
    clipmem = GetClipboardData( CF_TEXT );
    if( clipmem == NULL ) {
	CloseClipboard( );	
	return WPTERR_CLIP_GET;	
    }
    CloseClipboard( );
    return 0;
} /* clip_check */

static void
wnd_msg_markall( HWND hwnd )
{
    unsigned keys[4] = {0};

    if( PTD_is_used() ) {
	keys[0] = VK_CONTROL | 0x8000;
	keys[1] = 'A' | 0x8000;	
	keys[2] = 'A';	
	keys[3] = VK_CONTROL;	
	PTD_keyb_send( keys, 4 );

    }
    else {
	KEYDOWN( VK_CONTROL, 0x1d );	
	KEYDOWN( (BYTE)'A', 0x1e );	
	KEYUP( (BYTE)'A', 0x1e );
	KEYUP( VK_CONTROL, 0x1d );	
    }
} /* msg_wm_markall */


static void
wnd_msg_paste( HWND hwnd )
{
    unsigned keys[4] = {0};

    if( PTD_is_used() ) {
	keys[0] = VK_CONTROL | 0x8000;
	keys[1] = 'V' | 0x8000;
	keys[2] = 'V';
	keys[3] = VK_CONTROL;
	PTD_keyb_send( keys, 4 );	
    }
    else {
	KEYDOWN( VK_CONTROL, 0x1d );	
	KEYDOWN( (BYTE)'V', 0x2f );	
	KEYUP( (BYTE)'V', 0x2f );	
	KEYUP( VK_CONTROL, 0x1d );	
    }
} /* msg_wm_paste */


static void
wnd_msg_copy( HWND hwnd )
{
    unsigned keys[4] = {0};

    if( PTD_is_used() ) {
	keys[0] = VK_CONTROL | 0x8000;
	keys[1] = 'C' | 0x8000;
	keys[2] = 'C';
	keys[3] = VK_CONTROL;
	PTD_keyb_send( keys, 4 );	
    }
    else {
	KEYDOWN( VK_CONTROL, 0x1d );
	KEYDOWN( (BYTE)'C', 0x2e );
	KEYUP( (BYTE)'C', 0x2e );
	KEYUP( VK_CONTROL, 0x1d );	
    }
} /* msg_wm_copy */


static inline void
wnd_msg_em_set_pos( HWND hwnd, int begin )
{
    SendMessage( hwnd, EM_SETSEL, 0, begin? 1 : -1 );
} /* wnd_msg_em_set_pos */


static HWND
get_curr_wnd( HWND main, int hotkey, HWND *r_main )
{
    HWND prev, fg;

    if( hotkey )
	prev = GetForegroundWindow();
    else {
	if( r_main )
	    *r_main = GetNextWindow( main, GW_HWNDNEXT );
	return PTD_get_curr_hwnd( );
    }

    SetForegroundWindow( prev );

    AttachThreadInput( GetCurrentThreadId(),
			GetWindowThreadProcessId( prev, NULL ),
			TRUE );
    fg = GetFocus();
    AttachThreadInput( GetCurrentThreadId(),
			GetWindowThreadProcessId( prev, NULL ),
			FALSE );

    if( r_main )
	*r_main = prev;

    return fg;
} /* get_curr_wnd */


int
get_window_contents( HWND old_hwnd, curr_wnd_ctx *ctx, int *r_hotkey )
{
    HWND hwnd;
    int rc = 1, hotkey = 0;
    
    if( r_hotkey )
	hotkey = *r_hotkey;
	
    hwnd = get_curr_wnd( old_hwnd, hotkey, &ctx->main );
    if( hwnd == NULL )
	return rc;
    ctx->focus = hwnd;
    clip_clear( );
	
    AttachThreadInput( GetCurrentThreadId( ),
			GetWindowThreadProcessId( hwnd, NULL ),	
			TRUE );
    SetFocus( hwnd );
	
    /* First we try to send a simple clipboard copying command and check
       if the clipboard contains some text. */
    SendMessage( hwnd, WM_COPY, 0, 0 );
    if( !clip_check( ) ) {
	rc = 0; 
	goto leave;
    }
    /* Then the check if the window is an edit control */
    wnd_msg_em_set_pos( hwnd, 0 );
    SendMessage( hwnd, WM_COPY, 0, 0 );
    if( !clip_check( ) ) {
	rc = 0; 
	goto leave;
    }
	
    /* The last try is to send a mark all and copy to clipboard command */
    wnd_msg_markall( hwnd );
    wnd_msg_copy( hwnd );
    if( !clip_check( ) )
	rc = 0;

leave:
    AttachThreadInput( GetCurrentThreadId( ),					   
			GetWindowThreadProcessId( hwnd, NULL ),				   
			FALSE );
    if( r_hotkey )
	*r_hotkey = 0; /* reset: we need this in any case */
    
    return rc;
} /* get_window_contents */


int
set_window_contents( HWND old_hwnd, curr_wnd_ctx *ctx )
{
    HWND hwnd, lost;	
	
    hwnd = ctx->focus;
    if( IsIconic( ctx->main ) )
	ShowWindow( hwnd, SW_SHOWNORMAL );
    SetForegroundWindow( hwnd );
	
    AttachThreadInput( GetCurrentThreadId( ),
			GetWindowThreadProcessId( hwnd, NULL ),
			TRUE );
	
    lost = SetFocus( hwnd );

    wnd_msg_em_set_pos( hwnd, 0 );
    wnd_msg_paste( hwnd );
    wnd_msg_em_set_pos( hwnd, 1 );
	
    AttachThreadInput( GetCurrentThreadId(),
			GetWindowThreadProcessId( hwnd, NULL ),
			FALSE );
	
    SetForegroundWindow( lost );

    return 0;
} /* set_window_contents */
