/* wptGPGOptSkel.h - Options.skel file from the G10 directory.
 *	Copyright (C) 2000, 2001, 2002, 2003 Timo Schulz
 *
 * This file is part of WinPT.
 *
 * WinPT is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License 
 * as published by the Free Software Foundation; either version 2 
 * of the License, or (at your option) any later version.
 *  
 * WinPT is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License 
 * along with WinPT; if not, write to the Free Software Foundation, 
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 */

#ifndef WPT_GPGOPTSKEL_H
#define WPT_GPGOPTSKEL_H

/* gpg 1.2.3-cvs */
static const char options_skel[] =
"# Options for GnuPG\r\n"
"# Copyright 1998, 1999, 2000, 2001, 2002, 2003 Free Software Foundation, Inc.\r\n"
"# \r\n"
"# This file is free software; as a special exception the author gives\r\n"
"# unlimited permission to copy and/or distribute it, with or without\r\n"
"# modifications, as long as this notice is preserved.\r\n"
"# \r\n"
"# This file is distributed in the hope that it will be useful, but\r\n"
"# WITHOUT ANY WARRANTY, to the extent permitted by law; without even the\r\n"
"# implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.\r\n"
"#\r\n"
"# Unless you specify which option file to use (with the command line\r\n"
"# option \"--options filename\"), GnuPG uses the file ~/.gnupg/gpg.conf\r\n"
"# by default.\r\n"
"#\r\n"
"# An options file can contain any long options which are available in\r\n"
"# GnuPG. If the first non white space character of a line is a '#',\r\n"
"# this line is ignored.  Empty lines are also ignored.\r\n"
"#\r\n"
"# See the man page for a list of options.\r\n"
"\r\n"
"# Uncomment the following option to get rid of the copyright notice\r\n"
"\r\n"
"#no-greeting\r\n"
"\r\n"
"# If you have more than 1 secret key in your keyring, you may want to\r\n"
"# uncomment the following option and set your preferred keyid.\r\n"
"\r\n"
"#default-key 621CC013\r\n"
"\r\n"
"# If you do not pass a recipient to gpg, it will ask for one.  Using\r\n"
"# this option you can encrypt to a default key.  Key validation will\r\n"
"# not be done in this case.  The second form uses the default key as\r\n"
"# default recipient.\r\n"
"\r\n"
"#default-recipient some-user-id\r\n"
"#default-recipient-self\r\n"
"\r\n"
"# By default GnuPG creates version 3 signatures for data files.  This\r\n"
"# is not strictly OpenPGP compliant but PGP 6 and most versions of PGP\r\n"
"# 7 require them.  To disable this behavior, you may use this option\r\n"
"# or --openpgp.\r\n"
"\r\n"
"#no-force-v3-sigs\r\n"
"\r\n"
"# Because some mailers change lines starting with \"From \" to \">From \"\r\n"
"# it is good to handle such lines in a special way when creating\r\n"
"# cleartext signatures; all other PGP versions do it this way too.\r\n"
"# To enable full OpenPGP compliance you may want to use this option.\r\n"
"\r\n"
"#no-escape-from-lines\r\n"
"\r\n"
"# If you do not use the Latin-1 (ISO-8859-1) charset, you should tell\r\n"
"# GnuPG which is the native character set.  Please check the man page\r\n"
"# for supported character sets.  This character set is only used for\r\n"
"# metadata and not for the actual message which does not undergo any\r\n"
"# translation.  Note that future version of GnuPG will change to UTF-8\r\n"
"# as default character set.\r\n"
"\r\n"
"#charset utf-8\r\n"
"\r\n"
"# Group names may be defined like this:\r\n"
"#   group mynames = paige 0x12345678 joe patti\r\n"
"#\r\n"
"# Any time \"mynames\" is a recipient (-r or --recipient), it will be\r\n"
"# expanded to the names \"paige\", \"joe\", and \"patti\", and the key ID\r\n"
"# \"0x12345678\".  Note there is only one level of expansion - you\r\n"
"# cannot make an group that points to another group.  Note also that\r\n"
"# if there are spaces in the recipient name, this will appear as two\r\n"
"# recipients.  In these cases it is better to use the key ID.\r\n"
"\r\n"
"#group mynames = paige 0x12345678 joe patti\r\n"
"\r\n"
"# Some old Windows platforms require 8.3 filenames.  If your system\r\n"
"# can handle long filenames, uncomment this.\r\n"
"\r\n"
"no-mangle-dos-filenames\r\n"
"\r\n"
"# Lock the file only once for the lifetime of a process.  If you do\r\n"
"# not define this, the lock will be obtained and released every time\r\n"
"# it is needed - normally this is not needed.\r\n"
"\r\n"
"#lock-once\r\n"
"\r\n"
"# GnuPG can send and receive keys to and from a keyserver.  These\r\n"
"# servers can be HKP, email, or LDAP (if GnuPG is built with LDAP\r\n"
"# support).\r\n"
"#\r\n"
"# Example HKP keyserver:\r\n"
"#      x-hkp://pgp.mit.edu\r\n"
"#\r\n"
"# Example email keyserver:\r\n"
"#      mailto:pgp-public-keys@keys.nl.pgp.net\r\n"
"#\r\n"
"# Example LDAP keyservers:\r\n"
"#      ldap://pgp.surfnet.nl:11370\r\n"
"#      ldap://keyserver.pgp.com\r\n"
"#\r\n"
"# Regular URL syntax applies, and you can set an alternate port\r\n"
"# through the usual method:\r\n"
"#      x-hkp://keyserver.example.net:22742\r\n"
"#\r\n"
"# If you have problems connecting to a HKP server through a buggy http\r\n"
"# proxy, you can use keyserver option broken-http-proxy (see below),\r\n"
"# but first you should make sure that you have read the man page\r\n"
"# regarding proxies (keyserver option honor-http-proxy)\r\n"
"#\r\n"
"# Most users just set the name and type of their preferred keyserver.\r\n"
"# Most servers do synchronize with each other and DNS round-robin may\r\n"
"# give you a quasi-random server each time.\r\n"
"\r\n"
"#keyserver x-hkp://pgp.mit.edu\r\n"
"#keyserver mailto:pgp-public-keys@keys.nl.pgp.net\r\n"
"#keyserver ldap://pgp.surfnet.nl:11370\r\n"
"#keyserver ldap://keyserver.pgp.com\r\n"
"\r\n"
"# Common options for keyserver functions:\r\n"
"#\r\n"
"# include-disabled = when searching, include keys marked as \"disabled\"\r\n"
"#                    on the keyserver (not all keyservers support this).\r\n"
"#\r\n"
"# no-include-revoked = when searching, do not include keys marked as\r\n"
"#                      \"revoked\" on the keyserver.\r\n"
"#\r\n"
"# verbose = show more information as the keys are fetched.\r\n"
"#           Can be used more than once to increase the amount\r\n"
"#           of information shown.\r\n"
"#\r\n"
"# use-temp-files = use temporary files instead of a pipe to talk to the\r\n"
"#                  keyserver.  Some platforms (Win32 for one) always\r\n"
"#                  have this on.\r\n"
"#\r\n"
"# keep-temp-files = do not delete temporary files after using them\r\n"
"#                   (really only useful for debugging)\r\n"
"#\r\n"
"# honor-http-proxy = if the keyserver uses HTTP, honor the http_proxy\r\n"
"#                    environment variable\r\n"
"#\r\n"
"# broken-http-proxy = try to work around a buggy HTTP proxy\r\n"
"#\r\n"
"# auto-key-retrieve = automatically fetch keys as needed from the keyserver\r\n"
"#                     when verifying signatures or when importing keys that\r\n"
"#                     have been revoked by a revocation key that is not\r\n"
"#                     present on the keyring.\r\n"
"#\r\n"
"# no-include-attributes = do not include attribute IDs (aka \"photo IDs\")\r\n"
"#                         when sending keys to the keyserver.\r\n"
"\r\n"
"#keyserver-options auto-key-retrieve\r\n"
"\r\n"
"# Uncomment this line to display photo user IDs in key listings and\r\n"
"# when a signature from a key with a photo is verified.\r\n"
"\r\n"
"#show-photos\r\n"
"\r\n"
"# Use this program to display photo user IDs\r\n"
"#\r\n"
"# %i is expanded to a temporary file that contains the photo.\r\n"
"# %I is the same as %i, but the file isn't deleted afterwards by GnuPG.\r\n"
"# %k is expanded to the key ID of the key.\r\n"
"# %K is expanded to the long OpenPGP key ID of the key.\r\n"
"# %t is expanded to the extension of the image (e.g. \"jpg\").\r\n"
"# %T is expanded to the MIME type of the image (e.g. \"image/jpeg\").\r\n"
"# %f is expanded to the fingerprint of the key.\r\n"
"# %% is %, of course.\r\n"
"#\r\n"
"# If %i or %I are not present, then the photo is supplied to the\r\n"
"# viewer on standard input.  If your platform supports it, standard\r\n"
"# input is the best way to do this as it avoids the time and effort in\r\n"
"# generating and then cleaning up a secure temp file.\r\n"
"#\r\n"
"# The default program is \"xloadimage -fork -quiet -title 'KeyID 0x%k' stdin\"\r\n"
"# On Mac OS X and Windows, the default is to use your regular JPEG image\r\n"
"# viewer.\r\n"
"#\r\n"
"# Some other viewers:\r\n"
"# photo-viewer \"qiv %i\"\r\n"
"# photo-viewer \"ee %i\"\r\n"
"# photo-viewer \"display -title 'KeyID 0x%k'\"\r\n"
"#\r\n"
"# This one saves a copy of the photo ID in your home directory:\r\n"
"# photo-viewer \"cat > ~/photoid-for-key-%k.%t\"\r\n"
"#\r\n"
"# Use your MIME handler to view photos:\r\n"
"# photo-viewer \"metamail -q -d -b -c %T -s 'KeyID 0x%k' -f GnuPG\"\r\n"
"\r\n"
"# Passphrase agent\r\n"
"#\r\n"
"# We support the old experimental passphrase agent protocol as well as\r\n"
"# the new Assuan based one (currently available in the \"newpg\" package\r\n"
"# at ftp.gnupg.org/gcrypt/alpha/aegypten/).  To make use of the agent,\r\n"
"# you have to run an agent as daemon and use the option\r\n"
"#\r\n"
"# use-agent\r\n"
"#\r\n" 
"# which tries to use the agent but will fallback to the regular mode\r\n"
"# if there is a problem connecting to the agent.  The normal way to\r\n"
"# locate the agent is by looking at the environment variable\r\n"
"# GPG_AGENT_INFO which should have been set during gpg-agent startup.\r\n"
"# In certain situations the use of this variable is not possible, thus\r\n"
"# the option\r\n"
"# \r\n"
"# --gpg-agent-info=<path>:<pid>:1\r\n"
"#\r\n"
"# may be used to override it.\r\n";


#endif /* WPT_GPGOPTSKEL_H */