/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.gnu.crypto.hash;

import gnu.crypto.hash.IMessageDigest;
import gnu.crypto.hash.Whirlpool;
import gnu.crypto.util.Util;
import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;

public class TestOfWhirlpool
implements Testlet {
    private static final String TV1 = "EBAA1DF2E97113BE187EB0303C660F6E643E2C090EF2CDA9A2EA6DCF5002147D1D0E1E9D996E879CEF9D26896630A5DB3308D5A0DC235B199C38923BE2259E03";
    private static final String TV2 = "5777FC1F8467A1C004CD9130439403CCDAA9FDC86092D9CFFE339E6008612374D04C8FC0C724707FEAE6F7CEB1E030CABF652A673DA1849B02654AF76EEE24A7";
    private IMessageDigest algorithm;
    private IMessageDigest clone;

    public void test(TestHarness harness) {
        byte[] md;
        harness.checkPoint("TestOfWhirlpool");
        try {
            this.algorithm = new Whirlpool();
            harness.check(this.algorithm.selfTest(), "selfTest");
        }
        catch (Exception x) {
            harness.debug(x);
            harness.fail("TestOfWhirlpool.selfTest");
        }
        try {
            this.algorithm = new Whirlpool();
            this.algorithm.update((byte)0);
            md = this.algorithm.digest();
            harness.check(TV1.equals(Util.toString((byte[])md)), "test8ZeroBits");
        }
        catch (Exception x) {
            harness.debug(x);
            harness.fail("TestOfWhirlpool.test8ZeroBits");
        }
        try {
            this.algorithm = new Whirlpool();
            this.algorithm.update((byte)0);
            this.algorithm.update((byte)0);
            md = this.algorithm.digest();
            harness.check(TV2.equals(Util.toString((byte[])md)), "test16ZeroBits");
        }
        catch (Exception x) {
            harness.debug(x);
            harness.fail("TestOfWhirlpool.test16ZeroBits");
        }
        try {
            this.algorithm = new Whirlpool();
            this.algorithm.update((byte)0);
            this.clone = (IMessageDigest)this.algorithm.clone();
            md = this.algorithm.digest();
            harness.check(TV1.equals(Util.toString((byte[])md)), "testCloning #1");
            this.clone.update((byte)0);
            md = this.clone.digest();
            harness.check(TV2.equals(Util.toString((byte[])md)), "testCloning #2");
        }
        catch (Exception x) {
            harness.debug(x);
            harness.fail("TestOfWhirlpool.testCloning");
        }
    }
}

