/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.gnu.crypto.hash;

import gnu.crypto.hash.IMessageDigest;
import gnu.crypto.hash.MD2;
import gnu.crypto.util.Util;
import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;

public class TestOfMD2
implements Testlet {
    private IMessageDigest algorithm;
    private IMessageDigest clone;

    public void test(TestHarness harness) {
        String exp;
        byte[] md;
        harness.checkPoint("TestOfMD2");
        try {
            this.algorithm = new MD2();
            harness.check(this.algorithm.selfTest(), "selfTest");
        }
        catch (Exception x) {
            harness.debug(x);
            harness.fail("TestOfMD2.selfTest");
        }
        try {
            this.algorithm = new MD2();
            this.algorithm.update("a".getBytes(), 0, 1);
            md = this.algorithm.digest();
            exp = "32EC01EC4A6DAC72C0AB96FB34C0B5D1";
            harness.check(exp.equals(Util.toString((byte[])md)), "testA");
        }
        catch (Exception x) {
            harness.debug(x);
            harness.fail("TestOfMD2.testA");
        }
        try {
            this.algorithm = new MD2();
            this.algorithm.update("abc".getBytes(), 0, 3);
            md = this.algorithm.digest();
            exp = "DA853B0D3F88D99B30283A69E6DED6BB";
            harness.check(exp.equals(Util.toString((byte[])md)), "testABC");
        }
        catch (Exception x) {
            harness.debug(x);
            harness.fail("TestOfMD2.testABC");
        }
        try {
            this.algorithm = new MD2();
            this.algorithm.update("message digest".getBytes(), 0, 14);
            md = this.algorithm.digest();
            exp = "AB4F496BFB2A530B219FF33031FE06B0";
            harness.check(exp.equals(Util.toString((byte[])md)), "testMessageDigest");
        }
        catch (Exception x) {
            harness.debug(x);
            harness.fail("TestOfMD2.testMessageDigest");
        }
        try {
            this.algorithm = new MD2();
            this.algorithm.update("abcdefghijklmnopqrstuvwxyz".getBytes(), 0, 26);
            md = this.algorithm.digest();
            exp = "4E8DDFF3650292AB5A4108C3AA47940B";
            harness.check(exp.equals(Util.toString((byte[])md)), "testAlphabet");
        }
        catch (Exception x) {
            harness.debug(x);
            harness.fail("TestOfMD2.testAlphabet");
        }
        try {
            this.algorithm = new MD2();
            this.algorithm.update("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789".getBytes(), 0, 62);
            md = this.algorithm.digest();
            exp = "DA33DEF2A42DF13975352846C30338CD";
            harness.check(exp.equals(Util.toString((byte[])md)), "testAsciiSubset");
        }
        catch (Exception x) {
            harness.debug(x);
            harness.fail("TestOfMD2.testAsciiSubset");
        }
        try {
            this.algorithm = new MD2();
            this.algorithm.update("12345678901234567890123456789012345678901234567890123456789012345678901234567890".getBytes(), 0, 80);
            md = this.algorithm.digest();
            exp = "D5976F79D83D3A0DC9806C3C66F3EFD8";
            harness.check(exp.equals(Util.toString((byte[])md)), "testEightyNumerics");
        }
        catch (Exception x) {
            harness.debug(x);
            harness.fail("TestOfMD2.testEightyNumerics");
        }
        try {
            this.algorithm = new MD2();
            this.algorithm.update("a".getBytes(), 0, 1);
            this.clone = (IMessageDigest)this.algorithm.clone();
            md = this.algorithm.digest();
            exp = "32EC01EC4A6DAC72C0AB96FB34C0B5D1";
            harness.check(exp.equals(Util.toString((byte[])md)), "testCloning #1");
            this.clone.update("bc".getBytes(), 0, 2);
            md = this.clone.digest();
            exp = "DA853B0D3F88D99B30283A69E6DED6BB";
            harness.check(exp.equals(Util.toString((byte[])md)), "testCloning #2");
        }
        catch (Exception x) {
            harness.debug(x);
            harness.fail("TestOfMD2.testCloning");
        }
    }
}

