/*
 * Decompiled with CFR 0.152.
 */
package test.sig.rsa;

import gnu.crypto.sig.rsa.RSAKeyPairGenerator;
import gnu.crypto.sig.rsa.RSAPSSSignature;
import java.security.Key;
import java.security.KeyPair;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.HashMap;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestOfRSAPSSSignature
extends TestCase {
    private RSAKeyPairGenerator kpg = new RSAKeyPairGenerator();
    private RSAPublicKey publicK;
    private RSAPrivateKey privateK;
    private RSAPSSSignature alice;
    private RSAPSSSignature bob;
    private byte[] message;
    static /* synthetic */ Class class$test$sig$rsa$TestOfRSAPSSSignature;

    public TestOfRSAPSSSignature(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)TestOfRSAPSSSignature.suite());
    }

    public static Test suite() {
        return new TestSuite(class$test$sig$rsa$TestOfRSAPSSSignature == null ? (class$test$sig$rsa$TestOfRSAPSSSignature = TestOfRSAPSSSignature.class$("test.sig.rsa.TestOfRSAPSSSignature")) : class$test$sig$rsa$TestOfRSAPSSSignature);
    }

    public void testSigWithDefaults() {
        this.alice = new RSAPSSSignature();
        this.bob = (RSAPSSSignature)this.alice.clone();
        this.message = "1 if by land, 2 if by sea...".getBytes();
        HashMap<String, Key> map = new HashMap<String, Key>();
        map.put("gnu.crypto.sig.private.key", this.privateK);
        this.alice.setupSign(map);
        this.alice.update(this.message, 0, this.message.length);
        Object signature = this.alice.sign();
        map.put("gnu.crypto.sig.public.key", this.publicK);
        this.bob.setupVerify(map);
        this.bob.update(this.message, 0, this.message.length);
        Assert.assertTrue((String)"testSigWithDefaults()", (boolean)this.bob.verify(signature));
    }

    public void testSigWithShaSalt16() {
        this.alice = new RSAPSSSignature("sha1", 16);
        this.bob = (RSAPSSSignature)this.alice.clone();
        this.message = "Que du magnifique...".getBytes();
        HashMap<String, Key> map = new HashMap<String, Key>();
        map.put("gnu.crypto.sig.private.key", this.privateK);
        this.alice.setupSign(map);
        this.alice.update(this.message, 0, this.message.length);
        Object signature = this.alice.sign();
        map.put("gnu.crypto.sig.public.key", this.publicK);
        this.bob.setupVerify(map);
        this.bob.update(this.message, 0, this.message.length);
        Assert.assertTrue((String)"testSigWithShaSalt16()", (boolean)this.bob.verify(signature));
    }

    public void testSigWithRipeMD160Salt8() {
        this.alice = new RSAPSSSignature("ripemd160", 8);
        this.bob = (RSAPSSSignature)this.alice.clone();
        this.message = "abcdefghijklmnopqrstuvwxyz0123456789".getBytes();
        HashMap<String, Key> map = new HashMap<String, Key>();
        map.put("gnu.crypto.sig.private.key", this.privateK);
        this.alice.setupSign(map);
        this.alice.update(this.message, 0, this.message.length);
        Object signature = this.alice.sign();
        map.put("gnu.crypto.sig.public.key", this.publicK);
        this.bob.setupVerify(map);
        this.bob.update(this.message, 0, this.message.length);
        Assert.assertTrue((String)"testSigWithRipeMD160Salt8()", (boolean)this.bob.verify(signature));
    }

    protected void setUp() {
        this.kpg.setup(new HashMap());
        KeyPair kp = this.kpg.generate();
        this.publicK = (RSAPublicKey)kp.getPublic();
        this.privateK = (RSAPrivateKey)kp.getPrivate();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

