.if n .ds Q \&"
.if t .ds Q ``
.if n .ds U \&"
.if t .ds U ''
.TH "gv" 1 
.tr \&
.nr bi 0
.nr ll 0
.nr el 0
.de DS
..
.de DE
..
.de Pp
.ie \\n(ll>0 \{\
.ie \\n(bi=1 \{\
.nr bi 0
.if \\n(t\\n(ll=0 \{.IP \\(bu\}
.if \\n(t\\n(ll=1 \{.IP \\n+(e\\n(el.\}
.\}
.el .sp 
.\}
.el \{\
.ie \\nh=1 \{\
.LP
.nr h 0
.\}
.el .PP 
.\}
..
.SH Name
gv - a PostScript and PDF previewer


.SH Synopsis 

.Pp
.DS
.sp 
.ft CR
.nf
gv [ filename ]
   [-monochrome] [-grayscale] [-color]
   [-[no]safer] [-[no]quiet] [-arguments <arguments>]
   [-page <label>] [-[no]center]
   [-media <media>]
   [-portrait] [-landscape] [-upsidedown] [-seascape]
   [-scale <n>] [-scalebase <n>]
   [-swap] [-noswap]
   [-antialias] [-noantialias]
   [-dsc] [-nodsc]
   [-eof] [-noeof]
   [-pixmap] [-nopixmap]
   [-watch] [-nowatch]
   [-?] [-h] [-help]
   [-resize] [-noresize]
   [-geometry [<width>][x<height>][{+-}<xoffset>{+-}<yoffset>]
   [-ad <resource file>]
   [-style <resource file>]
   [-spartan]
   [<other toolkit options>]
.DE
.fi 
.ec
.ft P
.sp

.SH Description 

.Pp
.Pp
gv allows to view and navigate through
PostScript and PDF documents on an X display
by providing a user interface for the ghostscript interpreter.
.Pp
Please note that gv is derived from Tim Theisen's
ghostview 1.5.
.Pp
.SH Options 

.Pp
.nr ll +1
.nr t\n(ll 2
.if \n(ll>1 .RS
.IP "\fBfilename\fP"
.nr bi 1
.Pp
The name of the file to be displayed.
The file ending \*Q.ps\*U may be omitted.
\*Qfilename\*U may point to a compressed file 
(gzipped, zipped or compressed).
Viewing PDF files requires at least ghostscript version 4.x.
.IP "\fB-ad <resource file>\fP"
.nr bi 1
.Pp
Read and use additional resources from the file
<resource file>.
These resources have higher priority than those provided
in the context of the -style <resource file> option.
.IP "\fB-antialias\fP, \fB-noantialias\fP"
.nr bi 1
.Pp
Whether to use antialiasing.
.IP "\fB-arguments <arguments>\fP"
.nr bi 1
.Pp
Start ghostscript with additional options as specified by the
string <arguments>.
.IP "\fB-center\fP, \fB-nocenter\fP"
.nr bi 1
.Pp
Whether the page should be centered automatically.
.IP "\fB-dsc\fP, \fB-nodsc\fP"
.nr bi 1
.Pp
Determines if document structuring convention (DSC) comments
should be respected or ignored.
If -nodsc is used gv will not attempt to examine
the structure of the document but will pass the file
to the ghostscript interpreter as a whole. In this case no page numbers
are shown and freely moving around in the document is not possible.
This option may help when viewing files not conforming
to the document structuring conventions.
.IP "\fB-eof\fP, \fB-noeof\fP"
.nr bi 1
.Pp
Defines the behaviour of the postscript scanner used to
examine the structure of the document.
If -noeof is used the scanner will ignore end of file (EOF)
comments. This may help when viewing documents which import other
documents without enclosing them within the proper
"BeginDocument" and "EndDocument" comments.
If -eof is used, the scanner treats an EOF comment as
marking the end of the file.
.IP "\fB-pixmap\fP, \fB-nopixmap\fP"
.nr bi 1
.Pp
If -pixmap is used gv tries to maintain off-screen regions
of the displayed page by allocating a sufficiently large pixmap.
If -nopixmap is used the X Server is responsible for
maintaining obscured portions of the displayed page
(see also the \*QuseBackingPixmap\*U resource).
.IP "\fB-h\fP, \fB-?\fP "
.nr bi 1
.Pp
Display a short help message and exit.
.IP "\fB-help\fP"
.nr bi 1
.Pp
Display a more explicit help message and exit.
.IP "\fB-scale <n>\fP"
.nr bi 1
.Pp
Selects the scale entry <n> relative to the scale 1.0.
<n> must be an integer.
.IP "\fB-scalebase <n>\fP"
.nr bi 1
.Pp
Selects the scale base <n>.
.IP "\fB-monochrome\fP, \fB-grayscale\fP, \fB-color\fP"
.nr bi 1
.Pp
Sets the color palette to be used.
.IP "\fB-media <media>\fP"
.nr bi 1
.Pp
Selects the paper size to be used. Valid values are names of
paper sizes that appear in the list of page medias as given
by the medias resource.
.IP "\fB-page <label>\fP"
.nr bi 1
.Pp
Display the page with label <label> first.
.IP "\fB-portrait\fP, \fB-landscape\fP, \fB-seascape\fP, \fB-upsidedown\fP"
.nr bi 1
.Pp
Sets the orientation.
.IP "\fB-quiet\fP, \fB-noquiet\fP"
.nr bi 1
.Pp
Whether to start ghostscript with the -dQUIET option.
.IP "\fB-resize\fP, \fB-noresize\fP"
.nr bi 1
.Pp
Whether gv is allowed to automatically fit the
size of its window to the size of the displayed page.
.IP "\fB-safer\fP, \fB-nosafer\fP"
.nr bi 1
.Pp
Whether to start ghostscript with the -dSAFER option.
.IP "\fB-spartan\fP"
.nr bi 1
.Pp
This is a shortcut for \*Q-style gv_spartan.dat\*U.
.IP "\fB-style <resource file>\fP"
.nr bi 1
.Pp
Read and use additional resources from the file <resource file>.
These resources have  lower priority than those provided
in the context of the -ad <resource file> option.
.IP "\fB-swap\fP, \fB-noswap\fP"
.nr bi 1
.Pp
Whether to interchange the meaning of the orientations
landscape and seascape.
.IP "\fB-watch\fP, \fB-nowatch\fP"
.nr bi 1
.Pp
The -watch option causes gv to check the document
periodically. If changes are detected gv will
automatically display the newer version of the file.
The document is by default checked once every second. 
This can be changed via the watchFileFrequency resource.
Note that sending gv the SIGHUP signal also causes
an update of the displayed document. This method
may be used by document creators to trigger gv
remotely.
.if \n(ll>1 .RE
.nr ll -1

.SH Resources 

.Pp
\fBResource files\fP
.Pp
In general gv does not depend on any external resource files.
However, when starting gv, preferences are read from
.Pp
.nr ll +1
.nr t\n(ll 0
.if \n(ll>1 .RS
.nr bi 1
.Pp
\fBa system specific resource file\fP.
The name of this file is as described by the \*QXFILESEARCHPATH\*U
environment variable, or, if this variable is not defined,
implementation dependant. In most cases it is  
\*Q/usr/X11/lib/X11/app-defaults/GV\*U.
Administrators may want to modify this file in order
to set up gv according to the local needs of their system.
.nr bi 1
.Pp
\fBa user specific resource file\fP.
The name of this file is either \*Q~/.gv\*U or as described
by the \*QXUSERFILESEARCHPATH\*U environment variable.
.if \n(ll>1 .RE
.nr ll -1
.Pp
The files \*Qgv_user.ad\*U and \*Qgv_system.ad\*U (located in the library directory
of gv, which is most probably either 
\*Q/usr/local/lib/gv/\*U or \*Q/usr/lib/gv/\*U may serve as a basis
for constructing the user and system specific resource files.
.Pp
Note that the user and system specific resource files are not the only
sources of preferences taken into account when gv is started.
However, in practice these are the most important.
.Pp
\fBResources of gv\fP
.Pp
The following describes some of the resources of gv.
The precise syntax of some of the resource values may be 
inferred from the appended default system specific resource file.
.Pp
.nr ll +1
.nr t\n(ll 2
.if \n(ll>1 .RS
.IP "antialias"
.nr bi 1
.Pp
Whether antialiasing should be used.
Valid values are \*QTrue\*U and \*QFalse\*U.
.IP "autoCenter"
.nr bi 1
.Pp
Whether the displayed page should automatically be centered 
(for instance when opening a new file).
Valid values are \*QTrue\*U and \*QFalse\*U.
.IP "autoResize"
.nr bi 1
.Pp
Whether gv is allowed to resize the main window
according to the size of the current page.
Valid values are \*QTrue\*U and \*QFalse\*U.
.IP "confirmPrint"
.nr bi 1
.Pp
Whether printing requires an extra confirmation.
Valid values are \*QTrue\*U and \*QFalse\*U.
.IP "confirmQuit"
.nr bi 1
.Pp
Whether leaving gv requires extra confirmation.
Valid values are \*Q0\*U (Never), \*Q1\*U
(When processing) and \*Q2\*U (Always).
The default value is \*Q1\*U, which causes
a confirmation request when trying to leave gv
in the presence of pending PDF to Postscript conversions.
.IP "ignoreEOF"
.nr bi 1
.Pp
Defines the behaviour of the postscript scanner as described
in the Options section.
Valid values are \*QTrue\*U and \*QFalse\*U.   
.IP "respectDSC"
.nr bi 1
.Pp
Determines whether gv should attempt to respect document 
structuring comments.
Valid values are \*QTrue\*U and \*QFalse\*U.
.IP "reverseScrolling"
.nr bi 1
.Pp
Defines the interpretation of directions when
scrolling with the mouse.
Valid values are \*QTrue\*U and \*QFalse\*U.
.IP "swapLandscape"
.nr bi 1
.Pp
Whether the meaning of \*Qlandscape\*U and \*Qseacape\*U
should be interchanged.
Valid values are \*QTrue\*U and \*QFalse\*U.
.IP "scratchDir"
.nr bi 1
.Pp
Specifies a directory used to store temporary data.
.IP "defaultSaveDir"
.nr bi 1
.Pp
Specifies the default destination directory for files to be saved.
.IP "useBackingPixmap"
.nr bi 1
.Pp
If the value of this resource is \*QFalse\*U the X Server
is advised that saving off-screen pixels of the displayed page
would be beneficial (maintaining backing store). In this case gv 
does not actively maintain the contents of the page but relies
on the X Server. The server is, however, always free to stop 
maintaining backing backing store.
If the value of this resource is \*QTrue\*U the X Server
is advised that maintaining backing store is not useful.
In this case gv attempts to allocate a sufficiently large pixmap
to store the contents of the displayed page.
.IP "watchFile"
.nr bi 1
.Pp
Whether the document should be checked periodically and updated
automatically if  changes are detected.
Valid values are \*QTrue\*U and \*QFalse\*U.
.IP "watchFileFrequency"
.nr bi 1
.Pp
Defines the time in milliseconds elapsing between successive
checks of the document when watchFile is set to \*QTrue\*U.
Allowed values must be larger than 500.
.IP "printCommand"
.nr bi 1
.Pp
The command used for printing a file.
The command may contain multiple '%s' wildcards
which will be replaced by the name of the file to be 
printed.
.IP "gsInterpreter"
.nr bi 1
.Pp
The command used to start the ghostscript interpreter.
.IP "gsCmdScanPDF"
.nr bi 1
.Pp
The command used to extract document structuring comments
from a PDF file.
.IP "gsCmdConvPDF"
.nr bi 1
.Pp
The command used to convert a PDF file to PostScript.
.IP "gsX11Device"
.nr bi 1
.Pp
The ghostscript command line option which activates the
\*QX11\*U device. 
.IP "gsX11AlphaDevice"
.nr bi 1
.Pp
The ghostscript command line option which activates the
\*QX11\*U device with antialiasing enabled. 
.IP "gsSafer"
.nr bi 1
.Pp
Determines whether ghostscript should be started with the
\*Q-dSAFER\*U command line option.
.IP "gsQuiet"
.nr bi 1
.Pp
Determines whether ghostscript should be started with the
\*Q-dQUIET\*U command line option.
.IP "gsArguments"
.nr bi 1
.Pp
May be used to provide additional command line options for the
ghostscript interpreter.
Starting gv with the \*Q-arguments <arguments>\*U
option will override this resource setting.
.IP "magMenu"
.nr bi 1
.Pp
Describes the menu that pops up when preparing to
to zoom an area of the displayed page.
.IP "dirs"
.nr bi 1
.Pp
Defines a list of directories accessible via the Directories
menu in the file selection window.
The special value \*QHome\*U corresponds to the users home directory,
the value \*QTmp\*U corresponds to the scratch directory as defined
by the scratchDir resource.
.IP "filter"
.nr bi 1
.Pp
Defines the default filter to be used when displaying a directory
contents in the file selection window.
A filter is specified according to the syntax
.DS
.sp 
.ft CR
.nf
   <filter>    := [<filespecs>] [no <filespecs>]
   <filespecs> := <filespec> [<filespecs>]
   <filespec>  := filename possibly including wildcards '*'
                  which match any character.
.DE
.fi 
.ec
.ft P
.sp

Example: The filter
.DS
.sp 
.ft CR
.nf
   GV*filter: *.ps *.pdf no .*
.DE
.fi 
.ec
.ft P
.sp

screens out all files with names starting with a dot
and keeps of the remaining ones only those which end
on \*Q.ps\*U or \*Q.pdf\*U.
.IP "filters"
.nr bi 1
.Pp
Defines a list of filters offered in the Filters
menu of the file selection window.
The filter \*QNone\*U has a special meaning
causing all files to be displayed when the corresponding
menu entry is selected.
.IP "miscMenuEntries"
.nr bi 1
.Pp
Describes the menu that pops up when clicking with the 
third mouse button on the displayed page. 
The value of this resource is a list of menu entries.
Allowed entries are
\*Qupdate\*U,
\*Qredisplay\*U,    
\*Qtoggle_current\*U,    
\*Qtoggle_even\*U,    
\*Qtoggle_odd\*U,    
\*Qunmark\*U,    
\*Qstop\*U,    
\*Qprint_all\*U,    
\*Qprint_marked\*U,    
\*Qsave_all\*U,    
\*Qsave_marked\*U and
\*Qline\*U.
.IP "showTitle"
.nr bi 1
.Pp
Whether the name of the displayed document should be shown in the
title bar of the window. The name of gv's icon will also change
accordingly if this resource is set to \*QTrue\*U.
.IP "maximumWidth, maximumHeight"
.nr bi 1
.Pp
When resizing gv will not attempt to exceed the size specified
by these resources.
These resources may be specified as a positive integer
or as \*Qscreen\*U, optionally combined with
a positive or negative offset.
The default values listed above provide examples for this syntax.
\*Qscreen\*U will automatically be replaced by the size of the
screen.
.IP "minimumWidth, minimumHeight"
.nr bi 1
.Pp
Defines a minimum size for the main window.
Valid values for both resources are positive integers larger
than 200.
.IP "scale"
.nr bi 1
.Pp
Sets the initial scale. The value of this resource is the offset
of the scale to be selected relative to the scale 1.0 in the
the \*QScale\*U menu.
.IP "scaleBase"
.nr bi 1
.Pp
Selects the initial scale base. The value of this resource should 
be a positive integer.
.IP "scales"
.nr bi 1
.Pp
Defines the available scales bases and scales in the \*QScale\*U
menu.   
.IP "orientation"
.nr bi 1
.Pp
Sets the initial orientation. Valid values are 
\*Qportrait\*U, \*Qlandscape\*U,\*Qseascape\*U,
\*Qupside-down\*U and
\*Qautomatic\*U.
\*Qautomatic\*U causes gv to attempt
to derive the correct orientation from document structuring
comments.
.IP "fallbackOrientation"
.nr bi 1
.Pp
Defines the paper-size to be used when automatic orientation
detetction fails.  Valid values are 
\*Qportrait\*U, \*Qlandscape\*U,\*Qseascape\*U 
and \*Qupside-down\*U.
.IP "medias"
.nr bi 1
.Pp
A list describing the page medias known to gv.
List entries starting with \*Q!\*U or \*Q#\*U will not appear in the
\*QMedia\*U menu but will still be used for automatic paper size 
detection.
.IP "pagemedia"
.nr bi 1
.Pp
Sets the paper size. 
Allowd values are as given in the above list of paper-sizes.
Specifying
\*Qautomatic\*U causes gv to attempt
to derive the correct paper-size from document structuring
comments.
.IP "fallbackPageMedia"
.nr bi 1
.Pp
Defines the paper-size to be used when automatic paper-size 
detetction fails.  Valid values are as given in the  above
list of paper-sizes.
.if \n(ll>1 .RE
.nr ll -1
.Pp
\fBThe default user and system specific resource file\fP
.DS
.sp 
.ft CR
.nf
GV.pageMedia:           automatic
GV.orientation:         automatic
GV.fallbackOrientation: portrait
GV.swapLandscape:       False
GV.autoCenter:          True
GV.antialias:           False
GV.respectDSC:          True
GV.ignoreEOF:           True
GV.confirmPrint:        True
GV.reverseScrolling:    False
GV.autoResize:          True
GV.maximumWidth:        screen-20
GV.maximumHeight:       screen-44
GV.minimumWidth:        400
GV.minimumHeight:       430
GV.geometry:            +10+10
GV.confirmQuit:         1
GV.watchFile:           False
GV.watchFileFrequency:  1000
GV.showTitle:           True
GV.miscMenuEntries:     redisplay       \\n\\
                        # update        \\n\\
                        stop            \\n\\
                        line            \\n\\
                        toggle_current  \\n\\
                        toggle_even     \\n\\
                        toggle_odd      \\n\\
                        unmark          \\n\\
                        line            \\n\\
                        print_all       \\n\\
                        print_marked    \\n\\
                        save_all        \\n\\
                        save_marked
GV*filter:              no .*
GV*filters:             None\\n\\
                        *.ps* *.pdf*  no  .*\\n\\
                        *.ps*   no  .*\\n\\
                        *.pdf*  no  .*\\n\\
                        no  .*
GV*dirs:                Home\\n\\
                        Tmp\\n\\
                        /usr/doc\\n\\
                        /usr/local/doc
GV.scale:               0
GV.scaleBase:           1
GV.scales:              Natural size,   1.000,  screen  \\n\\
                        Pixel based,    1.000,  pixel   \\n\\
                        0.100,          0.100           \\n\\
                        0.125,          0.125           \\n\\
                        0.250,          0.250           \\n\\
                        0.500,          0.500           \\n\\
                        0.707,          0.707           \\n\\
                        1.000,          1.000           \\n\\
                        1.414,          1.414           \\n\\
                        2.000,          2.000           \\n\\
                        4.000,          4.000           \\n\\
                        8.000,          8.000           \\n\\
                        10.00,          10.00
GV.medias:              Letter,         612     792     \\n\\
                        # LetterSmall,  612     792     \\n\\
                        Legal,          612     1008    \\n\\
                        Statement,      396     612     \\n\\
                        Tabloid,                792     1224    \\n\\
                        Ledger,         1224    792     \\n\\
                        Folio,          612     936     \\n\\
                        Quarto,         610     780     \\n\\
                        # 7x9,          504     648     \\n\\
                        # 9x11,         648     792     \\n\\
                        # 9x12,         648     864     \\n\\
                        # 10x13,                720     936     \\n\\
                        10x14,          720     1008    \\n\\
                        Executive,      540     720     \\n\\
                        # A0,           2384    3370    \\n\\
                        # A1,           1684    2384    \\n\\
                        # A2,           1191    1684    \\n\\
                        A3,             842     1191    \\n\\
                        A4,             595     842     \\n\\
                        # A4Small,      595     842     \\n\\
                        A5,             420     595     \\n\\
                        # A6,           297     420     \\n\\
                        # A7,           210     297     \\n\\
                        # A8,           148     210     \\n\\
                        # A9,           105     148     \\n\\
                        # A10,          73      105     \\n\\
                        # B0,           2920    4127    \\n\\
                        # B1,           2064    2920    \\n\\
                        # B2,           1460    2064    \\n\\
                        # B3,           1032    1460    \\n\\
                        B4,             729     1032    \\n\\
                        B5,             516     729     \\n\\
                        # B6,           363     516     \\n\\
                        # B7,           258     363     \\n\\
                        # B8,           181     258     \\n\\
                        # B9,           127     181     \\n\\
                        # B10,          91      127     \\n\\
                        # ISOB0,                2835    4008    \\n\\
                        # ISOB1,                2004    2835    \\n\\
                        # ISOB2,                1417    2004    \\n\\
                        # ISOB3,                1001    1417    \\n\\
                        # ISOB4,                709     1001    \\n\\
                        # ISOB5,                499     709     \\n\\
                        # ISOB6,                354     499     \\n\\
                        # ISOB7,                249     354     \\n\\
                        # ISOB8,                176     249     \\n\\
                        # ISOB9,                125     176     \\n\\
                        # ISOB10,       88      125     \\n\\
                        # C0,           2599    3676    \\n\\
                        # C1,           1837    2599    \\n\\
                        # C2,           1298    1837    \\n\\
                        # C3,           918     1296    \\n\\
                        # C4,           649     918     \\n\\
                        # C5,           459     649     \\n\\
                        # C6,           323     459     \\n\\
                        # C7,           230     323     \\n\\
                        # DL,           312     624
GV.magMenu:             2,      2       \\n\\
                        4,      4       \\n\\
                        8,      8       \\n\\
                        16,     16      \\n\\
                        32,     32      \\n\\
                        64,     64
GV*Ghostview.background:                white
GV*Ghostview.foreground:                black
GV.gsInterpreter:       gs
GV.gsCmdScanPDF:        gs -dNODISPLAY -dQUIET -sPDFname=%s -sDSCname=%s pdf2dsc.ps -c quit
GV.gsCmdConvPDF:        gs -dNODISPLAY -dQUIET  -dNOPAUSE -sPSFile=%s %s -c quit
GV.gsX11Device:         -sDEVICE=x11
GV.gsX11AlphaDevice:    -dNOPLATFONTS -sDEVICE=x11alpha
GV.gsSafer:             True
GV.gsQuiet:             True
GV.gsArguments:
GV.uncompressCommand:   gzip -d -c %s > %s
GV.printCommand:        lpr
GV.scratchDir:          ~/
GV.defaultSaveDir:      ~/
GV.fallbackPagemedia:   a4
GV.useBackingPixmap:    True
.DE
.fi 
.ec
.ft P
.sp

.SH Mouse and key bindings 

.Pp
.nr ll +1
.nr t\n(ll 2
.if \n(ll>1 .RS
.IP "\fBMouse bindings in the Main and the Zoom window\fP"
.nr bi 1
.Pp
The following mouse events are defined when the mouse pointer
is either on the displayed page or on a zoomed area:
.Pp
.nr ll +1
.nr t\n(ll 2
.if \n(ll>1 .RS
.IP "\fB-\fP press button 1, move mouse, release button 1"
.nr bi 1
.Pp
Scrolls the displayed page 'proportionally'.
.IP "\fB-\fP press button 3, move mouse, release button 3"
.nr bi 1
.Pp
Scrolls the displayed page 'absolutely'.
.IP "\fB-\fP double-click with button 1"
.nr bi 1
.Pp
In the main window this displays the previous/next page
if the double-click occured in the left/right half of the
window.
In a zoom window it does nothing.
.IP "\fB-\fP press button 2, release button 2"
.nr bi 1
.Pp
Pops up a small menu which allows to choose a magnification
for a certain area around the current mouse position.
After selecting a magnification a zoom window pops up
displaying the area at the chosen scale.
.IP "\fB-\fP press button 2, move mouse, release button 2"
.nr bi 1
.Pp
This draws and thereby defines a rectangular region which
can be displayed in a zoom window. The magnification for the
area can be selected by means of a popup menu which appears after
releasing button 2.
.IP " \fB-\fP press button 1, press button 2"
.nr bi 1
.Pp
Redisplays the current page. This event sequence works only
in the main window.
.IP "\fB-\fP press button 3, release button 3"
.nr bi 1
.Pp
Pops up a small menu which offers a few standard actions
like 'Redisplay', 'Mark Page', etc.
.if \n(ll>1 .RE
.nr ll -1
.IP "\fBMouse bindings in the File Selection popup\fP"
.nr bi 1
.Pp
The following mouse events are defined when the mouse pointer is
in the window of either a file or a directory list:
.Pp
.nr ll +1
.nr t\n(ll 2
.if \n(ll>1 .RS
.IP "\fB-\fP press button 1, move mouse, release button 1"
.nr bi 1
.Pp
Scrolls a file or directory list 'proportionally'.
.IP "\fB-\fP press button 2, move mouse, release button 2"
.nr bi 1
.Pp
Scrolls a file or directory list 'absolutely'.
.IP "\fB-\fP press button 2, release button 2"
.nr bi 1
.Pp
Scrolls a file or directory list one page up/down
if the button was pressed in the upper/lower half of the list.
.IP "\fB-\fP double-click with button 1 on a filename"
.nr bi 1
.Pp
Selects the file and closes the File Selection popup.
.IP "\fB-\fP click with button 1 on a directory name"
.nr bi 1
.Pp
Causes the contents of this directory to be displayed.
.if \n(ll>1 .RE
.nr ll -1
.IP "\fBMouse bindings in the Table of Contents\fP"
.nr bi 1
.Pp
The following mouse events are defined when the mouse pointer is
in the window showing a list of page numbers of the
current file:
.Pp
.nr ll +1
.nr t\n(ll 2
.if \n(ll>1 .RS
.IP "\fB-\fP press button 1, move mouse, release button 1"
.nr bi 1
.Pp
Scrolls the table of contents.
.IP "\fB-\fP press button 1 on a page number"
.nr bi 1
.Pp
Go to this page.
.IP "\fB-\fP press button 2 on a page number"
.nr bi 1
.Pp
Mark this page if it is unmarked, but unmark it if it is marked.
.IP "\fB-\fP press button 2, move mouse, release button 2"
.nr bi 1
.Pp
Marks/unmarks all unmarked/marked pages in the region
crossed by the mouse pointer during the movement.
.if \n(ll>1 .RE
.nr ll -1
.IP "\fBMouse bindings in the Panner widget\fP"
.nr bi 1
.Pp
The Panner widget is the rectangular region located close to the
left edge of the main window. It indicates the size and the
position of the visible area of the current page relative to the
total page.
.Pp
The following mouse events are defined when the mouse pointer is
in this region:
.Pp
.nr ll +1
.nr t\n(ll 2
.if \n(ll>1 .RS
.IP "\fB-\fP press button 1, move mouse"
.nr bi 1
.Pp
Scrolls the displayed page.
.IP "\fB-\fP press button 2"
.nr bi 1
.Pp
Display the previous page.
.IP "\fB-\fP press button 3"
.nr bi 1
.Pp
Display the next page.
.if \n(ll>1 .RE
.nr ll -1
.IP "\fBKey Bindings\fP"
.nr bi 1
.Pp
.DS
.sp 
.ft CR
.nf
A          Toggle antialiasing on and off
C          Center the page
O          Open a new file
Q          Quit gv
R          Reopen the current file
Z          Toggle gv's resizing behaviour
I          Respect/Ignore document structuring
E          Respect/Ignore EOF comments
W          Watch file / Don't watch file
S          Save the marked pages
Shift-S    Save the current file
P          Print the marked pages
Shift-P    Print the current file
B          Go to the previous page
BackSpace  Go to the previous page
Delete     Go to the previous page
Prior      Go to the previous page
F          Go to the next page
Space      Go to the next page
Return     Go to the next page
Next       Go to the next page
\&.          Redisplays the current page
Ctrl-L     Redisplays the current page
M          Mark the current page
N          Unmark the current page
Shift-7    Select the scale entry -7 relative to the scale 1.0
Shift-6    Select the scale entry -6 relative to the scale 1.0
Shift-5    Select the scale entry -5 relative to the scale 1.0
Shift-4    Select the scale entry -4 relative to the scale 1.0
Shift-3    Select the scale entry -3 relative to the scale 1.0
Shift-2    Select the scale entry -2 relative to the scale 1.0
Shift-1    Select the scale entry -1 relative to the scale 1.0
0          Select the scale 1.0
1          Select the scale entry 1 relative to the scale 1.0
2          Select the scale entry 2 relative to the scale 1.0
3          Select the scale entry 3 relative to the scale 1.0
4          Select the scale entry 4 relative to the scale 1.0
5          Select the scale entry 5 relative to the scale 1.0
6          Select the scale entry 6 relative to the scale 1.0
7          Select the scale entry 7 relative to the scale 1.0
+          Select the next scale entry.
-          Select the previous scale entry.
U          Scroll up
D          Scroll down
H          Scroll left
K          Scroll up
J          Scroll down
L          Scroll right
Arrow      Scroll in the direction of the arrow
.DE
.fi 
.ec
.ft P
.sp
.if \n(ll>1 .RE
.nr ll -1

.SH Comments about the user interface 

.Pp
.nr ll +1
.nr t\n(ll 2
.if \n(ll>1 .RS
.Pp
.IP "\fBScales\fP"
.nr bi 1
.Pp
The \*QScale\*U menu which allows to view the document
at different sizes is divided into two parts. The first part
shows a list of available scale bases, the second part,
separated by a line, lists the relative scales which are applied
with respect to the selected scale base.
.Pp
By default two scales bases are available, the \*QNatural size\*U
and the \*QPixel based\*U base.
When choosing the \*QPixel based\*U scale base a relative scale 
of 1.0 causes one postscript point to correspond to one pixel on the 
screen.
.Pp
When viewing a document at a relative scale of 1.0
using the \*QNatural size\*U base the page should appear in its
real size, as if printed on paper.
For the \*QNatural size\*U base to work properly gv has to know
the correct size of the root window. Automatic detection
of this size unfortunately only provides approximate results, therefore
it is best if it is provided by the user. To do so the resource
.DS
.sp 
.ft CR
.nf
   GV.screenSize:  <width> x <height>
.DE
.fi 
.ec
.ft P
.sp

should be added to the \*QSCREEN_RESOURCES\*U property of the screen
the document is viewed on, with <width> and <height>
describing the width and height of the root window in units of millimeters.
For instance by using the command
.DS
.sp 
.ft CR
.nf
   echo "GV.screenSize: 396 x 291" | xrdb -override -screen
.DE
.fi 
.ec
.ft P
.sp

a width of 346 mm and a height of 291 mm will be used for the
\*QNatural size\*U scale base.
Alternatively the resource
.DS
.sp 
.ft CR
.nf
   GV.screenSize_<machine>_<disp>_<scr>:  <width> x <height>
.DE
.fi 
.ec
.ft P
.sp

may be added to a resource file read by gv. Here
<machine> ,<disp> and ANGLED) describe
the display on which gv displays the document.
For instance, if the display is set to \*Qtic.tac.toe.wo:0.1\*U
the resource should be specified as
.DS
.sp 
.ft CR
.nf
   GV.screenSize_tic_0_1: 396 x 291
.DE
.fi 
.ec
.ft P
.sp

Note that this method doesn't work on VMS.
As a last alternative the resource
.DS
.sp 
.ft CR
.nf
   GV.screenSize:  <width> x <height>
.DE
.fi 
.ec
.ft P
.sp

may be added to one of the resource files. However, for obvious reasons
this method should be used only on single user machines.
.Pp
.IP "\fBScrolling\fP"
.nr bi 1
.Pp
It is probably a de facto standard for user interfaces
that windows are supposed to be scrolled by means of
scrollbars attached to their sides.
However, for various reasons the use of scrollbars
has been minimized in gv.
.Pp
Instead, in all windows with obscured data, scrolling
may be performed by
pressing button1, moving the mouse, then releasing button1
directly in the window. This includes the displayed page,
zoom popups, the table of contents and the file and 
directory lists displayed in the file selection popup.
.Pp
.IP "\fBDisplaying new versions of a document\fP"
.nr bi 1
.Pp
During document creation it is usually desirable to
always display the newest version of the document in work.
.Pp
Instead of explicitly loading it via the file selection
popup the most recent version can be displayed by
pressing the \*QRedisplay\*U button in the main window
(VMS users should use the \*QUpdate File\*U entry in the
\*QFile\*U menu).
Choosing the \*QRedisplay\*U entry in the menu that pops
up when clicking with the third mouse button anywhere on the
displayed page certainly has the same effect.
.Pp
More comfortable is the "Watch File" feature which may
be switched on by selecting the corresponding entry in the
\*QState\*U menu. If activated gv will check
every now and then if a new version of the displayed
file exists. If so it will be displayed automatically.
By default the file is checked about once every
second.
.Pp
Finally it may also be left to the document creating program
to trigger gv to update its display. To do so the
program should send the SIGHUP signal to gv.
For instance at the end of a shell script generating a
postscript file from latex sources the line
.DS
.sp 
.ft CR
.nf
   kill -SIGHUP <gv_pid>
.DE
.fi 
.ec
.ft P
.sp

may be added (here \f(CR<gv_pid>\fP is the process id of
gv). Executing the script and thereby creating a new
version of the document will then also cause the
result to be displayed instantaneously.
Please note that this feature is available only on X11 R6
based systems. 
.if \n(ll>1 .RE
.nr ll -1

.Pp
.SH Availability 

.Pp
The source code of the most recent version of gv may be
obtained from the following sources:
.nr ll +1
.nr t\n(ll 2
.if \n(ll>1 .RS
.IP "World Wide Web:"
.nr bi 1
.Pp
http://wwwthep.physik.uni-mainz.de/~plass/gv/
.IP "Anonymous ftp:"
.nr bi 1
.Pp
ftp://thep.physik.uni-mainz.de/pub/gv/
.if \n(ll>1 .RE
.nr ll -1

.SH Authors 

.Pp
.DS
.sp 
.ft CR
.nf
Johannes Plass             plass@thep.physik.uni-mainz.de
                           Department of Physics
                           Johannes Gutenberg University
                           Mainz, Germany

gv is derived from GhostView 1.5, created by
          Tim Theisen      Systems Programmer
Internet: tim@cs.wisc.edu  Department of Computer Sciences
    UUCP: uwvax!tim        University of Wisconsin-Madison
   Phone: (608)262-0438    1210 West Dayton Street
     FAX: (608)262-9777    Madison, WI   53706
.DE
.fi 
.ec
.ft P
.sp

.Pp
.SH Suggestions and bug reports 

.Pp
Please send suggestions or bug reports to plass@thep.physik.uni-mainz.de.
.Pp
.Pp
.Pp
.Pp
