/*
**
** options_gv.c
**
** Copyright (C) 1995, 1996, 1997 Johannes Plass
** 
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
** 
** Author:   Johannes Plass (plass@thep.physik.uni-mainz.de)
**           Department of Physics
**           Johannes Gutenberg-University
**           Mainz, Germany
**
*/

/*
#define MESSAGES
*/
#include "message.h"

#include "config.h"

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>

#include "paths.h"
#include INC_X11(Intrinsic.h)
#include INC_X11(StringDefs.h)
#include INC_X11(Shell.h)
#include INC_XAW(SimpleMenu.h)
#include INC_XAW(SmeBSB.h)
#include "Aaa.h"
#include "Button.h"
#include "FileSel.h"
#include "Ghostview.h"
#include "Frame.h"
#include "MButton.h"
#include "Switch.h"

#include "callbacks.h"
#include "d_memdebug.h"
#include "file.h"
#include "gv.h"
#include "popup.h"
#include "widgets_misc.h"
#include "main_resources.h"
#include "main_globals.h"
#include "misc.h"
#include "note.h"
#include "options.h"
#include "options_gv.h"
#include "ps.h"
#include "doc_misc.h"

#ifdef VMS
#   include "strcasecmp.h"
#else
#   include <unistd.h>
#endif

static Widget   optionControl;
static Widget   reverseScrollingToggle,confirmPrintToggle,antialiasToggle;
static Widget   dscToggle,eofToggle,autoCenterToggle,autoResizeToggle;
static Widget   swapLandscapeToggle,watchToggle,miscLabel;
static Widget   mediaLabel,mediaButton,mediaMenu;
static Widget   confirmLabel,confirmButton,confirmMenu;
static Widget   fmediaLabel,fmediaButton,fmediaMenu;
static Widget   orientLabel,orientButton,orientMenu;
static Widget   forientLabel,forientButton,forientMenu;
static Widget   magLabel,magButton,magMenu;
static Widget   showTitleToggle;
static Widget   filter,print_command, scratch_dir,default_save_dir,filters,dirs;
static Widget   uncompress;

static Bool	options_created = False;
static Bool	options_visible = False;

static String orientations[5] = { "Portrait","Landscape","Upside-Down","Seascape", NULL };
static String confirm_quit_styles[4] = { "Never","When processing","Always", NULL };
static int opt_orientation;
static int opt_pagemedia;

static void options_gv_setOptionsAtEntry();
static void options_gv_create();

/*######################################################
   options_gv_cb_popup
#######################################################*/

void options_gv_cb_popup(w, client_data, call_data)
   Widget	w;
   XtPointer	client_data, call_data;
{
   BEGINMESSAGE(options_gv_cb_popup)
   if (!options_created) options_gv_create();
   if (!options_visible) {
      options_gv_setOptionsAtEntry();
      popup_positionPopup(optiongvpopup,viewFrame,POPUP_POSITION_POS,4,4);
      XtPopup(optiongvpopup, XtGrabNone);
      options_visible=True;
   }
   ENDMESSAGE(options_gv_cb_popup)
}      

/*######################################################
   options_gv_cb_popdown
#######################################################*/

void options_gv_cb_popdown(w, client_data, call_data)
   Widget	w;
   XtPointer	client_data, call_data;
{
   BEGINMESSAGE(options_gv_cb_popdown)
   if (options_visible) {
      cb_popdownNotePopup((Widget)NULL,(XtPointer)NULL,NULL);
      XtPopdown(optiongvpopup);
      options_visible=False;
   }
   ENDMESSAGE(options_gv_cb_popdown)
}

/*------------------------------------------------------
   options_gv_setOptionsAtEntry
------------------------------------------------------*/

static void options_gv_setOptionsAtEntry()
{
  String s;
  Arg args[2];
  Cardinal n;
  int i;
  char tmp[100];

  BEGINMESSAGE(options_gv_setOptionsAtEntry)

  widgets_setToggle(antialiasToggle, (app_res.antialias ? 1 : 0));
  widgets_setToggle(confirmPrintToggle, (app_res.confirm_print ? 1 : 0));
  widgets_setToggle(reverseScrollingToggle, (app_res.reverse_scrolling ? 1 : 0));
  widgets_setToggle(dscToggle, ((gv_scanstyle & SCANSTYLE_IGNORE_DSC) ? 0 : 1));
  widgets_setToggle(eofToggle,        ((gv_scanstyle & SCANSTYLE_IGNORE_EOF) ? 1 : 0));
  widgets_setToggle(autoCenterToggle, (app_res.auto_center ? 1 : 0));
  widgets_setToggle(autoResizeToggle, (app_res.auto_resize ? 1 : 0));
  widgets_setToggle(swapLandscapeToggle, (gv_swap_landscape ? 1 : 0));
  widgets_setToggle(watchToggle, (app_res.watch_file ? 1 : 0));
  widgets_setToggle(showTitleToggle, (app_res.show_title ? 1 : 0));

  SMESSAGE(gv_print_command)
  widgets_setText(print_command, gv_print_command);
  SMESSAGE(app_res.scratch_dir)
  widgets_setText(scratch_dir,  app_res.scratch_dir);
  SMESSAGE(app_res.default_save_dir)
  widgets_setText(default_save_dir,  app_res.default_save_dir);
  SMESSAGE(gv_filters)
  widgets_setText(filters,gv_filters);
  SMESSAGE(gv_dirs)
  widgets_setText(dirs,gv_dirs);
  SMESSAGE(gv_filter)
  widgets_setText(filter,gv_filter);
  SMESSAGE(gv_uncompress_command)
  widgets_setText(uncompress,gv_uncompress_command);

  s=NULL;
  for (i = 0; papersizes[i].name; i++) {
    if (!strcasecmp(app_res.default_pagemedia,papersizes[i].name))
      s = papersizes[i].name;
  }
  if (!s) s = "Automatic";
                                   n=0;
  XtSetArg(args[n], XtNlabel, s);  n++;
  XtSetValues(mediaButton, args, n);
  opt_pagemedia = doc_convStringToPageMedia(NULL,s);

  s=NULL;
  for (i = 0; papersizes[i].name; i++) {
    if (!strcasecmp(app_res.fallback_pagemedia,papersizes[i].name))
      s = papersizes[i].name;
  }
  if (!s) s = "A4";
                                   n=0;
  XtSetArg(args[n], XtNlabel, s);  n++;
  XtSetValues(fmediaButton, args, n);

  s=NULL;
  for (i = 0; orientations[i]; i++) {
    if (!strcasecmp(app_res.default_orientation,orientations[i]))
      s = orientations[i];
  }
  if (!s) s = "Automatic";
                                   n=0;
  XtSetArg(args[n], XtNlabel, s);  n++;
  XtSetValues(orientButton, args, n);
  opt_orientation = doc_convStringToDocOrient(s);

  s=NULL;
  for (i = 0; orientations[i]; i++) {
    if (!strcasecmp(app_res.fallback_orientation,orientations[i]))
      s = orientations[i];
  }
  if (!s) s = orientations[0];
                                   n=0;
  XtSetArg(args[n], XtNlabel, s);  n++;
  XtSetValues(forientButton, args, n);

  s=confirm_quit_styles[app_res.confirm_quit];
                                   n=0;
  XtSetArg(args[n], XtNlabel, s);  n++;
  XtSetValues(confirmButton, args, n);

  sprintf(tmp,"%d",app_res.magstep);
                                   n=0;
  XtSetArg(args[n], XtNlabel, tmp);  n++;
  XtSetValues(magButton, args, n);

  ENDMESSAGE(options_gv_setOptionsAtEntry)
}

/*------------------------------------------------------
   options_gv_apply
------------------------------------------------------*/

static void options_gv_apply()
{
   Arg args[5];
   Cardinal n;
   char    *value, *str;
   static Boolean s_print_command = False;
   static Boolean s_uncompress = False;
   static Boolean s_scratch_dir = False;
   static Boolean s_default_save_dir = False;
   static Boolean s_media = False;
   static Boolean s_fmedia = False;
   static Boolean s_orient = False;
   static Boolean s_forient = False;
   Boolean b;
   int i,j,k;
   Boolean redisplay=False;
   Boolean reopen=False;
   char *l;

   BEGINMESSAGE(options_gv_apply)

   app_res.confirm_print = SwitchIsSet(confirmPrintToggle) ? True : False ;
   app_res.reverse_scrolling = SwitchIsSet(reverseScrollingToggle) ? True : False ;
   app_res.auto_center = SwitchIsSet(autoCenterToggle) ? True : False ;

   b = app_res.antialias;
   app_res.antialias = SwitchIsSet(antialiasToggle) ? True : False;
   cb_antialias(NULL,NULL,NULL); /* only change the menu entry */
   if (b != app_res.antialias) reopen=True;

   i = gv_swap_landscape;
   gv_swap_landscape = SwitchIsSet(swapLandscapeToggle) ? 1 : 0;
   if (i != gv_swap_landscape) redisplay=True;

   b = SwitchIsSet(autoResizeToggle) ? True : False;
   if (b != app_res.auto_resize) {
     cb_autoResize(NULL,NULL,NULL);
   }

   i = (gv_scanstyle & SCANSTYLE_IGNORE_DSC) ? 0 : 1;
   j = SwitchIsSet(dscToggle) ? 1 : 0;
   if (i != j) {
     gv_scanstyle = (gv_scanstyle & SCANSTYLE_IGNORE_DSC) ?
       (gv_scanstyle & ~SCANSTYLE_IGNORE_DSC) :
       (gv_scanstyle |  SCANSTYLE_IGNORE_DSC);
     cb_handleDSC(NULL,NULL,NULL);
     reopen=True;
   }

   b = SwitchIsSet(watchToggle) ? True : False;
   if (b != app_res.watch_file) {
     cb_watchFile(NULL,(XtPointer)1,NULL);
   }

   b = SwitchIsSet(showTitleToggle) ? True : False;
   if (b != app_res.show_title) {
     cb_showTitle(NULL,(XtPointer)1,NULL);
   }

   i = (gv_scanstyle & SCANSTYLE_IGNORE_EOF ? 1 : 0);
   j = SwitchIsSet(eofToggle) ? 1 : 0;
   if (i != j) {
     gv_scanstyle = (gv_scanstyle & SCANSTYLE_IGNORE_EOF) ?
       (gv_scanstyle & ~SCANSTYLE_IGNORE_EOF) :
       (gv_scanstyle |  SCANSTYLE_IGNORE_EOF);
     cb_handleEOF(NULL,NULL,NULL);
     reopen=True;
   }

   value = widgets_getText(uncompress);
   str = GV_XtNewString(value);
   if   (s_uncompress == True) {INFMESSAGE(freeing) GV_XtFree(gv_uncompress_command);} 
   else  s_uncompress =  True;
   gv_uncompress_command =  str;

   value = widgets_getText(print_command);
   str = GV_XtNewString(value);
   if   (s_print_command == True) {INFMESSAGE(freeing) GV_XtFree(gv_print_command);} 
   else  s_print_command =  True;
   gv_print_command =  str;

   value = widgets_getText(scratch_dir);
   str = GV_XtNewString(value);
   if   (s_scratch_dir == True) {INFMESSAGE(freeing) GV_XtFree(app_res.scratch_dir);} 
   else  s_scratch_dir =  True;
   app_res.scratch_dir =  str;

   value = widgets_getText(default_save_dir);
   str = GV_XtNewString(value);
   if   (s_default_save_dir == True) {INFMESSAGE(freeing) GV_XtFree(app_res.default_save_dir);} 
   else  s_default_save_dir =  True;
   app_res.default_save_dir =  str;

   value = widgets_getText(filters);
   str = GV_XtNewString(value);
   GV_XtFree(gv_filters);
   gv_filters =  str;

   value = widgets_getText(dirs);
   str = GV_XtNewString(value);
   GV_XtFree(gv_dirs);
   gv_dirs =  str;

   value = widgets_getText(filter);
   str = GV_XtNewString(value);
   GV_XtFree(gv_filter);
   gv_filter =  str;

   if (s_media) GV_XtFree(app_res.default_pagemedia);
							n=0;
   XtSetArg(args[n], XtNlabel, &app_res.default_pagemedia);n++;
   XtGetValues(mediaButton, args, n);
   app_res.default_pagemedia = GV_XtNewString(app_res.default_pagemedia);
   i = doc_convStringToPageMedia(NULL,app_res.default_pagemedia);
   if (i != opt_pagemedia) {
     INFMESSAGE(pagemedia changed)
     opt_pagemedia = i;
     j = gv_pagemedia_auto;
     k = gv_pagemedia;
     gv_pagemedia_auto = 0;
     i = doc_convStringToPageMedia(doc,app_res.default_pagemedia);
     cb_setPagemedia(NULL,(XtPointer)i,(XtPointer)1);
     if ((j != gv_pagemedia_auto) || (k != gv_pagemedia)) redisplay = True;
   }
   s_media = True;

   if (s_fmedia) GV_XtFree(app_res.fallback_pagemedia);
							n=0;
   XtSetArg(args[n], XtNlabel, &app_res.fallback_pagemedia);n++;
   XtGetValues(fmediaButton, args, n);
   app_res.fallback_pagemedia = GV_XtNewString(app_res.fallback_pagemedia);
   gv_fallback_pagemedia = doc_convStringToPageMedia(NULL,app_res.fallback_pagemedia);
   s_fmedia = True;

   if (s_orient) GV_XtFree(app_res.default_orientation);
							n=0;
   XtSetArg(args[n], XtNlabel, &app_res.default_orientation);n++;
   XtGetValues(orientButton, args, n);
   app_res.default_orientation = GV_XtNewString(app_res.default_orientation);
   i = doc_convStringToDocOrient(app_res.default_orientation);
   if (i != opt_orientation) {
     INFMESSAGE(orientation changed)
     opt_orientation = i;
     j = gv_orientation_auto;
     k = gv_orientation;
     gv_orientation_auto = 0;
     cb_setOrientation(NULL,(XtPointer)i,(XtPointer)1);
     if ((j != gv_orientation_auto) || (k != gv_orientation)) redisplay = True;
   }
   s_orient = True;

   if (s_forient) GV_XtFree(app_res.fallback_orientation);
							n=0;
   XtSetArg(args[n], XtNlabel, &app_res.fallback_orientation);n++;
   XtGetValues(forientButton, args, n);
   app_res.fallback_orientation = GV_XtNewString(app_res.fallback_orientation);
   gv_fallback_orientation = doc_convStringToDocOrient(app_res.fallback_orientation);
   s_forient = True;

							n=0;
   XtSetArg(args[n], XtNlabel, &l);                     n++;
   XtGetValues(magButton, args, n);
   app_res.magstep = i = atoi(l);
   if (i != gv_magstep) {
     INFMESSAGE(magstep changed)
     redisplay = True;
   }
   gv_magstep = i;

							n=0;
   XtSetArg(args[n], XtNlabel, &l);                     n++;
   XtGetValues(confirmButton, args, n);
   i=0;
   while (i<3) {
     if (!strcmp(confirm_quit_styles[i],l)) app_res.confirm_quit = i;
     ++i;
   }

							n=0;
   XtSetArg(args[n], XtNtmpDir, app_res.scratch_dir);	n++;
   XtSetArg(args[n], XtNfilters, gv_filters);		n++;
   XtSetArg(args[n], XtNdirs, gv_dirs);			n++;
   XtSetArg(args[n], XtNfilter, gv_filter);		n++;
   XtSetArg(args[n], XtNreverseScrolling,app_res.reverse_scrolling);n++;
   XtSetValues(FileSel, args, n);

   if (reopen) {
     if (gv_filename) {
        cb_stopInterpreter(page,NULL,NULL);
        show_page(REQUEST_REOPEN,NULL);
     }
   } else if (redisplay) show_page(REQUEST_OPTION_CHANGE,NULL);

   ENDMESSAGE(options_gv_apply)
}

/*------------------------------------------------------
   options_gv_cb_save
------------------------------------------------------*/

static
void options_gv_cb_save(w, client_data, call_data)
  Widget	w;
  XtPointer	client_data, call_data;
{
  int    argn = 0;
  String argi[25];
  String argv[25];
  char tmp[20];
  String l;
  Arg args[1];
  Cardinal n;
  int i;
  String t = "True";
  String f = "False";

  BEGINMESSAGE(options_gv_cb_save)

  if (!options_visible) {
    INFMESSAGE(option popup not up)
    ENDMESSAGE(options_gv_cb_save)
    return;
  }
  options_setArg(&(argi[argn]),&(argv[argn]),".printCommand:"        ,gv_intern_name,widgets_getText(print_command));
       ++argn;
  options_setArg(&(argi[argn]),&(argv[argn]),".uncompressCommand:"   ,gv_intern_name,widgets_getText(uncompress));
       ++argn;
  options_setArg(&(argi[argn]),&(argv[argn]),".scratchDir:"          ,gv_class       ,widgets_getText(scratch_dir));
       ++argn;
  options_setArg(&(argi[argn]),&(argv[argn]),".defaultSaveDir:"      ,gv_class       ,widgets_getText(default_save_dir));
       ++argn;
  options_setArg(&(argi[argn]),&(argv[argn]),".confirmPrint:"        ,gv_class       ,SwitchIsSet(confirmPrintToggle) ? t : f);
       ++argn;
  options_setArg(&(argi[argn]),&(argv[argn]),".reverseScrolling:"    ,gv_class       ,SwitchIsSet(reverseScrollingToggle) ? t : f);
       ++argn;
  options_setArg(&(argi[argn]),&(argv[argn]),".respectDSC:"          ,gv_class       ,SwitchIsSet(dscToggle) ? t : f);
       ++argn;
  options_setArg(&(argi[argn]),&(argv[argn]),".ignoreEOF:"           ,gv_class       ,SwitchIsSet(eofToggle) ? t : f);
       ++argn;
  options_setArg(&(argi[argn]),&(argv[argn]),".watchFile:"           ,gv_class       ,SwitchIsSet(watchToggle) ? t : f);
       ++argn;
  options_setArg(&(argi[argn]),&(argv[argn]),".showTitle:"           ,gv_class       ,SwitchIsSet(showTitleToggle) ? t : f);
       ++argn;
  options_setArg(&(argi[argn]),&(argv[argn]),".autoCenter:"          ,gv_class       ,SwitchIsSet(autoCenterToggle) ? t : f);
       ++argn;
  options_setArg(&(argi[argn]),&(argv[argn]),".antialias:"           ,gv_class       ,SwitchIsSet(antialiasToggle) ? t : f);
       ++argn;
  options_setArg(&(argi[argn]),&(argv[argn]),".autoResize:"          ,gv_class       ,SwitchIsSet(autoResizeToggle) ? t : f);
       ++argn;
  options_setArg(&(argi[argn]),&(argv[argn]),".swapLandscape:"       ,gv_class       ,SwitchIsSet(swapLandscapeToggle) ? t : f);
       ++argn;
  options_setArg(&(argi[argn]),&(argv[argn]),"*filters:"             ,gv_class       ,widgets_getText(filters));
       ++argn;
  options_setArg(&(argi[argn]),&(argv[argn]),"*filter:"              ,gv_class       ,widgets_getText(filter));
       ++argn;
  options_setArg(&(argi[argn]),&(argv[argn]),"*dirs:"                ,gv_class       ,widgets_getText(dirs));
       ++argn;
                                    n=0;
  XtSetArg(args[n], XtNlabel, &l);  n++;
  XtGetValues(mediaButton, args, n);
  options_setArg(&(argi[argn]),&(argv[argn]),".pageMedia:"           ,gv_class       ,l);
       ++argn;
  XtGetValues(fmediaButton, args, n);
  options_setArg(&(argi[argn]),&(argv[argn]),".fallbackPageMedia:"   ,gv_class       ,l);
       ++argn;
  XtGetValues(orientButton, args, n);
  options_setArg(&(argi[argn]),&(argv[argn]),".orientation:"         ,gv_class       ,l);
       ++argn;
  XtGetValues(forientButton, args, n);
  options_setArg(&(argi[argn]),&(argv[argn]),".fallbackOrientation:",gv_class        ,l);
       ++argn;
  XtGetValues(magButton, args, n);
  sprintf(tmp,"%d",atoi(l));
  options_setArg(&(argi[argn]),&(argv[argn]),".magstep:"            ,gv_class        ,tmp);
       ++argn;
  XtGetValues(confirmButton, args, n);
  i=0; while (i<3) {
     if (!strcmp(confirm_quit_styles[i],l)) sprintf(tmp,"%d",i);
     ++i;
   }
  options_setArg(&(argi[argn]),&(argv[argn]),".confirmQuit:"        ,gv_class        ,tmp);
       ++argn;

  options_save(argn,argi,argv);
  while (--argn >=0) {
    GV_XtFree(argi[argn]); 
    GV_XtFree(argv[argn]);
  }

  ENDMESSAGE(options_gv_cb_save)
}


/*------------------------------------------------------
   options_gv_cb_apply
------------------------------------------------------*/

static void options_gv_cb_apply(w, client_data, call_data)
   Widget	w;
   XtPointer	client_data, call_data;
{
   BEGINMESSAGE(options_gv_cb_apply)
   if (options_visible) options_gv_apply();
   ENDMESSAGE(options_gv_cb_apply)
}


/*------------------------------------------------------
   options_gv_create
------------------------------------------------------*/

void cb_changeMenuLabel(w, client_data, call_data)
  Widget	w;
  XtPointer	client_data, call_data;
{
  Arg      args[1];
  Cardinal n;
  char *l;
  Widget p;

  BEGINMESSAGE(cb_changeMenuLabel)
  p = XtParent(XtParent(w));
				      	n=0;
   XtSetArg(args[n], XtNlabel, &l);	n++;
   XtGetValues(w, args, n);
				      	n=0;
   XtSetArg(args[n], XtNlabel, l);	n++;
   XtSetValues(p, args, n);
  ENDMESSAGE(cb_changeMenuLabel)
}


static char *addTextTrans =
"\
<MapNotify>:display-caret(on,always)display-caret(off,always)\n\
<EnterNotify>:display-caret(on,always)\n\
<LeaveNotify>:display-caret(off,always)\
";

void options_gv_create()
{
   Arg          args[10];
   Cardinal     n;
   Dimension	minw,minh;
   Widget       w;
   char tmp[20];
   int i;
   static XtTranslations trans=(XtTranslations)NULL;

   BEGINMESSAGE(options_gv_create)

   if (options_created) {
     INFMESSAGE(popup exists)
     ENDMESSAGE(options_gv_create)
   }

        						n=0;
        XtSetArg(args[n], XtNallowShellResize, True);	n++;
   optiongvpopup = XtCreatePopupShell("optiongvPopup",transientShellWidgetClass,toplevel, args, n);

         						n=0;
        XtSetArg(args[n], XtNresizeWidth, True);	n++;
        XtSetArg(args[n], XtNresizeHeight, True);	n++;
        XtSetArg(args[n], XtNmaximumWidth, 0);	 	n++;
        XtSetArg(args[n], XtNmaximumHeight,0);	 	n++;
   optionControl = XtCreateManagedWidget("optionControl",aaaWidgetClass,optiongvpopup,args,n);

   miscLabel              = XtCreateManagedWidget("misc",labelWidgetClass,optionControl,NULL,(Cardinal)0);
   antialiasToggle        = XtCreateManagedWidget("antialias",switchWidgetClass,optionControl,NULL,(Cardinal)0);
   confirmPrintToggle     = XtCreateManagedWidget("confirmPrint",switchWidgetClass,optionControl,NULL,(Cardinal)0);
   reverseScrollingToggle = XtCreateManagedWidget("scrolling",switchWidgetClass,optionControl,NULL,(Cardinal)0);
   autoCenterToggle       = XtCreateManagedWidget("autoCenter",switchWidgetClass,optionControl,NULL,(Cardinal)0);
   autoResizeToggle       = XtCreateManagedWidget("autoResize",switchWidgetClass,optionControl,NULL,(Cardinal)0);
   swapLandscapeToggle    = XtCreateManagedWidget("swapLandscape",switchWidgetClass,optionControl,NULL,(Cardinal)0);
   dscToggle              = XtCreateManagedWidget("respectDSC",switchWidgetClass,optionControl,NULL,(Cardinal)0);
   eofToggle              = XtCreateManagedWidget("eof",switchWidgetClass,optionControl,NULL,(Cardinal)0);
   watchToggle            = XtCreateManagedWidget("watch",switchWidgetClass,optionControl,NULL,(Cardinal)0);
   showTitleToggle        = XtCreateManagedWidget("showTitle",switchWidgetClass,optionControl,NULL,(Cardinal)0);

                                         n=0;
   XtSetArg(args[n], XtNresize, False);  ++n;
   mediaLabel  = XtCreateManagedWidget("mediaLabel",labelWidgetClass,optionControl,args,n);
   mediaButton = XtCreateManagedWidget("mediaButton",mbuttonWidgetClass,optionControl,args,n);
   mediaMenu   = XtCreatePopupShell("menu", simpleMenuWidgetClass,mediaButton, args,n);
   w           = XtCreateManagedWidget("Automatic",smeBSBObjectClass,mediaMenu,args,n);
		 XtAddCallback(w, XtNcallback,cb_changeMenuLabel,NULL); 
   fmediaLabel  = XtCreateManagedWidget("fmediaLabel",labelWidgetClass,optionControl,args,n);
   fmediaButton = XtCreateManagedWidget("fmediaButton",mbuttonWidgetClass,optionControl,args,n);
   fmediaMenu   = XtCreatePopupShell("menu", simpleMenuWidgetClass,fmediaButton,args,n);
		 for (i = 0; papersizes[i].name; i++) {
		   if (i > 0) {
		     if ((papersizes[i].width == papersizes[i-1].width) &&
			 (papersizes[i].height == papersizes[i-1].height)) {
		       continue;
		     }
		   }
		   w = XtCreateManagedWidget(papersizes[i].name,smeBSBObjectClass, mediaMenu,NULL,(Cardinal)0);
  		       XtAddCallback(w, XtNcallback,cb_changeMenuLabel,NULL); 
		   if (i>0) { /* skip the bounding box */
		     w = XtCreateManagedWidget(papersizes[i].name,smeBSBObjectClass, fmediaMenu,NULL,(Cardinal)0);
		         XtAddCallback(w, XtNcallback,cb_changeMenuLabel,NULL); 
		   }
		 }

   orientLabel   = XtCreateManagedWidget("orientLabel",labelWidgetClass,optionControl,args,n);
   orientButton  = XtCreateManagedWidget("orientButton",mbuttonWidgetClass,optionControl,args,n);
   orientMenu    = XtCreatePopupShell("menu", simpleMenuWidgetClass,orientButton, args,n);
                   w = XtCreateManagedWidget("Automatic",smeBSBObjectClass,orientMenu,args,n);
		       XtAddCallback(w, XtNcallback,cb_changeMenuLabel,NULL); 
   forientLabel  = XtCreateManagedWidget("forientLabel",labelWidgetClass,optionControl,args,n);
   forientButton = XtCreateManagedWidget("forientButton",mbuttonWidgetClass,optionControl,args,n);
   forientMenu   = XtCreatePopupShell("menu", simpleMenuWidgetClass,forientButton, args,n);
		   for (i = 0; orientations[i]; i++) {
		     w = XtCreateManagedWidget(orientations[i],smeBSBObjectClass, orientMenu,NULL,(Cardinal)0);
		         XtAddCallback(w, XtNcallback,cb_changeMenuLabel,NULL); 
		     w = XtCreateManagedWidget(orientations[i],smeBSBObjectClass, forientMenu,NULL,(Cardinal)0);
		         XtAddCallback(w, XtNcallback,cb_changeMenuLabel,NULL); 
		   }

   magLabel   = XtCreateManagedWidget("magLabel",labelWidgetClass,optionControl,args,n);
   magButton  = XtCreateManagedWidget("magButton",mbuttonWidgetClass,optionControl,args,n);
   magMenu    = XtCreatePopupShell("menu", simpleMenuWidgetClass,magButton, args,n);
		for (i = app_res.minimum_magstep; i<= app_res.maximum_magstep; i++) {
		  sprintf(tmp,"  %d  ",i);
		  w = XtCreateManagedWidget(tmp,smeBSBObjectClass, magMenu,NULL,(Cardinal)0);
		      XtAddCallback(w, XtNcallback,cb_changeMenuLabel,NULL); 
		}

   confirmLabel  = XtCreateManagedWidget("confirmLabel",labelWidgetClass,optionControl,args,n);
   confirmButton = XtCreateManagedWidget("confirmButton",mbuttonWidgetClass,optionControl,args,n);
   confirmMenu   = XtCreatePopupShell("menu", simpleMenuWidgetClass,confirmButton, args,n);
		   for (i = 0; confirm_quit_styles[i]; i++) {
		     w = XtCreateManagedWidget(confirm_quit_styles[i],smeBSBObjectClass, confirmMenu,NULL,(Cardinal)0);
		         XtAddCallback(w, XtNcallback,cb_changeMenuLabel,NULL); 
		   }

        						n=0;
   w = XtCreateManagedWidget("apply", buttonWidgetClass,optionControl, args, n);
         XtAddCallback(w, XtNcallback, options_gv_cb_apply,NULL); 
   w = XtCreateManagedWidget("save", buttonWidgetClass,optionControl, args, n);
         XtAddCallback(w, XtNcallback, options_gv_cb_save,NULL);
   w = XtCreateManagedWidget("dismiss", buttonWidgetClass,optionControl, args, n);
         XtAddCallback(w, XtNcallback, options_gv_cb_popdown, NULL);
 
   uncompress       = widgets_createLabeledLineTextField("uncompress",   optionControl);
   print_command    = widgets_createLabeledLineTextField("printCommand", optionControl);
   scratch_dir      = widgets_createLabeledLineTextField("scratchDir",   optionControl);
   default_save_dir = widgets_createLabeledLineTextField("saveDir",      optionControl);
   filter           = widgets_createLabeledLineTextField("filter",       optionControl);
   if (!trans) trans=XtParseTranslationTable(addTextTrans);
   XtOverrideTranslations(print_command,trans);
   XtOverrideTranslations(scratch_dir,trans);
   XtOverrideTranslations(default_save_dir,trans);
   XtOverrideTranslations(filter,trans);

   filters    = widgets_createLabeledTextField("filters", optionControl);
   XtOverrideTranslations(filters,trans);

   dirs      = widgets_createLabeledTextField("dirs", optionControl);
   XtOverrideTranslations(dirs,trans);
/*
                                               n=0;
   XtSetArg(args[n], XtNtranslations, trans);  ++n;
   XtSetValues(print_command, args, n);
   XtSetValues(scratch_dir, args, n);
   XtSetValues(default_save_dir, args, n);
*/

   options_gv_setOptionsAtEntry();
   XtRealizeWidget(optiongvpopup);

   AaaWidgetGetNaturalSize((AaaWidget)optionControl,&minw,&minh);
   IIMESSAGE(minw,minh)
                                          n=0;
   XtSetArg(args[n], XtNminWidth, minw);  ++n;
   XtSetArg(args[n], XtNminHeight, minh); ++n;
   XtSetArg(args[n], XtNmaxWidth, XtUnspecifiedShellInt);  ++n;
/*
   XtSetArg(args[n], XtNmaxHeight, minh); ++n;
*/
   XtSetValues(optiongvpopup, args, n);

/*
                                       n=0;
   XtSetArg(args[n], XtNwidth, minw+130);  ++n;
   XtSetValues(optionControl, args, n);
*/
   XSetWMProtocols(XtDisplay(optiongvpopup),XtWindow(optiongvpopup),&wm_delete_window,1);

   options_created = True;  
                                
   ENDMESSAGE(options_gv_create)
}

