/*
**
** options_gs.c
**
** Copyright (C) 1995, 1996, 1997 Johannes Plass
** 
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
** 
** Author:   Johannes Plass (plass@thep.physik.uni-mainz.de)
**           Department of Physics
**           Johannes Gutenberg-University
**           Mainz, Germany
**
*/

/*
#define MESSAGES
*/
#include "message.h"

#include "config.h"

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>

#include "paths.h"
#include INC_X11(Intrinsic.h)
#include INC_X11(StringDefs.h)
#include INC_X11(Shell.h)
#include INC_XAW(SimpleMenu.h)
#include INC_XAW(SmeBSB.h)
#include INC_XAW(AsciiText.h)
#include "Aaa.h"
#include "Button.h"
#include "FileSel.h"
#include "Ghostview.h"
#include "Frame.h"
#include "MButton.h"
#include "Switch.h"

#include "callbacks.h"
#include "d_memdebug.h"
#include "file.h"
#include "gv.h"
#include "popup.h"
#include "widgets_misc.h"
#include "main_resources.h"
#include "main_globals.h"
#include "misc.h"
#include "note.h"
#include "options.h"
#include "options_gv.h"
#include "ps.h"
#include "doc_misc.h"

#ifdef VMS
#   include "strcasecmp.h"
#else
#   include <unistd.h>
#endif

static Widget   optionControl;
static Widget   quietToggle,saferToggle;

static Widget   scan,conv,gs,x11dev,x11alphadev,arguments;
static Bool	options_created = False;
static Bool	options_visible = False;

static Boolean s_gs = False;
static Boolean s_scan =   False;
static Boolean s_conv = False;
static Boolean s_arguments = False;
static Boolean s_x11dev = False;
static Boolean s_x11alphadev = False;

static void options_gs_setOptionsAtEntry();
static void options_gs_create();

/*######################################################
   options_gs_cb_popup
#######################################################*/

void options_gs_cb_popup(w, client_data, call_data)
   Widget	w;
   XtPointer	client_data, call_data;
{
   BEGINMESSAGE(options_gs_cb_popup)
   if (!options_created) options_gs_create();
   if (!options_visible) {
      options_gs_setOptionsAtEntry();
      popup_positionPopup(optiongspopup,viewFrame,POPUP_POSITION_POS,4,4);
      XtPopup(optiongspopup, XtGrabNone);
      options_visible=True;
   }
   ENDMESSAGE(options_gs_cb_popup)
}      

/*######################################################
   options_gv_cb_popdown
#######################################################*/

void options_gs_cb_popdown(w, client_data, call_data)
   Widget	w;
   XtPointer	client_data, call_data;
{
   BEGINMESSAGE(options_gv_cb_popdown)
   if (options_visible) {
      cb_popdownNotePopup((Widget)NULL,(XtPointer)NULL,NULL);
      XtPopdown(optiongspopup);
      options_visible=False;
   }
   ENDMESSAGE(options_gs_cb_popdown)
}

/*------------------------------------------------------
   options_gs_setOptionsAtEntry
------------------------------------------------------*/

static void options_gs_setOptionsAtEntry()
{
  BEGINMESSAGE(options_gs_setOptionsAtEntry)

  widgets_setToggle(saferToggle, gv_gs_safer);
  widgets_setToggle(quietToggle, gv_gs_quiet);

  SMESSAGE(gv_gs_interpreter)
  widgets_setText(gs, gv_gs_interpreter);
  SMESSAGE(gv_gs_cmd_scan_pdf)
  widgets_setText(scan, gv_gs_cmd_scan_pdf);
  SMESSAGE(gv_gs_cmd_conv_pdf)
  widgets_setText(conv, gv_gs_cmd_conv_pdf);
  SMESSAGE(gv_gs_x11_device)
  widgets_setText(x11dev, gv_gs_x11_device);
  SMESSAGE(gv_gs_x11_alpha_device)
  widgets_setText(x11alphadev, gv_gs_x11_alpha_device);
  SMESSAGE(gv_gs_arguments)
  widgets_setText(arguments, gv_gs_arguments);

  ENDMESSAGE(options_gs_setOptionsAtEntry)
}

/*------------------------------------------------------
   options_gs_apply
------------------------------------------------------*/

static Boolean options_gs_change (w,b,sP,fP)
  Widget w;
  Boolean b;
  String *sP;
  String *fP;
{
  String v;
  Boolean r=False;
  v = widgets_getText(w);
  v = options_squeeze(v);
  if (strcmp(v,*sP)) {
      if (b) *fP = *sP;
      *sP = v;
      r = True;
  } else GV_XtFree(v);
  return(r);
}

static void options_gs_apply()
{
   Arg args[5];
   Cardinal n;
   int i;
   Boolean reopen=False;
   String free[6] = {NULL,NULL,NULL,NULL,NULL,NULL};

   BEGINMESSAGE(options_gv_apply)

   i = gv_gs_quiet;
   gv_gs_quiet = SwitchIsSet(quietToggle) ? 1 : 0;
   if (i != gv_gs_quiet) reopen=True;

   i = gv_gs_safer;
   gv_gs_safer = SwitchIsSet(saferToggle) ? 1 : 0;
   if (i != gv_gs_safer) reopen=True;

   reopen = options_gs_change(gs,s_gs,&gv_gs_interpreter,&(free[0]));
   reopen = options_gs_change(scan,s_scan,&gv_gs_cmd_scan_pdf,&(free[1]));
            options_gs_change(conv,s_conv,&gv_gs_cmd_conv_pdf,&(free[2]));
   reopen = options_gs_change(x11dev,s_x11dev,&gv_gs_x11_device,&(free[3]));
   reopen = options_gs_change(x11alphadev,s_x11alphadev,&gv_gs_x11_alpha_device,&(free[4]));
   reopen = options_gs_change(arguments,s_arguments,&gv_gs_arguments,&(free[5]));

   if (reopen) {
     cb_stopInterpreter(page,NULL,NULL);
								n=0;
     XtSetArg(args[n], XtNinterpreter,gv_gs_interpreter);	n++;
     if (gv_gs_safer)  XtSetArg(args[n], XtNsafer,True);
     else              XtSetArg(args[n], XtNsafer,False);
                                                                n++;
     if (gv_gs_quiet)  XtSetArg(args[n], XtNquiet,True);
     else              XtSetArg(args[n], XtNquiet,False);
                                                                n++;
     XtSetArg(args[n], XtNarguments,gv_gs_arguments);           n++;
     XtSetValues(page, args, n);
     if (gv_filename) show_page(REQUEST_REOPEN,NULL);
   }

   for (i=0; i<6 ; i++) if (free[i]) GV_XtFree(free[i]);

   ENDMESSAGE(options_gv_apply)
}

/*------------------------------------------------------
   options_gs_cb_save
------------------------------------------------------*/

static void options_gs_setArg(w,argiP,argvP,argnP,format,name)
  Widget w;
  String *argiP;
  String *argvP;
  int    *argnP;
  String format;
  String name;
{
  String s;
  s = widgets_getText(w);
  s = options_squeeze(s);
  options_setArg(argiP,argvP,format,name,s);
  ++(*argnP);
  GV_XtFree(s);
}

static
void options_gs_cb_save(w, client_data, call_data)
  Widget	w;
  XtPointer	client_data, call_data;
{
  int    argn = 0;
  String argi[10];
  String argv[10];
  String t = "True";
  String f = "False";

  BEGINMESSAGE(options_gv_cb_save)

  if (!options_visible) {
    INFMESSAGE(option popup not up)
    ENDMESSAGE(options_gs_cb_save)
    return;
  }

  options_gs_setArg(gs         ,&(argi[argn]),&(argv[argn]),&argn,".gsInterpreter:"    ,gv_intern_name);
  options_gs_setArg(scan       ,&(argi[argn]),&(argv[argn]),&argn,".gsCmdScanPDF:"     ,gv_intern_name);
  options_gs_setArg(conv       ,&(argi[argn]),&(argv[argn]),&argn,".gsCmdConvPDF:"     ,gv_intern_name);
  options_gs_setArg(x11dev     ,&(argi[argn]),&(argv[argn]),&argn,".gsX11Device:"      ,gv_intern_name);
  options_gs_setArg(x11alphadev,&(argi[argn]),&(argv[argn]),&argn,".gsX11AlphaDevice:" ,gv_intern_name);
  options_gs_setArg(arguments  ,&(argi[argn]),&(argv[argn]),&argn,".gsArguments:"      ,gv_intern_name);

  options_setArg(&(argi[argn]),&(argv[argn]),".gsSafer:"          ,gv_intern_name ,SwitchIsSet(saferToggle) ? t : f);
  ++argn;
  options_setArg(&(argi[argn]),&(argv[argn]),".gsQuiet:"          ,gv_intern_name ,SwitchIsSet(quietToggle) ? t : f);
  ++argn;

  options_save(argn,argi,argv);
  while (--argn >=0) {
    GV_XtFree(argi[argn]); 
    GV_XtFree(argv[argn]);
  }

  ENDMESSAGE(options_gv_cb_save)
}

/*------------------------------------------------------
   options_gs_cb_defaults
------------------------------------------------------*/

extern String intern_resources[]; /* defined in main.c */
extern char *main_getInternResource();

static void options_gs_getInternResource(db,name,vP,bP,fP)
  XrmDatabase db;
  String name;
  String *vP;
  Boolean *bP;
  String *fP;
{
  BEGINMESSAGE(options_gs_getInternResource)
  if (*bP) *fP = *vP;
  *vP = main_getInternResource(db,name);
  *vP = GV_XtNewString(*vP);
  *bP = True;
  ENDMESSAGE(options_gs_getInternResource)
}

static void options_gs_cb_defaults(w, client_data, call_data)
  Widget	w;
  XtPointer	client_data, call_data;
{
  XrmDatabase db = NULL;
  String s,*sP = intern_resources;
  String free[6] = {NULL,NULL,NULL,NULL,NULL,NULL};
  int i;

  BEGINMESSAGE(options_gs_cb_defaults)
  if (!options_visible) {
    INFMESSAGE(option popup not up)
    ENDMESSAGE(options_gs_cb_defaults)
    return;
  }

  while (*sP) XrmPutLineResource(&db,*sP++);
  options_gs_getInternResource(db,"gsInterpreter",&gv_gs_interpreter,&s_gs,&(free[0]));
  options_gs_getInternResource(db,"gsCmdScanPDF",&gv_gs_cmd_scan_pdf,&s_scan,&(free[1]));
  options_gs_getInternResource(db,"gsCmdConvPDF",&gv_gs_cmd_conv_pdf,&s_conv,&(free[2]));
  options_gs_getInternResource(db,"gsX11Device",&gv_gs_x11_device,&s_x11dev,&(free[3]));
  options_gs_getInternResource(db,"gsX11AlphaDevice",&gv_gs_x11_alpha_device,&s_x11alphadev,&(free[4]));
  options_gs_getInternResource(db,"gsArguments",&gv_gs_arguments,&s_arguments,&(free[5]));
  s = main_getInternResource(db,"gsSafer");
  if (!strcasecmp(s,"true"))  gv_gs_safer = 1; else gv_gs_safer = 0;
  s = main_getInternResource(db,"gsQuiet");
  if (!strcasecmp(s,"true"))  gv_gs_quiet = 1; else gv_gs_quiet = 0;

  options_gs_setOptionsAtEntry();

  for (i=0; i<6 ; i++) if (free[i]) GV_XtFree(free[i]);
  XrmDestroyDatabase(db);

  ENDMESSAGE(options_gs_cb_defaults)
}

/*------------------------------------------------------
   options_gs_cb_apply
------------------------------------------------------*/

static void options_gs_cb_apply(w, client_data, call_data)
   Widget	w;
   XtPointer	client_data, call_data;
{
   BEGINMESSAGE(options_gs_cb_apply)
   if (options_visible) options_gs_apply();
   ENDMESSAGE(options_gs_cb_apply)
}

/*------------------------------------------------------
   options_gs_create
------------------------------------------------------*/

static char *addTextTrans =
"\
<MapNotify>:display-caret(on,always)display-caret(off,always)\n\
<EnterNotify>:display-caret(on,always)\n\
<LeaveNotify>:display-caret(off,always)\
";

void options_gs_create()
{
   Arg          args[10];
   Cardinal     n;
   Dimension	minw,minh;
   static XtTranslations trans=(XtTranslations)NULL;
   Widget w;

   BEGINMESSAGE(options_gs_create)

   if (options_created) {
     INFMESSAGE(popup exists)
     ENDMESSAGE(options_gs_create)
   }

        						n=0;
        XtSetArg(args[n], XtNallowShellResize, True);	n++;
   optiongspopup = XtCreatePopupShell("optiongsPopup",transientShellWidgetClass,toplevel, args, n);

         						n=0;
        XtSetArg(args[n], XtNresizeWidth, True);	n++;
        XtSetArg(args[n], XtNresizeHeight, True);	n++;
        XtSetArg(args[n], XtNmaximumWidth, 0);	 	n++;
        XtSetArg(args[n], XtNmaximumHeight,0);	 	n++;
   optionControl = XtCreateManagedWidget("optiongsControl",aaaWidgetClass,optiongspopup,args,n);

   saferToggle        = XtCreateManagedWidget("safer",switchWidgetClass,optionControl,NULL,(Cardinal)0);
   quietToggle        = XtCreateManagedWidget("quiet",switchWidgetClass,optionControl,NULL,(Cardinal)0);
 
   gs           = widgets_createLabeledLineTextField("gs",   optionControl);
   x11dev       = widgets_createLabeledLineTextField("x11dev", optionControl);
   x11alphadev  = widgets_createLabeledLineTextField("x11alphadev", optionControl);
   arguments    = widgets_createLabeledLineTextField("arguments", optionControl);
   scan         = widgets_createLabeledTextField("scan", optionControl);
   conv         = widgets_createLabeledTextField("conv", optionControl);
   if (!trans) trans=XtParseTranslationTable(addTextTrans);
   XtOverrideTranslations(gs,trans);
   XtOverrideTranslations(scan,trans);
   XtOverrideTranslations(conv,trans);
   XtOverrideTranslations(x11dev,trans);
   XtOverrideTranslations(x11alphadev,trans);
   XtOverrideTranslations(arguments,trans);

                                          n=0;
   XtSetArg(args[n], XtNwrap, XawtextWrapWord);  ++n;
   XtSetArg(args[n], XtNresize, XawtextResizeHeight);  ++n;
   XtSetArg(args[n], XtNscrollVertical, XawtextScrollNever);  ++n;
   XtSetValues(scan, args, n);
   XtSetValues(conv, args, n);

        						n=0;
   w = XtCreateManagedWidget("apply", buttonWidgetClass,optionControl, args, n);
         XtAddCallback(w, XtNcallback, options_gs_cb_apply,NULL); 
   w = XtCreateManagedWidget("save", buttonWidgetClass,optionControl, args, n);
         XtAddCallback(w, XtNcallback, options_gs_cb_save,NULL);
   w = XtCreateManagedWidget("dismiss", buttonWidgetClass,optionControl, args, n);
         XtAddCallback(w, XtNcallback, options_gs_cb_popdown, NULL);
   w = XtCreateManagedWidget("defaults", buttonWidgetClass,optionControl, args, n);
         XtAddCallback(w, XtNcallback, options_gs_cb_defaults, NULL);

   options_gs_setOptionsAtEntry();
   XtRealizeWidget(optiongspopup);

   AaaWidgetGetNaturalSize((AaaWidget)optionControl,&minw,&minh);
   IIMESSAGE(minw,minh)
                                          n=0;
   XtSetArg(args[n], XtNminWidth, minw);  ++n;
   XtSetArg(args[n], XtNminHeight, minh); ++n;
   XtSetArg(args[n], XtNmaxWidth, XtUnspecifiedShellInt);  ++n;
   XtSetArg(args[n], XtNmaxHeight, XtUnspecifiedShellInt);  ++n;
   XtSetValues(optiongspopup, args, n);

   XSetWMProtocols(XtDisplay(optiongspopup),XtWindow(optiongspopup),&wm_delete_window,1);

   options_created = True;  
                                
   ENDMESSAGE(options_gv_cb_create)
}
