/*
**
** options.c
**
** Copyright (C) 1995, 1996, 1997 Johannes Plass
** 
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
** 
** Author:   Johannes Plass (plass@thep.physik.uni-mainz.de)
**           Department of Physics
**           Johannes Gutenberg-University
**           Mainz, Germany
**
*/

/*
#define MESSAGES
*/
#include "message.h"

#include "config.h"

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>

#include "paths.h"
#include INC_X11(Intrinsic.h)

#include "d_memdebug.h"
#include "gv.h"
#include "main_resources.h"
#include "main_globals.h"
#include "file.h"
#include "note.h"
#include "options.h"

#ifdef VMS
#   define unlink remove
#else
#   include <unistd.h>
#endif

#define MESSAGE_STRING_LEN 512
#define MAX_RECORD_LENGTH  512


/*######################################################
   options_setArg
#######################################################*/

void options_setArg(argiP,argvP,format,name,value)
  String *argiP;
  String *argvP;
  String format;
  String name;
  String value;
{
  *argiP = XtMalloc((strlen(format)+strlen(name)+1)*sizeof(char));
  strcpy(*argiP,name);
  strcat(*argiP,format);
  *argvP = XtMalloc((strlen(value)+1)*sizeof(char));
  strcpy(*argvP,value);
}

/*######################################################
   options_squeeze
#######################################################*/

String  options_squeeze(s)
  String s;
{
  String d,md;

  BEGINMESSAGE(options_squeeze)
  if (!s) s = "";
  md = s = d = FS_XtNewString(s);
  while (isspace(*d)) d++;
  while (*d) {
    if (!isspace(*d) || !isspace(*(d+1))) {
       if (isspace(*d)) *s++=' ';
       else *s++=*d;
    }
    d++;
  }
  *s='\0';
  d = md +strlen(s);
  if (d != md) while (isspace(*(--d))) *d = '\0';
  return(md);
  ENDMESSAGE(options_squeeze)
}

/*------------------------------------------------------
   options_readline
------------------------------------------------------*/

#   define END_OF_RECORD "\n"

static char* options_readline(infile,lineP)
  FILE *infile;
  String *lineP;
{
  char tmp[MAX_RECORD_LENGTH];
  char *esc;
  int  multi;

  BEGINMESSAGE(options_readline)
  while (fgets(tmp,MAX_RECORD_LENGTH,infile)) {
    multi = *lineP ? strlen(*lineP) : 0;
    *lineP = GV_XtRealloc(*lineP,(multi+strlen(tmp)+1)*sizeof(char));
    if (!multi) (*lineP)[0] = '\0';
    strcat(*lineP,tmp);
    multi=0; esc = strrchr(tmp,'\\');
    if (esc && *(esc+1) == '\n') while (esc != tmp && *esc-- == '\\') multi = !multi;
    if (!multi) break;
  }
  ENDMESSAGE(options_readline)
  return(*lineP);
}

/*------------------------------------------------------
   options_writeline
------------------------------------------------------*/

static void options_writeline(outfile,header,value)
  FILE *outfile;
  String header;
  String value;
{
  int num_nl=0;
  char *line;
  char *nl=value;

  BEGINMESSAGE(options_writeline)
  while ((nl=strchr(nl,'\n'))) { nl++; num_nl++; }
  line = GV_XtMalloc((strlen(header) + strlen(value) + num_nl*3 + 2)*sizeof(char));
  line[0]='\0';
  strcpy(line,header);
  while (num_nl>=0) {
    if (num_nl>0) {
      nl=strchr(value,'\n');
      *nl++='\0';
    }
    strcat(line,value);
    if (num_nl) {
      value=nl;
      while(isspace(*value)) value++;
      if (*value=='\0') {
	strcat(line,"\n");
	num_nl=0;
      }
      else strcat(line,"\\n\\\n");
    }
    else        strcat(line,"\n");
    INFSMESSAGE(writing,line)
    fputs(line,outfile);
    num_nl--;
    value=nl;
    line[0]='\0';
  }
  GV_XtFree(line);
  ENDMESSAGE(options_writeline)
}

/*######################################################
   options_save
#######################################################*/

void options_save(argn,argi,argv)
  int  argn;
  String *argi;
  String *argv;
{
  FILE *tempfile;
  FILE *infile;
  char *tempfilename;
  char errorMessage[MESSAGE_STRING_LEN];

  BEGINMESSAGE(options_save)
  if (argn == 0) {
     INFMESSAGE(nothing to do)
     ENDMESSAGE(SaveOptionsToFile)
     return;
  }
  else --argn;

  if (!gv_user_defaults_file) {
    sprintf(errorMessage,"Save aborted: \nUndefined destination file.");
    NotePopupShowMessage(errorMessage);
    INFMESSAGE(undefined destination file)
    ENDMESSAGE(options_save)
    return;
  }
  INFSMESSAGE(trying to write to,gv_user_defaults_file)

  infile=fopen(gv_user_defaults_file,"r"); 
  tempfilename=file_getTmpFilename(gv_user_defaults_file,gv_user_defaults_file);
  INFSMESSAGE(using temporary file,tempfilename)
   
  if (!tempfilename || !(tempfile = fopen(tempfilename,"w"))) {
    sprintf(errorMessage,"Save aborted: \nCannot create temporary file");
    NotePopupShowMessage(errorMessage);
    INFMESSAGE(cannot create temporary file)
    fclose(infile);
    GV_XtFree(tempfilename);
    ENDMESSAGE(options_save)
    return;
  }

  if (infile) {
    char *tmp;
    char *line=NULL;
    int i,j;
    while (options_readline(infile,&line)) {
      SMESSAGE(line)
      i=j=0;
      while (i <= argn) {
	if (argi[i][0] != '\0' && !strncmp(line,argi[i],strlen(argi[i]))) {
	  INFSMESSAGE(found:,line)
	  tmp=strchr(line,':')+1;
	  while (isspace(*tmp) && *tmp != '\n') tmp++; *tmp = '\0';
	  options_writeline(tempfile,line,argv[i]);
          argi[i][0]='\0';
          j=i;
	  while (j<argn) {
	    tmp=argi[j]; argi[j]=argi[j+1]; argi[j+1]=tmp;
	    tmp=argv[j]; argv[j]=argv[j+1]; argv[j+1]=tmp;
	    j++;
	  }
	  j=1;
	  --argn;
	  break;
	}
	else ++i;
      }
      if (!j) fputs(line,tempfile);
      GV_XtFree(line);
      line=NULL;
    }
    fclose(infile);
  }
  if (argn>=0) fputs(END_OF_RECORD,tempfile);
  while (argn >= 0) {
    options_writeline(tempfile,argi[argn],argv[argn]);
    argn--;
  }
  fclose(tempfile);

  if (rename(tempfilename,gv_user_defaults_file)) {
    sprintf(errorMessage,"Save aborted: \nCannot rename temporary '%s'\n to '%s'",tempfilename,gv_user_defaults_file);
    NotePopupShowMessage(errorMessage);
    unlink(tempfilename);
    GV_XtFree(tempfilename);
    INFMESSAGE(cannot rename temporary file)
    ENDMESSAGE(options_save)
    return;
  }
  GV_XtFree(tempfilename);

  ENDMESSAGE(options_save)
}










