#  Copyright (C) 1993-2002, Ghostgum Software Pty Ltd.  All rights reserved.
#  
# This file is part of GSview.
#  
# This program is distributed with NO WARRANTY OF ANY KIND.  No author
# or distributor accepts any responsibility for the consequences of using it,
# or for whether it serves any particular purpose or works at all, unless he
# or she says so in writing.  Refer to the GSview Free Public Licence 
# (the "Licence") for full details.
#  
# Every copy of GSview must include a copy of the Licence, normally in a 
# plain ASCII text file named LICENCE.  The Licence grants you the right 
# to copy, modify and redistribute GSview, but only under certain conditions 
# described in the Licence.  Among other things, the Licence requires that 
# the copyright notice and this notice be preserved on all copies.

# Makefile for GSview for Windows - GSVIEW.EXE or GSVIEW32.EXE
# using Borland C++ 4.5 or C++Builder 4
#   copy gvwin.mak makefile
#   make
#

# Edit COMPBASE and WIN32 as required
!if $(__MAKE__) >= 0x520
BUILDER=4
COMPBASE = c:\progra~1\borland\cbuild~1
COMP16BASE = c:\bc45
!elif $(__MAKE__) >= 0x510
BUILDER=3
COMPBASE = c:\borland\cbuild~1
COMP16BASE = c:\bc45
!else
BUILDER=0
COMPBASE = c:\bc45
COMP16BASE = $(COMPBASE)
!endif
# DEBUG=1 for Debugging options
DEBUG=1
# WIN32 is the default
WIN32=1

# Shouldn't need editing below here
COMPDIR = $(COMPBASE)\bin
INCDIR = $(COMPBASE)\include
LIBDIR = $(COMPBASE)\lib

CLFLAG = -L$(LIBDIR)
!if $(WIN32)
WINEXT=32
CCAUX = bcc32 -WC
MODEL=32
CFLAGS=-v -WE -w -tWM -H=gsview32.sym -I"$(INCDIR)"
CC = $(COMPDIR)\bcc32
RCOMP = $(COMPDIR)\brcc32
!if $(DEBUG)
DEBUGLINK=-v
!endif
!else
WINEXT=16
CCAUX = $(COMP16BASE)\bin\bcc
MODEL=l
CFLAGS=-v -m$(MODEL) -zEGV_FAR_DATA -Ff=256 -W -2 -h -w -H=gsview16.sym -I"$(INCDIR)" $(OLD)
DEBUGLINK=/v
CC = $(COMP16BASE)\bin\bcc
RCOMP = $(COMPDIR)\brcc
LINK16 = $(COMP16BASE)\bin\tlink
!endif
!if $(BUILDER) >= 3
LINK=$(COMPDIR)\ilink32
HC=$(COMPBASE)\help\tools\hcw /E /C /M
!else
LINK=$(COMPDIR)\tlink32
HC=$(COMPDIR)\hc31
!endif

!if $(__MAKE__) >= 0x510
WININSTALL=winsetup.exe uninstgs.exe
!endif

all: gsview$(WINEXT).exe\
  gsviewen.hlp\
  gsvw$(WINEXT)de.dll gsviewde.hlp setp$(WINEXT)de.dll\
  gsvw$(WINEXT)es.dll gsviewes.hlp setp$(WINEXT)es.dll\
  gsvw$(WINEXT)fr.dll gsviewfr.hlp setp$(WINEXT)fr.dll\
  gsvw$(WINEXT)gr.dll gsviewgr.hlp setp$(WINEXT)gr.dll\
  gsvw$(WINEXT)it.dll gsviewit.hlp setp$(WINEXT)it.dll\
  gsvw$(WINEXT)nl.dll gsviewnl.hlp setp$(WINEXT)nl.dll\
  gvwgs$(WINEXT).exe gsv16spl.exe $(WININSTALL)

.cpp.obj:
	$(CC) -c $(CFLAGS) {$< }

# -P to compile as .cpp
.c.obj:
	$(CC) -c $(CFLAGS) {$< }

ECHOGSV=echogsv.exe

!include "gvcver.mak"
!include "gvwinc.mak"
	
# change cw32mt to cw32 for single thread
gsview32.exe: $(OBJS) gvwin32.res gvwin32.def
	$(LINK) -Tpe -aa -c -m -s $(DEBUGLINK) @&&!
$(LIBDIR)\c0w32 +
$(OBJS) +
,gsview32.exe,gsview32, +
$(LIBDIR)\import32 +
$(LIBDIR)\cw32mt, +
gvwin32.def, +
gvwin32.res
!

gsview16.exe: $(OBJS) gvwin16.res gvwin16.def
	$(LINK) -Twe -c -m -s $(DEBUGLINK) @&&!
$(LIBDIR)\c0w$(MODEL) +
$(OBJS) +
,gsview16.exe,gsview16, +
$(LIBDIR)\import +
$(LIBDIR)\mathw$(MODEL) +
$(LIBDIR)\cw$(MODEL), +
gvwin16.def, +
gvwin16.res
!

gsvw32de.dll: gvwlang.c gsvw32de.res de\gvwin32.def
	$(CC) -c -v -WD -w -I"$(INCDIR)" gvwlang.c
	$(LINK) -Tpd -c -m -s $(DEBUGLINK) @&&!
$(LIBDIR)\c0d32 +
gvwlang.obj +
,gsvw32de.dll,gsvw32de, +
$(LIBDIR)\import32 +
$(LIBDIR)\cw32mt, +
de\gvwin32.def, +
gsvw32de.res
!

gsvw16de.dll: gvwlang.c gsvw16de.res de\gvwin16.def
	$(CC) -ml -c -v -WD -w -I"$(INCDIR)" gvwlang.c
	$(LINK16) -Twd -c -m -s $(DEBUGLINK) @&&!
$(LIBDIR)\c0dl +
gvwlang.obj +
,gsvw16de.dll,gsvw16de, +
$(LIBDIR)\import +
$(LIBDIR)\cwl, +
de\gvwin16.def, +
gsvw16de.res
!

gsvw32es.dll: gvwlang.c gsvw32es.res es\gvwin32.def
	$(CC) -c -v -WD -w -I"$(INCDIR)" gvwlang.c
	$(LINK) -Tpd -c -m -s $(DEBUGLINK) @&&!
$(LIBDIR)\c0d32 +
gvwlang.obj +
,gsvw32es.dll,gsvw32es, +
$(LIBDIR)\import32 +
$(LIBDIR)\cw32mt, +
es\gvwin32.def, +
gsvw32es.res
!

gsvw32fr.dll: gvwlang.c gsvw32fr.res fr\gvwin32.def
	$(CC) -c -v -WD -w -I"$(INCDIR)" gvwlang.c
	$(LINK) -Tpd -c -m -s $(DEBUGLINK) @&&!
$(LIBDIR)\c0d32 +
gvwlang.obj +
,gsvw32fr.dll,gsvw32fr, +
$(LIBDIR)\import32 +
$(LIBDIR)\cw32mt, +
fr\gvwin32.def, +
gsvw32fr.res
!

gsvw32gr.dll: gvwlang.c gsvw32gr.res gr\gvwin32.def
	$(CC) -c -v -WD -w -I"$(INCDIR)" gvwlang.c
	$(LINK) -Tpd -c -m -s $(DEBUGLINK) @&&!
$(LIBDIR)\c0d32 +
gvwlang.obj +
,gsvw32gr.dll,gsvw32gr, +
$(LIBDIR)\import32 +
$(LIBDIR)\cw32mt, +
gr\gvwin32.def, +
gsvw32gr.res
!

gsvw16fr.dll: gvwlang.c gsvw16fr.res fr\gvwin16.def
	$(CC) -ml -c -v -WD -w -I"$(INCDIR)" gvwlang.c
	$(LINK16) -Twd -c -m -s $(DEBUGLINK) @&&!
$(LIBDIR)\c0dl +
gvwlang.obj +
,gsvw16fr.dll,gsvw16fr, +
$(LIBDIR)\import +
$(LIBDIR)\cwl, +
fr\gvwin16.def, +
gsvw16fr.res
!

gsvw32it.dll: gvwlang.c gsvw32it.res it\gvwin32.def
	$(CC) -c -v -WD -w -I"$(INCDIR)" gvwlang.c
	$(LINK) -Tpd -c -m -s $(DEBUGLINK) @&&!
$(LIBDIR)\c0d32 +
gvwlang.obj +
,gsvw32it.dll,gsvw32it, +
$(LIBDIR)\import32 +
$(LIBDIR)\cw32mt, +
it\gvwin32.def, +
gsvw32it.res
!

gsvw16it.dll: gvwlang.c gsvw16it.res it\gvwin16.def
	$(CC) -ml -c -v -WD -w -I"$(INCDIR)" gvwlang.c
	$(LINK16) -Twd -c -m -s $(DEBUGLINK) @&&!
$(LIBDIR)\c0dl +
gvwlang.obj +
,gsvw16it.dll,gsvw16it, +
$(LIBDIR)\import +
$(LIBDIR)\cwl, +
it\gvwin16.def, +
gsvw16it.res
!

gsvw32nl.dll: gvwlang.c gsvw32nl.res nl\gvwin32.def
	$(CC) -c -v -WD -w -I"$(INCDIR)" gvwlang.c
	$(LINK) -Tpd -c -m -s $(DEBUGLINK) @&&!
$(LIBDIR)\c0d32 +
gvwlang.obj +
,gsvw32nl.dll,gsvw32nl, +
$(LIBDIR)\import32 +
$(LIBDIR)\cw32mt, +
nl\gvwin32.def, +
gsvw32nl.res
!

uninstgs.exe: dwuninst.cpp dwuninst.h dwuninst.res dwuninst.def
	$(CC) -c -v -WE -w -I"$(INCDIR)" dwuninst.cpp
	$(LINK) -Tpe -aa -c -m -s $(DEBUGLINK) @&&!
$(LIBDIR)\c0w32 +
dwuninst.obj +
,uninstgs.exe,uninstgs, +
$(LIBDIR)\import32 +
$(LIBDIR)\cw32, +
dwuninst.def, +
dwuninst.res
!

winsetup.exe: winsetup.obj winsetup.res winsetup.def dwinst.obj gvcbeta.obj
!if $(WIN32)
	$(LINK) -Tpe -aa -c -m -s $(DEBUGLINK) @&&!
$(LIBDIR)\c0w32 +
winsetup.obj +
dwinst.obj gvcbeta.obj +
,winsetup.exe,winsetup, +
$(LIBDIR)\import32 +
$(LIBDIR)\cw32, +
winsetup.def, +
winsetup.res
!
!else
	$(LINK16) -Twe -c -m -s $(DEBUGLINK) @&&!
$(LIBDIR)\c0w$(MODEL) +
winsetup.obj +
winunzip.obj setupc.obj gvcbeta.obj gvwdde.obj +
,winsetup.exe,winsetup, +
$(LIBDIR)\import +
$(LIBDIR)\mathw$(MODEL) +
$(LIBDIR)\cw$(MODEL), +
winsetup.def, +
winsetup.res
!
!endif

setp32de.dll: gvwlang.c setp32de.res de\setup32.def
	$(CC) -c -v -WD -w -I"$(INCDIR)" gvwlang.c
	$(LINK) -Tpd -c -m -s $(DEBUGLINK) @&&!
$(LIBDIR)\c0d32 +
gvwlang.obj +
,setp32de.dll,setp32de, +
$(LIBDIR)\import32 +
$(LIBDIR)\cw32mt, +
de\setup32.def, +
setp32de.res
!

setp32es.dll: gvwlang.c setp32es.res es\setup32.def
	$(CC) -c -v -WD -w -I"$(INCDIR)" gvwlang.c
	$(LINK) -Tpd -c -m -s $(DEBUGLINK) @&&!
$(LIBDIR)\c0d32 +
gvwlang.obj +
,setp32es.dll,setp32es, +
$(LIBDIR)\import32 +
$(LIBDIR)\cw32mt, +
es\setup32.def, +
setp32es.res
!

setp32fr.dll: gvwlang.c setp32fr.res fr\setup32.def
	$(CC) -c -v -WD -w -I"$(INCDIR)" gvwlang.c
	$(LINK) -Tpd -c -m -s $(DEBUGLINK) @&&!
$(LIBDIR)\c0d32 +
gvwlang.obj +
,setp32fr.dll,setp32fr, +
$(LIBDIR)\import32 +
$(LIBDIR)\cw32mt, +
fr\setup32.def, +
setp32fr.res
!

setp32gr.dll: gvwlang.c setp32gr.res gr\setup32.def
	$(CC) -c -v -WD -w -I"$(INCDIR)" gvwlang.c
	$(LINK) -Tpd -c -m -s $(DEBUGLINK) @&&!
$(LIBDIR)\c0d32 +
gvwlang.obj +
,setp32gr.dll,setp32gr, +
$(LIBDIR)\import32 +
$(LIBDIR)\cw32mt, +
gr\setup32.def, +
setp32gr.res
!

setp32it.dll: gvwlang.c setp32it.res it\setup32.def
	$(CC) -c -v -WD -w -I"$(INCDIR)" gvwlang.c
	$(LINK) -Tpd -c -m -s $(DEBUGLINK) @&&!
$(LIBDIR)\c0d32 +
gvwlang.obj +
,setp32it.dll,setp32it, +
$(LIBDIR)\import32 +
$(LIBDIR)\cw32mt, +
it\setup32.def, +
setp32it.res
!

setp32nl.dll: gvwlang.c setp32nl.res nl\setup32.def
	$(CC) -c -v -WD -w -I"$(INCDIR)" gvwlang.c
	$(LINK) -Tpd -c -m -s $(DEBUGLINK) @&&!
$(LIBDIR)\c0d32 +
gvwlang.obj +
,setp32nl.dll,setp32nl, +
$(LIBDIR)\import32 +
$(LIBDIR)\cw32mt, +
nl\setup32.def, +
setp32nl.res
!

ungsview.exe: ungsview.obj ungsview.res ungsview.def
!if $(WIN32)
	$(LINK) -Tpe -aa -c -m -s $(DEBUGLINK) @&&!
$(LIBDIR)\c0w32 +
ungsview.obj +
,ungsview.exe,ungsview, +
$(LIBDIR)\import32 +
$(LIBDIR)\cw32, +
ungsview.def, +
ungsview.res
!
!else
	$(LINK16) -Twe -c -m -s $(DEBUGLINK) @&&!
$(LIBDIR)\c0w$(MODEL) +
ungsview.obj +
,ungsview.exe,ungsview, +
$(LIBDIR)\import +
$(LIBDIR)\mathw$(MODEL) +
$(LIBDIR)\cw$(MODEL), +
ungsview.def, +
ungsview.res
!
!endif


gvwgs32.exe: gvwgs.c gvwgs.h gvwgs32.res
	$(CC) -c -v -tWM -WE -w -I"$(INCDIR)" gvwgs.c
	$(LINK) -Tpe -aa -c -m -s $(DEBUGLINK) @&&!
$(LIBDIR)\c0w32 +
gvwgs.obj +
,gvwgs32.exe,gvwgs32, +
$(LIBDIR)\import32 +
$(LIBDIR)\cw32mt, +
gvwgs32.def, +
gvwgs32.res
!

gvwgs16.exe: gvwgs.c gvwgs.h gvwgs16.res
	$(CC) -c $(CFLAGS) gvwgs.c
	$(LINK16) -Twe -c -m -s $(DEBUGLINK) @&&!
$(LIBDIR)\c0w$(MODEL) +
gvwgs.obj +
,gvwgs16.exe,gvwgs16, +
$(LIBDIR)\import +
$(LIBDIR)\mathw$(MODEL) +
$(LIBDIR)\cw$(MODEL), +
gvwgs16.def, +
gvwgs16.res
!

gsv16spl.exe: gsv16spl.c gsv16spl.rc gsv16spl.def  $(LANGUAGE)\gvclang.h
	copy $(LANGUAGE)\gvclang.h gvclang.h
	$(COMP16BASE)\bin\bcc -W -ms -c -v -I$(COMP16BASE)\include $*.c
	$(COMP16BASE)\bin\brcc -i$(COMP16BASE)\include  -r $*.rc
	$(COMP16BASE)\bin\tlink /Twe /c /m /s /l $(DEBUGLINK) @&&!
$(COMP16BASE)\lib\c0ws +
$*.obj +
,$*.exe,$*, +
$(COMP16BASE)\lib\import +
$(COMP16BASE)\lib\mathws +
$(COMP16BASE)\lib\cws, +
$*.def
!
	$(COMP16BASE)\bin\rlink -t $*.res $*.exe

strip: all
	$(COMPDIR)\tdstrp32 gsview32.exe
	$(COMPDIR)\tdstrp32 gsvw32de.dll
	$(COMPDIR)\tdstrp32 gsvw32es.dll
	$(COMPDIR)\tdstrp32 gsvw32fr.dll
	$(COMPDIR)\tdstrp32 gsvw32gr.dll
	$(COMPDIR)\tdstrp32 gsvw32it.dll
	$(COMPDIR)\tdstrp32 gsvw32nl.dll
	$(COMPDIR)\tdstrp32 winsetup.exe
	$(COMPDIR)\tdstrp32 setp32de.dll
	$(COMPDIR)\tdstrp32 setp32es.dll
	$(COMPDIR)\tdstrp32 setp32fr.dll
	$(COMPDIR)\tdstrp32 setp32gr.dll
	$(COMPDIR)\tdstrp32 setp32it.dll
	$(COMPDIR)\tdstrp32 setp32nl.dll
	$(COMPDIR)\tdstrp32 uninstgs.exe

