/* Convert Greek code page 1253 to Unicode */
/* Ghostgum Software Pty Ltd. 2001-07-02 */
/* This file is in the public domain */

/* greek2uc.c */
#include <stdio.h>
#ifdef _MSC_VER
#include <io.h>
#include <fcntl.h>
#endif

unsigned int greek2unicode[] = {
 0x0000,  0x0001,  0x0002,  0x0003,  0x0004,  0x0005,  0x0006,  0x0007, 
 0x0008,  0x0009,  0x000a,  0x000b,  0x000c,  0x000d,  0x000e,  0x000f, 
 0x0010,  0x0011,  0x0012,  0x0013,  0x0014,  0x0015,  0x0016,  0x0017, 
 0x0018,  0x0019,  0x001a,  0x001b,  0x001c,  0x001d,  0x001e,  0x001f, 
 0x0020,  0x0021,  0x0022,  0x0023,  0x0024,  0x0025,  0x0026,  0x0027, 
 0x0028,  0x0029,  0x002a,  0x002b,  0x002c,  0x002d,  0x002e,  0x002f, 
 0x0030,  0x0031,  0x0032,  0x0033,  0x0034,  0x0035,  0x0036,  0x0037, 
 0x0038,  0x0039,  0x003a,  0x003b,  0x003c,  0x003d,  0x003e,  0x003f, 
 0x0040,  0x0041,  0x0042,  0x0043,  0x0044,  0x0045,  0x0046,  0x0047, 
 0x0048,  0x0049,  0x004a,  0x004b,  0x004c,  0x004d,  0x004e,  0x004f, 
 0x0050,  0x0051,  0x0052,  0x0053,  0x0054,  0x0055,  0x0056,  0x0057, 
 0x0058,  0x0059,  0x005a,  0x005b,  0x005c,  0x005d,  0x005e,  0x005f, 
 0x0060,  0x0061,  0x0062,  0x0063,  0x0064,  0x0065,  0x0066,  0x0067, 
 0x0068,  0x0069,  0x006a,  0x006b,  0x006c,  0x006d,  0x006e,  0x006f, 
 0x0070,  0x0071,  0x0072,  0x0073,  0x0074,  0x0075,  0x0076,  0x0077, 
 0x0078,  0x0079,  0x007a,  0x007b,  0x007c,  0x007d,  0x007e,  0x007f, 
 0x20ac,  0x0081,  0x201a,  0x0192,  0x201e,  0x2026,  0x2020,  0x2021, 
 0x0088,  0x2030,  0x008a,  0x2039,  0x008c,  0x008d,  0x008e,  0x008f, 
 0x0090,  0x2018,  0x2019,  0x201c,  0x201d,  0x2022,  0x2013,  0x2014, 
 0x0098,  0x2122,  0x009a,  0x203a,  0x009c,  0x009d,  0x009e,  0x009f, 
 0x00a0,  0x0385,  0x0386,  0x00a3,  0x00a4,  0x00a5,  0x00a6,  0x00a7, 
 0x00a8,  0x00a9,  0xf8f9,  0x00ab,  0x00ac,  0x00ad,  0x00ae,  0x2015, 
 0x00b0,  0x00b1,  0x00b2,  0x00b3,  0x0384,  0x00b5,  0x00b6,  0x00b7, 
 0x0388,  0x0389,  0x038a,  0x00bb,  0x038c,  0x00bd,  0x038e,  0x038f, 
 0x0390,  0x0391,  0x0392,  0x0393,  0x0394,  0x0395,  0x0396,  0x0397, 
 0x0398,  0x0399,  0x039a,  0x039b,  0x039c,  0x039d,  0x039e,  0x039f, 
 0x03a0,  0x03a1,  0xf8fa,  0x03a3,  0x03a4,  0x03a5,  0x03a6,  0x03a7, 
 0x03a8,  0x03a9,  0x03aa,  0x03ab,  0x03ac,  0x03ad,  0x03ae,  0x03af, 
 0x03b0,  0x03b1,  0x03b2,  0x03b3,  0x03b4,  0x03b5,  0x03b6,  0x03b7, 
 0x03b8,  0x03b9,  0x03ba,  0x03bb,  0x03bc,  0x03bd,  0x03be,  0x03bf, 
 0x03c0,  0x03c1,  0x03c2,  0x03c3,  0x03c4,  0x03c5,  0x03c6,  0x03c7, 
 0x03c8,  0x03c9,  0x03ca,  0x03cb,  0x03cc,  0x03cd,  0x03ce,  0xf8fb, 
};

FILE *infile;
FILE *outfile;;

int main(int argc, char *argv[])
{
int ch;
int code;

    infile = stdin;
    outfile = stdout;

    if (argc >= 2) {
	infile = fopen(argv[1], "rb");  
	if (infile == NULL) {
	    fprintf(stderr, "Can't open input file '%s'\n", argv[1]);
	    return 1;
	}
    }
    if (argc >= 3) {
	outfile = fopen(argv[2], "wb");  
	if (outfile == NULL) {
	    fprintf(stderr, "Can't open output file '%s'\n", argv[2]);
	    return 1;
	}
    }

#ifdef _MSC_VER
    _setmode(fileno(infile), _O_BINARY);
    _setmode(fileno(outfile), _O_BINARY);
#endif

    fputc(0xff, outfile);
    fputc(0xfe, outfile);
    while ( (ch = fgetc(infile)) != EOF ) {
	if ((ch >=0) && (ch <= 0xff)) {
	    code = greek2unicode[(unsigned int)ch];
	    fputc(code & 0xff, outfile);
	    fputc((code >> 8) & 0xff, outfile);
	}
    }
    return 0;
}
