/* codepage.c */
#include <stdio.h>
#include <string.h>
#ifdef _MSC_VER
#include <io.h>
#include <fcntl.h>
#endif

unsigned int *cp;

/* Used for OS/2 Western European languages */
/* 437 is the MS-DOS US English OEM code page */
unsigned int cp1252_to_437[] = {
0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 
17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 
48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 
64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 
80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 
 96,  97,  98,  99, 100, 101, 102, 103, 
104, 105, 106, 107, 108, 109, 110, 111, 
112, 113, 114, 115, 116, 117, 118, 119, 
120, 121, 122, 123, 124, 125, 126, 127, 

128, 129,  44, 159,  44,  95, 253, 252,
136,  37,  83,  60,  79, 141, 142, 143,
144,  96,  39,  34,  34,  249, 45,  95, 
152, 153, 115,  62, 111, 157, 158,  89,
 32, 173, 155, 156,  15, 157, 221,  21,
 34,  99, 166, 174, 170,  45, 114,  95,
248, 241, 253,  51,  39, 230,  20, 250,

 44,  49, 167, 175, 172, 171,  95, 168,
 65,  65,  65,  65, 142, 143, 146, 128,
 69, 144,  69,  69,  73,  73,  73,  73, 
 68, 165,  79,  79,  79,  79, 153, 120,

 79,  85,  85,  85, 154,  89,  95, 225, 
133, 160, 131,  97, 132, 134, 145, 135,
138, 130, 136, 137, 141, 161, 140, 139,
100, 164, 149, 162, 147, 111, 148, 246,
111, 151, 163, 150, 129, 121,  95, 152};

/* Code page 850 is OEM with better support for accented characters */
unsigned int cp1252_to_850[] = {
  0,   1,   2,   3,   4,   5,   6,   7, 
  8,   9,  10,  11,  12,  13,  14,  15, 
 16,  17,  18,  19,  20,  21,  22,  23, 
 24,  25,  26,  27,  28,  29,  30,  31, 
 32,  33,  34,  35,  36,  37,  38,  39, 
 40,  41,  42,  43,  44,  45,  46,  47, 
 48,  49,  50,  51,  52,  53,  54,  55, 
 56,  57,  58,  59,  60,  61,  62,  63, 
 64,  65,  66,  67,  68,  69,  70,  71, 
 72,  73,  74,  75,  76,  77,  78,  79, 
 80,  81,  82,  83,  84,  85,  86,  87, 
 88,  89,  90,  91,  92,  93,  94,  95, 
 96,  97,  98,  99, 100, 101, 102, 103, 
104, 105, 106, 107, 108, 109, 110, 111, 
112, 113, 114, 115, 116, 117, 118, 119, 
120, 121, 122, 123, 124, 125, 126, 127, 
 63,  63,  39, 159,  34,  46, 197, 206, 
 94,  37,  83,  60,  79,  63,  90,  63, 
 63,  39,  39,  34,  34,   7,  45,  45, 
126,  84, 115,  62, 111,  63, 122,  89, 
255, 173, 189, 156, 207, 190, 221, 245, 
249, 184, 166, 174, 170, 240, 169, 238, 
248, 241, 253, 252, 239, 230, 244, 250, 
247, 251, 167, 175, 172, 171, 243, 168, 
183, 181, 182, 199, 142, 143, 146, 128, 
212, 144, 210, 211, 222, 214, 215, 216, 
209, 165, 227, 224, 226, 229, 153, 158, 
157, 235, 233, 234, 154, 237, 232, 225, 
133, 160, 131, 198, 132, 134, 145, 135, 
138, 130, 136, 137, 141, 161, 140, 139, 
208, 164, 149, 162, 147, 228, 148, 246, 
155, 151, 163, 150, 129, 236, 231, 152};

unsigned int cp850_to_1252[] = {
  0,   1,   2,   3,   4,   5,   6,   7, 
  8,   9,  10,  11,  12,  13,  14,  15, 
 16,  17,  18,  19,  20,  21,  22,  23, 
 24,  25,  26,  27,  28,  29,  30,  31, 
 32,  33,  34,  35,  36,  37,  38,  39, 
 40,  41,  42,  43,  44,  45,  46,  47, 
 48,  49,  50,  51,  52,  53,  54,  55, 
 56,  57,  58,  59,  60,  61,  62,  63, 
 64,  65,  66,  67,  68,  69,  70,  71, 
 72,  73,  74,  75,  76,  77,  78,  79, 
 80,  81,  82,  83,  84,  85,  86,  87, 
 88,  89,  90,  91,  92,  93,  94,  95, 
 96,  97,  98,  99, 100, 101, 102, 103, 
104, 105, 106, 107, 108, 109, 110, 111, 
112, 113, 114, 115, 116, 117, 118, 119, 
120, 121, 122, 123, 124, 125, 126, 127, 
199, 252, 233, 226, 228, 224, 229, 231, 
234, 235, 232, 239, 238, 236, 196, 197, 
201, 230, 198, 244, 246, 242, 251, 249, 
255, 214, 220, 248, 163, 216, 215, 131, 
225, 237, 243, 250, 241, 209, 170, 186, 
191, 174, 172, 189, 188, 161, 171, 187, 
166, 166, 166, 166, 166, 193, 194, 192, 
169, 166, 166,  43,  43, 162, 165,  43, 
 43,  45,  45,  43,  45,  43, 227, 195, 
 43,  43,  45,  45, 166,  45,  43, 164, 
240, 208, 202, 203, 200, 105, 205, 206, 
207,  43,  43, 166,  95, 166, 204, 175, 
211, 223, 212, 210, 245, 213, 181, 254, 
222, 218, 219, 217, 253, 221, 175, 180, 
173, 177,  61, 190, 182, 167, 247, 184, 
176, 168, 183, 185, 179, 178, 166, 160};


/* Used for OS/2 Greek.  869 is IBM Modern Greek */
unsigned int cp1253_to_869[] = {
  0,   1,   2,   3,   4,   5,   6,   7, 
  8,   9,  10,  11,  12,  13,  14,  15, 
 16,  17,  18,  19,  20,  21,  22,  23, 
 24,  25,  26,  27,  28,  29,  30,  31, 
 32,  33,  34,  35,  36,  37,  38,  39, 
 40,  41,  42,  43,  44,  45,  46,  47, 
 48,  49,  50,  51,  52,  53,  54,  55, 
 56,  57,  58,  59,  60,  61,  62,  63, 
 64,  65,  66,  67,  68,  69,  70,  71, 
 72,  73,  74,  75,  76,  77,  78,  79, 
 80,  81,  82,  83,  84,  85,  86,  87, 
 88,  89,  90,  91,  92,  93,  94,  95, 
 96,  97,  98,  99, 100, 101, 102, 103, 
104, 105, 106, 107, 108, 109, 110, 111, 
112, 113, 114, 115, 116, 117, 118, 119, 
120, 121, 122, 123, 124, 125, 126, 127, 
 63, 129, 140, 102,  34,  58,  43,  43, 
 63,  37,  63,  60,  63,  63,  63,  63, 
 63, 139, 140,  34,  34,   7,  22,  22, 
 63,  84,  63,  62,  63,  63,  63,  63, 
255, 247, 134, 156, 111,  89, 138, 245, 
249, 151,  63, 174, 137, 240,  82, 142, 
248, 241, 153, 154, 239, 230,  20, 136, 
141, 143, 144, 175, 146, 171, 149, 152, 
161, 164, 165, 166, 167, 168, 169, 170, 
172, 173, 181, 182, 183, 184, 189, 190, 
198, 199,  63, 207, 208, 209, 210, 211, 
212, 213, 145, 150, 155, 157, 158, 159, 
252, 214, 215, 216, 221, 222, 224, 225, 
226, 227, 228, 229, 230, 231, 232, 233, 
234, 235, 237, 236, 238, 242, 243, 244, 
246, 250, 160, 251, 162, 163, 253,  63}; 

/* Used for HTML and Linux.  28597 is ISO-8859-7 */
/* 1253 and 8859-7 are almost identical. */ 
/* The major problem with 1253 is the location of capital alpha with tonos. */
unsigned int cp1253_to_28597[] = {
  0,   1,   2,   3,   4,   5,   6,   7, 
  8,   9,  10,  11,  12,  13,  14,  15, 
 16,  17,  18,  19,  20,  21,  22,  23, 
 24,  25,  26,  27,  28,  29,  30,  31, 
 32,  33,  34,  35,  36,  37,  38,  39, 
 40,  41,  42,  43,  44,  45,  46,  47, 
 48,  49,  50,  51,  52,  53,  54,  55, 
 56,  57,  58,  59,  60,  61,  62,  63, 
 64,  65,  66,  67,  68,  69,  70,  71, 
 72,  73,  74,  75,  76,  77,  78,  79, 
 80,  81,  82,  83,  84,  85,  86,  87, 
 88,  89,  90,  91,  92,  93,  94,  95, 
 96,  97,  98,  99, 100, 101, 102, 103, 
104, 105, 106, 107, 108, 109, 110, 111, 
112, 113, 114, 115, 116, 117, 118, 119, 
120, 121, 122, 123, 124, 125, 126, 127, 

 63, 129,  44, 102,  34,  46,  63,  63, 	/* 0x80 */
136,  63, 138,  60, 140, 141, 142, 143, 
144,  39,  39,  34,  34,  46,  45,  45, 
152,  84, 154,  62, 156, 157, 158, 159, 

160, 181, 182, 163,  36,  89, 166, 167, 	/* 0xa0 */
168, 169,  63, 171, 172, 173,  82, 175, 

176, 177, 178, 179, 180,  63,  63, 183, 
184, 185, 186, 187, 188, 189, 190, 191, 

192, 193, 194, 195, 196, 197, 198, 199, 	/* 0xc0 */
200, 201, 202, 203, 204, 205, 206, 207, 
208, 209, 210, 211, 212, 213, 214, 215, 
216, 217, 218, 219, 220, 221, 222, 223, 
224, 225, 226, 227, 228, 229, 230, 231, 
232, 233, 234, 235, 236, 237, 238, 239, 
240, 241, 242, 243, 244, 245, 246, 247, 
248, 249, 250, 251, 252, 253, 254,  63};

unsigned int cp1253_to_unicode[] = {
 0x0000,  0x0001,  0x0002,  0x0003,  0x0004,  0x0005,  0x0006,  0x0007, 
 0x0008,  0x0009,  0x000a,  0x000b,  0x000c,  0x000d,  0x000e,  0x000f, 
 0x0010,  0x0011,  0x0012,  0x0013,  0x0014,  0x0015,  0x0016,  0x0017, 
 0x0018,  0x0019,  0x001a,  0x001b,  0x001c,  0x001d,  0x001e,  0x001f, 
 0x0020,  0x0021,  0x0022,  0x0023,  0x0024,  0x0025,  0x0026,  0x0027, 
 0x0028,  0x0029,  0x002a,  0x002b,  0x002c,  0x002d,  0x002e,  0x002f, 
 0x0030,  0x0031,  0x0032,  0x0033,  0x0034,  0x0035,  0x0036,  0x0037, 
 0x0038,  0x0039,  0x003a,  0x003b,  0x003c,  0x003d,  0x003e,  0x003f, 
 0x0040,  0x0041,  0x0042,  0x0043,  0x0044,  0x0045,  0x0046,  0x0047, 
 0x0048,  0x0049,  0x004a,  0x004b,  0x004c,  0x004d,  0x004e,  0x004f, 
 0x0050,  0x0051,  0x0052,  0x0053,  0x0054,  0x0055,  0x0056,  0x0057, 
 0x0058,  0x0059,  0x005a,  0x005b,  0x005c,  0x005d,  0x005e,  0x005f, 
 0x0060,  0x0061,  0x0062,  0x0063,  0x0064,  0x0065,  0x0066,  0x0067, 
 0x0068,  0x0069,  0x006a,  0x006b,  0x006c,  0x006d,  0x006e,  0x006f, 
 0x0070,  0x0071,  0x0072,  0x0073,  0x0074,  0x0075,  0x0076,  0x0077, 
 0x0078,  0x0079,  0x007a,  0x007b,  0x007c,  0x007d,  0x007e,  0x007f, 
 0x20ac,  0x0081,  0x201a,  0x0192,  0x201e,  0x2026,  0x2020,  0x2021, 
 0x0088,  0x2030,  0x008a,  0x2039,  0x008c,  0x008d,  0x008e,  0x008f, 
 0x0090,  0x2018,  0x2019,  0x201c,  0x201d,  0x2022,  0x2013,  0x2014, 
 0x0098,  0x2122,  0x009a,  0x203a,  0x009c,  0x009d,  0x009e,  0x009f, 
 0x00a0,  0x0385,  0x0386,  0x00a3,  0x00a4,  0x00a5,  0x00a6,  0x00a7, 
 0x00a8,  0x00a9,  0xf8f9,  0x00ab,  0x00ac,  0x00ad,  0x00ae,  0x2015, 
 0x00b0,  0x00b1,  0x00b2,  0x00b3,  0x0384,  0x00b5,  0x00b6,  0x00b7, 
 0x0388,  0x0389,  0x038a,  0x00bb,  0x038c,  0x00bd,  0x038e,  0x038f, 
 0x0390,  0x0391,  0x0392,  0x0393,  0x0394,  0x0395,  0x0396,  0x0397, 
 0x0398,  0x0399,  0x039a,  0x039b,  0x039c,  0x039d,  0x039e,  0x039f, 
 0x03a0,  0x03a1,  0xf8fa,  0x03a3,  0x03a4,  0x03a5,  0x03a6,  0x03a7, 
 0x03a8,  0x03a9,  0x03aa,  0x03ab,  0x03ac,  0x03ad,  0x03ae,  0x03af, 
 0x03b0,  0x03b1,  0x03b2,  0x03b3,  0x03b4,  0x03b5,  0x03b6,  0x03b7, 
 0x03b8,  0x03b9,  0x03ba,  0x03bb,  0x03bc,  0x03bd,  0x03be,  0x03bf, 
 0x03c0,  0x03c1,  0x03c2,  0x03c3,  0x03c4,  0x03c5,  0x03c6,  0x03c7, 
 0x03c8,  0x03c9,  0x03ca,  0x03cb,  0x03cc,  0x03cd,  0x03ce,  0xf8fb, 
};

FILE *infile;
FILE *outfile;;
int unicode = 0;
int ch;

typedef struct codepage_s {
    const char *name;	    /* name of code page */
    unsigned int *table;    /* code page translation table */
    int unicode;	    /* non-zero if output is Unicode */
} codepage_t;

codepage_t cptable[] = {
    {"1252_437", cp1252_to_437, 0},	/* MS-DOS United States */
    {"1252_850", cp1252_to_850, 0},	/* MS-DOS Multilingual (Latin I) */
    {"850_1252", cp850_to_1252, 0},	/* MS-DOS Multilingual (Latin I) */
    {"1253_869", cp1253_to_869, 0},	 /* IBM Modern Greek */
    {"1253_28597",  cp1253_to_28597, 0}, /* ISO-8859-7 Greek */
    {"1253_8859-7", cp1253_to_28597, 0}, /* ISO-8859-7 Greek */
    {"1253_uc", cp1253_to_unicode, 1},   /* Greek to Unicode */
    {NULL, NULL}};

int main(int argc, char *argv[])
{
    int i;

    cp = NULL;
    if (argc >= 4) {
	for (i=0; cptable[i].name; i++) {
	    if (strcmp(argv[1], cptable[i].name)==0) {
		cp = cptable[i].table;
		unicode = cptable[i].unicode;
		break;
	    }
	}
    }
    
    if ((cp == NULL) || (argc != 4)) {
	fprintf(stderr, "Usage: codepage cp inputfile outputfile\n");
	fprintf(stderr, "cp is one of the following codepages:\n");
	for (i=0; cptable[i].name; i++)
	    fprintf(stderr, "  %s\n", cptable[i].name);
	return 1;
    }
    
    infile = fopen(argv[2], "rb");  
    if (infile == NULL) {
	fprintf(stderr, "Can't open input file '%s'\n", argv[1]);
	return 1;
    }
    
    
    outfile = fopen(argv[3], "wb");  
    if (outfile == NULL) {
	fprintf(stderr, "Can't open output file '%s'\n", argv[2]);
	return 1;
    }


#ifdef _MSC_VER
    _setmode(fileno(infile), _O_BINARY);
    _setmode(fileno(outfile), _O_BINARY);
#endif

    if (unicode) {
	fputc(0xff, outfile);
	fputc(0xfe, outfile);
    }
    while ( (ch = fgetc(infile)) != EOF ) {
	if ((ch >=0) && (ch <= 0xff)) {
	    if (unicode) {
	        fputc((char)( cp[(unsigned int)ch]       & 0xff), outfile);
	        fputc((char)((cp[(unsigned int)ch] >> 8) & 0xff), outfile);
	    }
	    else
	        fputc((char)cp[(unsigned int)ch], outfile);
	}
    }
    fclose(infile);
    fclose(outfile);
    return 0;
}
