# Copyright (C) 2002-2003 Ghostgum Software Pty Ltd.  All rights reserved.
#
#  This software is provided AS-IS with no warranty, either express or
#  implied.
#
#  This software is distributed under licence and may not be copied,
#  modified or distributed except as expressly authorised under the terms
#  of the licence contained in the file LICENCE in this distribution.
#
#  For more information about licensing, please refer to
#  http://www.ghostgum.com.au/ or contact Ghostsgum Software Pty Ltd, 
#  218 Gallaghers Rd, Glen Waverley VIC 3150, AUSTRALIA, 
#  Fax +61 3 9886 6616.
#

# $Id: unix.mak,v 1.21 2004/04/22 11:04:18 ghostgum Exp $
# Unix makefile

BINDIR=./bin
OBJDIR=./obj
SRCDIR=./src
SRCWINDIR=./srcwin
EPSOBJDIR=./objeps

prefix=
EPSTOOL_ROOT=/usr/local
EPSTOOL_BASE=$(prefix)$(EPSTOOL_ROOT)
EPSTOOL_BINDIR=$(EPSTOOL_BASE)/bin
EPSTOOL_MANDIR=$(EPSTOOL_BASE)/man
EPSTOOL_DOCDIR=$(EPSTOOL_BASE)/share/doc

INSTALL=install -m 644
INSTALL_EXE=install -m 755

XINCLUDE=
PFLAGS=-DMULTITHREAD
PLINK=-lpthread -lrt

GTKCFLAGS=-DGTK `pkg-config --cflags gtk+-2.0` -DGTK_DISABLE_DEPRECATED
GTKLIBS=`pkg-config --libs gtk+-2.0`

LIBPNGINC=-Ilibpng -Izlib
LIBPNGCFLAGS=-DHAVE_LIBPNG
LIBPNGLIBS=-lpng

#LONGFILEDEF=-DLARGEFILES -DFILE_OFFSET="long long" -DDSC_OFFSET="unsigned long long" -DDSC_OFFSET_FORMAT=\"llu\" -D_LARGEFILE_SOURCE -D_FILE_OFFSET_BITS=64
#LONGFILEMOD=clfile
LONGFILEDEF=
LONGFILEMOD=cfile

MAKE=make
CDEFS=-DX11 -DUNIX -DNONAG $(LONGFILEDEF)
CDEBUG+= -g
CFLAGS+= $(CDEFS) -Wall -Wstrict-prototypes -Wmissing-declarations -Wmissing-prototypes -fno-builtin -fno-common -Wcast-qual -Wwrite-strings $(CDEBUG) $(RPM_OPT_FLAGS) $(XINCLUDE) $(PFLAGS) $(LIBPNGCFLAGS) $(GTKCFLAGS)
CCAUX=gcc
CC=gcc
LFLAGS=$(PLINK) $(LIBPNGLIBS) $(GTKLIBS)
CLINK=gcc $(LDFLAGS)
LINK=gcc $(LDFLAGS)


COMP=$(CC) -I$(SRCDIR) -I$(OBJDIR) $(CFLAGS)


NUL=
DD=/$(NUL)
SRC=$(SRCDIR)/$(NUL)
SRCWIN=$(SRCWINDIR)/$(NUL)
OD=$(OBJDIR)/$(NUL)
BD=$(BINDIR)/$(NUL)
OBJ=.o
EXE=
CO=-c

FE=-o $(NUL)
FO=-o $(NUL)
FEO=-o $(OD)
FOO=-o $(OD)

CP=cp -f
RM=rm -f
RMDIR=rm -rf

OBJPLAT=$(OD)xapp$(OBJ) $(OD)xdll$(OBJ) $(OD)xdlg$(OBJ) \
 $(OD)xdoc$(OBJ) \
 $(OD)xgsimg$(OBJ) $(OD)xgssrv$(OBJ) $(OD)ximg$(OBJ) \
 $(OD)xmain$(OBJ) $(OD)xmenu$(OBJ) $(OD)xopt$(OBJ) \
 $(OD)xview$(OBJ) $(OD)$(LONGFILEMOD)$(OBJ)

EPSOBJPLAT=$(OD)xdll$(OBJ) $(OD)$(LONGFILEMOD)$(OBJ)
EPSLIB=-ldl $(LIBPNGLIBS)

xview_h=$(SRC)xview.h

XPM=$(SRCDIR)/xpm/$(NUL)
XPMBUTTONS=$(XPM)xback.xpm $(XPM)xfwd.xpm $(XPM)xgoto.xpm $(XPM)xhelp.xpm \
 $(XPM)xinfo.xpm $(XPM)xmagm.xpm $(XPM)xmagp.xpm $(XPM)xnext.xpm \
 $(XPM)xnexts.xpm $(XPM)xopen.xpm $(XPM)xprev.xpm $(XPM)xprevs.xpm \
 $(XPM)xprint.xpm

BEGIN=$(OD)lib.rsp
TARGET=$(BD)gsview$(EXE)

include $(SRC)common.mak

$(OD)lib.rsp: makefile
	-mkdir $(BINDIR)
	-mkdir $(OBJDIR)
	echo "dummy" > $(OD)lib.rsp

$(TARGET): $(OBJS)
	$(LINK) $(FE)$(TARGET) $(OBJS) $(LFLAGS)

# X11/gtk+ specific

$(OD)xapp$(OBJ): $(SRC)xapp.c $(common_h) $(dscparse_h) \
 $(copt_h) $(capp_h) $(cres_h) $(cver_h) $(cview_h) \
 en/clang.h en/clang.rc $(SRC)xlang.rc
	$(COMP) -Ien -I. $(FOO)xapp$(OBJ) $(CO) $(SRC)xapp.c

$(OD)xdlg$(OBJ): $(SRC)xdlg.c $(common_h) $(dscparse_h) \
 $(capp_h) $(cres_h) $(cview_h)
	$(COMP) $(FOO)xdlg$(OBJ) $(CO) $(SRC)xdlg.c

$(OD)xdll$(OBJ): $(SRC)xdll.c $(common_h) $(cdll_h)
	$(COMP) $(FOO)xdll$(OBJ) $(CO) $(SRC)xdll.c

$(OD)xdoc$(OBJ): $(SRC)xdoc.c $(common_h) $(dscparse_h) $(capp_h) $(cdoc_h)
	$(COMP) $(FOO)xdoc$(OBJ) $(CO) $(SRC)xdoc.c

$(OD)xgsimg$(OBJ): $(SRC)xgsimg.c $(common_h) $(gdevdsp_h) $(errors_h) \
 $(capp_h) $(cimg_h) $(cdisplay_h)
	$(COMP) $(FOO)xgsimg$(OBJ) $(CO) $(SRC)xgsimg.c

$(OD)xgssrv$(OBJ): $(SRC)xgssrv.c $(common_h) $(gdevdsp_h) $(dscparse_h) \
 $(capp_h) $(cimg_h) $(cdisplay_h) $(copt_h) $(cpdf_h) $(cgssrv_h)
	$(COMP) $(FOO)xgssrv$(OBJ) $(CO) $(SRC)xgssrv.c

$(OD)ximg$(OBJ): $(SRC)ximg.c $(common_h) $(gdevdsp_h) $(errors_h) $(cimg_h)
	$(COMP) $(FOO)ximg$(OBJ) $(CO) $(SRC)ximg.c

$(OD)xmain$(OBJ): $(SRC)xmain.c $(common_h) $(errors_h) $(iapi_h) \
 $(dscparse_h) $(copt_h) $(capp_h) $(cargs_h) $(cdoc_h) \
 $(cdll_h) $(cgsdll_h) $(cmsg_h) $(cview_h) $(cvcmd_h)
	$(COMP) $(FOO)xmain$(OBJ) $(CO) $(SRC)xmain.c

$(OD)xmenu$(OBJ): $(SRC)xmenu.c $(common_h) $(copt_h) $(cres_h) \
 $(cvcmd_h) $(cview_h) $(xview_h) $(XPMBUTTONS)
	$(COMP) $(FOO)xmenu$(OBJ) $(CO) $(SRC)xmenu.c

$(OD)xopt$(OBJ): $(SRC)xopt.c $(common_h) $(dscparse_h) \
 $(capp_h) $(cres_h) $(cview_h)
	$(COMP) $(FOO)xopt$(OBJ) $(CO) $(SRC)xopt.c

$(OD)xview$(OBJ): $(SRC)xview.c $(common_h) \
 $(errors_h) $(iapi_h) $(gdevdsp_h) \
 $(dscparse_h) $(copt_h) $(capp_h) $(cimg_h) $(cdisplay_h) $(cmsg_h) \
 $(dpagec_h) $(cgssrv_h) $(cvcmd_h) $(cview_h) $(xview_h)
	$(COMP) $(FOO)xview$(OBJ) $(CO) $(SRC)xview.c

epstool:
	make -f makefile GTKCFLAGS= GTKLIBS= LIBPNGCFLAGS= LIBPNGLIBS= OBJDIR=$(EPSOBJDIR) $(BD)epstool$(EXE)

epstool_clean:
	-$(RM) $(EPSOBJS)
	-$(RM) $(OD)lib.rsp
	-$(RM) $(BD)epstool$(EXE)
	-rmdir $(OBJDIR)

# Languages
$(BD)en.txt: $(SRC)xlang.c $(cver_h) $(cres_h) $(SRC)xlang.rc \
 en/clang.h en/clang.rc
	$(COMP) -Ien $(FEO)xlangen$(EXE) $(SRC)xlang.c
	$(BD)xlangen$(EXE) > $(BD)en.txt

epstool_install: epstool
	-mkdir -p $(EPSTOOL_BASE)
	chmod 755 $(EPSTOOL_BASE)
	-mkdir -p $(EPSTOOL_BINDIR)
	chmod 755 $(EPSTOOL_BINDIR)
	$(INSTALL_EXE) $(BD)epstool$(EXE) $(EPSTOOL_BINDIR)$(DD)epstool$(EXE)
	-mkdir -p $(EPSTOOL_MANDIR)
	chmod 755 $(EPSTOOL_MANDIR)
	-mkdir -p $(EPSTOOL_MANDIR)$(DD)man1
	chmod 755 $(EPSTOOL_MANDIR)$(DD)man1
	$(INSTALL) doc$(DD)epstool.1 $(EPSTOOL_MANDIR)$(DD)man1$(DD)epstool.1
	-mkdir -p $(EPSTOOL_DOCDIR)
	chmod 755 $(EPSTOOL_DOCDIR)
	$(INSTALL) doc$(DD)epstool.htm $(EPSTOOL_DOCDIR)$(DD)epstool.htm
	$(INSTALL) LICENCE $(EPSTOOL_DOCDIR)$(DD)LICENCE


clean:
	-$(RM) $(OBJS)
	-$(RM) $(TARGET)
	-$(RM) $(OD)lib.rsp
	make -f makefile OBJDIR=$(EPSOBJDIR) epstool_clean
	-rmdir $(BINDIR) $(OBJDIR) 

