/* Copyright (C) 1993-2001, Ghostgum Software Pty Ltd.  All rights reserved.
  
  This file is part of GSview.
  
  This program is distributed with NO WARRANTY OF ANY KIND.  No author
  or distributor accepts any responsibility for the consequences of using it,
  or for whether it serves any particular purpose or works at all, unless he
  or she says so in writing.  Refer to the GSview Free Public Licence 
  (the "Licence") for full details.
  
  Every copy of GSview must include a copy of the Licence, normally in a 
  plain ASCII text file named LICENCE.  The Licence grants you the right 
  to copy, modify and redistribute GSview, but only under certain conditions 
  described in the Licence.  Among other things, the Licence requires that 
  the copyright notice and this notice be preserved on all copies.
*/

/* gvwinit.c */
/* Initialisation routines for Windows GSview */
#include "gvwin.h"

static void init_displays(void);

/* Open/Save File Dialog Box */
OPENFILENAME ofn;
TCHAR szOFilename[MAXSTR];	/* filename for OFN */
/* buttons */
WNDPROC lpfnButtonWndProc;	/* default button WndProc */
struct buttonlist {
   HWND hbutton;
   struct buttonlist *next;
};
struct buttonlist *buttonhead, *buttontail;
BOOL dde_exit = FALSE;		/* exit after sending DDE command */

BOOL parse_args(GSVIEW_ARGS *pargs);

/* convert gs version integer to string */
/* buf must be 6 chars or longer */
void gsver_string(int ver, char *buf)
{
    /* make sure length including null never exceeds 6 */
    if (ver >= 9999)
	strcpy(buf, "0.0");
    sprintf(buf, "%d.%02d", ver / 100, ver % 100);
}

/* convert gs version string to integer */
int gsver_int(char *buf)
{
    int ver;
    if (strlen(buf) == 4)
	ver = (buf[0]-'0')*100 + (buf[2]-'0')*10 + (buf[3]-'0');
    else if (strlen(buf) == 3)
	ver = (buf[0]-'0')*100 + (buf[2]-'0')*10;
    else
	ver = GS_REVISION;
    return ver;
}

void
drop_filename(HWND hwnd, char *str)
{
    /* Send the message to the main window */
    if (strlen(str) != 0) {
	/* open file specified on command line */
	HGLOBAL hglobal;
	LPSTR szFile;
	hglobal = GlobalAlloc(GHND | GMEM_SHARE, strlen(str)+1);
	if (hglobal) {
	    szFile = (LPSTR)GlobalLock(hglobal);
	    strcpy(szFile, str);
	    GlobalUnlock(hglobal);
	    PostMessage(hwnd, WM_COMMAND, IDM_DROP, (LPARAM)hglobal);
	}
    }
}

/* Don't start another instance - use previous instance */
/* This is never used in Win95/NT */
void
gsview_init0(LPSTR lpszCmdLine)
{
	HWND hwnd = FindWindow(szClassName, NULL);
	BringWindowToTop(hwnd);
#ifdef NOTUSED
#if __BORLANDC__ == 0x452
	/* avoid bug in BC++ 4.0 */
	/* skip over EXE name */
	while ( *lpszCmdLine && (*lpszCmdLine!=' ')) 
		lpszCmdLine++;
	while ( *lpszCmdLine && (*lpszCmdLine==' ')) 
		lpszCmdLine++;
#endif
#endif
	drop_filename(hwnd, lpszCmdLine);
}


char workdir[MAXSTR];

/* This code allows GSview to automatically find the language DLLs.
 * This allows languages to be added without having to alter the
 * source code of the GSview executable.
 */

/* At startup, we look for language DLLs in the GSview EXE directory
 * which have the following name.  The ?? is replaced by the two
 * letter Internet country code.
 */
const TCHAR lang_pattern[] = TEXT("gsvw32??.dll");
const int lang_offset = 6;  /* offset to ?? */

/* We load each of these DLLs and if they contain a version
 * string that matches the GSview EXE, we consider them to
 * be a valid language DLL.  We store the details about each
 * in the following structure.  
 * The id is allocated automatically.
 * We refer to each language in the INI file using the twocc code, 
 * which matches the two letter Internet country code.
 * Each language DLL provides a bitmap of the language name,
 * to allow it to be displayed on systems without that language
 * installed.
 * The required ANSI codepage is in codepage.  If any code page is
 * acceptable (e.g. English) then this may be 0.
 */
typedef struct lang_s {
    int id;
    char twocc[3];
    TCHAR dllname[MAXSTR];
    HBITMAP bitmap;
    int codepage;
} lang_t;

/* The list of language DLLs available */
#define MAXLANG 19
lang_t lang[MAXLANG];
int nlang;

int
language_find(void)
{
    int i;
    HANDLE hff = INVALID_HANDLE_VALUE;
    WIN32_FIND_DATA wfd;
    TCHAR dirname[MAXSTR];
    TCHAR pattern[1024];
    int twocc_index;
    HINSTANCE hInstance;

    for (i=0; i<MAXLANG; i++) {
	lang[i].id = 0;
	lang[i].twocc[0] = '\0';
	lang[i].dllname[0] = '\0';
	lang[i].bitmap = NULL;
    }

    /* First language is always English */
    nlang = 0;
    lang[nlang].id = IDM_LANGMENU + nlang + 1;
    lang[nlang].twocc[0] = 'e';
    lang[nlang].twocc[1] = 'n';
    lang[nlang].twocc[2] = '\0';
    lang[nlang].dllname[0] = '\0';
    lang[nlang].bitmap = LoadBitmap(phInstance, MAKEINTRESOURCE(ID_LANG));
    nlang++;

    /* Now search for language DLLs */
    GetModuleFileName(phInstance, dirname, sizeof(dirname));
    for (i=lstrlen(dirname)-1; i>0; i--) {
	if (dirname[i] == '\\') {
	    dirname[i+1] = '\0';
	    break;
	}
    }
    lstrcpy(pattern, dirname);
    lstrcat(pattern, lang_pattern);
    twocc_index = lstrlen(pattern - 6);
    memset(&wfd, 0, sizeof(wfd));

    hff = FindFirstFile(pattern, &wfd);
    while (hff != INVALID_HANDLE_VALUE) {
        lang[nlang].id = IDM_LANGMENU + nlang + 1;
	lang[nlang].twocc[0] = wfd.cFileName[lang_offset];
	lang[nlang].twocc[1] = wfd.cFileName[lang_offset+1];
	lang[nlang].twocc[2] = '\0';
	if (lstrlen(dirname) + lstrlen(wfd.cFileName) < 
	    sizeof(lang[nlang].dllname)/sizeof(TCHAR)-1) {
	    lstrcpy(lang[nlang].dllname, dirname); 
	    lstrcat(lang[nlang].dllname, wfd.cFileName); 
 	}
	else
	    lang[nlang].id = 0;	/* can't do it */
	lang[nlang].bitmap = NULL;

	/* Try opening DLL */
        hInstance = LoadLibrary(lang[nlang].dllname);
        if (hInstance >= (HINSTANCE)HINSTANCE_ERROR) {
	    TCHAR vbuf[MAXSTR];
	    /* Make sure DLL version matches EXE */
	    memset(vbuf, 0, sizeof(vbuf));
	    LoadString(hInstance, IDS_GSVIEWVERSION, vbuf, sizeof(vbuf));
	    if (lstrcmp(TEXT(GSVIEW_DOT_VERSION), vbuf) != 0)
		lang[nlang].id = 0;
	    else  {
		/* Load bitmap of language name */
		lang[nlang].bitmap = LoadBitmap(hInstance, 
			MAKEINTRESOURCE(ID_LANG));
		/* Get required code page */
		LoadString(hInstance, IDS_CODEPAGE, vbuf, sizeof(vbuf));
#ifdef UNICODE
		lang[nlang].codepage = _wtoi(vbuf);
#else
		lang[nlang].codepage = atoi(vbuf);
#endif
	    }
	    FreeLibrary(hInstance);
	}

	if (lang[nlang].id != 0)
	    nlang++;	/* found a valid language */

	if (!FindNextFile(hff, &wfd)) {
	    FindClose(hff);
	    hff = INVALID_HANDLE_VALUE;
	}
    }

    return 0;
}

int language_free(void)
{
    int i;
    for (i=0; i<nlang; i++) {
	lang[i].id = 0;
	lang[i].twocc[0] = '\0';
	lang[i].dllname[0] = '\0';
	if (lang[i].bitmap)
	    DeleteObject((HGDIOBJ)lang[i].bitmap);
    }
    return 0;
}

int language_id(const char *str)
{
    int i;
    for (i=0; i<nlang; i++) {
	if (strcmp(str, lang[i].twocc) == 0)
	    return lang[i].id;
    }
    return 0;
}

int language_lookup(int id)
{
    int i;
    for (i=0; i<nlang; i++) {
	if (id == lang[i].id)
	    return i;
    }
    return 0;
}

const char * language_twocc(int id)
{
    int i;
    for (i=0; i<nlang; i++) {
	if (id == lang[i].id)
	    return lang[i].twocc;
    }
    return "en";
}

const TCHAR * language_dllname(int id)
{
    int i;
    for (i=0; i<nlang; i++) {
	if (id == lang[i].id)
	    return lang[i].dllname;
    }
    return TEXT("");
}


/* load language dependent resources */
/* returns TRUE if language change successful */
BOOL
load_language(int language)
{
TCHAR langdll[MAXSTR];
HINSTANCE hInstance;
    if (language == IDM_LANGEN) {
	if ((hlanguage != (HINSTANCE)NULL) && (hlanguage != phInstance))
	    FreeLibrary(hlanguage);
	/* Don't load a DLL */
	hlanguage = phInstance;
	return TRUE;
    }

    lstrcpy(langdll, language_dllname(language));
    hInstance = LoadLibrary(langdll);
    if (hInstance >= (HINSTANCE)HINSTANCE_ERROR) {
	if ((hlanguage != (HINSTANCE)NULL) && (hlanguage != phInstance))
	    FreeLibrary(hlanguage);
	hlanguage = hInstance;

	load_string(IDS_GSVIEWVERSION, langdll, sizeof(langdll));
	if (lstrcmp(TEXT(GSVIEW_DOT_VERSION), langdll) != 0)
	    message_box(TEXT("Language resources version doesn't match GSview EXE"), 0);

	return TRUE;
    }
    
    return FALSE;
}

void
change_language(void)
{
TCHAR *p;
HMENU hMenuOptions;
HMENU hMenuLang;
HMENU hMenuMedia;
int i;

    nCodePageSystem = GetACP();
    nCodePageLanguage = nCodePageSystem;

    nCodePageLanguage = lang[language_lookup(option.language)].codepage;
    if (nCodePageLanguage == 0)
	nCodePageLanguage = nCodePageSystem;

    if (nCodePageLanguage == 1253)
       info_font = hFontGreek;
    else if (nCodePageLanguage == 1250)
       info_font = hFontEastEurope;
    else if (nCodePageLanguage == 1251)
       info_font = hFontCyrillic;
    else
       info_font = hFontAnsi;

    hmenu = LoadMenu(hlanguage, TEXT("gsview_menu"));
    /* Add extra languages to menu */
#ifdef VIEWONLY
    hMenuOptions = GetSubMenu(hmenu, 1);
#else
    hMenuOptions = GetSubMenu(hmenu, 2);
#endif
    hMenuLang = GetSubMenu(hMenuOptions, 4);
    for (i=1; i<nlang; i++) {
	AppendMenu(hMenuLang, MF_BITMAP, lang[i].id, (LPTSTR)lang[i].bitmap);
	if (!is_winnt && (nCodePageSystem != lang[i].codepage))
	    enable_menu_item(IDM_LANGMENU, lang[i].id, FALSE);
    }

    /* User media */
#ifdef VIEWONLY
    hMenuMedia = GetSubMenu(hmenu, 4);
#else
    hMenuMedia = GetSubMenu(hmenu, 5);
#endif
    for (i=0; i<sizeof(usermedia)/sizeof(USERMEDIA)-1; i++) {
	if (usermedia[i].name[0])
	    AppendMenuA(hMenuMedia, MF_STRING, 
		usermedia[i].id, (LPSTR)usermedia[i].name);
    }

    SetMenu(hwndimg, hmenu);

    haccel = LoadAccelerators(hlanguage, TEXT("gsview_accel"));

#ifdef USE_HTMLHELP
    HtmlHelp(hwndimg,szHelpName, HH_CLOSE_ALL, (DWORD)NULL);
    gs_addmessf("HtmlHelp: %s HH_CLOSE_ALL\n", szHelpName);
#else
    WinHelp(hwndimg,szHelpName,HELP_QUIT,(DWORD)NULL);
#endif
    /* get path to help file */
    lstrcpy(szHelpName, szExePath);
    p = szHelpName + lstrlen(szHelpName);
#ifdef USE_HTMLHELP
    lstrcat(szHelpName, TEXT("gsviewen.chm"));
#else
    load_string(IDS_HELPFILE, p, 
	sizeof(szHelpName)/sizeof(TCHAR) - (int)(p-szHelpName));
#endif
    if (debug)
	gs_addmessf("Help file is %s\n", szHelpName);

    nHelpTopic = IDS_TOPICROOT;
    init_check_menu();
    InvalidateRect(hwndimg, (LPRECT)NULL, FALSE);
    if (hwnd_measure)
	PostMessage(hwnd_measure, WM_COMMAND, IDCANCEL, 0L);
}


#ifdef __BORLANDC__
#pragma argsused
#endif
/* language dialog box */