/* $Id: linux_logo.h,v 1.5 2002/06/09 19:47:02 png2linuxlogo Exp $
 * include/asm/linux_logo.h: This is a color Linux logo
 *                           to be displayed on boot.
 *
 * Copyright (C) 1996 Larry Ewing (lewing@isc.tamu.edu)
 * Copyright (C) 1998 Jakub Jelinek (jj@sunsite.mff.cuni.cz)
 *
 * You can put anything here, subject to these restrictions:
 *  - LINUX_LOGO_COLORS has to be strictly less than 224;
 *  - image size has to be exactly 80x80;
 *  - index values have to start from 0x20
 *    (i.e., RGB(linux_logo_red[0],
 *               linux_logo_green[0],
 *               linux_logo_blue[0]) is color index 0x20);
 *  - BW image has to be 80x80 as well, with most-significant
 *    bit on the left;
 *  - serial_console ASCII image can be any size,
 *    but it should contain %s to display the version.
 *
 * This version was autogenerated by png2linuxlogo 1.02 of 9 June 2002
 * (http://www.libpng.org/pub/png/apps/png2linuxlogo.html),
 * Copyright (C) 2001-2002 Greg Roelofs (newt@pobox.com).
 *
 * Replace /usr/src/linux/include/asm-<your_arch>/linux_logo.h with
 * this (include/asm will point at include/asm-<your_arch> after you
 * do "make config" or "make menuconfig"), edit the linux_logo_banner
 * line below ("FIXME") to match the original, recompile the kernel, and
 * enjoy your new boot logo.  (Unless your display supports 16 or fewer
 * colors, in which case you're out of luck...sorry.)
 */

#include <linux/init.h>
#include <linux/version.h>

#define linux_logo_banner "Linux/<arch-FIXME> version " UTS_RELEASE

#define __HAVE_ARCH_LINUX_LOGO		/* needed for 2.4.18, at least */

#define LINUX_LOGO_COLORS 208

#ifdef INCLUDE_LINUX_LOGO_DATA

unsigned char linux_logo_red[] __initdata = {
  0xF4, 0xEC, 0x1C, 0x49, 0xAC, 0xB0, 0x1C, 0xAC,
  0x41, 0xDC, 0x64, 0x46, 0x2C, 0xD4, 0x77, 0xE4,
  0x90, 0xE4, 0xAC, 0xCC, 0x57, 0x34, 0xA8, 0xC9,
  0x0C, 0x6C, 0xEA, 0x14, 0x5C, 0xBC, 0x54, 0xB4,
  0xE4, 0xF4, 0x9C, 0xC8, 0x27, 0xDA, 0x50, 0xE3,
  0x4E, 0x24, 0xDC, 0xDC, 0xD4, 0x2C, 0xEC, 0xEC,
  0x24, 0x37, 0x28, 0xB8, 0xC4, 0xFC, 0xC4, 0x44,
  0x9C, 0xE4, 0x7C, 0x3E, 0x37, 0x58, 0xDC, 0x70,
  0xAC, 0x93, 0xD4, 0xD4, 0x64, 0x5C, 0xCC, 0x49,
  0x94, 0x14, 0x4C, 0xD4, 0xD4, 0x0C, 0x34, 0xDC,
  0x71, 0x87, 0xC4, 0xCC, 0xBA, 0xC8, 0xD9, 0xBC,
  0xDF, 0x4C, 0xCC, 0x1C, 0xB4, 0x4C, 0x27, 0xBC,
  0x9C, 0xA9, 0xA8, 0xDC, 0x9C, 0xE4, 0x64, 0xA4,
  0x64, 0x84, 0xE4, 0x8C, 0xCC, 0x61, 0x56, 0x94,
  0xA9, 0x3D, 0xBC, 0x4C, 0xDF, 0xBC, 0xC4, 0xBB,
  0x9C, 0xEC, 0x3C, 0x7C, 0x34, 0x54, 0x6C, 0x74,
  0x84, 0x54, 0x7C, 0x74, 0x7C, 0x9C, 0xB0, 0xBC,
  0xF3, 0xB7, 0xC4, 0x34, 0x7C, 0xC7, 0xB4, 0x24,
  0xB4, 0xD4, 0x9C, 0x84, 0x5C, 0xE4, 0xA8, 0xAC,
  0x94, 0x88, 0xDC, 0x4C, 0xCB, 0xCC, 0xB4, 0xDC,
  0x89, 0x84, 0xEE, 0x74, 0x74, 0xD8, 0x64, 0xF4,
  0xDC, 0x34, 0x24, 0xF4, 0xC4, 0xDC, 0xE7, 0x2E,
  0x9C, 0x98, 0xA1, 0xB0, 0x34, 0xD4, 0x9E, 0xE4,
  0x41, 0x1C, 0xC4, 0x94, 0xB6, 0xF4, 0x7C, 0xAE,
  0x77, 0x9E, 0xBC, 0xAC, 0xCB, 0x84, 0xE6, 0x5C,
  0x8C, 0xBC, 0xC9, 0x9B, 0xD4, 0x9C, 0x04, 0xCA
};

unsigned char linux_logo_green[] __initdata = {
  0xDA, 0xD4, 0x1B, 0x33, 0x96, 0xA2, 0x6E, 0x84,
  0x35, 0xAA, 0x36, 0x44, 0x3E, 0x82, 0x73, 0xB9,
  0x61, 0xD2, 0x6B, 0x7E, 0x53, 0x1E, 0x7E, 0x86,
  0x32, 0x3D, 0xCE, 0x0E, 0x5D, 0x7C, 0x37, 0xA2,
  0xAF, 0xCA, 0x98, 0xAA, 0x26, 0x9E, 0x6D, 0xB7,
  0x5D, 0x72, 0xB5, 0xD6, 0xA4, 0x5E, 0xB8, 0xB2,
  0x1C, 0x6D, 0x17, 0x92, 0x8E, 0xFA, 0xB8, 0x26,
  0x63, 0xBE, 0x7A, 0x61, 0x65, 0x44, 0xA3, 0x54,
  0x7A, 0x6B, 0xA6, 0xA2, 0x62, 0x72, 0x9E, 0x78,
  0x91, 0x15, 0x7A, 0xD4, 0xAC, 0x0B, 0x3D, 0xCA,
  0x6D, 0x58, 0xC2, 0xA6, 0x84, 0xC4, 0xD0, 0xBE,
  0xDD, 0x2E, 0x8E, 0x52, 0xB6, 0x26, 0x23, 0xB6,
  0x84, 0xA8, 0x78, 0xC4, 0xB2, 0xA7, 0x5C, 0x6E,
  0x3B, 0x7A, 0xC3, 0x8A, 0x8A, 0x54, 0x4C, 0x96,
  0x92, 0x3B, 0x8C, 0x4B, 0xC4, 0x95, 0x88, 0x8D,
  0x6D, 0xBE, 0x23, 0x4E, 0x76, 0x62, 0x44, 0x6B,
  0x90, 0x52, 0x60, 0x5F, 0x56, 0x82, 0x9C, 0xAE,
  0xC3, 0xB2, 0xBE, 0x24, 0x6E, 0x95, 0x7E, 0x5A,
  0x72, 0x97, 0xC2, 0x6E, 0x5C, 0xAE, 0x72, 0xA1,
  0x66, 0x74, 0xAA, 0x7E, 0x9C, 0xCC, 0x77, 0xC2,
  0xAA, 0x83, 0xED, 0x56, 0xC6, 0xB6, 0x66, 0xBE,
  0xA9, 0x82, 0x1E, 0xF3, 0xBD, 0xBE, 0xC5, 0x2C,
  0x88, 0x74, 0xA0, 0x88, 0x32, 0xCA, 0x83, 0xCA,
  0x2B, 0x15, 0x7C, 0x7E, 0x85, 0xB9, 0x7A, 0xAD,
  0x49, 0x99, 0xB9, 0x82, 0x93, 0x62, 0xE4, 0x64,
  0x60, 0x9E, 0xC3, 0x7B, 0xAA, 0x8E, 0x02, 0xB4
};

unsigned char linux_logo_blue[] __initdata = {
  0xB4, 0xAC, 0x18, 0x0C, 0x4C, 0x3C, 0x14, 0x21,
  0x2F, 0x04, 0x0C, 0x41, 0x24, 0x24, 0x71, 0x05,
  0x0C, 0x7C, 0x17, 0x1C, 0x4E, 0x04, 0x0C, 0x1C,
  0x04, 0x10, 0x9C, 0x0C, 0x17, 0x0F, 0x0C, 0x74,
  0x0B, 0x14, 0x84, 0x4C, 0x25, 0x0B, 0x0E, 0x77,
  0x0C, 0x14, 0x06, 0xD3, 0x08, 0x08, 0x0F, 0x0F,
  0x11, 0x0C, 0x0B, 0x14, 0x0C, 0xFC, 0xA4, 0x0C,
  0x13, 0x74, 0x3C, 0x16, 0x0F, 0x12, 0x0C, 0x19,
  0x1F, 0x0D, 0x64, 0x64, 0x63, 0x1C, 0x5C, 0x1D,
  0x92, 0x11, 0x0C, 0xD4, 0x28, 0x09, 0x0F, 0xB4,
  0x6C, 0x0E, 0xC4, 0x0C, 0x0B, 0xB4, 0xC8, 0xBC,
  0xDB, 0x0C, 0x0C, 0x04, 0xB4, 0x0C, 0x19, 0x94,
  0x18, 0xA9, 0x10, 0x8F, 0x9C, 0x0C, 0x58, 0x0C,
  0x0C, 0x14, 0x0F, 0x89, 0x26, 0x16, 0x4A, 0x94,
  0x56, 0x38, 0x16, 0x4A, 0x81, 0x37, 0x0A, 0x0B,
  0x11, 0x10, 0x0C, 0x0C, 0x14, 0x0C, 0x10, 0x11,
  0x70, 0x0C, 0x0F, 0x11, 0x0F, 0x4C, 0x7A, 0x89,
  0x13, 0xAF, 0x94, 0x14, 0x54, 0x20, 0x14, 0x07,
  0x14, 0x05, 0x94, 0x34, 0x5C, 0x64, 0x08, 0x9A,
  0x1C, 0x10, 0x5C, 0x24, 0x09, 0xCD, 0x0D, 0x34,
  0x56, 0x83, 0xEB, 0x24, 0x6C, 0x30, 0x14, 0x10,
  0x69, 0x0C, 0x1E, 0xF4, 0xBB, 0x0C, 0x8E, 0x2B,
  0x6C, 0x12, 0x9F, 0x44, 0x34, 0x9C, 0x11, 0x1A,
  0x0F, 0x0F, 0x1C, 0x3C, 0x18, 0x0C, 0x77, 0xA8,
  0x0F, 0x95, 0xB9, 0x04, 0x08, 0x2C, 0xE2, 0x40,
  0x20, 0x70, 0xA1, 0x14, 0x4C, 0x8C, 0x04, 0x6D
};

unsigned char linux_logo[] __initdata = {
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x8B, 0x64, 0x64, 0xB4, 0x64,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x68, 0xB4, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE,
  0xEE, 0xCF, 0x64, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0xD4,
  0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE,
  0xEE, 0xEE, 0xEE, 0xEE, 0xB4, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0xD4, 0xEE,
  0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE,
  0xEE, 0xEE, 0x69, 0x6D, 0xEE, 0xD4, 0x8B, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0xCC,
  0xCC, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0xCF, 0xEE, 0xEE,
  0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE,
  0xEE, 0x22, 0x8E, 0x2B, 0x69, 0xEE, 0xEE, 0x68,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0xB4, 0xEE, 0xEE, 0xEE,
  0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE,
  0xEE, 0x22, 0x64, 0x70, 0x91, 0x69, 0xEE, 0xD4,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0xEE, 0xEE, 0xEE, 0xEE,
  0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE,
  0xEE, 0x44, 0x34, 0x2B, 0x7E, 0x69, 0xEE, 0xEE,
  0xB4, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0xB4, 0xEE, 0xEE, 0xEE, 0xEE,
  0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE,
  0xEE, 0x69, 0x22, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE,
  0xD4, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x64, 0xEE, 0xEE, 0xEE, 0xEE,
  0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE,
  0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE,
  0xEE, 0x64, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0xCF, 0xEE, 0xEE, 0xEE, 0xEE,
  0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE,
  0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE,
  0xEE, 0xEE, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0xD4, 0xEE, 0xEE, 0xEE, 0x6D,
  0x22, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE,
  0xEE, 0xEE, 0x69, 0xCF, 0xEE, 0xEE, 0xEE, 0xEE,
  0xEE, 0xEE, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0xCF, 0xEE, 0xEE, 0x6D, 0x44,
  0x69, 0xCF, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0x44,
  0x86, 0x2E, 0x93, 0x69, 0x44, 0xEE, 0xEE, 0xEE,
  0xEE, 0xEE, 0x8B, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0xD4, 0xEE, 0x6D, 0xDE, 0xA9,
  0x8B, 0x7E, 0x6D, 0xEE, 0xEE, 0xEE, 0x91, 0xED,
  0xB7, 0x56, 0x75, 0x64, 0x6D, 0xEE, 0xEE, 0xEE,
  0xEE, 0xEE, 0x68, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0xCF, 0xEE, 0x8E, 0xA9, 0x78,
  0x4B, 0x8F, 0xEE, 0xEE, 0xEE, 0x69, 0x81, 0xC2,
  0xC2, 0xCB, 0x6B, 0x68, 0x7E, 0xEE, 0xEE, 0xEE,
  0xEE, 0xEE, 0x64, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0xD4, 0xEE, 0x8B, 0xE1, 0x34,
  0x7C, 0xCB, 0xCF, 0xEE, 0xEE, 0x93, 0x78, 0x4B,
  0xB4, 0x86, 0x81, 0xCB, 0x70, 0xEE, 0xEE, 0xEE,
  0xEE, 0xEE, 0xB4, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0xB4, 0xEE, 0xD2, 0x6D, 0x91,
  0x2B, 0xCB, 0x86, 0x69, 0x22, 0x8E, 0xCB, 0x64,
  0xEE, 0xCF, 0x93, 0xC2, 0xBD, 0xEE, 0xEE, 0xEE,
  0xEE, 0xEE, 0x64, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x64, 0xEE, 0xB7, 0x6D, 0x6D,
  0x8E, 0xCC, 0xB4, 0xEE, 0x3B, 0x91, 0xE6, 0x2B,
  0xEE, 0xEE, 0xEE, 0xDF, 0xE6, 0xEE, 0xEE, 0xEE,
  0xEE, 0xEE, 0xB4, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0xB4, 0xEE, 0x70, 0x93, 0xEE,
  0xEE, 0x24, 0xD6, 0xE3, 0x74, 0xEB, 0x3F, 0xD4,
  0xEE, 0xEE, 0xEE, 0xE2, 0xE6, 0xEE, 0xEE, 0xEE,
  0xEE, 0xEE, 0x64, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x64, 0xEE, 0x44, 0x78, 0xD9,
  0x30, 0x45, 0x4E, 0x41, 0x29, 0x53, 0x2F, 0x73,
  0xD8, 0x22, 0x8B, 0xCB, 0x42, 0xEE, 0xEE, 0xEE,
  0xEE, 0xEE, 0xCF, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x8B, 0xEE, 0xEE, 0xED, 0xBC,
  0x29, 0xC7, 0x99, 0x41, 0x8A, 0xD7, 0xD7, 0xD7,
  0x2F, 0x29, 0xCD, 0xEF, 0x69, 0xEE, 0xEE, 0xEE,
  0xEE, 0xEE, 0xD4, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0xCC,
  0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC,
  0xCC, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x68, 0xEE, 0x50, 0x58, 0x45,
  0x4F, 0xDD, 0x8A, 0x41, 0x8A, 0xBF, 0xD7, 0x8A,
  0x2F, 0x2F, 0x2F, 0x8A, 0x61, 0xEE, 0xEE, 0xEE,
  0xEE, 0xEE, 0xEE, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0xCC, 0x75, 0x6F, 0x21,
  0x21, 0x21, 0x20, 0x21, 0x20, 0x21, 0x20, 0x21,
  0x21, 0x6F, 0x75, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x8B, 0xEE, 0x30, 0x96, 0x85,
  0x4E, 0xDD, 0x41, 0xD7, 0xD7, 0xBF, 0x8A, 0x99,
  0x2F, 0x4A, 0xBC, 0xBC, 0x97, 0xEE, 0xEE, 0xEE,
  0xEE, 0xEE, 0xEE, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0xA9, 0xD5, 0xCE, 0x3A,
  0xCE, 0x21, 0x3A, 0x21, 0x3A, 0x20, 0x3A, 0xCE,
  0x3A, 0xCE, 0xD5, 0x7C, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x68, 0xEE, 0x30, 0x7A, 0x85,
  0x4F, 0xA8, 0x8A, 0xD7, 0x8A, 0xD7, 0x2F, 0x2F,
  0x73, 0xBC, 0xB1, 0x45, 0xB6, 0xEE, 0xEE, 0xEE,
  0xEE, 0xEE, 0xEE, 0x8B, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x83, 0x94, 0x94,
  0x94, 0x94, 0x94, 0x94, 0x94, 0x94, 0x83, 0x94,
  0x94, 0x94, 0x94, 0x7C, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x77, 0x68, 0xEE, 0x3B, 0xE0, 0x5E,
  0xDD, 0xA8, 0x8A, 0x8A, 0xCD, 0x4A, 0x73, 0xD1,
  0x74, 0x45, 0x45, 0x54, 0x3E, 0xEE, 0xEE, 0x93,
  0x22, 0xEE, 0xEE, 0xD4, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0xD5, 0x94, 0x59,
  0x47, 0x94, 0x47, 0x47, 0xB5, 0x59, 0x47, 0x47,
  0x47, 0x59, 0x6F, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x68, 0xEE, 0x91, 0xAC, 0xA4,
  0x97, 0x4C, 0x73, 0xBC, 0x36, 0x58, 0x30, 0xE4,
  0x45, 0x7A, 0x73, 0xA6, 0x81, 0xEE, 0xEE, 0x34,
  0xDE, 0xB4, 0xEE, 0xEE, 0x68, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0xCC, 0xEA, 0x47, 0xBA,
  0xB5, 0xBA, 0xBA, 0xBA, 0x62, 0xBA, 0xB5, 0xEC,
  0xBA, 0x83, 0xAA, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x77, 0xEE, 0xB4, 0x7C, 0xA5,
  0x89, 0x74, 0xBC, 0xE4, 0xB1, 0x45, 0xE4, 0x54,
  0x60, 0x43, 0x72, 0x75, 0x7C, 0x7E, 0xEE, 0x69,
  0x2E, 0xDE, 0x7E, 0xEE, 0xD4, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0xEA, 0x94, 0x62,
  0x62, 0x63, 0x63, 0x63, 0x66, 0x63, 0x66, 0xC8,
  0x62, 0xCE, 0x7C, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x68, 0xEE, 0xB4, 0x7C, 0xE2,
  0xDB, 0x61, 0x74, 0x96, 0x96, 0x36, 0xB6, 0xD3,
  0x7F, 0xE2, 0x78, 0xE6, 0x6B, 0x8B, 0xEE, 0xEE,
  0xCA, 0x2B, 0xEE, 0xEE, 0xEE, 0x8B, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x83, 0xC8,
  0x62, 0x63, 0x63, 0x66, 0x63, 0x63, 0x63, 0x62,
  0xC8, 0xD5, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0xCF, 0xEE, 0x64, 0xBD, 0x77,
  0x7C, 0xD0, 0xE5, 0xE5, 0xE5, 0xDB, 0x3F, 0xCC,
  0x77, 0x78, 0xCB, 0x55, 0x55, 0x78, 0x7E, 0xEE,
  0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0x91, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0xCC, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x83, 0x62,
  0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66,
  0x62, 0x75, 0x72, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x64, 0xEE, 0xEE, 0x2E, 0xC2, 0x6B,
  0x7C, 0xE2, 0x7C, 0xE2, 0x7C, 0xE2, 0xE2, 0x76,
  0x78, 0xCB, 0x55, 0xCB, 0x55, 0x55, 0x8B, 0xEE,
  0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0x6D, 0x70, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0xA7, 0xD3,
  0x95, 0x92, 0x95, 0x95, 0x95, 0x95, 0x95, 0x95,
  0xD3, 0xA7, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x68, 0x69, 0x6D, 0x69, 0x6B, 0xCB, 0xCB,
  0x72, 0x77, 0x77, 0xE2, 0x7C, 0xE2, 0x78, 0xC2,
  0x55, 0xCB, 0x55, 0x55, 0x55, 0xCB, 0xCB, 0x22,
  0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0xDF, 0xE0,
  0xDA, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x3D,
  0x5D, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0xD4, 0xEE, 0xEE, 0x6D, 0x81, 0xCB, 0x55, 0x55,
  0xC2, 0x72, 0x77, 0x7C, 0xBD, 0xE6, 0x55, 0x55,
  0xCB, 0x55, 0xCB, 0x55, 0xCB, 0x55, 0x55, 0xDE,
  0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xCF,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x5D,
  0xDA, 0x33, 0x33, 0x37, 0x37, 0x33, 0x2D, 0xDA,
  0xA1, 0x77, 0x72, 0x77, 0x72, 0x77, 0x68, 0xCF,
  0xEE, 0xEE, 0xEE, 0xB4, 0xCB, 0x55, 0x55, 0x55,
  0x55, 0xCB, 0x78, 0xC2, 0xCB, 0x55, 0xCB, 0x55,
  0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB, 0x55, 0x78,
  0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE,
  0x68, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0xC6,
  0xDA, 0x8C, 0x33, 0x8C, 0x37, 0x33, 0xAD, 0xDA,
  0x9E, 0x72, 0x8B, 0x64, 0x64, 0xD4, 0xEE, 0xEE,
  0xEE, 0xEE, 0x69, 0xBD, 0x55, 0x55, 0xCB, 0x55,
  0xCB, 0x55, 0x55, 0xCB, 0x55, 0x55, 0xCB, 0x55,
  0xCB, 0x55, 0x55, 0x55, 0xCB, 0x55, 0xCB, 0x55,
  0x2B, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE,
  0xEE, 0x8B, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x8D,
  0xDA, 0x8C, 0x2D, 0x2D, 0x33, 0x2D, 0x33, 0xDA,
  0x5F, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE,
  0xEE, 0xEE, 0x34, 0xE6, 0xCB, 0x55, 0xCB, 0x55,
  0xCB, 0x55, 0xCB, 0x55, 0x55, 0xCB, 0x55, 0xCB,
  0x55, 0x55, 0x55, 0xCB, 0x55, 0x55, 0x55, 0xCB,
  0xC1, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE,
  0xEE, 0xEE, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0xC3,
  0x33, 0xDA, 0x33, 0xDA, 0x33, 0x33, 0xDA, 0x33,
  0xC3, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE,
  0xEE, 0xEE, 0xC1, 0xE6, 0x55, 0xCB, 0x55, 0xCB,
  0x55, 0xCB, 0xC2, 0xC2, 0x55, 0xCB, 0x55, 0x55,
  0xCB, 0x55, 0xCB, 0x55, 0xC2, 0xC2, 0xE6, 0xC2,
  0x6B, 0x6D, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE,
  0xEE, 0xEE, 0xD4, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0xE8,
  0xAE, 0x37, 0xDC, 0x37, 0xDC, 0xDC, 0x37, 0xDC,
  0xA3, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE,
  0xEE, 0x69, 0x42, 0x7C, 0x6B, 0xC2, 0xCB, 0x55,
  0xC2, 0xE6, 0xE6, 0x78, 0xC2, 0x55, 0xCB, 0x55,
  0xCB, 0x78, 0x6B, 0x6B, 0xBD, 0x72, 0xBD, 0x75,
  0xC2, 0x91, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE,
  0xEE, 0xEE, 0xEE, 0x68, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0xE8,
  0x82, 0x58, 0x27, 0x58, 0x32, 0x60, 0x32, 0x82,
  0x71, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE,
  0xEE, 0x2B, 0xE1, 0xE2, 0x78, 0xCB, 0x55, 0x55,
  0x55, 0xC2, 0xC2, 0xCB, 0x55, 0x55, 0xCB, 0x55,
  0xCB, 0xCB, 0xE6, 0x6B, 0xBD, 0x72, 0x72, 0x77,
  0xBD, 0x6B, 0xEE, 0xEE, 0xD4, 0xEE, 0xEE, 0xEE,
  0xEE, 0xEE, 0xEE, 0xEE, 0x8B, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0xD4, 0xA3,
  0xEB, 0x58, 0x87, 0x58, 0x58, 0xD1, 0x30, 0xEB,
  0x5F, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE,
  0xEE, 0xDE, 0x76, 0xCB, 0xCB, 0x55, 0xCB, 0xCB,
  0x55, 0xCB, 0xC2, 0x55, 0x55, 0xCB, 0x55, 0xCB,
  0x55, 0xCB, 0x55, 0xCB, 0xCB, 0xCB, 0x6B, 0xBD,
  0x72, 0xE6, 0xB4, 0xEE, 0xEE, 0x22, 0x22, 0xEE,
  0xEE, 0xEE, 0xEE, 0xEE, 0x64, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x64, 0xEE, 0xA1,
  0xD1, 0xEB, 0x80, 0xB9, 0xB9, 0xD6, 0xEB, 0xD1,
  0x48, 0xEE, 0x69, 0xEE, 0xEE, 0xEE, 0x7E, 0x6D,
  0x69, 0xBD, 0xCB, 0x55, 0x55, 0xCB, 0x55, 0x55,
  0xCB, 0x55, 0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB,
  0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB, 0x55, 0xC2,
  0xBD, 0x75, 0x6B, 0xEE, 0xEE, 0xEE, 0x69, 0x3B,
  0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0x68, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0xEE, 0xEE, 0xA1,
  0x9F, 0x5F, 0xC6, 0x39, 0x39, 0xC6, 0x9E, 0x8D,
  0x48, 0xEE, 0x69, 0xEE, 0xEE, 0xEE, 0x22, 0xEE,
  0x2E, 0x55, 0x55, 0x55, 0xCB, 0x55, 0x55, 0xCB,
  0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB,
  0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB, 0x55, 0x55,
  0x55, 0x6B, 0x6B, 0xB4, 0xEE, 0xEE, 0x6D, 0x22,
  0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0x64, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0xCF, 0xEE, 0x46,
  0xC6, 0xC6, 0x9D, 0x3C, 0x3C, 0xC6, 0xC6, 0x65,
  0x46, 0x69, 0xCF, 0xEE, 0xEE, 0x44, 0xEE, 0x69,
  0xCB, 0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB, 0xCB,
  0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB,
  0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB,
  0x55, 0xCB, 0x78, 0xBD, 0xEE, 0x22, 0x91, 0x22,
  0x22, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x68, 0xEE, 0x5C,
  0x9D, 0x23, 0x9D, 0xD8, 0x23, 0x9D, 0x23, 0x48,
  0x48, 0x2B, 0xEE, 0xEE, 0x6D, 0x22, 0xEE, 0xC1,
  0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB,
  0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB,
  0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB,
  0x55, 0xCB, 0x55, 0x55, 0xD4, 0x7E, 0xD4, 0x3B,
  0xCF, 0x6D, 0xEE, 0xEE, 0xEE, 0xEE, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x68, 0x5C,
  0x6A, 0x48, 0x48, 0x57, 0xD8, 0x48, 0x51, 0x6A,
  0x5C, 0xCF, 0xEE, 0xEE, 0x22, 0xEE, 0x6D, 0xC2,
  0x55, 0xCB, 0x55, 0x55, 0xCB, 0x55, 0xCB, 0x55,
  0xCB, 0xCB, 0xCB, 0x55, 0xCB, 0x55, 0xCB, 0x55,
  0xCB, 0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB, 0x55,
  0xCB, 0x55, 0xCB, 0x55, 0x70, 0x6D, 0xEE, 0xEE,
  0x6D, 0x44, 0xEE, 0xEE, 0xEE, 0xEE, 0xB4, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0xC0, 0x3B,
  0x6E, 0x3B, 0x51, 0xAF, 0xAF, 0x51, 0x3B, 0x6E,
  0x3B, 0xAF, 0xEE, 0xEE, 0x6D, 0xEE, 0xDE, 0x55,
  0xCB, 0x55, 0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB,
  0xC2, 0xCB, 0xCB, 0x55, 0xCB, 0x55, 0xCB, 0x55,
  0xCB, 0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB, 0x55,
  0xCB, 0x55, 0xCB, 0x55, 0x8B, 0xEE, 0xEE, 0xEE,
  0xEE, 0x7E, 0xEE, 0xEE, 0xEE, 0xEE, 0xCF, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0xCC,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0xC0, 0x4D,
  0xC9, 0xD8, 0x46, 0xD8, 0x79, 0x48, 0xD8, 0xC9,
  0xAF, 0x7B, 0xEE, 0xEE, 0xEE, 0xEE, 0x78, 0xCB,
  0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB,
  0xC2, 0xC2, 0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB,
  0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB,
  0x55, 0xCB, 0x55, 0xCB, 0x77, 0xEE, 0xEE, 0xEE,
  0xEE, 0xCA, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x4D, 0x50,
  0x67, 0x9C, 0xC9, 0x5C, 0x5C, 0xC9, 0x9C, 0x6A,
  0x7E, 0x51, 0xEE, 0xEE, 0xEE, 0x44, 0x55, 0xCB,
  0x55, 0x55, 0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB,
  0x78, 0xCB, 0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB,
  0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB,
  0x55, 0xCB, 0x55, 0x55, 0x72, 0xEE, 0xEE, 0xEE,
  0xEE, 0x44, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0x64,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0xCC, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x49, 0xAB,
  0x67, 0x28, 0xBB, 0x2C, 0x28, 0xBB, 0x28, 0x67,
  0xAB, 0x26, 0xEE, 0xEE, 0xEE, 0x86, 0x55, 0xCB,
  0x55, 0xCB, 0xCB, 0x55, 0xCB, 0x55, 0xCB, 0x55,
  0x78, 0xCB, 0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB,
  0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB,
  0x55, 0xCB, 0x55, 0xCB, 0xC2, 0xEE, 0xEE, 0xEE,
  0xEE, 0x69, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xB4,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0xB2, 0x26,
  0x49, 0x7E, 0x9C, 0x50, 0x50, 0x9C, 0x50, 0x49,
  0x26, 0x38, 0xEE, 0xEE, 0xEE, 0xE1, 0x55, 0x55,
  0xCB, 0x55, 0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB,
  0x78, 0xCB, 0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB,
  0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB,
  0x55, 0xCB, 0x55, 0xCB, 0x55, 0xEE, 0xEE, 0xEE,
  0xEE, 0xD9, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xD4,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0xB2, 0xC4, 0xC4, 0xC4, 0xC4, 0xC4, 0xC4, 0x5B,
  0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0x8F, 0xCB, 0x55,
  0xCB, 0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB, 0x55,
  0x78, 0xCB, 0xCB, 0x55, 0xCB, 0x55, 0xCB, 0x55,
  0xCB, 0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB, 0x55,
  0xCB, 0x55, 0xCB, 0x55, 0xCB, 0xEE, 0xEE, 0xEE,
  0xEE, 0x22, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0xD4,
  0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xD2, 0x55, 0xCB,
  0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB,
  0x78, 0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB, 0x55,
  0xCB, 0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB, 0x55,
  0xCB, 0x55, 0xCB, 0x55, 0x55, 0x69, 0xEE, 0xEE,
  0x69, 0x6D, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0xEE,
  0xEE, 0xEE, 0x6D, 0xEE, 0xEE, 0x75, 0x55, 0x55,
  0xCB, 0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB, 0xCB,
  0xE6, 0xCB, 0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB,
  0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB,
  0x55, 0xCB, 0x55, 0xCB, 0x55, 0x28, 0xEE, 0xEE,
  0x22, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0xEE,
  0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0x78, 0x55, 0xCB,
  0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB,
  0x78, 0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB, 0x55,
  0xCB, 0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB, 0x55,
  0xCB, 0x55, 0xCB, 0x55, 0xCB, 0x6D, 0xEE, 0x3B,
  0x22, 0x6D, 0x6D, 0xEE, 0xEE, 0xEE, 0xEE, 0xD4,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0xEE,
  0xD9, 0x82, 0xA2, 0x6D, 0x69, 0x6B, 0x55, 0x55,
  0xCB, 0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB, 0x55,
  0x6B, 0xCB, 0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB,
  0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB,
  0x55, 0xCB, 0x55, 0xCB, 0xE6, 0xEE, 0x69, 0x6D,
  0xEE, 0xEE, 0x6D, 0xD9, 0x7E, 0x69, 0xEE, 0xCF,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0xCC, 0x77, 0xA5,
  0x4F, 0x8A, 0xA8, 0x97, 0x6D, 0x8F, 0xCB, 0x55,
  0xCB, 0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB, 0xCB,
  0xE6, 0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB, 0x55,
  0xCB, 0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB, 0x55,
  0xCB, 0x55, 0xE6, 0x76, 0xD0, 0x69, 0xEE, 0xEE,
  0xEE, 0xEE, 0xEE, 0xEE, 0x6D, 0x91, 0xEE, 0x64,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0xAA, 0x29,
  0xC7, 0xDD, 0xC7, 0xA8, 0x53, 0x64, 0xCB, 0x55,
  0xCB, 0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB, 0xCB,
  0xE6, 0xCB, 0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB,
  0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB,
  0x55, 0x31, 0x8A, 0xCD, 0x99, 0xA1, 0xEE, 0xEE,
  0xEE, 0xEE, 0xEE, 0xEE, 0x6D, 0x22, 0x5D, 0x8B,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0xCC, 0x27, 0xE4,
  0x4F, 0xA8, 0x99, 0xDD, 0x99, 0xC5, 0xE6, 0x55,
  0xCB, 0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB, 0xCB,
  0xE6, 0xCB, 0xCB, 0x55, 0xCB, 0x55, 0xCB, 0x55,
  0xCB, 0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB, 0x55,
  0x55, 0x43, 0x4E, 0x2F, 0x4A, 0x28, 0xEE, 0xEE,
  0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0x50, 0x4A, 0x8A,
  0x8B, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0xCC,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0xD0, 0x7A, 0x5E,
  0xDD, 0xA8, 0x4E, 0xA8, 0xC7, 0x99, 0x95, 0xCB,
  0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB,
  0xCB, 0xCB, 0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB,
  0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB,
  0x55, 0x43, 0xDD, 0xC7, 0x4C, 0x23, 0xEE, 0xEE,
  0xEE, 0xEE, 0xEE, 0xEE, 0x6D, 0xE4, 0x4A, 0x4A,
  0x42, 0xCC, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x81, 0xD3, 0x74, 0x5E, 0x40,
  0xDD, 0x99, 0xA8, 0x99, 0xA8, 0xDD, 0x8A, 0xEA,
  0xCB, 0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB, 0x55,
  0xCB, 0xCB, 0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB,
  0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB,
  0x4B, 0xEC, 0x4E, 0x4E, 0xE4, 0x71, 0xD9, 0xEE,
  0xEE, 0xEE, 0xEE, 0x6D, 0x98, 0x2F, 0xC7, 0xDD,
  0xE1, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0xE9, 0x24, 0xB3, 0xDC, 0x7A, 0x5E, 0x40, 0xDD,
  0x99, 0xA8, 0xDD, 0x99, 0xA8, 0xDD, 0x8A, 0xE4,
  0xC2, 0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB, 0x55,
  0xCB, 0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB, 0x55,
  0xCB, 0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB, 0x78,
  0x75, 0x43, 0x4E, 0x4F, 0xE4, 0x36, 0x30, 0x23,
  0x35, 0x35, 0x3E, 0xD1, 0x7A, 0x40, 0xDD, 0xDD,
  0xA7, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0xDF, 0x36,
  0x5E, 0x4F, 0x5E, 0x4F, 0x40, 0x4F, 0x4F, 0xC7,
  0x4E, 0xC7, 0xA8, 0xDD, 0x99, 0xDD, 0xA8, 0x8A,
  0xB3, 0xCB, 0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB,
  0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB,
  0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB, 0x55, 0x6B,
  0x75, 0xEC, 0x29, 0x4F, 0x45, 0x97, 0xBE, 0xB0,
  0xBE, 0xBE, 0xBE, 0xE4, 0x85, 0x4F, 0xDD, 0x99,
  0x6C, 0xD2, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0xEF, 0x5E,
  0x4F, 0x4E, 0x4F, 0xDD, 0xDD, 0xDD, 0xC7, 0x4E,
  0xA8, 0xC7, 0x4E, 0x99, 0xA8, 0x99, 0xDD, 0xA8,
  0x29, 0x75, 0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB,
  0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB,
  0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB, 0x55, 0x6B,
  0xBD, 0xC5, 0xE4, 0x40, 0x45, 0xB1, 0xE4, 0x97,
  0x97, 0x54, 0xB1, 0x85, 0xC7, 0x99, 0xC7, 0xC7,
  0xDD, 0x43, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0xEF, 0x85,
  0x4E, 0xDD, 0xC7, 0x99, 0xC7, 0x99, 0xDD, 0xDD,
  0xA8, 0x99, 0xC7, 0x4E, 0xDD, 0xA8, 0x99, 0xC7,
  0x99, 0x43, 0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB,
  0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB,
  0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB, 0x55, 0x78,
  0x72, 0x95, 0x74, 0x45, 0x5E, 0x45, 0x45, 0xB1,
  0x45, 0x29, 0x40, 0x4E, 0xDD, 0xA8, 0x4E, 0xA8,
  0x99, 0xC7, 0x90, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x68, 0x4A,
  0x4E, 0xC7, 0xC7, 0xC7, 0x4E, 0xA8, 0x99, 0x99,
  0xC7, 0x99, 0xC7, 0xC7, 0x8A, 0xA8, 0xDD, 0xA8,
  0xA8, 0x40, 0xEA, 0x55, 0xCB, 0x55, 0xCB, 0x55,
  0xCB, 0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB, 0x55,
  0xCB, 0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB, 0xE6,
  0x75, 0xB8, 0xAE, 0xB1, 0x85, 0x4F, 0x40, 0x4F,
  0x4F, 0x40, 0x4F, 0x4F, 0xC7, 0x99, 0xA8, 0xDD,
  0x99, 0xA8, 0xC7, 0x43, 0xD2, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0xCC, 0x8B, 0x92,
  0x4E, 0x99, 0xC7, 0x99, 0xA8, 0xC7, 0x99, 0xA8,
  0xDD, 0xA8, 0x4E, 0xA8, 0xC7, 0xDD, 0xC7, 0xC7,
  0xDD, 0xD7, 0x73, 0xC2, 0x55, 0xCB, 0x55, 0xCB,
  0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB,
  0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB, 0x55, 0xE6,
  0x93, 0x71, 0x74, 0x45, 0x4F, 0x4E, 0xDD, 0xDD,
  0x4F, 0xDD, 0xDD, 0xA8, 0x99, 0xC7, 0x4E, 0xC7,
  0x99, 0xDD, 0x99, 0x99, 0x6C, 0xA6, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x8B, 0x27,
  0x85, 0x99, 0xDD, 0x99, 0xC7, 0x99, 0xC7, 0xDD,
  0x8A, 0xC7, 0x99, 0xA8, 0x4E, 0x99, 0x99, 0x99,
  0xC7, 0x99, 0x8A, 0x25, 0x55, 0xCB, 0x55, 0xCB,
  0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB,
  0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB, 0xE6, 0xCF,
  0x6D, 0xA3, 0x97, 0x29, 0x4F, 0xDD, 0x99, 0x99,
  0xDD, 0x99, 0xA8, 0xDD, 0xC7, 0xC7, 0x99, 0xC7,
  0x99, 0xA8, 0xA8, 0xA8, 0x99, 0x99, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x8B, 0x27,
  0x4C, 0xDD, 0xC7, 0xDD, 0xC7, 0x4E, 0xDD, 0xC7,
  0xA8, 0xC7, 0xC7, 0x99, 0xC7, 0xA8, 0xC7, 0xDD,
  0xC7, 0x4E, 0x41, 0x29, 0xAA, 0xCB, 0x55, 0xCB,
  0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB,
  0x55, 0xCB, 0x55, 0xCB, 0x55, 0xBD, 0xCF, 0xEE,
  0x3B, 0x30, 0xE4, 0x85, 0x4F, 0xC7, 0x4E, 0xC7,
  0x99, 0xC7, 0x4E, 0xA8, 0x4E, 0xA8, 0x4E, 0xA8,
  0xDD, 0x99, 0xC7, 0x99, 0xDD, 0xA8, 0x77, 0x72,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0xE1, 0x97,
  0x85, 0x4E, 0x99, 0xC7, 0xC7, 0x99, 0xA8, 0xC7,
  0x4E, 0xC7, 0x99, 0xC7, 0xA8, 0x4E, 0xA8, 0x4E,
  0xC7, 0x4E, 0xA8, 0x8A, 0x80, 0x6B, 0x55, 0xCB,
  0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB,
  0x55, 0xCB, 0x55, 0xCB, 0xDE, 0xEE, 0xEE, 0xEE,
  0x3B, 0x58, 0x7A, 0x45, 0x4F, 0xDD, 0xA8, 0x99,
  0xC7, 0xC7, 0x4E, 0xA8, 0xC7, 0x99, 0xA8, 0xDD,
  0x99, 0xA8, 0xDD, 0xC7, 0x40, 0x90, 0xCC, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0xA6, 0x92,
  0x85, 0xDD, 0xC7, 0x4E, 0xC7, 0x99, 0xC7, 0xDD,
  0x99, 0xA8, 0x99, 0xA8, 0x99, 0xC7, 0x99, 0xA8,
  0x4E, 0xDD, 0x4F, 0x40, 0xE4, 0xA3, 0x7C, 0x55,
  0xCB, 0x55, 0xCB, 0x55, 0xCB, 0x55, 0xCB, 0x55,
  0xCB, 0x78, 0xDE, 0x22, 0xEE, 0xEE, 0xEE, 0xEE,
  0x52, 0x98, 0x54, 0x29, 0x4F, 0xA8, 0x99, 0xA8,
  0xDD, 0x99, 0xA8, 0x99, 0xC7, 0x4E, 0x99, 0xA8,
  0xC7, 0x99, 0x4E, 0xAD, 0x3F, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x43, 0xAD,
  0x5E, 0x4F, 0x4E, 0xDD, 0xC7, 0x4E, 0xA8, 0x99,
  0xA8, 0x4E, 0xDD, 0xC7, 0x99, 0xA8, 0xC7, 0xC7,
  0xA8, 0x4E, 0x4E, 0x85, 0x7A, 0x58, 0xD9, 0x93,
  0x8F, 0x75, 0x6B, 0x78, 0x77, 0xD2, 0xDE, 0x34,
  0x22, 0x6D, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE,
  0x9A, 0x87, 0xE4, 0x29, 0x4F, 0xA8, 0xDD, 0x99,
  0xA8, 0x99, 0xC7, 0x99, 0xA8, 0x4E, 0xA8, 0x4E,
  0x40, 0xAD, 0x3F, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x45, 0xB1,
  0xB1, 0xB1, 0x5E, 0x85, 0x85, 0x4F, 0x4E, 0x4F,
  0x99, 0xDD, 0xA8, 0x99, 0xA8, 0x4E, 0xA8, 0x4E,
  0xC7, 0xC7, 0x4F, 0x29, 0xE4, 0x98, 0x35, 0xEE,
  0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE,
  0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE,
  0x79, 0x98, 0x54, 0x5E, 0xDD, 0xC7, 0x99, 0xC7,
  0x99, 0xDD, 0xA8, 0x4E, 0xDD, 0xDD, 0x85, 0x54,
  0xA6, 0x77, 0x72, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x7F, 0x54,
  0x74, 0x97, 0x97, 0x54, 0xBC, 0xB1, 0xB1, 0x45,
  0x85, 0x85, 0x4E, 0x4F, 0xDD, 0xC7, 0x4E, 0xC7,
  0x99, 0xDD, 0x4F, 0xB1, 0x74, 0x30, 0x2A, 0xEE,
  0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE,
  0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE,
  0x79, 0x58, 0x97, 0xB1, 0x85, 0xC7, 0xC7, 0xDD,
  0x4E, 0x4E, 0x4F, 0x40, 0x5E, 0xE4, 0xDB, 0x72,
  0xCC, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0xD2,
  0xD0, 0x5F, 0x30, 0xD1, 0xB0, 0x74, 0x74, 0x74,
  0x74, 0xE4, 0xE4, 0x45, 0x85, 0xDD, 0x99, 0xDD,
  0x4E, 0x85, 0x45, 0x74, 0x98, 0xA4, 0x57, 0xEE,
  0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE,
  0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE,
  0x9A, 0x30, 0xBE, 0x97, 0xB1, 0x29, 0x85, 0x85,
  0x85, 0x45, 0xE4, 0x54, 0xB6, 0xAC, 0x72, 0x77,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x72, 0xC1, 0x42, 0x65, 0xA2, 0x98,
  0x61, 0xD1, 0xBE, 0x82, 0x7A, 0x54, 0xE4, 0xBC,
  0xE4, 0x54, 0x3D, 0x98, 0xA2, 0xE0, 0x52, 0xEE,
  0xEE, 0xCF, 0xD4, 0xB4, 0x64, 0xB4, 0x64, 0xB4,
  0x64, 0xB4, 0x64, 0xB4, 0x64, 0xB4, 0xD4, 0xCF,
  0xAB, 0xE0, 0x98, 0xB0, 0x74, 0x54, 0xAD, 0x54,
  0x54, 0x74, 0xB0, 0xA2, 0xA0, 0x72, 0x77, 0x72,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x77, 0x75, 0x77, 0x75, 0x84, 0xDE,
  0x5A, 0x48, 0xA4, 0xA2, 0x61, 0xD1, 0xBE, 0xB0,
  0xB0, 0xB9, 0xB9, 0x9B, 0x9B, 0xD8, 0x91, 0x68,
  0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
  0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x72,
  0x4D, 0x88, 0x30, 0x98, 0x32, 0x32, 0xBE, 0x3D,
  0xB0, 0x61, 0x9F, 0xD2, 0x77, 0x77, 0x72, 0x77,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0xCC, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x77, 0x77, 0xCC, 0x77,
  0xCC, 0xCC, 0x72, 0xA0, 0xAC, 0x9B, 0xA2, 0x9F,
  0xA2, 0xA2, 0x71, 0xE0, 0x57, 0x42, 0x77, 0x77,
  0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72,
  0x72, 0x72, 0x72, 0x72, 0x72, 0x77, 0x72, 0x77,
  0xE1, 0xAB, 0x88, 0xA2, 0xB9, 0xD1, 0xB9, 0x30,
  0xA2, 0xA1, 0x84, 0x77, 0x72, 0x72, 0x77, 0x72,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x77, 0x77, 0x84, 0xE7, 0x5D,
  0x39, 0x2A, 0x7D, 0x6E, 0xE1, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
  0x77, 0x77, 0x77, 0x77, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x42, 0x2C, 0x57, 0x2A, 0x88, 0x88, 0x79,
  0xE7, 0x84, 0x77, 0x72, 0x77, 0x77, 0x72, 0x77,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x77, 0x75,
  0x77, 0x77, 0x72, 0x77, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72,
  0x72, 0x72, 0x72, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x77, 0x75, 0xCC,
  0xCC, 0x77, 0x72, 0x77, 0x72, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
  0x77, 0x77, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x77,
  0x77, 0x72, 0x77, 0x72, 0x77, 0x77, 0x72, 0x77,
  0x72, 0x77, 0x72, 0x77, 0x72, 0x77, 0x72, 0x77
};

#define INCLUDE_LINUX_LOGOBW
#define INCLUDE_LINUX_LOGO16
#include <linux/linux_logo.h>

#else

/* prototypes only */
extern unsigned char linux_logo_red[];
extern unsigned char linux_logo_green[];
extern unsigned char linux_logo_blue[];
extern unsigned char linux_logo[];
extern unsigned char linux_logo_bw[];
extern unsigned char linux_logo16_red[];
extern unsigned char linux_logo16_green[];
extern unsigned char linux_logo16_blue[];
extern unsigned char linux_logo16[];

#endif
