#define	CURSES_LIBRARY	1
#include <curses.h>

#ifdef PDCDEBUG
char *rcsid__getattr = "$Header: C:\CURSES\private\RCS\_getattr.c 2.1 1993/06/18 20:23:23 MH Rel MH $";
#endif




/*man-start*********************************************************************

  PDC_get_attribute()	- Get attribute at current cursor

  PDCurses Description:
 	This is a private PDCurses function

 	Return the current attr at current cursor position on the screen.

  PDCurses Return Value:
 	This routine will return OK upon success and otherwise ERR will be
 	returned.

  PDCurses Errors:
 	There are no defined errors for this routine.

  Portability:
 	PDCurses	int	PDC_get_attribute( void );

**man-end**********************************************************************/

int	PDC_get_attribute(void)
{
#ifdef	OS2
	char Cell[4];
	USHORT cellLen = 2;
	USHORT curRow = PDC_get_cur_row();
	USHORT curCol = PDC_get_cur_col();
#endif

#ifdef PDCDEBUG
	if (trace_on) PDC_debug("PDC_get_attribute() - called\n");
#endif

#ifdef	FLEXOS
	/* Get and return current attribute.  Force error until fixed. */
	return ((COLOR_CYAN) >> ((sizeof(ch type) / 2) * 8));
#endif

#ifdef	DOS
	regs.x.ax = 0x0800;
	regs.h.bh = _cursvar.video_page;
	int86(0x10, &regs, &regs);
	return ((int) regs.h.ah);
#endif

#ifdef	OS2
	VioReadCellStr((PCH)&Cell, (PUSHORT)&cellLen, (USHORT)curRow, (USHORT)curCol, 0);
	return ((int) Cell[1]);
#endif

#ifdef UNIX
/* INCOMPLETE */
#endif
}
