#define	CURSES_LIBRARY	1
#include <curses.h>

#ifdef PDCDEBUG
char *rcsid__chgattr = "$Header: C:\CURSES\private\RCS\_chgattr.c 2.1 1993/06/18 20:23:11 MH Rel MH $";
#endif




/*man-start*********************************************************************

  PDC_chg_attrs()	- Change attributes in a rectangle

  PDCurses Description:
 	This routine will change the attribute(s) from a starting (y,x)
 	position to an ending (y,x) position to the specified attribute.

  PDCurses Return Value:
 	This function returns OK on success and ERR on error.

  PDCurses Errors:
 	It is an error to call this function with a NULL window pointer.
 	It is also an error to pass rectangular coordinates that lay
 	outside of window.

  Portability:
 	PDCurses	int PDC_chg_attrs( WINDOW* w, chtype attr,
 					int sy, int sx,
 					int ey, int ex );

**man-end**********************************************************************/

int	PDC_chg_attrs(WINDOW *w, chtype attr, int sy, int sx, int ey, int ex)
{
	chtype	oldattr = w->_attrs;
	int	c;
	int	l;

#ifdef PDCDEBUG
	if (trace_on) PDC_debug("PDC_chr_attrs() - called\n");
#endif

	if (w == (WINDOW *)NULL)		return( ERR );
	if (sy > w->_maxy)	return( ERR );
	if (sx > w->_maxx)	return( ERR );
	if (ey >= w->_maxy)	ey = w->_maxy - 1;
	if (ex >= w->_maxx)	ex = w->_maxx - 1;

	wattrset(w, attr);
	for (l = sy; l <= ey; l++)
	{
		for (c = sx; c <= ex; c++)
			w->_y[l][c] = (w->_y[l][c] & A_CHARTEXT) | attr;

		if (w->_firstch[l] == _NO_CHANGE)
		{
			w->_firstch[l] = sx;
			w->_lastch[l] = ex;
		}
		else
		if (w->_firstch[l] != _NO_CHANGE)
		{
			if (sx < w->_firstch[l])
				w->_firstch[l] = sx;
			if (ex > w->_lastch[l])
				w->_lastch[l] = ex;
		}
	}
	w->_attrs = oldattr;
	return( OK );
}
