#define	CURSES_LIBRARY	1
#include <curses.h>

#ifdef	REGISTERWINDOWS
#ifdef PDCDEBUG
char *rcsid__addtail = "$Header: C:\CURSES\private\RCS\_addtail.c 2.1 1993/06/18 20:23:05 MH Rel MH $";
#endif




/*man-start*********************************************************************

  PDC_addtail()	- add window to the visible window list

  PDCurses Description:
 	This is a private PDCurses function.

 	This routine adds the passed window pointer to the end fo the
 	visible window list.  All windows on this list will automatically
 	be refreshed if _cursvar.refreshall is true.

  PDCurses Return Value:
 	This function returns OK upon success otherwise ERR is returned.

  PDCurses Errors:
 	It is an error to pass a NULL window pointer.

  Portability:
 	PDCurses	int	PDC_addtail( WINDOW* tail );

**man-end**********************************************************************/

int	PDC_addtail(WINDOW *tail)
{
	WINDS  *next = _cursvar.visible;

#ifdef PDCDEBUG
	if (trace_on) PDC_debug("PDC_addtail() - called\n");
#endif

	if  (tail == (WINDOW *)NULL)
		return( ERR );

	while (next != (WINDS *)NULL)
	{
		if (next->next == NULL)
			break;
		next = next->next;
	}
	if (next == NULL)
		PDC_inswin(tail, (WINDOW *)NULL);
	else
	{
		if (next->w == NULL)
			PDC_inswin(tail, (WINDOW *)NULL);
		else
			PDC_addwin(tail, next->w);
	}
	return( OK );
}
#endif
