#define	CURSES_LIBRARY	1
#include <curses.h>
#undef	wstandout

#ifdef PDCDEBUG
char *rcsid_wstandou = "$Header: C:\CURSES\portable\RCS\wstandou.c 2.1 1993/06/18 20:21:57 MH Rel MH $";
#endif




/*man-start*********************************************************************

  wstandout()	- attribute manipulation

  X/Open Description:
 	These functions manipulate the current attributes of the named
 	window.  These attributes can be any combination of A_STANDOUT,
 	A_REVERSE, A_BOLD, A_DIM, A_BLINK, A_UNDERLINE.

 	These constants are defined in <curses.h> and can be combined
 	with the bitwise-OR operator (|).

 	The current attributes of a window are applied to all characters
 	that are written into the window with waddch().  Attributes are
 	a property of the character, and move with the character
 	through any scrolling and insert/delete line/character operations.
 	To the extent possible on the particular terminal, they will be
 	displayed as the graphic rendition of characters put on the
 	screen.

 	The attrset() function sets the current attributes of the given
 	window to attrs.  The attroff() function turns off the named
 	attributes without turning on or off any other attributes.  The
 	attron() function turs on the named attriutes without affecting
 	any others.  The standout function is the same as
 	attron( A_STANDOUT ).  The standend() function is the same as
 	attrset( 0 ); that is it turns off all attributes.

 	NOTE:  attroff(), attron() and attrset() are macros.

  PDCurses Description:
 	System V compatible color support is included.
 	See <curses.h> for further details.

  X/Open Return Value:
 	These functions return OK on success and ERR on error.

  PDCurses Errors:
 	It is an error to call this function with a NULL window pointer.

  Portability:
 	PDCurses	int wstandout( WINDOW* win );
 	X/Open Dec '88	int wstandout( WINDOW* win );
 	BSD Curses	int wstandout( WINDOW* win );
 	SYS V Curses	int wstandout( WINDOW* win );

**man-end**********************************************************************/

int	wstandout( WINDOW *win )
{
#ifdef PDCDEBUG
	if (trace_on) PDC_debug("wstandout() - called\n");
#endif

	return( wattrset( win, A_STANDOUT ) );
}
