#ifndef NO_MEMORY_H
#include <memory.h>
#endif
#define	CURSES_LIBRARY	1
#include <curses.h>
#undef	wdelch

#ifdef PDCDEBUG
char *rcsid_wdelch = "$Header: C:\CURSES\portable\RCS\wdelch.c 2.1 1993/06/18 20:21:38 MH Rel MH $";
#endif




/*man-start*********************************************************************

  wdelch()	- remove character from window

  X/Open Description:
 	The character under the cursor in the window is deleted.  All
 	characters to the right on the same line are moved to the left
 	one position and the last character on the line is filled with
 	a blank.  The cursor position does not change (after moving to
 	y, x if coordinates are specified).

 	NOTE: delch(), mvdelch(), and mvwdelch() are macros.

  PDCurses Description:
 	Nothing additional.

  X/Open Return Value:
 	The wdelch() function returns OK on success and ERR on error.

  X/Open Errors:
 	No errors are defined for this function.

  Portability:
 	PDCurses	int wdelch( WINDOW* win );
 	X/Open Dec '88	int wdelch( WINDOW* win );
 	BSD Curses	int wdelch( WINDOW* win );
 	SYS V Curses	int wdelch( WINDOW* win );

**man-end**********************************************************************/

int	wdelch(WINDOW *win)
{
	int		y;
	int		x;
	int		maxx;
	chtype*		temp1;

#ifdef PDCDEBUG
	if (trace_on) PDC_debug("wdelch() - called\n");
#endif

	if (win == (WINDOW *)NULL)
		return (ERR);

	y	= win->_cury;
	x	= win->_curx;
	maxx	= win->_maxx - 1;
	temp1	= &win->_y[y][x];

	memmove( temp1, temp1 + 1, (maxx - x) * sizeof(chtype) );

	win->_y[y][maxx] = win->_blank | win->_attrs;
	win->_lastch[y] = maxx;

	if ((win->_firstch[y] == _NO_CHANGE) ||
	    (win->_firstch[y] > x))
	{
		win->_firstch[y] = x;
	}
	return (OK);
}
