#define	CURSES_LIBRARY	1
#include <curses.h>
#undef	copywin

#ifdef PDCDEBUG
char *rcsid_copywin = "$Header: C:\CURSES\portable\RCS\copywin.c 2.1 1993/06/18 20:19:07 MH Rel MH $";
#endif




/*man-start*********************************************************************

  copywin()	- Overlay/overwrite a part of a window on top of another.

  PDCurses Description:
 	This routine is similar to overwrite() and overlay() but copywin()
 	does not require that the two windows overlap.

 	The arguments src_tc and src_tr specify the top left corner of the
 	region to be copied to the destination window.
 	The arguments dst_tc,dst_tr,dst_br,dst_bc specify the region within
 	the destination window to where the copy is made.

 	The argument overlay, if TRUE, indicates that the copy is done
 	non-destructively (as in overlay()). Blanks in the source window
 	are not copied to the destination window. When overlay is FALSE,
 	(as in overwrit()), the copy is destructive; blanks are copied
 	to the destination window.

  PDCurses Errors:
 	It is an error to pass a NULL window pointer.

  Portability:
 	PDCurses	int	copywin( WINDOW* src_w, WINDOW* dst_w, int src_tc,
 			int src_tc, int dst_tr, int dst_tc, int dst_br, int dst_bc,
 			bool overlay);
 	X/Open Dec '88
 	SYS V Curses	int	copywin( WINDOW* src_w, WINDOW* dst_w, int src_tr,
 			int src_tc, int dst_tr, int dst_tc, int dst_br, int dst_bc,
 			bool overlay);

**man-end**********************************************************************/

int	copywin(WINDOW *src_w, WINDOW *dst_w, int src_tr,
 			int src_tc, int dst_tr, int dst_tc, int dst_br, int dst_bc,
 			bool overlay)
{
	int	src_start_x = src_tc;
	int	src_start_y = src_tr;
	int	dst_start_x = dst_tc;
	int	dst_start_y = dst_tr;
	int	src_end_x;
	int	src_end_y;
	int	dst_end_x;
	int	dst_end_y;
	int	src_rows,src_cols;
	int	dst_rows,dst_cols;
	int	min_rows,min_cols;
	int	max_rows,max_cols;
	int	rc;

#ifdef PDCDEBUG
	if (trace_on) PDC_debug("copywin() - called\n");
#endif

	if (src_w == (WINDOW *)NULL)	return( ERR );
	if (dst_w == (WINDOW *)NULL)	return( ERR );

	src_rows = src_w->_maxy - src_tr;
	src_cols = src_w->_maxx - src_tc;
	dst_rows = dst_br - dst_tr;
	dst_cols = dst_bc - dst_tc;

	min_rows = min(src_rows,dst_rows);
	min_cols = min(src_cols,dst_cols);

	src_end_y = src_tr + min_rows;
	src_end_x = src_tc + min_cols;
	dst_end_y = dst_tr + min_rows;
	dst_end_x = dst_tc + min_cols;

	rc = PDC_copy_win(src_w,dst_w,src_start_y,src_start_x,src_end_y,src_end_x,
		dst_start_y,dst_start_x,dst_end_y,dst_end_x,overlay);

	return( rc );
}
