NAME
     uniq - remove duplicate lines from a sorted file

SYNOPSIS
     uniq [-cdu] [-f skip-fields] [-s skip-chars]  [-w  check-chars]  [-#skip-
     fields]   [+#skip-chars]   [--count]   [--repeated]  [--unique]  [--skip-
     fields=skip-fields] [--skip-chars=skip-chars] [--check-chars=check-chars]
     [infile] [outfile]

DESCRIPTION
     This manual page documents the GNU version  of  uniq.   uniq  prints  the
     unique  lines  in  a  sorted  file,  discarding  all  but one of a run of
     matching lines.  It can optionally show only lines  that  appear  exactly
     once,  or  lines  that appear more than once.  uniq requires sorted input
     because it compares only consecutive lines.

     If the output file is not specified, uniq writes to the standard  output.
     If the input file is not specified, it reads from the standard input.

     OPTIONS

     -u, --unique
          Only print unique lines.

     -d, --repeated
          Only print duplicate lines.

     -c, --count
          Print the number of times each line occurred along with the line.

     -, -f, --skip-fields=number
          In this option, number is an  integer  representing  the  number  of
          fields  to  skip  over  before  checking  for uniqueness.  The first
          number fields, along with any blanks found before number  fields  is
          reached,  are skipped over and not counted.  Fields are defined as a
          strings of non-space, non-tab characters, that  are  separated  from
          each other by spaces and tabs.

     --, -s, +skip-chars=number
          In this option,  number  is  an  integer  represent  the  number  of
          characters  to  skip over before checking for uniqueness.  The first
          number  characters,  along  with  any  blanks  found  before  number
          characters is reached, are skipped over and not counted.  If you use
          both the field and character skipping options,  fields  are  skipped
          over first.

     -w, +check-chars=number
          Specify the number of characters to  compare  in  the  lines,  after
          skipping  any  specified fields and characters.  Normally the entire
          rest of the lines are compared.

     The long-named options can be introduced with `+' as well  as  `--',  for
     compatibility with previous releases.  Eventually support for `+' will be
     removed, because it is incompatible with the POSIX.2 standard.
