extproc sh
#!/bin/sh
out=$TMP/m4$$.out
err=$TMP/m4$$.err

xout=$TMP/m4$$x.out
xerr=$TMP/m4$$x.err

trap "rm $out $err $xout $xerr >nul; exit 1" 1 2 3 14 15

for i
do
	echo "Input file: $i"
	m4 -d -Iexamples $i >$out 2>$err

	sed -e '/^dnl @result{}/!d' -e 's///' $i > $xout

	if cmp -s $out $xout; then
		:
	else
		echo `sed -e 's/^dnl //' -e 1q $i`
		echo "$i: stdout mismatch"
		diff $out $xout
	fi

	sed -e '/^dnl @error{}/!d' -e 's///' $i > $xerr

	if cmp -s $err $xerr; then
		:
	else
		echo `sed -e 's/^dnl //' -e 1q $i`
		echo "$i: stderr mismatch"
		diff $err $xerr
	fi

done

rm -f $out $err $xout $xerr
