NAME
     xargs - build and execute command lines from standard input

SYNOPSIS
     xargs [-0prtx] [-e[eof-str]] [-i[replace-str]] [-l[max-lines]]  [-n  max-
     args]    [-s    max-chars]   [-P   max-procs]   [+null]   [+eof[=eof-str]
     [+replace[=replace-str]  [+max-lines[=max-lines]  [+interactive]   [+max-
     chars  max-chars]  [+verbose] [+exit] [+max-procs max-procs] [+no-run-if-
     empty] [command [initial-arguments]]

DESCRIPTION
     This manual page  documents  the  GNU  version  of  xargs.   xargs  reads
     arguments  from  the  standard  input,  delimited by blanks (which can be
     protected with double or single quotes or a backslash) or  newlines,  and
     executes  the  command  (default is /bin/echo) one or more times with any
     initial-arguments followed by arguments read from standard input.   Blank
     lines on the standard input are ignored.

     xargs exits with the following status:
     0 if it succeeds
     123 if any invocation of the command exited with status 1-125
     124 if the command exited with status 255
     125 if the command is killed by a signal
     126 if the command cannot be run
     127 if the command is not found
     1 if some other error occurred.

     OPTIONS

     +null, -0
          Input filenames are terminated by a null  character  instead  of  by
          whitespace  and  the  quotes  and  backslash  are not special (every
          character is taken literally).  However, any end of file  string  is
          still  recognized.   Useful  with  the  GNU find -print0 option when
          filenames might contain white space, quote marks, or backslashes.

     +eof[=eof-str], -e[eof-str]
          Set the end of file string to eof-str.  (If the end of  file  string
          occurs  as  a  line of input, the rest of the input is ignored.)  If
          eof-str is omitted, there is no end of file string.  If this  option
          is not given, the end of file string defaults to "_".

     +replace[=replace-str], -i[replace-str]
          Replace occurences of replace-str  in  the  initial  arguments  with
          names  read  from  standard  input.   If  replace-str is omitted, it
          defaults to "{}" (like for `find -exec').  Causes the command to  be
          executed once per line of input.  Implies -x.

     +max-lines[=max-lines], -l[max-lines]
          Use at most max-lines nonblank input lines per  command  line;  max-
          lines defaults to 1 if omitted.  Trailing blanks cause an input line
          to be logically continued on the next input line.  Implies -x.

     +max-args max-args, -n max-args
          Use at most max-args arguments per command line.   Fewer  than  max-
          args  arguments  will  be  used  if  the size (see the -s option) is
          exceeded, unless the -x option is given, in which  case  xargs  will
          exit.

     +interactive, -p
          Prompt the user about whether to run each command line  and  read  a
          line  from  the terminal.  Only run the command line if the response
          starts with `y' or `Y'.  Implies -t.

     +no-run-if-empty, -r
          If the standard input does not contain any nonblanks, do not run the
          command.   Normally,  the  command  is  run once even if there is no
          input.

     +max-chars max-chars, -s max-chars
          Use at most max-chars characters per  command  line,  including  the
          command and initial arguments.  The default is as large as possible.

     +verbose, -t
          Print the command line on the standard error output before executing
          it.

     +exit, -x
          Exit if the size (see the -s option) is exceeded.

     +max-procs max-procs, -P max-procs
          Run up to max-procs processes at a time; the default is 1.  If  max-
          procs  is 0, xargs will run as many processes as possible at a time.
          Use the -n option with -P; otherwise chances are that only one  exec
          will be done.
