(* Copyright (C) 2002 Aitor Santamaria_Merino <aitor.sm@wanadoo.es> *)

(*
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*)
program vgashot;

{$S-}
{$M 1024, 0, 0}

uses dos;

const
     {***** Screen related ******}
     EGAVGA_SEQUENCER = $3C4;
     EGAVGA_GRAPHCTR  = $3CE;
     {***** TSR related *****}
     SwConst:word=$0801;


type
    {****  BMP RELATED *****}
    bmpheader = record
                      id     :  array[1..2] of byte;
                      filesz :  longint;
                      reserved: longint;
                      dataofs:  longint;
                      headersz: longint;
                      width:    longint;
                      height:   longint;
                      planes:   word;
                      bitsppix: word;
                      compress: longint;
                      datasize: longint;
                      hres    : longint;
                      vres    : longint;
                      colors  : longint;
                      importantcol: longint;
    end;
    RGBQuad = array[1..4] of byte;
    palettetype = array[0..15] of RGBQuad;
    AR1 = array[1..sizeof(bmpheader)] of byte;
    AR2 = array[1..sizeof(palettetype)] of byte;

    {screen related}
    ScrTable = array [0..80*25*2-1] of byte;
    Character = array[0..31] of byte;
    FONT = ARRAY [0..255] OF character;             {font table}
    FPTR = ^font;



var
   {**** BMP related ****}
   header : bmpheader;    {BMP header}
   palette: palettetype;  {BMP palette}
   podd: boolean;         {odd or even pixel?}
   pix : byte;            {stored half-pixel}
   f   : file of byte;    {BMP file}
   filename: string;      {name of the file}
   {**** screen related *****}
   PAGE_OFS : word absolute $0040:$004E;  {page offset}
   ScreenStatus : ScrTable;               {status of screen}
   CurScreen : ^ScrTable;                 {pointer to screen}
   fontptr : fptr;                        {pointer to current font table}
   c       : character;                   {character being analised}
   {**** TSR related *****}
   CPURegisters: Registers;
   PInt21,
   PInt09, PInt12, PInt28: Pointer;  {saved handlers for keyboard, getmemsize(API)}
   TempPtr: Pointer;            {for use on DoUnInstall}
   TSRInUse: Boolean;           {TSR is in use}
   PSPPtr : ^Word;              {pointer to PSP}
   MadeActive: boolean;         {request delayed}
   OurInDOS: byte;              {our particular inDOS flag}


procedure CLI; inline( $FA );
procedure STI; inline( $FB );


{********************   BMP RELATED ***************************}
procedure fillheader;
begin
     with header do begin
                         id[1]    := ord ('B');
                         id[2]    := ord ('M');
                         dataofs  := sizeof(header) + 4*16;
                         width    := 80*8;
                         height   := 25*16;
                         datasize := width*height div 2;
                         filesz   := dataofs + datasize;
                         reserved := 0;
                         headersz := 40;
                         planes   := 1;
                         bitsppix := 4;
                         compress := 0;
                         hres     := 0;
                         vres     := 0;
                         colors   := 16;    {2^4}
                         importantcol := 16;
     end;
end;

procedure fillpalette;
var ii: byte;
    base, add: byte;
begin
     for ii:= 0 to 15 do begin
         base := 128*ord(ii>7);
         add  := 255-base;
         palette[ii,1] := ord((ii AND 1)>0)*add+base;       {blue}
         palette[ii,2] := ord((ii AND 2)>0)*add+base;       {green}
         palette[ii,3] := ord((ii AND 4)>0)*add+base;       {red}
         palette[ii,4] := 0;                          {reserved}
     end;
     {corrections: 6(orange) and 7 (light gray)}
     for ii:=1 to 3 do begin
         palette[7,ii] := 192;
     end;
     palette[6,2] := 128;
end;


procedure writepix (value: byte);  {value: 0..15}
begin
{        writeLn (log,pix,',',ord(podd),',',value);}
     if podd then begin
        pix := pix OR value;
        write (f,pix);
{        writeLn (log, 'written ',pix);}
        pix := 0;
     end else
        pix := value shl 4;
     podd := NOT podd;
end;


{********************   SCREEN RELATED ***************************}


PROCEDURE GetFontAccess;                            {Magic numbers...}
CONST SeqRegs : ARRAY [1..4] OF word = ( $0100, $0402, $0704, $0300 );
      GCRegs  : ARRAY [1..3] OF word = ( $0204, $0005, $0406 );
VAR i : byte;
BEGIN
     CLI;
     FOR i := 1 TO 4 DO portw[ EGAVGA_SEQUENCER ] := SeqRegs[ i ];
     FOR i := 1 TO 3 DO portw[ EGAVGA_GRAPHCTR ] := GCRegs[ i ];
     STI;
END;


PROCEDURE ReleaseFontAccess;                         {magic numbers...}
CONST SeqRegs : ARRAY [1..4] OF word = ( $0100, $0302, $0304, $0300 );
      GCRegs  : ARRAY [1..3] OF word = ( $0004, $1005, $0E06 );
VAR i : byte;
BEGIN
     CLI;
     FOR i := 1 TO 4 DO portw[ EGAVGA_SEQUENCER ] := SeqRegs[ i ];
     FOR i := 1 TO 3 DO portw[ EGAVGA_GRAPHCTR ] := GCRegs[ i ];
     STI;
END;


function charAt (x,y: byte): byte;
begin
     charat := ScreenStatus [(y-1)*160+(x-1)*2]
end;


function fcolorAt (x,y: byte): byte;
begin
     fcolorAt := ScreenStatus [(y-1)*160+(x-1)*2+1] AND 15;
end;

function bcolorAt (x,y: byte): byte;
begin
     bcolorat := (ScreenStatus [(y-1)*160+(x-1)*2+1] SHR 4) AND 15;
end;

function activebit (bt: byte; b: byte): boolean;
begin
     activebit := (bt AND (1 shl b))>0
end;


Procedure CaptureScreen;
var i, j, k, l: word;
begin
     {initialization}
     podd := FALSE;
     pix  := 0;
     fillheader;
     fillpalette;
     fontptr := ptr( $A000, 0 );     {Pointer to first font}

     {open file}
     assign (f, filename);
     {$I-}
     rewrite (f);
     if IOResult<>0 then exit;
     {$I+}
     seek(f,0);

     {write headers}
     for i:=1 to sizeof(AR1) do
         write (f,AR1(header)[i]);
     for i:=1 to sizeof(AR2) do
         write (f,AR2(palette)[i]);

     {write data}
     {save screen status}
     CurScreen := ptr ($B800, Page_Ofs);
     move (CurScreen^, ScreenStatus, sizeof (ScrTable));

     {now parse fonts}
     getfontaccess;
     for i:=25 downto 1 do begin
         for j:=15 downto 0 do
             for k:=1 to 80 do begin
                 c := fontptr^[charat(k,i)];
                 for l:=7 downto 0 do
                     if activebit (c[j], l) then writepix (fcolorat(k,i))
                                            else writepix (bcolorat(k,i))
             end;
         end;
     ReleaseFontAccess;
     close (f)
end;


{********************   TSR RELATED ***************************}



procedure KeyboardInt; interrupt;
begin
  if  not TSRInUse  then
  if  (MEM[$40:$17] and 8) = 8  then   {These two: AltGr (RightALT)}
  if  (MEM[$40:$18] and 2) = 0  then
  if  Port[$60]=$42  then              {This one: Key F8  make code}
    begin
        TSRInUse := True;
        if OurInDOS = 0 then begin
           madeactive := False;
           CaptureScreen;
           TSRInUse := False
        end else
            MadeActive := TRUE
    end;
  { Call existing keyboard interrupt handler. }
  asm
    PUSHF
    CALL PINT09
  end;
end; {KeyboardInt}


procedure DoUnInstall ( var Removed: Boolean ); forward;


var
   MessageNum : Integer;
   DeInstallOk: Boolean;


procedure OutInt21; assembler;
asm
   push ax
   mov al, 1
   mov OurInDOS, al
   pop ax
   call PInt21
   push ax
   xor ax,ax
   mov OurInDOS, al
   pop ax
end;

procedure OurInt12 (_AX, BX, CX, DX, SI, DI, DS, ES, BP:Word); interrupt;
begin
   {1.- if DX=SWCOnst then message for us. Otherwise, normal DOS call}
   If DX = SwConst Then
      MessageNum := CX
   else
     begin
       MessageNum := 0;
       asm
          pushf
          call    PInt12
          mov     _AX, ax  {return memory size in _AX}
       end;
     end;

    {2.- Message for us? Then interpretate}
    if  MessageNum > 0   then
    case  lo(MessageNum)  of
                            1:  DX := Swap (DX);  {I'm here!!!}
                            2:  begin { Performs request to uninstall the TSR. }
                                     DoUnInstall (DeInstallOk);
                                     DX := ord(not DeInstallOk);
                                End;
    End;
end;


procedure BackgroundInt; interrupt;
begin
  { Call saved INT 28H handler. }
  asm
    PUSHF
    CALL PInt28
  end;
  if  MadeActive  then
  begin
    TSRInUse := True;
    MadeActive := False;
    CaptureScreen;
    TSRInUse := False;
  end;
end; {BackgroundInt}


procedure DoUnInstall ( var Removed: Boolean );
begin
  Removed := True;

  GetIntVec( $12, TempPtr );
  If  TempPtr <> @OurInt12  then
    Removed := False;

  GetIntVec( $09, TempPtr );
  if  TempPtr <> @KeyBoardInt  then
    Removed := False;

  {2.- YES: then restore everything}
  if  Removed  then
  begin
    { Restore interrupts }
    SetIntVec( $12, PInt12 );
    SetIntVec( $09, PInt09 );
    SetIntVec( $28, PInt28 );

    { Free up memory allocated to this program using
    INT 21 Func=49H "Release memory". }
    CPURegisters.AH := $49;
    CPURegisters.ES := PrefixSeg;{ Current program's PSP }
    Intr( $21, CPURegisters );
  end;
end;


procedure DoInstall;
begin
    {1.- Set controlling variables}
    TSRInUse := False;

    {2.- Deallocate DOS Environment block to save memory}
    PSPPtr := Ptr( PrefixSeg, $2C );
    CPURegisters.AX := $4900;
    CPURegisters.ES := PSPPtr^;
    Intr( $21, CPURegisters);

    {3.- Save old interrupt controllers}
    asm
       cli
    end;

    {INT 12h: Return free memory}
    GetIntVec( $12, PInt12 );
    SetIntVec( $12, @OurInt12 );

    {INT 09h: Keyboard}
    GetIntVec( $09, PInt09 );
    SetIntVec( $09, @KeyboardInt );

    {INT 28h: iddle proccesses}
    GetIntVec( $28, PInt28 );
    SetIntVec( $28, @BackgroundInt );

    asm
       sti
    end;

    {4.- Leave it resident}
    Keep(0);

end;



{********************   MAIN ***************************}

procedure showfasthelp;
begin
     writeLn ('VGASHOT filename');
     WriteLn ('VGASHOT /U');
     WriteLn ('VGASHOT /?');
     WriteLn;
     WriteLn ('filename  Installs VGAShot. THe image will be copied as');
     WriteLn ('          filename.BMP (overwritten) as a windows BMP image');
     WriteLn ('          Press AltGr+F8 (rightAlt+F8) to make the picture at');
     WriteLn ('          any time VGAShot is installed');
     writeLn ('/U        Uninstalls VGAShot');
     WriteLn ('/?        Shows this help');
     halt(0);
end;

(*   REMOVED: this created a .BMP file before being used, ANNOYING!
procedure testfile (filename: string);
var f: file of byte; i: integer;
begin
     {$I-}
     assign (f,filename);
     rewrite(f);
     I := IOResult;
     IF I<>0 THEN begin
        writelN (filename,' couldn''t be opened');
        writeLn ('DOS Error: ',i);
        halt (1)
     end;
     {$I+}
     close (f)
end; *)


function uninstalltsr: boolean;
Var
   Regs: registers;
Begin
  with  Regs  do Begin
    CX := $102;
    DX := SwConst;
  End;
  Intr( $12, Regs );
  UnInstalltsr := Regs.DX = 0;
End;

Function IsPresent: boolean;
Var
   Regs: registers;
Begin
  with  Regs  do Begin
    CX := $101;
    DX := SwConst;
  End;
  Intr( $12, Regs );
  IsPresent := Regs.DX = Swap(SwConst)
End;



begin
     if paramstr(1)='/?' then showfasthelp;
     if (paramcount=0) or (paramcount>1) then begin
        writeLn ('Error in parameters');
        ShowFastHelp
     end;
     if (paramstr(1)='/u') or (paramstr(1)='/U') then
     if ispresent then begin
        if uninstallTSR then writelN ('VGAShot unistalled satisfactorily')
                        else writeLn ('VGAShot couldn''t be uninstalled!!');
        halt (0)
     end else begin
         writeLn ('VGAShot is not present in memory');
         halt (1)
     end;

     {install case}
     if ispresent then begin
        writeLn ('VGAShot is already present!');
        WriteLn ('Uninstall it first');
        halt(1)
     end;
     filename := paramstr(1)+'.BMP';
{     testfile (filename);    REMOVED!!}
     DOInstall
end.
