/* A program similar to UNIX tr */

/* Copyright (C) 1998 Jim Hall, jhall1@isd.net */

/*
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include <stdio.h>
#include <stdlib.h>				/* for atoi */


/* Function prototypes */

int what_char (const char *string);


/* Main program */

int
main (int argc, char **argv)
{
  /* Variables */

  int old, new;
  int ch;

  /* Evaluate command line */

  /* Quick check for now.  Later, I'll support command line
  parameters to delete characters, etc.  For version 1.0, I
  will only support translating one character to another. */

  if (argc < 3) {
    /* Not enough to work with */

    fprintf (stderr, "TRCH: Not enough arguments.\n");
    exit (1);
  }

  else if (argc > 3) {
    /* Too many arguments */

    fprintf (stderr, "TRCH: Too many arguments.\n");
    exit (1);
  }

  /* Assign old and new chars. */

  old = what_char (argv[1]);
  new = what_char (argv[2]);

  /* Translate characters */

  while ((ch = getchar ()) != EOF) {
    if (ch == old) {
      putchar (new);
    }

    else {
      putchar (ch);
    }
  } /* while */

  exit (0);
}

int
what_char (const char *string)
{
  /* Evaluate what character the string represents, and return
  the value of the character. */

  /* Check first if this starts with an escape character */

  switch (string[0]) {
  case '\\':
    /* At least starts with an escape character */

    /* Check if this is a standard control character. */

    switch (string[1]) {
    case '\0':
      /* Return a verbatim slash */
      return ('\\');
      /* break;					/* keeps compiler happy */

    case 'r':
      return ('\r');
      /* break;					/* keeps compiler happy */

    case 't':
      return ('\t');
      /* break;					/* keeps compiler happy */

    case 'v':
      return ('\v');
      /* break;					/* keeps compiler happy */

    case 'n':
      return ('\n');
      /* break;					/* keeps compiler happy */

    case 'b':
      return ('\b');
      /* break;					/* keeps compiler happy */

    case '\\':
      return ('\\');
      /* break;					/* keeps compiler happy */
    }

    /* Assume a number.  Now use atoi to get the value. */

    /* THIS NEEDS SOME MORE WORK */

    return (atoi (&string[1]));

  case '^':
    /* An extension:  allow the carat character to
    represent a control sequence. */

    if (string[1] == '\0') {
      /* Return a verbatim carat */
      return ('^');
    }

    else if ((string[1] >= 'a') && (string[1] <= 'z')) {
      return (string[1] - 'a' + 1);
    }

    /* else */

    return (string[1] - 'A' + 1);
    /* break;					/* keeps compiler happy */
  }

  /* Does not start with a special character.  Assume the first
  letter is the character of interest. */

  return (string[0]);
}
