	; collection of "all" internal variables and constants used

	; Y coordinates of all the stuff below, for the new feature
	; of circulating the status lines
statline	dw 58	; for the 16 status bits
protoline	dw 59	; for protocol/CRLF/handshake/LED/local echo
helpline	dw 0	; for the help "screen" and messages
		; also adjust ANSI output window accordingly...
rotoline	dw 57	; where to store data while copying stuff around

		; where to display the 16 status bits (1 line = 2*80 byte)
statpos         dw 9280	; see STATLINE

		; where to display the serial, CR/LF and handshake setup 
		; also shows the LEDs and the local echo
protopos        dw 9440	; see PROTOLINE
		; (area) where to display local echo of sent data
tstart          dw 9440+140	; same line, right 10 chars
tend            dw 9440+160
		; pointer into sent data display
tpos            dw 9440+140

		; where to display special messages and help "screen"
msgstart        dw 0	; see HELPLINE
msgend          dw 0+160

		; next is the definition of the ANSI output window
rstart          dw 160		; second line
rstartxy        db 0		; continued in rfirstrow
rfirstrow	db   1		; so rstartxy is: HI=Y LO=X
rend            dw 4000		; (80*25) shl 1
rendxy          dw 184fh        ; lower right corner for ANSI output
		; pointers into the ANSI output window
rpos            dw 160		; init as rstart
rposxy          dw 0100h        ; H=Y L=X - init as rstartxy

; =====================================================================

		; further ANSI status: attribute, saved values
rattr           dw 1e20h
rscrollreg	db 0,24-1	; rstartxy-relative line numbers of
				; region which is handled by scrolling
rled		dw 0
rleds		db '1234'	; the LED simulation :-)

asaveattr	dw 0
asavepos	dw 0
asaveposxy	dw 0
asavescrollreg	db 0,24-1

		; ANSI parser stuff: buffers and similar
aparptr         dw apars	; *offset* - current parameter
apars           db 0,0,0,0	; limited to 4 entries for now

abufptr		dw abuffer	; *offset* - current buffer position
arecover	db 27		; for printing rejected seq, goes on below:
abuffer		db '.123;123;123;123m',0
abufend		db 0,0		; limit maximum length somehow...
ans_expect	db 0		; 1 if we expect to be still in an ANSI seq.

		; screen definition:
rows            dw 25
cols            dw 80
attr            dw 1e20h	; as default and for clear screen
screenseg	dw 0b800h
crtport         dw 3d4h ; from data found at 40h:[63h]

shiftstat       dw 0    ; copy of keyboard shift status at 40h:[17h]
flag_exit	dw 0	; set to != 0 to exit on next GETSH call

; =====================================================================

		; serial port setup and definition:
comdta          dw 0    ; port basis of serial port used
comnum          dw 3    ; number of serial port used

		; how to handle incoming and outgoing CR and LF
crpolicy        dw 0    ; 0..3: send CR as (LFCR CRLF CR or LF)
			; or 80h: add CR to incoming LF (and LF to CR)
send_cr         dw 0a0dh,0d0ah,000dh,000ah      ; CRLF-Sender: H=2nd/NUL
crsends         db 'CRLF','LFCR',' CR ',' LF '

hshake          dw 0    ; (in fact a byte) handshake configuration
		; decription strings for the above
crgets          db 'AUTO '
		; crgets MUST be right before hshakes in memory !
hshakes         db 'FERR BRKo BRK! STAU CTS? DSR? RTS! DTR! '
	; function of hshake bits:
	; BRK_rx'd_frame, BRK_rx'd_over, sending_BRK, allow_endless_TX_wait,
	; wait_for_cts, wait_for_dsr, shake_rts, shake_dtr

modlines        dw 0fc0bh       ; Hi: ANDmask Lo: Setting of modem control
				; here: re-set rts, dtr,  set out2, rts, dtr
				; out2 is also int enable! (-> value | 8)

linespeed       dw 0	; values 0..7 = 1200 2400 ... 38400 57600 115200
		; decription strings for the above (speed control values)
bauds           db '1200','2400','4800','9600','19.2','38.4','57.6','115.'

comstats:	dw 0    ; serial port status from UART (2 values)
comstats2:	dw 0	; to know if something has changed
		; description strings for the above:
mybits          db 'TOUT TNUL TRDY BRK_ FERR PERR OVER DRDY '
		; Timeout, TXallsent, TXmaysend, Break, 
		; FrameErr, Overflow, RXavailable
                db 'LINE RING DSR_ CTS_ dLIN dRNG dDSR dCTS '
		; LineDetection, Ring-Indicator, Modem(DataSet)Ready, CTS,
		; DeltaLD, DeltaRI, DeltaDSR, DeltaClearToSend

; <<<
; mods            db 'TX_2 TX_1 RTS_ DTR_ ' ; out2 out1 ReqToSend DatTermRdy
; for them, Disp (SHOW_PROTO) and ManualControl (FKeys) TX_*/RTS_ not yet here
; (current default: 0011 at program start, 0000 at program end, DTR_ is user
;  controlled, RTS_ is 1 unless "0 while busy" (RTSshake) selected)
; <<<

; =====================================================================

; the usual introduction stuff:
msg_cmdline	db 'Invalid command line arguments...',1,1
msg_hello       db 'AuerSoft Terminal V3 2001 '
                db   'Use F8 or both shifts to exit',1	; not ^C ...
		db 'give n in 1..8 on command line for speed '
		db   'preset (1200..115200)',1
		
		db 'and/or x in a..d on command line for port selection, ',1
		db  'defaults are last existing port (max. com4), '
		db  '9600 baud',1

                db 'F1 NextDisp F2 IncSpeed F3 BREAK_T F4 SendETX '
                db   'F5 TxCRLF_T F6 RxCRLF_T',1
                db 'F7 CTS/DSRwait F8 Exit F9 RTSshake F10 DTR_T',1
; HELP line directly follows hello message:
msg_help        db 'F1=inf F2=Sp+ F3=Brk! F4=ETX! F5=TxCR F6=RxCR '
                db   'F7=SHK? F8=EXIT F9=RTS! F10=DTR!',0

; complain if no serial port found or less than 80 columns found:
msg_nixcom      db 'no serial port found!',0
msg_wrongcols   db 'this needs 80 columns!',0
msg_wrongcom	db 'specified serial port does not exist!',0

; prompt strings if started from ROM
msg_askport	db 1,'Please type a number from 1..4 to select an',1
		db 'initial port number (will seek towards com1',1
		db 'from there until an installed port is found)',1,0
msg_askspeed	db 1,'Please type a number from 1..8 to select the',1
		db 'initial speed: 1=1200, 2=2400 3=4800 4=9600',1
		db '5=19200 6=38400 7=57600 8=115200',1,0


; =====================================================================

IRQ_intpos      dw 0    ; ***** pointer to IntVec COM1..4 => IRQ 4,3,4,3
IRQ_oldvect     dw 0,0  ; ***** old IntVec value
IRQ_oldmask	db 0	; ***** old 8259 interrupt mask
IRQ_oldevents	db 0	; ***** old UART event mask for interrupts

	; stuff for the incoming data buffer:
IRQ_buf_a       dw IRQ_buf	; ***** write pointer
IRQ_buf_b       dw IRQ_buf	; ***** read pointer

IRQ_buf         db '0123456789ABCDEF0123456789ABCDEF'   ; (incoming) buffer
IRQ_eofbuf      db 0

