; API functions for handling the serial communications,
; working together with terminal-irq.asm

	; transmit: send data to the serial port
	; (NOTE: could be changed to write to a buffer which
	; is in turn processed by the IRQ if the send buffer
	; is found to be full)

SENDEN: mov dx,[cs:comdta] ; returns AX -1, NZ if buffer spilled
        mov BX,ax	; *** should also handle TX_BRK here ***
        add dl,6
        mov ax,3030h    ; (3030h: require DSR, CTS)
        test byte [hshake],4   ; DSR?
        jnz dodsr2
        and ax,0dfdfh   ; not 2020h	; if hshake test 4, require DSR
dodsr2: test byte [hshake],8   ; CTS?
        jnz docts
        and ax,0efefh   ; not 1010h	; if hshake test 8, require CTS
docts:          call _WAIT
        jnz falsch_s
        dec dx
        mov ax,2020h    ; wait for room in the send buffer
                call _WAIT
        jnz falsch_s    ; if no room found, data is lost (see NOTE)
        mov dx,[cs:comdta]   ; output data to serial port
        mov ax,BX
        out dx,al
        RET

falsch_s:		; data is lost, buffer was full (traffic jam)
        mov ax,-1
        or sp,sp
        RET

;######################################

TX_BRK: PUSH ax		; set up the break status according to
        PUSH dx		; the bit 20h of hshake (break <-> data)
        mov dx,[cs:comdta]
        add dx,3
        in al,dx
        IODLY
        and al,10111111b
        test word [hshake],20h
        jz ntxb
        or al,40h
ntxb:   out dx,al
        POP dx
        POP ax
        RET

;######################################

MOD_LINES:              ; set up modem control lines:
        PUSH ax		; modlines has and-mask (hi) and or-mask (lo)
        PUSH bx
        PUSH dx
        mov dx,[cs:comdta]
        mov bx,[cs:modlines]
        add dx,4
        in al,dx
        IODLY     ; 6x86 Delay
        and al,bh
        or al,bl
        out dx,al
        POP dx
        POP bx
        POP ax
        RET

;######################################

SPEEDSET:               ; set serial speed according to linespeed 0..7:
        PUSH ax		; 0=1200 1=2400 ... 5=38400 6=57600 7=115200
        PUSH bx
        PUSH cx
        PUSH dx
        mov ax,[cs:linespeed]
        mov cx,ax
spcalc:
        mov ax,60h      ; for 1200 Baud
        shr ax,cl
        cmp ax,3
        jnb norm_sp
        inc ax          ; 1->2 (57,6k) 0->1 (115,2k)
norm_sp:
speed:                  ; divisor AX
        mov bx,ax
        mov dx,[cs:comdta]
        PUSHf
        cli
        PUSH dx
        add dl,3
        mov al,80h      ; prepare for divisor setup (flipflop)
        out dx,al
        IODLY     ; delay
        POP dx
	mov ax,bx	; <<<	mov al,bl
	out dx,ax	; <<<	out dx,al       ; Lo
        IODLY
			; <<<	inc dx
			; <<<	mov al,bh
			; <<<	out dx,al       ; Hi
			; <<<	IODLY
        add dx,3	; <<<	add dl,3-1
        mov al,00000011b        ; abc pp(none) s(1) dd(8) -> N 8 1
			; serial parameter bit map
        out dx,al       ; a=end divisor setup b=no break c=no sticky parity
; ***   IODLY
; ***   sub dl,3-1
; ***   mov al,0
; ***   out dx,al       ; <- was wrong... IRQ enable thing...
        POPf
        POP dx
        POP cx
        POP bx
        POP ax
        RET

;######################################

_WAIT:  or ax,ax        ; Wait for a certain input pattern (0=skip)
        jz wdont        ; mask AH, target AL, port DX
        PUSH bx		; timeout defined by TIMEOUT, WAITGFX, WAITBIT
        PUSH bp
        mov bx,ax
        mov bp,TIMEOUT
wretry: in al,dx
        and al,bh       ; Mask
        cmp al,bl       ; Comp
        jz wok          ; Zero
	; <<< check for timeout...
        PUSH dx
        mov dx,61h      ; default port 61h, bit at 10h
%ifdef  WAITGFX         ; ********
        mov dx,[cs:crtport]
        add dx,6	; alternate port GFX+6, bit at 8 or 1
%endif                  ; ********
wtlp:   in al,dx
        test al,WAITBIT
        jnz wtlp
wtlp2:  in al,dx        ;  0->1 in (port(61h) and 10h)
        test al,WAITBIT
        jz wtlp2
        POP dx  
	; <<< ... checked for timeout
        dec bp  
        jnz wretry
werr:   or sp,sp        ; Not Zero
wok:    POP bp
        POP bx
wdont:  RET   

