{
* gtkquizchooser
* Copyright (c) 2005 Andreas K. Foerster <akfquiz@akfoerster.de>
*
* Environment: FreePascal + GTK (1.2 or 2.0)
*
* This file is part of AKFQuiz
*
* AKFQuiz is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* AKFQuiz is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA
*}

{$IfDef GTK1}
  {$UnDef GTK2}
{$EndIf}

{$IfDef FPC}
  {$Mode Delphi}
  {$LongStrings on}
{$EndIf}

program gtkquizchooser;
uses uakfquiz, qsys, SysUtils, unix, 
{$IfDef GTK2}
  glib2,gdk2,gtk2;
{$Else}
  glib,gdk,gtk; { GTK 1 - faster, smaller }
{$EndIf}

var 
  wChooser: PGtkWidget;
  QuizFile,
  QuizPrg,
  PrgDir : myString;

var allowNewQuiz: boolean = false;

{$I template.inc}

procedure help;
begin
WriteLn(stderr, 'syntax:');
WriteLn(stderr, '  gtkquizchooser [options] program');
WriteLn(stderr);
WriteLn(stderr, 'options:');
WriteLn(stderr, '-d <dir>    starting directory (overrides QUIZPATH)');
WriteLn(stderr, '-n | --new  allow new files (for use with an editor)');
WriteLn(stderr, '            a new file will be created with a template');
WriteLn(stderr);
WriteLn(stderr, 'and GTK options supported');
WriteLn(stderr);
Halt
end;

procedure createQuiz(QuizFile: string);
var o: text;
begin
Assign(o, QuizFile);
Rewrite(o);
if pos('de', getsystemlanguage)=1
   then WriteLn(o, template_de)
   else WriteLn(o, template_en);
close(o);
end;

procedure fileSelected(w: PGtkWidget; fs: PGtkFileSelection); cdecl;
var s: mystring;
begin
s := gtk_file_selection_get_filename(GTK_FILE_SELECTION(fs));
QuizFile := s;
if getQuizFile(QuizFile) 
  then begin gtk_widget_hide(wChooser); gtk_main_quit end { found }
  else if allowNewQuiz and not DirectoryExists(s)
          then begin { new quiz }
	       QuizFile := s; { it was reset by getQuizFile }
	       if pos('.', QuizFile)=0 
	          then QuizFile := Quizfile + quizext; { add extension }
	       gtk_widget_hide(wChooser); 
	       gtk_main_quit 
	       end
          else QuizFile := '' { invalid entry }
end;

procedure destroy(widget:PGtkWidget; data: gPointer); cdecl;
begin
gtk_widget_hide(wChooser);
gtk_main_quit 
end;

procedure applyQuizPath;
var p : mystring;
begin
p := getquizpath;
if p='' then 
  p := ExpandFileName(
     PrgDir+'..'+DirectorySeparator+'share'+DirectorySeparator+'akfquiz');

gtk_file_selection_set_filename(GTK_FILE_SELECTION(wChooser), 
                             pGchar(IncludeTrailingPathDelimiter(p)));
end;

procedure setActiveDir;
begin
PrgDir := ExpandFileName(ExtractFilePath(ParamStr(0)));
chdir(PrgDir)
end;

procedure handleParameters;
var 
  i: integer;
  s: mystring;
begin
if ParamCount=0 then help;

s := '';
i := 0;
repeat
  inc(i);
  s := ParamStr(i);
  if (s='-h') or (s='--help') or (s='/?') then help;
  if (s='-d') or (s='-D') then begin inc(i); continue end;
  if (s='-n') or (s='--new') then allowNewQuiz := true;
until (s[1]<>'-') or (i>=ParamCount);

if s[1]='-' then help;

QuizPrg := s;
while i<ParamCount do
  begin
  inc(i);
  s := ParamStr(i);
  QuizPrg := QuizPrg + ' ' + s
  end;
end;

begin
QuizFile := '';
QuizPrg := '';
handleParameters;

setActiveDir;

gtk_init(@argc, @argv);

{ Create a new file selection widget }
wChooser := gtk_file_selection_new(AKFQuizName+' '+AKFQuizVersion);

gtk_signal_connect(GTK_OBJECT(wChooser), 'destroy',
                   GTK_SIGNAL_FUNC(@destroy), @wChooser);

{ Connect the ok_button to file_ok_sel function }
gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(wChooser)^.ok_button),
                   'clicked', GTK_SIGNAL_FUNC(@fileSelected), wChooser);

{ Connect the cancel_button to destroy the widget }
gtk_signal_connect_object(
             GTK_OBJECT(GTK_FILE_SELECTION(wChooser)^.cancel_button),
             'clicked', GTK_SIGNAL_FUNC(@gtk_widget_destroy),
              GTK_OBJECT(wChooser));

applyQuizPath;

gtk_widget_show(wChooser);
gtk_main;

if QuizFile<>'' then 
   begin
   if not FileExists(QuizFile) then createQuiz(QuizFile);
   Shell(QuizPrg + ' ' + QuizFile)
   end
end.
