
VERSION=4.1.1
SVERSION=411
ARCH=x86

#####################################################################
# change here:
#####################################################################

# Language for Manpages:
LANGUAGE=deutsch

PREFIX   = /usr/local
BINDIR   = $(PREFIX)/bin
DOCDIR   = $(PREFIX)/share/doc/akfquiz
GETQUIZ  = $(BINDIR)/getquiz
QUIZPATH = $(PREFIX)/share/akfquiz
HTMLPATH = $(QUIZPATH)/html

CGIPATH  = /usr/lib/cgi-bin

MANPATH = $(PREFIX)/man
#MANPATH = $(PREFIX)/share/man
MAN1DIR = $(MANPATH)/man1
MAN5DIR = $(MANPATH)/man5
MAN8DIR = $(MANPATH)/man8

# compiled with GPC, renamed and the rest compiled with FPC
#EXTRAS = xgrquiz ncrtquiz

######################################################################

# all is for Unix
all: mkquiz crtquiz akfquiz.cgi diaquiz linequiz grquiz gtkquizchooser

# using FreePascal and DJGPP
dos: mkquiz crtquiz linequiz grquiz
	ln -s -f grquiz akfquiz

pkg-dos: clean
	move *.exe ..\..\bin
	cd ..\..
	-zip -9vr aqz$(SVERSION)-b.zip bin doc share
	-zip -9vr aqz$(SVERSION)-s.zip source

# I'm using MSYS
windows: windowsresources wquizchooser mkquiz crtquiz linequiz cgiquiz grquiz
	mv -f cgiquiz.exe akfquiz.cgi

# MSYS & InnoSetup
pkg-windows: clean
	iscc akfquiz.iss

doc:
	make -C ../doc 

mkquiz: mkquiz.pas qsys.pas qmsgs.pas uakfquiz.pas
	$(PC) $(PFLAGS) $(POPT) $(DEFINES) mkquiz.pas

crtquiz: crtquiz.pas qsys.pas qmsgs.pas uakfquiz.pas
	$(PC) $(PFLAGS) $(POPT) $(DEFINES) crtquiz.pas

linequiz: linequiz.pas qsys.pas qmsgs.pas uakfquiz.pas
	$(PC) $(PFLAGS) $(POPT) $(DEFINES) linequiz.pas

cgiquiz: cgiquiz.pas uakfquiz.pas qmsgs.pas qsys.pas
	$(PC) $(PFLAGS) $(POPT) $(DEFINES) cgiquiz.pas

akfquiz.cgi: cgiquiz.pas uakfquiz.pas qmsgs.pas qsys.pas
	$(PC) $(PFLAGS) $(POPT) $(DEFINES) cgiquiz.pas
	-mv -f cgiquiz akfquiz.cgi

quizhg.o: quizhg.ppm
	binobj quizhg.ppm quizhg.o AKFQuizHg

grquiz: grquiz.pas qsys.pas qmsgs.pas uakfquiz.pas clgrph.pas \
        sdlgrph.pas $(IMAGEFILES) lat9.inc
	-$(PC) $(PFLAGS) $(POPT) $(DEFINES) $(GUIFLAG) grquiz.pas

diaquiz: diaquiz.pas qsys.pas qmsgs.pas uakfquiz.pas dialog.pas
	$(PC) $(PFLAGS) $(POPT) $(DEFINES) diaquiz.pas

# just for Unix, just FPC
gtkquizchooser: gtkquizchooser.pas
	$(PC) $(PFLAGS) $(POPT) $(DEFINES) $(GUIFLAG) gtkquizchooser.pas

# just for Windows, just FPC
wquizchooser: wquizchooser.pas
	$(PC) $(PFLAGS) $(POPT) $(DEFINES) $(GUIFLAG) wquizchooser.pas

# just for Windows
windowsresources:
	windres -i wquizchooser.rc -o wquizchooser.res
	windres -i mkquiz.rc -o mkquiz.res
	windres -i crtquiz.rc -o crtquiz.res
	windres -i linequiz.rc -o linequiz.res
	windres -i cgiquiz.rc -o cgiquiz.res
	windres -i grquiz.rc -o grquiz.res

clean:
	-rm -f *.o *.or *.a a.out *.gpi *.gpm *.ppu *.old *~
	-rm -f ../ports/w32stuff/*.old
	-rm -f *.aw *.ow *.owr *.ppw *.res
	-rm -f *.AW *.OW *.OWR *.PPW *.RES

distclean: clean
	-rm -f mkquiz crtquiz cgiquiz akfquiz.cgi diaquiz linequiz \
	       grquiz gtkquizchooser
	-rm -f $(EXTRAS)
	-rm -f *.exe

new: distclean

# just for Unix
install: all
	@echo "*"
	@echo "* creating directories"
	@echo "*"
	test -d $(BINDIR)   || install -d $(BINDIR)
	test -d $(DOCDIR)   || install -d $(DOCDIR)
	test -d $(MAN1DIR)  || install -d $(MAN1DIR)
	test -d $(MAN5DIR)  || install -d $(MAN5DIR)
	test -d $(MAN8DIR)  || install -d $(MAN8DIR)
	test -d $(QUIZPATH) || install -d -m 1777 $(QUIZPATH)
	test -d $(HTMLPATH) || install -d $(HTMLPATH)
	@echo "*"
	@echo "* installing programs"
	@echo "*"
	install -m 0755 -s mkquiz $(BINDIR)
	install -m 0755 -s crtquiz $(BINDIR)
	install -m 0755 -s diaquiz $(BINDIR)
	install -m 0755 -s linequiz $(BINDIR)
	-install -m 0755 -s grquiz $(BINDIR)
	#-install -o root -m 4755 -s grquiz $(BINDIR)
	-install -m 0755 gtkquizchooser $(BINDIR)
	-test -n "$(EXTRAS)" && install -m 0755 -s $(EXTRAS) $(BINDIR)
	install -m 0755 akfquiz $(BINDIR)
	install -m 0755 quizstat $(BINDIR)
	@echo "*"
	@echo "* installing manpages"
	@echo "*"
	install -m 0644 ../doc/$(LANGUAGE)/mkquiz.1 $(MAN1DIR)
	install -m 0644 ../doc/$(LANGUAGE)/crtquiz.1 $(MAN1DIR)
	install -m 0644 ../doc/$(LANGUAGE)/grquiz.1 $(MAN1DIR)
	install -m 0644 ../doc/$(LANGUAGE)/linequiz.1 $(MAN1DIR)
	install -m 0644 ../doc/$(LANGUAGE)/gtkquizchooser.1 $(MAN1DIR)
	install -m 0644 ../doc/$(LANGUAGE)/akfquiz.cgi.8 $(MAN8DIR)
	install -m 0644 ../doc/$(LANGUAGE)/akfquiz.5 $(MAN5DIR)
	@echo "*"
	@echo "* installing documentation"
	@echo "*"
	install -m 0644 ../doc/COPYING $(DOCDIR)
	install -m 0644 ../doc/deutsch/COPYING.de $(DOCDIR)
	install -m 0644 ../doc/CHANGELOG $(DOCDIR)
	install -m 0644 ../doc/FAQ.html $(DOCDIR)
	install -m 0644 ../doc/TODO $(DOCDIR)
	install -m 0644 ../doc/english/template $(DOCDIR)/template-en
	install -m 0644 ../doc/deutsch/template $(DOCDIR)/template-de
	install -m 0644 ../doc/english/INSTALL $(DOCDIR)/INSTALL-en
	install -m 0644 ../doc/deutsch/INSTALL $(DOCDIR)/INSTALL-de
	@echo "*"
	@echo "* installing example quiz-files to $(QUIZPATH)"
	@echo "*"
	install -m 0644 ../quiz/*.akfquiz $(QUIZPATH)
	@echo "*"
	@echo "* installing files needed for HTML to $(HTMLPATH)"
	@echo "*"
	install -m 0755 -d $(HTMLPATH)
	install -m 0644 ../html/*.js ../html/*.png ../html/*.css $(HTMLPATH)
	install -m 0644 ../html/schulnote.html $(HTMLPATH)
	@echo "*"
	@echo "* creating getquiz"
	@echo "*"
	echo >  $(GETQUIZ) "#!/bin/sh"
	echo >> $(GETQUIZ) "cp -i $(HTMLPATH)/* ."
	chmod 755 $(GETQUIZ)
	@echo "*"
	@echo "* HINT: install the CGI program with 'make install-cgi'"
	@echo "* the CGI-path ist configured to $(CGIPATH)"
	@echo "*"

install-cgi: akfquiz.cgi
	install -d $(CGIPATH)
	install -m 0755 -s akfquiz.cgi $(CGIPATH)

# searches for Quizfiles and installs them as programs
# just for Unix
install-quizzes:
	for quiz in ../quiz/*.akfquiz; \
	  do \
	  TARGET=$(BINDIR)/$$(basename $$quiz .akfquiz); \
	  echo '#! /usr/bin/env akfquiz' > $$TARGET; \
	  echo >> $$TARGET; \
	  cat $$quiz >> $$TARGET; \
	  chmod 755 $$TARGET; \
	  echo "$$TARGET installed"; \
	done

# just for Unix
uninstall:
	-rm $(BINDIR)/mkquiz
	-rm $(BINDIR)/crtquiz
	-rm $(BINDIR)/linequiz
	-rm $(BINDIR)/diaquiz
	-rm $(BINDIR)/grquiz
	-rm $(BINDIR)/quizstat
	-rm $(BINDIR)/gtkquizchooser
	-rm -f $(BINDIR)/xgrquiz
	-rm -f $(BINDIR)/ncrtquiz
	-rm $(GETQUIZ)
	-rm $(BINDIR)/akfquiz
	-rm $(MAN1DIR)/mkquiz.1
	-rm $(MAN1DIR)/crtquiz.1
	-rm $(MAN1DIR)/grquiz.1
	-rm $(MAN1DIR)/linequiz.1
	-rm $(MAN1DIR)/gtkquizchooser.1
	-rm $(MAN8DIR)/akfquiz.cgi.8
	-rm $(MAN5DIR)/akfquiz.5
	-rm -r $(HTMLPATH)
	-rm -r $(QUIZPATH)
	-rm -r $(DOCDIR)

pkg: distclean
	tar czvCf ../.. \
	  ../akfquiz-$(VERSION).main.tar.gz \
	      akfquiz/start \
	      akfquiz/configure \
	      akfquiz/Makefile \
	      akfquiz/autopackage/ \
	      akfquiz/quiz/ \
	      akfquiz/doc/ \
	      akfquiz/html/ \
	      akfquiz/srcbin/


pkg-bin: mkquiz crtquiz linequiz akfquiz.cgi diaquiz akfquiz grquiz
	-tar czvCf ../.. \
	  ../akfquiz-$(VERSION).bin.$$(uname -s).$(ARCH).tar.gz \
	      akfquiz/doc/COPYING \
	      akfquiz/srcbin/mkquiz \
	      akfquiz/srcbin/crtquiz \
	      akfquiz/srcbin/akfquiz.cgi \
	      akfquiz/srcbin/diaquiz \
	      akfquiz/srcbin/linequiz \
	      akfquiz/srcbin/grquiz \
	      akfquiz/srcbin/gtkquizchooser \
	      akfquiz/srcbin/akfquiz

pkg-xbin: mkquiz crtquiz linequiz akfquiz.cgi diaquiz akfquiz grquiz
	-tar czvCf ../.. \
	  ../akfquiz-$(VERSION).bin.$$(uname -s).$(ARCH).tar.gz \
	      akfquiz/doc/COPYING \
	      akfquiz/srcbin/mkquiz \
	      akfquiz/srcbin/crtquiz \
	      akfquiz/srcbin/akfquiz.cgi \
	      akfquiz/srcbin/diaquiz \
	      akfquiz/srcbin/linequiz \
	      akfquiz/srcbin/grquiz \
	      akfquiz/srcbin/xgrquiz \
	      akfquiz/srcbin/ncrtquiz \
	      akfquiz/srcbin/gtkquizchooser \
	      akfquiz/srcbin/akfquiz

# End
