#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "supereq.h"
#include "paramlist.hpp"

typedef float REAL;
void rfft(int n,int isign,REAL x[]);

#define M 15
#define PI 3.1415926535897932384626433832795
#define RINT(x) ((x) >= 0 ? ((int)((x) + 0.5)) : ((int)((x) - 0.5)))
//#define EQU_ENABLE_DITHER 1
#define DITHERLEN 65536
#define NCH 2
#define MAXBANDS 20

static REAL fact[M+1];
static REAL aa = 96;
static REAL iza;

typedef struct equ_data_s{
 REAL *lires,*lires1,*lires2,*rires,*rires1,*rires2,*irest;
 REAL *fsamples;
 int chg_ires,cur_ires;
 int winlen,tabsize,nbufsamples;
 short *inbuf;
 REAL *outbuf;
 int enable,NBANDS;
#ifdef EQU_ENABLE_DITHER
 REAL *ditherbuf;
 int ditherptr;
 int dither;
 float hm1;
#endif
 REAL bands[MAXBANDS];
 paramlist paramroot;
}equ_data_s;

static REAL equbands[MAXBANDS] = {
  65.406392,92.498606,130.81278,184.99721,261.62557,369.99442,523.25113,
  739.9884 ,1046.5023,1479.9768,2093.0045,2959.9536,4186.0091,5919.9072,
  8372.0181,11839.814,16744.036,
  20000.0,20100.0,20200.0
};

static REAL alpha(REAL a)
{
  if (a <= 21) return 0;
  if (a <= 50) return 0.5842*pow(a-21,0.4)+0.07886*(a-21);
  return 0.1102*(a-8.7);
}

static REAL izero(REAL x)
{
  REAL ret = 1;
  int m;

  for(m=1;m<=M;m++)
    {
      REAL t;
      t = pow(x/2,m)/fact[m];
      ret += t*t;
    }

  return ret;
}

void *equ_init(int wb, int nb_bands, long bandcfg[])
{
  struct equ_data_s *eqd;
  int i,j;

  eqd=(struct equ_data_s *)calloc(1,sizeof(*eqd));
  if(!eqd)
   return eqd;

  memcpy(eqd->bands,equbands,MAXBANDS*sizeof(eqd->bands[0]));

  if(nb_bands){
   if(nb_bands>MAXBANDS)
    nb_bands=MAXBANDS;
   eqd->NBANDS=nb_bands;
   for(i=0;i<nb_bands;i++)
    eqd->bands[i]=(REAL)bandcfg[i];
  }else
   eqd->NBANDS=17;

  //eqd->winlen  = (1 << (wb-1));
  eqd->winlen  = (1 << (wb-1))-1; // ???
  eqd->tabsize = 1 << wb;

  eqd->lires1   = (REAL *)malloc(sizeof(REAL)*eqd->tabsize);
  eqd->lires2   = (REAL *)malloc(sizeof(REAL)*eqd->tabsize);
  eqd->rires1   = (REAL *)malloc(sizeof(REAL)*eqd->tabsize);
  eqd->rires2   = (REAL *)malloc(sizeof(REAL)*eqd->tabsize);
  eqd->irest    = (REAL *)malloc(sizeof(REAL)*eqd->tabsize);
  eqd->fsamples = (REAL *)malloc(sizeof(REAL)*eqd->tabsize);
  eqd->inbuf    = (short *)calloc(eqd->winlen*NCH,sizeof(int));
  eqd->outbuf   = (REAL *)calloc(eqd->tabsize*NCH,sizeof(REAL));
  if(!eqd->lires1 || !eqd->lires2 || !eqd->rires1 || !eqd->rires2
   || !eqd->irest || !eqd->fsamples || !eqd->inbuf || !eqd->outbuf)
   goto err_out_init;

  eqd->lires = eqd->lires1;
  eqd->rires = eqd->rires1;
  eqd->cur_ires = 1;
  eqd->chg_ires = 1;
  eqd->enable = 1;

#ifdef EQU_ENABLE_DITHER
  eqd->ditherbuf= (REAL *)malloc(sizeof(REAL)*DITHERLEN);
  if(!eqd->ditherbuf)
   goto err_out_init;
  for(i=0;i<DITHERLEN;i++)
   eqd->ditherbuf[i] = (float(rand())/RAND_MAX-0.5);
#endif

  for(i=0;i<=M;i++){
   fact[i] = 1;
   for(j=1;j<=i;j++)
    fact[i] *= j;
  }

  iza = izero(alpha(aa));

  return (void *)eqd;

err_out_init:
 equ_quit(eqd);
 return NULL;
}

// -(N-1)/2 <= n <= (N-1)/2
static REAL win(REAL n,int N)
{
  return izero(alpha(aa)*sqrt(1-4*n*n/((N-1)*(N-1))))/iza;
}

static REAL sinc(REAL x)
{
  return x == 0 ? 1 : sin(x)/x;
}

static REAL hn_lpf(int n,REAL f,REAL fs)
{
  REAL t = 1/fs;
  REAL omega = 2*PI*f;
  return 2*f*t*sinc(n*omega*t);
}

static REAL hn_imp(int n)
{
  return n == 0 ? 1.0 : 0.0;
}

static REAL hn(int n,paramlist &param2,REAL fs)
{
  paramlistelm *e;
  REAL ret,lhn;

  lhn = hn_lpf(n,param2.elm->upper,fs);
  ret = param2.elm->gain*lhn;

  for(e=param2.elm->next;e->next != NULL && e->upper < fs/2;e = e->next)
    {
      REAL lhn2 = hn_lpf(n,e->upper,fs);
      ret += e->gain*(lhn2-lhn);
      lhn = lhn2;
    }

  ret += e->gain*(hn_imp(n)-lhn);

  return ret;
}

static void process_param(struct equ_data_s *eqd,float *bc,paramlist *param,paramlist &param2,float fs,int ch)
{
  paramlistelm **pp,*p,*e,*e2;
  int i;

  delete param2.elm;
  param2.elm = NULL;

  for(i=0,pp=&param2.elm;i<=eqd->NBANDS;i++,pp = &(*pp)->next)
  {
    (*pp) = new paramlistelm;
	(*pp)->lower = i == 0        ?  0 : eqd->bands[i-1];
	(*pp)->upper = i == eqd->NBANDS-1 ? fs : eqd->bands[i  ];
	(*pp)->gain  = bc[i];
  }

  for(e = param->elm;e != NULL;e = e->next)
  {
	if ((ch == 0 && !e->left) || (ch == 1 && !e->right)) continue;
	if (e->lower >= e->upper) continue;

	for(p=param2.elm;p != NULL;p = p->next)
		if (p->upper > e->lower) break;

	while(p != NULL && p->lower < e->upper)
	{
		if (e->lower <= p->lower && p->upper <= e->upper) {
			p->gain *= pow(10,e->gain/20);
			p = p->next;
			continue;
		}
		if (p->lower < e->lower && e->upper < p->upper) {
			e2 = new paramlistelm;
			e2->lower = e->upper;
			e2->upper = p->upper;
			e2->gain  = p->gain;
			e2->next  = p->next;
			p->next   = e2;

			e2 = new paramlistelm;
			e2->lower = e->lower;
			e2->upper = e->upper;
			e2->gain  = p->gain * pow(10,e->gain/20);
			e2->next  = p->next;
			p->next   = e2;

			p->upper  = e->lower;

			p = p->next->next->next;
			continue;
		}
		if (p->lower < e->lower) {
			e2 = new paramlistelm;
			e2->lower = e->lower;
			e2->upper = p->upper;
			e2->gain  = p->gain * pow(10,e->gain/20);
			e2->next  = p->next;
			p->next   = e2;

			p->upper  = e->lower;
			p = p->next->next;
			continue;
		}
		if (e->upper < p->upper) {
			e2 = new paramlistelm;
			e2->lower = e->upper;
			e2->upper = p->upper;
			e2->gain  = p->gain;
			e2->next  = p->next;
			p->next   = e2;

			p->upper  = e->upper;
			p->gain   = p->gain * pow(10,e->gain/20);
			p = p->next->next;
			continue;
		}
                return;
	}
  }
}

void equ_makeTable(void *eqd_p,float *lbc,float *rbc,float fs)
{
  struct equ_data_s *eqd=(struct equ_data_s *)eqd_p;
  int i,cires;
  REAL *nires;
  paramlist param2;

  if (!eqd) return;
  if (fs <= 0) return;

  cires=eqd->cur_ires;

  // L

  process_param(eqd,lbc,&eqd->paramroot,param2,fs,0);

  for(i=0;i<eqd->winlen;i++)
    eqd->irest[i] = hn(i-eqd->winlen/2,param2,fs)*win(i-eqd->winlen/2,eqd->winlen);

  for(;i<eqd->tabsize;i++)
    eqd->irest[i] = 0;

  rfft(eqd->tabsize,1,eqd->irest);

  nires = (cires==1)? eqd->lires2 : eqd->lires1;

  for(i=0;i<eqd->tabsize;i++)
    nires[i] = eqd->irest[i];

  process_param(eqd,rbc,&eqd->paramroot,param2,fs,1);

  // R

  for(i=0;i<eqd->winlen;i++)
    eqd->irest[i] = hn(i-eqd->winlen/2,param2,fs)*win(i-eqd->winlen/2,eqd->winlen);

  for(;i<eqd->tabsize;i++)
    eqd->irest[i] = 0;

  rfft(eqd->tabsize,1,eqd->irest);

  nires = cires == 1 ? eqd->rires2 : eqd->rires1;

  for(i=0;i<eqd->tabsize;i++)
    nires[i] = eqd->irest[i];

  //

  eqd->chg_ires = (cires==1)? 2 : 1;
}

void equ_quit(void *eqd_p)
{
 struct equ_data_s *eqd=(struct equ_data_s *)eqd_p;
 if(eqd){
  if(eqd->lires1)   free(eqd->lires1);
  if(eqd->lires2)   free(eqd->lires2);
  if(eqd->rires1)   free(eqd->rires1);
  if(eqd->rires2)   free(eqd->rires2);
  if(eqd->irest)    free(eqd->irest);
  if(eqd->fsamples) free(eqd->fsamples);
  if(eqd->inbuf)    free(eqd->inbuf);
  if(eqd->outbuf)   free(eqd->outbuf);
#ifdef EQU_ENABLE_DITHER
  if(eqd->ditherbuf) free(eqd->ditherbuf);
#endif
  free(eqd);
 }
 rfft(0,0,NULL);
}

void equ_clearbuf(void *eqd_p,int bps,int srate)
{
  struct equ_data_s *eqd=(struct equ_data_s *)eqd_p;
  int i;

  if(!eqd)
   return;

  eqd->nbufsamples = 0;
  for(i=0;i<eqd->tabsize*NCH;i++)
   eqd->outbuf[i] = 0;

  //memset(eqd->fsamples,0,sizeof(REAL)*eqd->tabsize);
  //memset(eqd->inbuf ,0,eqd->winlen*NCH*sizeof(int));
  //memset(eqd->outbuf,0,eqd->tabsize*NCH*sizeof(REAL));

  //eqd->cur_ires = 1;
  //eqd->chg_ires = 1;
}

/*
int equ_modifySamples(void *eqd_p,char *buf,int nsamples,int nch,int bps)
{
  struct equ_data_s *eqd=(struct equ_data_s *)eqd_p;
  int i,p,ch;
  REAL *ires;
  int amax =  ((long)1 << (bps-1))-1;
  int amin = -((long)1 << (bps-1));

  if(!eqd)
   return 0;

  if (eqd->chg_ires) {
	  eqd->cur_ires = eqd->chg_ires;
	  eqd->lires = eqd->cur_ires == 1 ? eqd->lires1 : eqd->lires2;
	  eqd->rires = eqd->cur_ires == 1 ? eqd->rires1 : eqd->rires2;
	  eqd->chg_ires = 0;
  }

  p = 0;

  while(eqd->nbufsamples+nsamples >= eqd->winlen)
    {
	  switch(bps)
	  {
	  case 8:
		for(i=0;i<(eqd->winlen-eqd->nbufsamples)*nch;i++)
			{
				eqd->inbuf[eqd->nbufsamples*nch+i] = ((unsigned char *)buf)[i+p*nch] - 0x80;
				float s = eqd->outbuf[eqd->nbufsamples*nch+i];
#ifdef EQU_ENABLE_DITHER
				if (eqd->dither) {
					float u;
					s -= eqd->hm1;
					u = s;
					s += eqd->ditherbuf[(eqd->ditherptr++) & (DITHERLEN-1)];
					if (s < amin) s = amin;
					if (amax < s) s = amax;
					s = RINT(s);
					eqd->hm1 = s - u;
					((unsigned char *)buf)[i+p*nch] = s + 0x80;
				} else
#endif
                                {
					if (s < amin) s = amin;
					if (amax < s) s = amax;
					((unsigned char *)buf)[i+p*nch] = RINT(s) + 0x80;
				}
			}
		for(i=eqd->winlen*nch;i<eqd->tabsize*nch;i++)
			eqd->outbuf[i-eqd->winlen*nch] = eqd->outbuf[i];

		break;

	  case 16:
		for(i=0;i<(eqd->winlen-eqd->nbufsamples)*nch;i++)
			{
				eqd->inbuf[eqd->nbufsamples*nch+i] = ((short *)buf)[i+p*nch];
				float s = eqd->outbuf[eqd->nbufsamples*nch+i];
#ifdef EQU_ENABLE_DITHER
				if (eqd->dither) {
					float u;
					s -= eqd->hm1;
					u = s;
					s += eqd->ditherbuf[(eqd->ditherptr++) & (DITHERLEN-1)];
					if (s < amin) s = amin;
					if (amax < s) s = amax;
					s = RINT(s);
					eqd->hm1 = s - u;
					((short *)buf)[i+p*nch] = s;
				} else
#endif
                                {
					if (s < amin) s = amin;
					if (amax < s) s = amax;
					((short *)buf)[i+p*nch] = RINT(s);
				}
			}
		for(i=eqd->winlen*nch;i<eqd->tabsize*nch;i++)
			eqd->outbuf[i-eqd->winlen*nch] = eqd->outbuf[i];

		break;

	  case 24:
		for(i=0;i<(eqd->winlen-eqd->nbufsamples)*nch;i++)
			{
				((int *)eqd->inbuf)[eqd->nbufsamples*nch+i] =
					(((unsigned char *)buf)[(i+p*nch)*3  ]      ) +
					(((unsigned char *)buf)[(i+p*nch)*3+1] <<  8) +
					(((  signed char *)buf)[(i+p*nch)*3+2] << 16) ;

				float s = eqd->outbuf[eqd->nbufsamples*nch+i];
#ifdef EQU_ENABLE_DITHER
				//if (eqd->dither) s += eqd->ditherbuf[(eqd->ditherptr++) & (DITHERLEN-1)];
#endif
				if (s < amin) s = amin;
				if (amax < s) s = amax;
				int s2 = RINT(s);
				((signed char *)buf)[(i+p*nch)*3  ] = s2 & 255; s2 >>= 8;
				((signed char *)buf)[(i+p*nch)*3+1] = s2 & 255; s2 >>= 8;
				((signed char *)buf)[(i+p*nch)*3+2] = s2 & 255;
			}
		for(i=eqd->winlen*nch;i<eqd->tabsize*nch;i++)
			eqd->outbuf[i-eqd->winlen*nch] = eqd->outbuf[i];

		break;

	  default:
                return 0;
	  }

      p += eqd->winlen-eqd->nbufsamples;
      nsamples -= eqd->winlen-eqd->nbufsamples;
      eqd->nbufsamples = 0;

      for(ch=0;ch<nch;ch++)
		{
			ires = ch == 0 ? eqd->lires : eqd->rires;

			if (bps == 24) {
				for(i=0;i<eqd->winlen;i++)
					eqd->fsamples[i] = ((int *)eqd->inbuf)[nch*i+ch];
			} else {
				for(i=0;i<eqd->winlen;i++)
					eqd->fsamples[i] = eqd->inbuf[nch*i+ch];
			}

			for(i=eqd->winlen;i<eqd->tabsize;i++)
				eqd->fsamples[i] = 0;

			if (eqd->enable) {
				rfft(eqd->tabsize,1,eqd->fsamples);

				eqd->fsamples[0] = ires[0]*eqd->fsamples[0];
				eqd->fsamples[1] = ires[1]*eqd->fsamples[1];
			
				for(i=1;i<eqd->tabsize/2;i++)
					{
						REAL re,im;

						re = ires[i*2  ]*eqd->fsamples[i*2] - ires[i*2+1]*eqd->fsamples[i*2+1];
						im = ires[i*2+1]*eqd->fsamples[i*2] + ires[i*2  ]*eqd->fsamples[i*2+1];

						eqd->fsamples[i*2  ] = re;
						eqd->fsamples[i*2+1] = im;
					}

				rfft(eqd->tabsize,-1,eqd->fsamples);
			} else {
				for(i=eqd->winlen-1+eqd->winlen/2;i>=eqd->winlen/2;i--) eqd->fsamples[i] = eqd->fsamples[i-eqd->winlen/2]*eqd->tabsize/2;
				for(;i>=0;i--) eqd->fsamples[i] = 0;
			}

			for(i=0;i<eqd->winlen;i++) eqd->outbuf[i*nch+ch] += eqd->fsamples[i]/eqd->tabsize*2;

			for(i=eqd->winlen;i<eqd->tabsize;i++) eqd->outbuf[i*nch+ch] = eqd->fsamples[i]/eqd->tabsize*2;
		}
    }

	switch(bps)
	  {
	  case 8:
		for(i=0;i<nsamples*nch;i++)
			{
				eqd->inbuf[eqd->nbufsamples*nch+i] = ((unsigned char *)buf)[i+p*nch] - 0x80;
				float s = eqd->outbuf[eqd->nbufsamples*nch+i];
#ifdef EQU_ENABLE_DITHER
				if (eqd->dither) {
					float u;
					s -= eqd->hm1;
					u = s;
					s += eqd->ditherbuf[(eqd->ditherptr++) & (DITHERLEN-1)];
					if (s < amin) s = amin;
					if (amax < s) s = amax;
					s = RINT(s);
					eqd->hm1 = s - u;
					((unsigned char *)buf)[i+p*nch] = s + 0x80;
				} else
#endif
                                {
					if (s < amin) s = amin;
					if (amax < s) s = amax;
					((unsigned char *)buf)[i+p*nch] = RINT(s) + 0x80;
				}
			}
		break;

	  case 16:
		for(i=0;i<nsamples*nch;i++)
			{
				eqd->inbuf[eqd->nbufsamples*nch+i] = ((short *)buf)[i+p*nch];
				float s = eqd->outbuf[eqd->nbufsamples*nch+i];
#ifdef EQU_ENABLE_DITHER
				if (eqd->dither) {
					float u;
					s -= eqd->hm1;
					u = s;
					s += eqd->ditherbuf[(eqd->ditherptr++) & (DITHERLEN-1)];
					if (s < amin) s = amin;
					if (amax < s) s = amax;
					s = RINT(s);
					eqd->hm1 = s - u;
					((short *)buf)[i+p*nch] = s;
				} else
#endif
                                {
					if (s < amin) s = amin;
					if (amax < s) s = amax;
					((short *)buf)[i+p*nch] = RINT(s);
				}
			}
		break;

	  case 24:
		for(i=0;i<nsamples*nch;i++)
			{
				((int *)eqd->inbuf)[eqd->nbufsamples*nch+i] =
					(((unsigned char *)buf)[(i+p*nch)*3  ]      ) +
					(((unsigned char *)buf)[(i+p*nch)*3+1] <<  8) +
					(((  signed char *)buf)[(i+p*nch)*3+2] << 16) ;

				float s = eqd->outbuf[eqd->nbufsamples*nch+i];
#ifdef EQU_ENABLE_DITHER
				//if (eqd->dither) s += eqd->ditherbuf[(eqd->ditherptr++) & (DITHERLEN-1)];
#endif
				if (s < amin) s = amin;
				if (amax < s) s = amax;
				int s2 = RINT(s);
				((signed char *)buf)[(i+p*nch)*3  ] = s2 & 255; s2 >>= 8;
				((signed char *)buf)[(i+p*nch)*3+1] = s2 & 255; s2 >>= 8;
				((signed char *)buf)[(i+p*nch)*3+2] = s2 & 255;
			}
		break;

	  default:
                return 0;
	}

  p += nsamples;
  eqd->nbufsamples += nsamples;

  return p;
}
*/

int equ_modifysamples_float(void *eqd_p,float *buf,int nsamples,int nch)
{
 struct equ_data_s *eqd=(struct equ_data_s *)eqd_p;
 int i,p,ch;
 REAL *ires;

 if(!eqd)
  return 0;

 if(eqd->chg_ires){
  eqd->cur_ires = eqd->chg_ires;
  eqd->lires = (eqd->cur_ires==1) ? eqd->lires1 : eqd->lires2;
  eqd->rires = (eqd->cur_ires==1) ? eqd->rires1 : eqd->rires2;
  eqd->chg_ires = 0;
 }

 p = 0;

 while(eqd->nbufsamples+nsamples >= eqd->winlen){
  for(i=0;i<(eqd->winlen-eqd->nbufsamples)*nch;i++){
   ((float *)eqd->inbuf)[eqd->nbufsamples*nch+i] = ((float *)buf)[i+p*nch];
   ((float *)buf)[i+p*nch] = eqd->outbuf[eqd->nbufsamples*nch+i];
  }
  for(i=eqd->winlen*nch;i<eqd->tabsize*nch;i++)
   eqd->outbuf[i-eqd->winlen*nch] = eqd->outbuf[i];

  p += eqd->winlen-eqd->nbufsamples;
  nsamples -= eqd->winlen-eqd->nbufsamples;
  eqd->nbufsamples = 0;

  for(ch=0;ch<nch;ch++){
   ires = (ch==0)? eqd->lires : eqd->rires;

   for(i=0;i<eqd->winlen;i++)
    eqd->fsamples[i] = ((float *)eqd->inbuf)[nch*i+ch];

   for(i=eqd->winlen;i<eqd->tabsize;i++)
    eqd->fsamples[i] = 0;

   if(eqd->enable){
    rfft(eqd->tabsize,1,eqd->fsamples);

    eqd->fsamples[0] = ires[0]*eqd->fsamples[0];
    eqd->fsamples[1] = ires[1]*eqd->fsamples[1];

    for(i=1;i<eqd->tabsize/2;i++){
     REAL re,im;

     re = ires[i*2  ]*eqd->fsamples[i*2] - ires[i*2+1]*eqd->fsamples[i*2+1];
     im = ires[i*2+1]*eqd->fsamples[i*2] + ires[i*2  ]*eqd->fsamples[i*2+1];

     eqd->fsamples[i*2  ] = re;
     eqd->fsamples[i*2+1] = im;
    }

    rfft(eqd->tabsize,-1,eqd->fsamples);
   }else{
    for(i=eqd->winlen-1+eqd->winlen/2;i>=eqd->winlen/2;i--)
     eqd->fsamples[i] = eqd->fsamples[i-eqd->winlen/2]*eqd->tabsize/2;
    for(;i>=0;i--)
     eqd->fsamples[i] = 0;
   }

   for(i=0;i<eqd->winlen;i++)
    eqd->outbuf[i*nch+ch] += eqd->fsamples[i]/eqd->tabsize*2;

   for(i=eqd->winlen;i<eqd->tabsize;i++)
    eqd->outbuf[i*nch+ch] = eqd->fsamples[i]/eqd->tabsize*2;
  }
 }

 for(i=0;i<nsamples*nch;i++){
  ((float *)eqd->inbuf)[eqd->nbufsamples*nch+i] = ((float *)buf)[i+p*nch];
  ((float *)buf)[i+p*nch] = eqd->outbuf[eqd->nbufsamples*nch+i];
 }

 p += nsamples;
 eqd->nbufsamples += nsamples;

 return p;
}
