//**************************************************************************
//*                     This file is part of the                           *
//*             Ogg Vorbis encoder output DLL plug-in for                  *
//*                      Mpxplay - audio player.                           *
//*                  The source code of Mpxplay is                         *
//*        (C) copyright 1998-2005 by PDSoft (Attila Padar)                *
//*                    http://mpxplay.cjb.net                              *
//*                  email: mpxplay@freemail.hu                            *
//**************************************************************************
//*  This program is distributed in the hope that it will be useful,       *
//*  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
//*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                  *
//*  Please contact with the author (with me) if you want to use           *
//*  or modify this source.                                                *
//**************************************************************************
//UTF-8 encoding

#include <stdlib.h>

#include "utf8.h"
#include "charmaps.h"


static struct cp_map_s *utf8_targetmap;


static int pds_stricmp(char *strp1,char *strp2)
{
 char c1,c2;
 if(!strp1 || !strp1[0])
  if(strp2 && strp2[0])
   return -1;
  else
   return 0;
 if(!strp2 || !strp2[0])
  if(strp1 && strp1[0])
   return 1;
  else
   return 0;

 do{
  c1=*strp1++;
  c2=*strp2++;
  if(c1!=c2){
   if(c1>='a' && c1<='z')  // convert to uppercase
    c1-=32;                // c1-='a'-'A'
   if(c2>='a' && c2<='z')
    c2-=32;
   if(c1!=c2)
    if(c1<c2)
     return -1;
    else
     return 1;
  }
 }while(c1 && c2);
 return 0;
}

static struct cp_map_s *textconv_select_mapping(char *mapname)
{
 struct cp_map_s *targetmap;
 targetmap=&cp_maps[0];
 if(mapname){
  struct cp_map_s *mapp=targetmap;
  while(mapp->name){
   if(pds_stricmp(mapp->name,mapname)==0){
    targetmap=mapp;
    break;
   }
   mapp++;
  }
 }
 return (targetmap);
}

void utf8_init(char *mapname)
{
 utf8_targetmap=textconv_select_mapping(mapname);
}

void utf8_encode(unsigned char *dest,unsigned char *src,unsigned int buflen)
{
 unsigned int index_out=0;

 if(!dest || !src || !utf8_targetmap)
  return;

 buflen-=4;

 do{
  unsigned int c=*src++;
  unsigned int wc=(c<utf8_targetmap->begin)? c:utf8_targetmap->map[c-utf8_targetmap->begin];

  if(wc < (1<<7)){
   dest[0] = wc;
   dest+=1;
   index_out+=1;
  }
  else if(wc < (1<<11)){
   dest[0] = 0xc0 | (wc >> 6);
   dest[1] = 0x80 | (wc & 0x3f);
   dest+=2;
   index_out+=2;
  }
  else if(wc < (1<<16)){
   dest[0] = 0xe0 | (wc >> 12);
   dest[1] = 0x80 | ((wc >> 6) & 0x3f);
   dest[2] = 0x80 | (wc & 0x3f);
   dest+=3;
   index_out+=3;
  }
 }while(index_out<buflen);
 dest[0]=0;
}
