//**************************************************************************
//*                     This file is part of the                           *
//*                      Mpxplay - audio player.                           *
//*                  The source code of Mpxplay is                         *
//*        (C) copyright 1998-2007 by PDSoft (Attila Padar)                *
//*                    http://mpxplay.cjb.net                              *
//*                  email: mpxplay@freemail.hu                            *
//**************************************************************************
//*  This program is distributed in the hope that it will be useful,       *
//*  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
//*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                  *
//*  Please contact with the author (with me) if you want to use           *
//*  or modify this source.                                                *
//**************************************************************************
//function:playlist save

#include "newfunc\newfunc.h"
#include "control\control.h"
#include "display\display.h"
#include "playlist.h"

#define MPXP_SAVELIST_RETCODE_OK         0
#define MPXP_SAVELIST_RETCODE_ERROR      1  // unknown error
#define MPXP_SAVELIST_RETCODE_CANTWRITE  2
#define MPXP_SAVELIST_RETCODE_NONSTANDARD_CUE 3

extern char *m3usavename,*mxusavename,*cuesavename;
extern unsigned int playlistload;

static char *savelist_get_relative_filename(char *filename,char *path,unsigned int pathlen)
{
 char csave,*rp;

 csave=filename[pathlen];
 filename[pathlen]=0;
 if(pds_stricmp(filename,path)==0){  // if path of startdir and save-dir is the same
  if(pathlen==(sizeof(PDS_DIRECTORY_ROOTDIR_STR)-1))
   rp=&filename[pathlen];
  else
   rp=&filename[pathlen+1];  // save relative to currdir (subdir\filename.mp3)
 }else{
  if(pds_getdrivenum_from_path(filename)>=0 && pds_getdrivenum_from_path(filename)==pds_getdrivenum_from_path(path)){ // drives are same
   rp=&filename[2];   // save relative to rootdir (\subdir\filename.mp3)
  }else{
   rp=filename;       // save with full path      (d:\subdir\filename.mp3)
  }
 }
 filename[pathlen]=csave;
 return rp;
}

static unsigned int save_m3u_playlist(struct playlist_side_info *psi,FILE *fp,char *path,unsigned int list_type)
{
 struct playlist_entry_info *pei;
 unsigned int pathlen;
 char cnvtmp[MAX_ID3LEN];

 pathlen=pds_strlen(path);

 if(pathlen){ // allways have to be
  if(list_type&PLST_EXTM3U)
   fprintf(fp,"#EXTM3U\n");

  for(pei=psi->firstsong;pei<=psi->lastentry;pei++){
   if((list_type&PLST_EXTM3U) && (pei->infobits&PEIF_ENABLED)){
    fprintf(fp,"#EXTINF:%d,%s - ",
  	       (pei->timemsec+500)/1000,
               mpxplay_playlist_textconv_back(cnvtmp,pei->id3info[I3I_ARTIST]));
    fprintf(fp,"%s\n",
               mpxplay_playlist_textconv_back(cnvtmp,pei->id3info[I3I_TITLE]));
   }
   fprintf(fp,"%s\n",savelist_get_relative_filename(pei->filename,path,pathlen));
  }
 }else{ // ???
  for(pei=psi->firstsong;pei<=psi->lastentry;pei++)
   fprintf(fp,"%s\n",pei->filename);         // save with full path
 }
 return MPXP_SAVELIST_RETCODE_OK;
}

static unsigned int save_mxu_playlist(struct playlist_side_info *psi,FILE *fp)
{
 struct playlist_entry_info *pei;
 char cnvtmp[MAX_ID3LEN];

 for(pei=psi->firstsong;pei<=psi->lastentry;pei++){
  fprintf(fp,"%s%s",(pei->filename)? pei->filename:"",
                      mpxplay_playlist_textconv_back(cnvtmp,pei->id3info[I3I_ARTIST]));
  fprintf(fp,"%s%8.8X\n",mpxplay_playlist_textconv_back(cnvtmp,pei->id3info[I3I_TITLE]),
                          (pei->infobits&PEIF_ENABLED)? (MXUFLAG_ENABLED|(((pei->timemsec+500)/1000)&MXUFLAG_TIMEMASK)):0);
 }
 return MPXP_SAVELIST_RETCODE_OK;
}

static unsigned int save_cue_playlist(struct playlist_side_info *psi,FILE *fp,char *path)
{
 struct playlist_entry_info *pei,*ppn;
 unsigned int pathlen=pds_strlen(path),trackcount=1,nonstandard=0;
 char cnvtmp[MAX_ID3LEN],lastfile[MAX_PATHNAMELEN]="";

 for(pei=psi->firstsong;pei<=psi->lastentry;pei++){
  if(pds_strcmp(pei->filename,lastfile)!=0 || !(pei->infobits&PEIF_INDEXED) || !(pei->infobits&PEIF_ENABLED)){
   char *ext=pds_strrchr(pei->filename,'.');
   if(ext){
    ext++;
    if(pds_stricmp(ext,"wav")==0)
     ext="WAVE";
   }else
    ext="";
   fprintf(fp,"FILE \"%s\" %s\n",savelist_get_relative_filename(pei->filename,path,pathlen),ext);
   pds_strcpy(lastfile,pei->filename);
  }
  fprintf(fp,"  TRACK %2.2d AUDIO\n",trackcount++);
  if(pei->id3info[I3I_ARTIST])
   fprintf(fp,"    PERFORMER \"%s\"\n",mpxplay_playlist_textconv_back(cnvtmp,pei->id3info[I3I_ARTIST]));
  if(pei->id3info[I3I_TITLE])
   fprintf(fp,"    TITLE \"%s\"\n",mpxplay_playlist_textconv_back(cnvtmp,pei->id3info[I3I_TITLE]));
  fprintf(fp,"    INDEX 01 %2.2d:%2.2d:%2.2d\n",(pei->pstime/60000),((pei->pstime/1000)%60),((pei->pstime%1000)*75/1000));

  // !!! writes non-standard (end of) INDEX if required
  ppn=pei+1;
  if((pei->infobits&PEIF_INDEXED) && pei->petime && (pei->petime!=pei->timemsec)){
   if((ppn>psi->lastentry) || !(ppn->infobits&PEIF_INDEXED) || (pei->petime!=ppn->pstime) || (pds_stricmp(pei->filename,ppn->filename)!=0)){
    fprintf(fp,"    INDEX EE %2.2d:%2.2d:%2.2d\n",(pei->petime/60000),((pei->petime/1000)%60),((pei->petime%1000)*75/1000));
    nonstandard=1;
   }
  }
 }
 if(nonstandard)
  return MPXP_SAVELIST_RETCODE_NONSTANDARD_CUE;
 return MPXP_SAVELIST_RETCODE_OK;
}

char *playlist_savelist_get_savename(unsigned int list_type)
{
 switch(list_type&PLST_LISTS){
  case PLST_MXU:return mxusavename;
  case PLST_CUE:return cuesavename;
  default:return m3usavename;
 }
}

static unsigned int savelist_gettype_from_filename(struct playlist_side_info *psi,char *filename)
{
 char *ext;
 ext=pds_strrchr(filename,'.');
 if(ext){
  if(pds_stricmp(ext,".m3u")==0)
   //if(psi->editsidetype&PLT_EXTENDED)
    return PLST_EXTM3U;
   //else
   // return PLST_M3U;
  if(pds_stricmp(ext,".mxu")==0)
   return PLST_MXU;
  if(pds_stricmp(ext,".cue")==0)
   return PLST_CUE;
 }
 return 0;
}

unsigned int playlist_savelist_save_playlist(struct mainvars *mvp,struct playlist_side_info *psi,char *file_name,unsigned int list_type)
{
 FILE *fp;
 unsigned int retcode=MPXP_SAVELIST_RETCODE_ERROR,len;
 char filename[MAX_PATHNAMELEN],path[MAX_PATHNAMELEN];

 if(!list_type)
  goto err_out_sl;

 if(list_type&PLST_MANUAL){
  if(!psi)
   psi=mvp->psil; // playlist side ???
  if(file_name)
   pds_strcpy(filename,file_name);
  else
   pds_fullpath(filename,playlist_savelist_get_savename(list_type));
  pds_getpath_from_fullname(path,filename);
 }else{ // PLST_AUTO
  psi=mvp->psi0+1; // right side
  pds_getpath_from_fullname(path,freeopts[OPT_PROGNAME]); // get directory of mpxplay.exe
  len=pds_strcpy(filename,path);
  if(len && (filename[len-1]!=PDS_DIRECTORY_SEPARATOR_CHAR))
   len+=pds_strcpy(&filename[len],PDS_DIRECTORY_SEPARATOR_STR);
  pds_strcpy(&filename[len],playlist_savelist_get_savename(list_type));
  playlist_loadsub_setnewinputfile(psi,filename);  // for startup
  funcbit_disable(playlistload,PLL_LISTS_CMDL);    // !!!
  funcbit_enable(playlistload,PLL_LOADLIST);       //
 }

 fp=pds_fopen(filename,"wt");
 if(fp==NULL){
  retcode=MPXP_SAVELIST_RETCODE_CANTWRITE;
  goto err_out_sl;
 }

 switch(list_type&PLST_LISTS){
  case PLST_MXU:retcode=save_mxu_playlist(psi,fp);;break;
  case PLST_CUE:retcode=save_cue_playlist(psi,fp,path);;break;
  default:retcode=save_m3u_playlist(psi,fp,path,list_type);;break;
 }
 pds_fclose(fp);

err_out_sl:
 return retcode;
}

static void playlist_savelist_manualsave(struct playlist_side_info *psi)
{
 char *sn,*fn,msg[MAX_PATHNAMELEN+80];

 if(psi->savelist_type){
  // correct file-extension for list_type (.M3U,.MXU,.CUE)
  sn=playlist_savelist_get_savename(psi->savelist_type);
  sn=pds_strrchr(sn,'.');
  if(sn){
   fn=pds_strrchr(psi->savelist_filename,'.');
   if(fn){
    *fn=0;
    pds_strcpy(fn,sn);
   }
  }
 }else{
  // correct list_type for file-extension
  psi->savelist_type=savelist_gettype_from_filename(psi,psi->savelist_filename);
 }

 pds_sfn_limit(psi->savelist_filename);

 switch(playlist_savelist_save_playlist(psi->mvp,psi,psi->savelist_filename,(psi->savelist_type|PLST_MANUAL))){
  case MPXP_SAVELIST_RETCODE_OK:
   pds_strcpy(msg,"Playlist is saved to\n");
   pds_strcat(msg,psi->savelist_filename);
   //display_textwin_openwindow_keymessage(TEXTWIN_FLAG_TIMEDMESSAGE|TEXTWIN_FLAG_MSGCENTERALIGN,NULL,msg);
   display_timed_message(msg);
   playlist_editlist_updatesides_add_dft(psi->mvp,psi->savelist_filename,DFT_PLAYLIST);
   break;
  case MPXP_SAVELIST_RETCODE_NONSTANDARD_CUE:
   pds_strcpy(msg,"Warning!\n The saved CUE contains non standard (INDEX EE) lines!\n");
   pds_strcat(msg,psi->savelist_filename);
   display_textwin_openwindow_errormsg_ok(NULL,msg);
   playlist_editlist_updatesides_add_dft(psi->mvp,psi->savelist_filename,DFT_PLAYLIST);
   break;
  default:
   pds_strcpy(msg,"Couldn't save playlist to\n");
   pds_strcat(msg,psi->savelist_filename);
   display_textwin_openwindow_errormsg_ok(NULL,msg);
   break;
 }
}

static display_textwin_button_t savelist_buttons[]={
 {""          ,0xffff}, // enter in edit-field executes the first button (savetype == extension of filename)
 {"[ EXTM3U ]",0x1265}, // 'e'
 {""          ,0x1245}, // 'E'
 {"[ M3U ]"   ,0x326d}, // 'm'
 {""          ,0x324d}, // 'M'
 {"[ CUE ]"   ,0x2e63}, // 'c'
 {""          ,0x2e43}, // 'C'
 {"[ MXU ]"   ,0x2d78}, // 'x'
 {""          ,0x2d58}, // 'X'
 {""          ,0x3c00}, // F2
 {"[ Cancel ]",KEY_ESC},// ESC
 {NULL,0}
};

static void manual_savelist_keyhand(struct playlist_side_info *psi,unsigned int extkey)
{
 switch(extkey){
  case 0xffff:psi->savelist_type=0;break;
  case 0x1265:
  case 0x1245:psi->savelist_type=PLST_EXTM3U;break;
  case 0x326d:
  case 0x324d:psi->savelist_type=PLST_M3U;break;
  case 0x2e63:
  case 0x2e43:psi->savelist_type=PLST_CUE;break;
  case 0x2d78:
  case 0x2d58:psi->savelist_type=PLST_MXU;break;
  default:return;
 }
 playlist_savelist_manualsave(psi);
}

void playlist_savelist_manual_save(struct mainvars *mvp)
{
 void *tw;
 unsigned int side,type;
 struct playlist_side_info *psi=mvp->psie;
 struct display_textwin_button_t *btsel;
 char filename[MAX_PATHNAMELEN],msg[50];

 if(psi->savelist_filename[0]){
  pds_strcpy(filename,pds_getfilename_from_fullname(psi->savelist_filename));
  pds_fullpath(psi->savelist_filename,filename); // new path + old filename
 }else{ // 1st calling or after directory/sublist change
  char *inpfile=NULL;
  if(psi->sublistlevel)
   inpfile=psi->sublistnames[psi->sublistlevel];
  else if(psi==mvp->psil)
   inpfile=playlist_loadsub_getinputfile(psi);
  if(inpfile){
   type=savelist_gettype_from_filename(psi,inpfile);
   if(type){
    psi->savelist_type=type;
    pds_fullpath(psi->savelist_filename,inpfile);
   }
  }
  if(!psi->savelist_filename[0]){
   if(!psi->savelist_type)
    psi->savelist_type=PLST_DEFAULT;
   pds_fullpath(psi->savelist_filename,playlist_savelist_get_savename(psi->savelist_type));
  }
 }

 pds_sfn_limit(psi->savelist_filename);

 switch(psi->savelist_type&PLST_LISTS){
  case PLST_EXTM3U:btsel=&savelist_buttons[1];break;
  case PLST_CUE:btsel=&savelist_buttons[5];break;
  case PLST_MXU:btsel=&savelist_buttons[7];break;
  default:btsel=&savelist_buttons[3];
 }

 tw=display_textwin_allocwindow_items(NULL,TEXTWIN_FLAG_MSGCENTERALIGN," Savelist ",manual_savelist_keyhand,psi);
 side=psi-mvp->psi0; // editorside
 sprintf(msg," Save playlist (%s side) to",((side)? "RIGHT":"LEFT"));
 display_textwin_additem_msg_alloc(tw,0,0,-1,msg);
 display_textwin_additem_editline(tw,TEXTWIN_FLAG_MSGLEFTALIGN,0,1,-1,44,psi->savelist_filename,MAX_PATHNAMELEN-2);
 display_textwin_additem_separatorline(tw,-1);
 display_textwin_additem_buttons(tw,TEXTWIN_FLAG_MSGCENTERALIGN,0,-1,savelist_buttons,btsel);
 display_textwin_openwindow_items(tw,0,0,0);
}

// clear savelist filename at loading of new playlist (in directory browser)
void playlist_savelist_clear(struct playlist_side_info *psi)
{
 psi->savelist_type=0;
 psi->savelist_filename[0]=0;
}
