//**************************************************************************
//*                     This file is part of the                           *
//*                      Mpxplay - audio player.                           *
//*                  The source code of Mpxplay is                         *
//*        (C) copyright 1998-2005 by PDSoft (Attila Padar)                *
//*                    http://mpxplay.cjb.net                              *
//*                  email: mpxplay@freemail.hu                            *
//**************************************************************************
//*  This program is distributed in the hope that it will be useful,       *
//*  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
//*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                  *
//*  Please contact with the author (with me) if you want to use           *
//*  or modify this source.                                                *
//**************************************************************************
//function:sort/order list

#include <string.h>
#include "newfunc\newfunc.h"
#include "playlist.h"

static void correct_pfilenums(struct playlist_side_info *psi,struct playlist_entry_info *pei_begin,struct playlist_entry_info *pei_end);

extern unsigned int sortcontrol;
extern char sortorder_string[256];
static char order_table[256];

static int check_order_str(char *strp1,char *strp2)
{
 char c1,c2;

 if(!strp1 || !strp1[0])
  if(strp2 && strp2[0])
   return -1;
  else
   return 0;
 if(!strp2 || !strp2[0])
  if(strp1 && strp1[0])
   return 1;
  else
   return 0;

 do{
  c1=order_table[*strp1];
  c2=order_table[*strp2];
  if(c1!=c2){
   if(c1<c2)
    return -1;
   else
    return 1;
  }
  strp1++;
  strp2++;
 }while(c1);
 return 0;
}


static int check_order_id3inf_title(struct playlist_entry_info *pei0,struct playlist_entry_info *pei1)
{
 char *s0,*s1;

 s0=pei0->id3info[I3I_TITLE];
 if(!s0)
  s0=pei0->id3info[I3I_ARTIST];
 if(!s0)
  s0=pds_getfilename_from_fullname(pei0->filename);

 s1=pei1->id3info[I3I_TITLE];
 if(!s1)
  s1=pei1->id3info[I3I_ARTIST];
 if(!s1)
  s1=pds_getfilename_from_fullname(pei1->filename);

 return check_order_str(s0,s1);
}

static int check_order_id3inf_artist(struct playlist_entry_info *pei0,struct playlist_entry_info *pei1)
{
 char *s0,*s1;

 s0=pei0->id3info[I3I_ARTIST];
 if(!s0)
  s0=pei0->id3info[I3I_TITLE];
 if(!s0)
  s0=pds_getfilename_from_fullname(pei0->filename);

 s1=pei1->id3info[I3I_ARTIST];
 if(!s1)
  s1=pei1->id3info[I3I_TITLE];
 if(!s1)
  s1=pds_getfilename_from_fullname(pei1->filename);

 return check_order_str(s0,s1);
}

static int check_order_id3inf_album(struct playlist_entry_info *pei0,struct playlist_entry_info *pei1)
{
 return check_order_str(pei0->id3info[I3I_ALBUM],pei1->id3info[I3I_ALBUM]);
}

static int check_order_id3inf_year(struct playlist_entry_info *pei0,struct playlist_entry_info *pei1)
{
 return check_order_str(pei0->id3info[I3I_YEAR],pei1->id3info[I3I_YEAR]);
}

static int check_order_id3inf_comment(struct playlist_entry_info *pei0,struct playlist_entry_info *pei1)
{
 return check_order_str(pei0->id3info[I3I_COMMENT],pei1->id3info[I3I_COMMENT]);
}

static int check_order_id3inf_genre(struct playlist_entry_info *pei0,struct playlist_entry_info *pei1)
{
 return check_order_str(pei0->id3info[I3I_GENRE],pei1->id3info[I3I_GENRE]);
}

static int check_order_id3inf_tracknum(struct playlist_entry_info *pei0,struct playlist_entry_info *pei1)
{
 long t1=pds_atol(pei0->id3info[I3I_TRACKNUM]);
 long t2=pds_atol(pei1->id3info[I3I_TRACKNUM]);
 if(t1<t2)
  return -1;
 if(t1==t2)
  return 0;
 return 1;
}

static int check_order_time(struct playlist_entry_info *pei0,struct playlist_entry_info *pei1)
{
 unsigned int t1=pei0->timesec;
 unsigned int t2=pei1->timesec;
 if(t1<t2)
  return -1;
 if(t1==t2)
  return 0;
 return 1;
}

static int check_order_filesize(struct playlist_entry_info *pei0,struct playlist_entry_info *pei1)
{
 unsigned int f1=pei0->filesize;
 unsigned int f2=pei1->filesize;
 if(f1<f2)
  return -1;
 if(f1==f2)
  return 0;
 return 1;
}

static int check_order_path(struct playlist_entry_info *pei0,struct playlist_entry_info *pei1)
{
 char path1[300],path2[300];
 pds_getpath_from_fullname(path1,pei0->filename);
 pds_getpath_from_fullname(path2,pei1->filename);
 return check_order_str(path1,path2);
}

static int check_order_filename(struct playlist_entry_info *pei0,struct playlist_entry_info *pei1)
{
 char *filename1,*filename2;
 filename1=pds_getfilename_from_fullname(pei0->filename);
 filename2=pds_getfilename_from_fullname(pei1->filename);
 return check_order_str(filename1,filename2);
}

static int check_order_pathfile(struct playlist_entry_info *pei0,struct playlist_entry_info *pei1)
{
 return check_order_str(pei0->filename,pei1->filename);
}

static check_order_func_t *check_order_funcs[]={
 &check_order_id3inf_title,
 &check_order_id3inf_artist,
 &check_order_id3inf_album,
 &check_order_id3inf_year,
 &check_order_id3inf_comment,
 &check_order_id3inf_genre,
 &check_order_id3inf_tracknum,
 &check_order_time,
 &check_order_filesize,
 &check_order_path,
 &check_order_filename,
 &check_order_pathfile,
 NULL
};

static check_order_func_t **side_orderfuncp;

#if defined(__WATCOMC__) && (PLAYLIST_MAX_ORDERKEYS==4) && (SORTC_DESCENDING==1)

int asm_coqs(const struct playlist_entry_info *pei0,const struct playlist_entry_info *pei1);

#pragma aux asm_coqs=\
 "mov ebx,eax"\
 "mov ecx,edx"\
 "mov edi,4"\
 "mov esi,dword ptr side_orderfuncp"\
 "back1:"\
  "cmp dword ptr [esi],0"\
  "je endnull"\
  "mov eax,ebx"\
  "mov edx,ecx"\
  "call dword ptr [esi]"\
  "test eax,eax"\
  "jz cont1"\
   "test byte ptr sortcontrol,1"\
   "jz ascending"\
    "neg eax"\
   "ascending:"\
   "jmp end"\
  "cont1:"\
  "add esi,4"\
  "dec edi"\
 "jnz back1"\
 "endnull:xor eax,eax"\
 "end:"\
 parm [eax][edx] value[eax] modify[eax ebx ecx edx edi esi];

static int check_order_func_qs(const struct playlist_entry_info *pei0,const struct playlist_entry_info *pei1)
{
 return asm_coqs(pei0,pei1);
}

#else

static int check_order_func_qs(const struct playlist_entry_info *pei0,const struct playlist_entry_info *pei1)
{
 unsigned int keylevel=0;
 do{
  int result;
  if(!(*(side_orderfuncp+keylevel)))
   break;
  result=(*(side_orderfuncp+keylevel))((struct playlist_entry_info *)pei0,(struct playlist_entry_info *)pei1);
  if(result!=0){
   if(sortcontrol&SORTC_DESCENDING)
    result=-result;
   return result;
  }
 }while(++keylevel<PLAYLIST_MAX_ORDERKEYS);
 return 0;
}

#endif

static int check_order_func_one(struct playlist_side_info *psi,struct playlist_entry_info *pei0,struct playlist_entry_info *pei1)
{
 unsigned int keylevel=0;
 do{
  int result;
  if(!psi->id3ordertype[keylevel])
   break;
  result=((psi->id3ordertype[keylevel])(pei0,pei1));
  if(result!=0){
   if(sortcontrol&SORTC_DESCENDING)
    result=-result;
   return result;
  }
 }while(++keylevel<PLAYLIST_MAX_ORDERKEYS);
 return 0;
}

static void order_one(struct playlist_side_info *psi,struct playlist_entry_info *pei_src)
{
 struct playlist_entry_info *pei_pos,*pei_bottom,*pei_top;
 unsigned int center;
 int result;
 struct playlist_entry_info pei_tmp;

 pei_bottom=psi->firstsong;
 pei_top=pei_src-1;
 if(pei_top<pei_bottom)
  return;

 result=1;

 center=(pei_top-pei_bottom);
 center>>=1;

 if(center){
  if(check_order_func_one(psi,pei_src,pei_top)>=0)
   return;
  do{
   pei_pos=pei_bottom+center;
   result=check_order_func_one(psi,pei_src,pei_pos);
   if(result==0)
    break;
   if(result<0)
    pei_top=pei_pos;
   else
    pei_bottom=pei_pos;
   center=(pei_top-pei_bottom);
   center>>=1;
  }while(center);
 }

 if(!center){
  pei_pos=pei_bottom;
  do{
   result=check_order_func_one(psi,pei_src,pei_pos);
   if(result<0)
    break;
   pei_pos++;
  }while(pei_pos<=pei_top);
 }

 if(result<=0){
  pds_memcpy((char *)&pei_tmp,pei_src,sizeof(struct playlist_entry_info));
  pds_qmemcpyr((pei_pos+1),pei_pos,(pei_src-pei_pos)*sizeof(struct playlist_entry_info)/4);
  pds_memcpy(pei_pos,(char *)&pei_tmp,sizeof(struct playlist_entry_info));
  correct_pfilenums(psi,pei_src,pei_pos);
 }
}

static void correct_pfilenums(struct playlist_side_info *psi,struct playlist_entry_info *pei_begin,struct playlist_entry_info *pei_end)
{
 struct mainvars *mvp;

 if(pei_begin==pei_end)
  return;

 mvp=psi->mvp;
 if(psi==mvp->psip){
  if(mvp->aktfilenum==pei_begin){
   mvp->aktfilenum=pei_end;
  }else{
   if(pei_begin<pei_end){
    if(mvp->aktfilenum>pei_begin && mvp->aktfilenum<=pei_end)
     mvp->aktfilenum--;
   }else{
    if(mvp->aktfilenum>=pei_end && mvp->aktfilenum<pei_begin)
     mvp->aktfilenum++;
   }
  }
  if(mvp->newfilenum==pei_begin){
   mvp->newfilenum=pei_end;
  }else{
   if(pei_begin<pei_end){
    if(mvp->newfilenum>pei_begin && mvp->newfilenum<=pei_end)
     mvp->newfilenum--;
   }else{
    if(mvp->newfilenum>=pei_end && mvp->newfilenum<pei_begin)
     mvp->newfilenum++;
   }
  }
 }
 if(pei_end<pei_begin){
  struct playlist_entry_info *tmp;
  tmp=pei_begin;
  pei_begin=pei_end;
  pei_end=tmp;
 }
 playlist_randlist_correctq(psi,pei_begin,pei_end);
 playlist_peimyself_reset(psi,pei_begin,pei_end);
}

//--------------------------------------------------------------------------
static void build_ordertable(void)
{
 char *ord=&sortorder_string[0];
 unsigned int i,pos;
 char tmp[256];

 for(i=0;i<256;i++)
  tmp[i]=i;

 pos=0;
 do{
  unsigned int c=*ord;
  if(!c)
   break;
  if(c>32 && c!='\"'){
   if(!pos){
    pos=c;
    pos++;
   }else{
    unsigned int from=33; // bellow 32 are control chars
    do{
     if(tmp[from]==c){
      if(from<pos){
       memmove(&tmp[from],&tmp[from+1],pos-from);
       tmp[pos-1]=c;
      }else{
       if(from>pos)
        memmove(&tmp[pos+1],&tmp[pos],from-pos);
       tmp[pos]=c;
       pos++;
      }
      break;
     }
     from++;
    }while(from<256);
   }
  }
  ord++;
 }while(pos<256);

 for(i=0;i<256;i++)
  order_table[tmp[i]]=i;

 for(i='a';i<='z';i++)
  order_table[i]=order_table[i-('a'-'A')]; // lower to uppercase
}

void playlist_sortlist_init(struct mainvars *mvp)
{
 struct playlist_side_info *psi0=mvp->psi0;
 unsigned int s,k,type;

 for(k=0;k<PLAYLIST_MAX_ORDERKEYS;k++){
  struct playlist_side_info *psi=psi0;
  type=*((unsigned int *)&psi->id3ordertype[k]);
  if(type>ID3ORDER_DISABLED)
   type=ID3ORDER_DISABLED;
  for(s=0;s<PLAYLIST_MAX_SIDES;s++,psi++)
   psi->id3ordertype[k]=check_order_funcs[type]; // convert index-value to func-pointer
 }

 build_ordertable();
}

void playlist_sortlist_selectorder(struct playlist_side_info *psi,unsigned int key,unsigned int type)
{
 if(type<ID3ORDER_DISABLED)
  psi->id3ordertype[key]=check_order_funcs[type];
 else
  psi->id3ordertype[key]=NULL;
}

void playlist_order_entry(struct playlist_side_info *psi,struct playlist_entry_info *pei_src)
{
 if(psi->id3ordertype[0] && (psi->lastentry>psi->firstsong)){
  struct mainvars *mvp=psi->mvp;
  unsigned int highakt=(psi->editorhighline==mvp->aktfilenum);

  order_one(psi,pei_src);

  if(highakt)
   playlist_editorhighline_set(psi,mvp->aktfilenum);
 }
}

static void playlist_order_side_block(struct playlist_side_info *psi,
                                      struct playlist_entry_info *firstentry,
                                      struct playlist_entry_info *lastentry)
{
 if(psi->id3ordertype[0] && (lastentry>firstentry)){
  struct mainvars *mvp=psi->mvp;

  side_orderfuncp=&psi->id3ordertype[0];

  qsort((void *)(firstentry),(lastentry-firstentry+1),sizeof(playlist_entry_info),check_order_func_qs);

  if(mvp->aktfilenum>=firstentry && mvp->aktfilenum<=lastentry)//{
   mvp->aktfilenum=playlist_peimyself_search(psi,mvp->aktfilenum);
   //if(!mvp->aktfilenum)           // ???
   // mvp->aktfilenum=firstentry-1; //
  //}
  if(mvp->newfilenum>=firstentry && mvp->newfilenum<=lastentry)
   mvp->newfilenum=playlist_peimyself_search(psi,mvp->newfilenum);
  if(psi->editorhighline>=firstentry && psi->editorhighline>psi->firstsong && psi->editorhighline<=lastentry)
   psi->editorhighline=playlist_peimyself_search(psi,psi->editorhighline);

  if(psi->chkfilenum_begin)
   playlist_chkfile_start_norm(psi,0);

  playlist_randlist_correctq(psi,firstentry,lastentry);
  playlist_peimyself_reset(psi,firstentry,lastentry);
 }
}

void playlist_order_side(struct playlist_side_info *psi)
{
 playlist_order_side_block(psi,psi->firstsong,psi->lastentry);
}

void playlist_order_filenames_block(struct playlist_side_info *psi,
                                    struct playlist_entry_info *firstentry,
                                    struct playlist_entry_info *lastentry)
{
 if(!psi->id3ordertype[0]){
  psi->id3ordertype[0]=check_order_funcs[ID3ORDER_PATHFILE];
  playlist_order_side_block(psi,firstentry,lastentry);
  psi->id3ordertype[0]=NULL;
 }
}

void playlist_order_filenames(struct playlist_side_info *psi)
{
 playlist_order_filenames_block(psi,psi->firstsong,psi->lastentry);
}

// sort directory filetypes (drive,dir,m3u) and filenames in directory browser
static int check_order_dft_qs(const struct playlist_entry_info *pei0,const struct playlist_entry_info *pei1)
{
 unsigned long head1=pei0->entrytype;
 unsigned long head2=pei1->entrytype;

 if(!head1)
  head1=DFT_AUDIOFILE;
 if(!head2)
  head2=DFT_AUDIOFILE;

 if(head1<head2)
  return -1;
 if(head1>head2)
  return 1;
 return check_order_str(pei0->filename,pei1->filename);
}

void playlist_order_dft(struct playlist_side_info *psi)
{
 if(psi->lastentry>psi->firstentry){
  qsort((void *)psi->firstentry,(psi->lastentry-psi->firstentry+1),sizeof(playlist_entry_info),check_order_dft_qs);
  playlist_peimyself_reset(psi,psi->firstentry,psi->lastentry);
 }
}

void playlist_swap_entries(struct playlist_side_info *psi,struct playlist_entry_info *e1,struct playlist_entry_info *e2)
{
 struct mainvars *mvp;

 pds_memxch((char *)e1,(char *)e2,sizeof(playlist_entry_info));

 mvp=psi->mvp;
 if(psi==mvp->psip){
  if(mvp->aktfilenum==e1)
   mvp->aktfilenum=e2;
  else
   if(mvp->aktfilenum==e2)
    mvp->aktfilenum=e1;
  if(mvp->newfilenum==e1)
   mvp->newfilenum=e2;
  else
   if(mvp->newfilenum==e2)
    mvp->newfilenum=e1;
  playlist_randlist_xchq(e1,e2);
 }
 if(psi->chkfilenum_begin){
  struct playlist_entry_info *lower=min(e1,e2);
  struct playlist_entry_info *higher=max(e1,e2);
  if(psi->chkfilenum_begin>=lower && psi->chkfilenum_begin<=higher)
   psi->chkfilenum_begin=lower;
 }
 playlist_peimyself_reset(psi,e1,e1);
 playlist_peimyself_reset(psi,e2,e2);
}
