//**************************************************************************
//*                     This file is part of the                           *
//*                      Mpxplay - audio player.                           *
//*                  The source code of Mpxplay is                         *
//*        (C) copyright 1998-2005 by PDSoft (Attila Padar)                *
//*                    http://mpxplay.cjb.net                              *
//*                  email: mpxplay@freemail.hu                            *
//**************************************************************************
//*  This program is distributed in the hope that it will be useful,       *
//*  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
//*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                  *
//*  Please contact with the author (with me) if you want to use           *
//*  or modify this source.                                                *
//**************************************************************************
//function:m3u,pls,fpl,mxu loading

#include <string.h>
#include "playlist.h"
#include "newfunc\newfunc.h"
#include "control\control.h"
#include "display\display.h"

typedef struct listhandler_s{
 char *extension;
 struct playlist_entry_info *(*loadlist)(struct playlist_entry_info *,struct playlist_side_info *,char *listname);
}listhandler_s;

static struct playlist_entry_info *open_load_m3u(struct playlist_entry_info *,struct playlist_side_info *,char *listname);
static struct playlist_entry_info *load_m3u(struct playlist_entry_info *,struct playlist_side_info *,FILE *listfile);
static struct playlist_entry_info *open_load_pls(struct playlist_entry_info *,struct playlist_side_info *,char *listname);
static struct playlist_entry_info *open_load_mxu(struct playlist_entry_info *,struct playlist_side_info *,char *listname);
static struct playlist_entry_info *open_load_fpl(struct playlist_entry_info *,struct playlist_side_info *,char *listname);

static struct listhandler_s listhandlers[]={
 {"m3u", &open_load_m3u },
 {"m3u8",&open_load_m3u },
 {"pls", &open_load_pls },
 {"mxu", &open_load_mxu },
 {"fpl", &open_load_fpl }
};

#define NUMBER_OF_LISTHANDLERS (sizeof(listhandlers)/sizeof(struct listhandler_s))

extern unsigned int loadid3tag,id3textconv;

static struct listhandler_s *select_listhandler_by_ext(char *filename)
{
 unsigned int i;
 char *ext=pds_strrchr(filename,'.');
 if(ext){
  ext++;
  for(i=0;i<NUMBER_OF_LISTHANDLERS;i++)
   if(pds_stricmp(listhandlers[i].extension,ext)==0)
    return (&listhandlers[i]);
 }
 return NULL;
}

unsigned int playlist_loadlist_check_extension(char *filename)
{
 if(select_listhandler_by_ext(filename))
  return 1;
 return 0;
}

unsigned int playlist_loadlist_mainload(struct playlist_side_info *psi,char *listname,unsigned int loadtype)
{
 struct listhandler_s *listhand;
 int drive;
 struct playlist_entry_info *pei,*begine;
 char *path,*shortfname,strtmp[300];

 pei=begine=psi->lastentry+1;

 if(loadtype&PLL_STDIN){
  pei=load_m3u(pei,psi,stdin);
  psi->lastentry=pei-1;
 }else{

  save_dir();

  if(listname[1]==':'){  // set drive
   drive=pds_getdrivenum_from_path(listname);
   if(drive>=0)
    pds_setdrive(drive);
   path=&listname[2];
  }else
   path=&listname[0];

  pds_strcpy(strtmp,path); // set subdir
  shortfname=pds_strrchr(strtmp,'\\');
  if(shortfname>(&strtmp[0])){
   *shortfname++=0;
   if(pds_chdir(strtmp)!=0){   // (d:)\subdir\list.m3u
    restore_dir();
    goto plm_end;
   }
  }else{
   shortfname=&strtmp[0];
   if(shortfname[0]=='\\'){
    shortfname++;
    if(pds_chdir("\\")!=0){    // (d:)\list.m3u
     restore_dir();
     goto plm_end;
    }
   }
  }
  listhand=select_listhandler_by_ext(listname);
  if(listhand)
   pei=listhand->loadlist(pei,psi,shortfname);
  psi->lastentry=pei-1;
  restore_dir();
 }

plm_end:

 if(pei>psi->firstentry)
  playlist_enable_side(psi);
 else
  playlist_disable_side(psi);

 if(pei==begine)
  return 0;
 return 1;
}

static struct playlist_entry_info *open_load_m3u(struct playlist_entry_info *pei,struct playlist_side_info *psi,char *listname)
{
 FILE *listfile;

 if((listfile=pds_fopen(listname,"rt"))!=NULL){
  pei=load_m3u(pei,psi,listfile);
  fclose(listfile);
 }
 return pei;
}

static struct playlist_entry_info *load_m3u(struct playlist_entry_info *pei,struct playlist_side_info *psi,FILE *listfile)
{
 char *ps,*pa,*pt; // string pointer of timesec,artist,title
 int timesec;
 unsigned int len,firstline=1,this_is_m3u8=0,linecount=0;
 char strtmp[360];

 funcbit_disable(psi->editsidetype,PLT_EXTENDED);

 while(fgets(strtmp,350,listfile) && (pei<=psi->endentry) && (psi->filenameslastp<psi->filenamesendp)){
  if(strtmp[0]){
   if(firstline){
    if(strtmp[0]==0xef && strtmp[1]==0xbb && strtmp[2]==0xbf){
     pds_strcpy(strtmp,&strtmp[3]);
     this_is_m3u8=1;
    }
    firstline=0;
   }
   if(strtmp[0]!='#'){
    char *s;
    if(pds_look_extgetch()==KEY_ESC)
     break;
    s=pds_strchr(strtmp,'\n');
    if(s)
     s[0]=0;
    if(!s || (s>&strtmp[0])){
     pei->filename=psi->filenameslastp;
     pds_fullpath(pei->filename,strtmp);
     len=pds_strlen(pei->filename);
     if(this_is_m3u8 && (id3textconv&ID3TEXTCONV_UTF_AUTO))
      len=mpxplay_playlist_textconv_funcs.utf8_to_char(pei->filename,len);
     if(id3textconv&ID3TEXTCONV_FILENAME)
      len=mpxplay_playlist_textconv_do(pei->filename,len,~ID3TEXTCONV_CODEPAGE);
     psi->filenameslastp+=len+1;

     if(psi->editsidetype&PLT_EXTENDED){ // #EXTM3U
      if(!(pei->infobits&PEIF_ENABLED))   // entry has no #EXTINF
       funcbit_disable(psi->editsidetype,PLT_EXTENDED); // disable extfunc
     }
     pei++;
     sprintf(strtmp,"Loading list: %4d. (press ESC to stop)",++linecount);
     display_message(0,0,strtmp);
    }
   }else{ // winamp EXTINF check & load
    if(pds_strncmp(strtmp,"#EXTINF:",8)==0){
     ps=&strtmp[8]; // begin of timesec
     pa=pds_strchr(ps,',');
     if(pa){
      pa[0]=0;   // end of timesec
      timesec=pds_atol(ps);
      if(timesec>=0){
       pei->timesec=timesec;
       funcbit_enable(pei->infobits,PEIF_ENABLED);
      }

      if((loadid3tag&ID3LOADMODE_LIST) && (psi->id3infolastp<psi->id3infoendp)){
       pa++;      // begin of artist
       pt=pds_strchr(pa,'\n'); // cut '\n' from the end of string
       if(pt)
        pt[0]=0;
       if(!pt || (pt>pa)){
        unsigned int convdone=0;
        pt=strstr(pa," - "); // search for the ' - ' separator (artist-title)
        if(pt){
         pt[0]=0;  // end of artist
         pt+=3;    // begin of title
        }
        len=pds_strcpy(psi->id3infolastp,pa);
        if(this_is_m3u8 && (id3textconv&ID3TEXTCONV_UTF_AUTO)){
         len=mpxplay_playlist_textconv_funcs.utf8_to_char(psi->id3infolastp,len);
         convdone=ID3TEXTCONV_UTF_ALL;
        }
        len=mpxplay_playlist_textconv_do(psi->id3infolastp,len,convdone);
        if(len){
         pei->id3info[I3I_ARTIST]=psi->id3infolastp;
         psi->id3infolastp+=len+1;
         funcbit_enable(pei->infobits,PEIF_ID3EXIST);
        }
        if(pt){
         len=pds_strcpy(psi->id3infolastp,pt);
         if(this_is_m3u8 && (id3textconv&ID3TEXTCONV_UTF_AUTO))
          len=mpxplay_playlist_textconv_funcs.utf8_to_char(psi->id3infolastp,len);
         len=mpxplay_playlist_textconv_do(psi->id3infolastp,len,convdone);
         if(len){
          pei->id3info[I3I_TITLE]=psi->id3infolastp;
          psi->id3infolastp+=len+1;
          funcbit_enable(pei->infobits,PEIF_ID3EXIST);
         }
        }
       }
      }
     }
    }else{
     if(pds_strncmp(strtmp,"#EXTM3U",7)==0)
      funcbit_enable(psi->editsidetype,PLT_EXTENDED);
    }
   }
  }
 }
 if(pds_look_extgetch()==KEY_ESC)
  pds_extgetch();
 clear_message();
 return pei;
}

static struct playlist_entry_info *open_load_pls(struct playlist_entry_info *pei,struct playlist_side_info *psi,char *listname)
{
 //struct playlist_entry_info *ipei;
 FILE *listfile;
 unsigned int len,first=1,linecount=0;
 char *datap,*sp,strtmp[360];

 if((listfile=pds_fopen(listname,"rt"))==NULL)
  return pei;

 funcbit_enable(psi->editsidetype,PLT_EXTENDED);

 pei--;

 while(fgets(strtmp,350,listfile) && (pei<=psi->endentry) && (psi->filenameslastp<psi->filenamesendp)){
  datap=pds_strchr(strtmp,'=');
  if(!datap)
   continue;
  *datap++=0;
  sp=pds_strchr(datap,'\n');
  if(sp){
   if(sp==datap)
    continue;
   *sp=0;
  }

  if(pds_strncmp(strtmp,"File",sizeof("File"))==0){
   if(pds_look_extgetch()==KEY_ESC)
    break;

   //ipei=pei+atol(&strtmp[sizeof("File")]);
   if(!first && (psi->editsidetype&PLT_EXTENDED)){
    if(!(pei->infobits&PEIF_ENABLED))
     funcbit_disable(psi->editsidetype,PLT_EXTENDED);
   }
   first=0;
   pei++;
   pei->filename=psi->filenameslastp;
   pds_fullpath(pei->filename,datap);
   len=pds_strlen(pei->filename);
   if(id3textconv&ID3TEXTCONV_FILENAME)
    len=mpxplay_playlist_textconv_do(pei->filename,len,~ID3TEXTCONV_CODEPAGE);
   psi->filenameslastp+=len+1;
   sprintf(strtmp,"Loading list: %4d. (press ESC to stop)",++linecount);
   display_message(0,0,strtmp);
   continue;
  }
  if(first)
   continue;
  if((loadid3tag&ID3LOADMODE_LIST) && (psi->id3infolastp<psi->id3infoendp)){
   if(pds_strncmp(strtmp,"Title",sizeof("Title"))==0){
    if(!pei->id3info[I3I_ARTIST] && !pei->id3info[I3I_TITLE]){
     char *pt=strstr(datap," - "); // Winamp style
     if(!pt)
      pt=strstr(datap," / ");      // Sonique style
     if(pt){
      pt[0]=0;  // end of artist
      pt+=3;    // begin of title
     }
     len=pds_strcpy(psi->id3infolastp,datap);
     len=mpxplay_playlist_textconv_do(psi->id3infolastp,len,0);
     if(len){
      pei->id3info[I3I_ARTIST]=psi->id3infolastp;
      psi->id3infolastp+=len+1;
      funcbit_enable(pei->infobits,PEIF_ID3EXIST);
     }
     if(pt){
      len=pds_strcpy(psi->id3infolastp,pt);
      len=mpxplay_playlist_textconv_do(psi->id3infolastp,len,0);
      if(len){
       pei->id3info[I3I_TITLE]=psi->id3infolastp;
       psi->id3infolastp+=len+1;
       funcbit_enable(pei->infobits,PEIF_ID3EXIST);
      }
     }
    }
    continue;
   }
  }
  if(pds_strncmp(strtmp,"Length",sizeof("Length"))==0){
   int timesec=pds_atol(datap);
   if(timesec>=0){
    pei->timesec=timesec;
    funcbit_enable(pei->infobits,PEIF_ENABLED);
   }
  }
 }
 pei++;
 if(pds_look_extgetch()==KEY_ESC)
  pds_extgetch();
 clear_message();
 fclose(listfile);
 return pei;
}

static struct playlist_entry_info *open_load_mxu(struct playlist_entry_info *pei,struct playlist_side_info *psi,char *listname)
{
 FILE *listfile;
 unsigned int len;
 char *lp,*listparts[MAX_ID3LISTPARTS];
 char strtmp[360],strtemp2[360];

 if((listfile=pds_fopen(listname,"rt"))==NULL)
  return pei;

 funcbit_enable(psi->editsidetype,PLT_EXTENDED);

 while(fgets(strtmp,350,listfile) && (pei<=psi->endentry) && (psi->filenameslastp<psi->filenamesendp)){
  if(strtmp[0]){
   if(strtmp[0]!='#'){
    pds_memset(&(listparts[0]),0,4*sizeof(char *));
    pds_strcpy(strtemp2,strtmp);
    listline_slice(&(listparts[0]),"\n",strtemp2);
    //new mxu style (from v1.43)
    if(listparts[0] && listparts[1] && listparts[2] && listparts[3]){
     pei->filename=psi->filenameslastp;
     len=pds_strcpy(pei->filename,listparts[0]);
     if(id3textconv&ID3TEXTCONV_FILENAME)
      len=mpxplay_playlist_textconv_do(pei->filename,len,~ID3TEXTCONV_CODEPAGE);
     psi->filenameslastp+=len+1;

     if((loadid3tag&ID3LOADMODE_LIST) && (psi->id3infolastp<psi->id3infoendp)){
      if(listparts[1][0]){
       len=pds_strcpy(psi->id3infolastp,listparts[1]);
       len=mpxplay_playlist_textconv_do(psi->id3infolastp,len,0);
       if(len){
        pei->id3info[I3I_ARTIST]=psi->id3infolastp;
        psi->id3infolastp+=len+1;
        funcbit_enable(pei->infobits,PEIF_ID3EXIST);
       }
      }
      if(listparts[2][0]){
       len=pds_strcpy(psi->id3infolastp,listparts[2]);
       len=mpxplay_playlist_textconv_do(psi->id3infolastp,len,0);
       if(len){
        pei->id3info[I3I_TITLE]=psi->id3infolastp;
        psi->id3infolastp+=len+1;
        funcbit_enable(pei->infobits,PEIF_ID3EXIST);
       }
      }
     }
     pei->timesec=pds_atol16(listparts[3]);

     if(pei->timesec&MXUFLAG_ENABLED){
      pei->timesec&=MXUFLAG_TIMEMASK;
      funcbit_enable(pei->infobits,PEIF_ENABLED);
     }else{
      pei->timesec=0;
      playlist_loadlist_get_header_by_ext(pei,psi,pei->filename);
     }

    }else{
     // old mxu style (v1.42)
     pds_memset(&(listparts[0]),0,4*sizeof(char *));
     pds_strcpy(strtemp2,strtmp);
     listline_slice(&(listparts[0]),":\n",strtemp2);

     if(listparts[0]){
      pei->filename=psi->filenameslastp;
      len=pds_strcpy(pei->filename,listparts[0]);
      if(id3textconv&ID3TEXTCONV_FILENAME)
       len=mpxplay_playlist_textconv_do(pei->filename,len,~ID3TEXTCONV_CODEPAGE);
      psi->filenameslastp+=len+1;
     }
     if((loadid3tag&ID3LOADMODE_LIST) && (psi->id3infolastp<psi->id3infoendp)){
      if(listparts[1]){
       lp=pds_strcutspc(listparts[1]);
       if(lp){
        len=pds_strcpy(psi->id3infolastp,lp);
        len=mpxplay_playlist_textconv_do(psi->id3infolastp,len,0);
        if(len){
      	 pei->id3info[I3I_ARTIST]=psi->id3infolastp;
	 psi->id3infolastp+=len+1;
         funcbit_enable(pei->infobits,PEIF_ID3EXIST);
        }
       }
      }
      if(listparts[2]){
       lp=pds_strcutspc(listparts[2]);
       if(lp){
        len=pds_strcpy(psi->id3infolastp,lp);
        len=mpxplay_playlist_textconv_do(psi->id3infolastp,len,0);
        if(len){
         pei->id3info[I3I_TITLE]=psi->id3infolastp;
	 psi->id3infolastp+=len+1;
         funcbit_enable(pei->infobits,PEIF_ID3EXIST);
        }
       }
      }
     }
     if(listparts[3]){
      funcbit_enable(pei->infobits,PEIF_ENABLED);
     }
    }
    pei++;
   }
  }
  if(pds_look_extgetch()==KEY_ESC)
   break;
 }
 if(pds_look_extgetch()==KEY_ESC)
  pds_extgetch();
 fclose(listfile);
 return pei;
}

static unsigned long pds_read_long_le(FILE *listfile)
{
 unsigned long num;
 fread((char *)&num,4,1,listfile);
 return num;
}

typedef struct fpl_main_header_s{
 unsigned long a;
 unsigned long b;
 unsigned long c;
 unsigned long e;
 unsigned long f;
 unsigned long number_of_entries;
}fpl_main_header_s;

/*typedef struct fpl_entry_info_s{
 unsigned long a[7];
}fpl_entry_info_s;*/

typedef struct fpl_entry_info_s{
 unsigned long a;
 unsigned long filesize;
 unsigned long c;        // filesize_major ?
 unsigned long d;
 unsigned long e;
 unsigned long f;
 unsigned long g;
}fpl_entry_info_s;

#define FPL_TAG_TYPES 7

static char *fpltagtypes[FPL_TAG_TYPES]={"Title","Artist","Album","Date","Comment","Genre","Tracknumber"};
static unsigned int id3index[FPL_TAG_TYPES]={I3I_TITLE,I3I_ARTIST,I3I_ALBUM,I3I_YEAR,I3I_COMMENT,I3I_GENRE,I3I_TRACKNUM};

static struct playlist_entry_info *open_load_fpl(struct playlist_entry_info *pei,struct playlist_side_info *psi,char *listname)
{
 FILE *listfile;
 unsigned long e,t,i,g,filetype,tags_in_group,taglen,datalen,bitrate;
 struct fpl_main_header_s fpl_mainhead;
 struct fpl_entry_info_s fpl_entryinfo;
 char *s,tagname[360],tagdata[360];

 if((listfile=pds_fopen(listname,"rb"))==NULL)
  return pei;

 funcbit_enable(psi->editsidetype,PLT_EXTENDED);

 fread((char *)&fpl_mainhead,sizeof(struct fpl_main_header_s),1,listfile);

 //fprintf(stdout,"e:%d \n",fpl_mainhead.number_of_entries);

 for(e=0;(e<fpl_mainhead.number_of_entries) && (pei<=psi->endentry) && (psi->filenameslastp<psi->filenamesendp);e++){
  sprintf(tagdata,"Loading list %4d/%d (press ESC to stop)",e,fpl_mainhead.number_of_entries);
  display_message(0,0,tagdata);
  filetype=pds_read_long_le(listfile); // ???
  taglen  =pds_read_long_le(listfile);
  if(taglen>=360)
   break;
  fread(tagname,1,taglen,listfile);
  tagname[taglen]=0;
  pei->filename=psi->filenameslastp;
  s=&tagname[0];
  if(pds_strncmp(s,"file://",sizeof("file://")-1)==0){
   unsigned int len;
   s+=sizeof("file://")-1;
   pds_fullpath(pei->filename,s);
   len=pds_strlen(pei->filename);
   if(id3textconv&ID3TEXTCONV_FILENAME){
    unsigned int convdone=~ID3TEXTCONV_CODEPAGE;
    if(id3textconv&ID3TEXTCONV_UTF_AUTO){
     len=mpxplay_playlist_textconv_funcs.utf8_to_char(pei->filename,len); // ??? allways utf-8 ?
     convdone=ID3TEXTCONV_UTF_ALL;
    }
    len=mpxplay_playlist_textconv_do(pei->filename,len,convdone);
   }
   psi->filenameslastp+=len+1;
  }else{
   psi->filenameslastp+=pds_strcpy(pei->filename,s)+1;
  }
  fread((char *)&fpl_entryinfo,sizeof(fpl_entry_info_s),1,listfile);
  //for(i=0;i<7;i++)
  // fprintf(stdout,"%d. %8.8X %10u\n",i,fpl_entryinfo.a[i],fpl_entryinfo.a[i]);
  //fprintf(stdout,"t%d : %d %s\n",e,fpl_entryinfo.number_of_tags,pei->filename);
  for(g=0;g<2;g++){ // ???
   tags_in_group=pds_read_long_le(listfile);
   for(t=0;t<tags_in_group;t++){
    taglen=pds_read_long_le(listfile);
    if(taglen>=360)
     break;
    fread(tagname,1,taglen,listfile);
    tagname[taglen]=0;
    datalen=pds_read_long_le(listfile);
    if(datalen>=360)
     break;
    fread(tagdata,1,datalen,listfile);
    tagdata[datalen]=0;
    if(pds_strcmp(tagname,"bitrate")==0){
     bitrate=pds_atol(tagdata);
     if(bitrate && fpl_entryinfo.filesize){
      bitrate*=1000/8;
      pei->timesec=(fpl_entryinfo.filesize+bitrate/2)/bitrate; // rounding
      funcbit_enable(pei->infobits,PEIF_ENABLED);
     }
    }else{
     if((loadid3tag&ID3LOADMODE_LIST) && (psi->id3infolastp<psi->id3infoendp)){
      for(i=0;i<FPL_TAG_TYPES;i++){
       if((pds_strcmp(tagname,fpltagtypes[i])==0) && !pei->id3info[id3index[i]]){
        unsigned int len=pds_strcpy(psi->id3infolastp,tagdata),convdone=0;
        if(id3textconv&ID3TEXTCONV_UTF_AUTO){
         len=mpxplay_playlist_textconv_funcs.utf8_to_char(psi->id3infolastp,len); // ??? UTF-8 allways?
         convdone=ID3TEXTCONV_UTF_ALL;
        }
        len=mpxplay_playlist_textconv_do(psi->id3infolastp,len,convdone);
        if(len){
         pei->id3info[id3index[i]]=psi->id3infolastp;
         psi->id3infolastp+=len+1;
         funcbit_enable(pei->infobits,PEIF_ID3EXIST);
        }
        break;
       }
      }
     }
    }
   }
  }
  if(!(pei->infobits&PEIF_ENABLED))
   funcbit_disable(psi->editsidetype,PLT_EXTENDED);
  pei++;
  if(pds_look_extgetch()==KEY_ESC)
   break;
 }
 if(pds_look_extgetch()==KEY_ESC)
  pds_extgetch();
 clear_message();

 fclose(listfile);
 return pei;
}

//-------------------------------------------------------------------------
// assign playlist entrytype/id3-name
unsigned int playlist_loadlist_get_header_by_ext(struct playlist_entry_info *pei,struct playlist_side_info *psi,char *filename)
{
 if(!playlist_loadsub_check_extension(filename))
  return 0;

 if(psi->editsidetype&PLT_DIRECTORY)
  pei->entrytype=DFT_PLAYLIST;
 else
  pei->entrytype=DFT_SUBLIST;
 if(!pei->id3info[I3I_ARTIST] && !pei->id3info[I3I_TITLE])
  switch(pei->entrytype){
   case DFT_PLAYLIST:pei->id3info[I3I_DFT_STORE]="[playlist]";break;
   case DFT_SUBLIST :pei->id3info[I3I_DFT_STORE]="[sub-list]";break;
  }
 return 1;
}
