//**************************************************************************
//*                     This file is part of the                           *
//*                      Mpxplay - audio player.                           *
//*                  The source code of Mpxplay is                         *
//*        (C) copyright 1998-2005 by PDSoft (Attila Padar)                *
//*                    http://mpxplay.cjb.net                              *
//*                  email: mpxplay@freemail.hu                            *
//**************************************************************************
//*  This program is distributed in the hope that it will be useful,       *
//*  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
//*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                  *
//*  Please contact with the author (with me) if you want to use           *
//*  or modify this source.                                                *
//**************************************************************************
//function:playlist entry add,delete,move

#include "newfunc\newfunc.h"
#include "playlist.h"
#include "display\display.h"

extern char *id3filterkeyword;
extern unsigned int refdisp;

void playlist_editlist_addfile_any(struct playlist_side_info *psi_src,struct playlist_entry_info *pei_src)
{
 struct playlist_side_info *psi_dest=psi_src->psio;
 struct playlist_entry_info *startentry;
 char strtmp[300];

 if(!(psi_src->editsidetype&PLT_ENABLED))
  return;

 if(GET_HFT(pei_src->entrytype)==HFT_DFT){  // add drive, dir or playlist
  startentry=psi_dest->lastentry;
  switch(pei_src->entrytype){
   case DFT_PLAYLIST:
   case DFT_SUBLIST :pds_strcpy(strtmp,pei_src->filename);
		     break;
   case DFT_SUBDIR:pds_strcpy(strtmp,pei_src->filename);
                   pds_strcat(strtmp,"\\*.*\\*.*");
		   break;
   case DFT_DRIVE:pds_strcpy(strtmp,"d:\\*.*\\*.*");
                  strtmp[0]=pei_src->filename[0];
		  break;
   default:return;
  }
  playlist_buildlist_one(psi_dest,strtmp,0,NULL);
  if(psi_dest->lastentry>startentry){
   if(startentry<psi_dest->firstentry)
    playlist_loadsub_setnewinputfile(strtmp); // !!!!!!
   playlist_chkfile_start_norm(psi_dest,startentry+1);
  }
 }else{
  if(playlist_editlist_addfile_one(psi_src,pei_src,NULL,EDITLIST_MODE_ALL))
   playlist_order_entry(psi_dest,psi_dest->lastentry);
 }
}

void playlist_editlist_copy_entry(struct playlist_side_info *psi_src,struct playlist_entry_info *pei_src)
{
 struct playlist_side_info *psi_dest=psi_src->psio;
 struct playlist_entry_info pei_tmp;
 char strtmp[300];

 if(!(psi_src->editsidetype&PLT_ENABLED))
  return;

 if(GET_HFT(pei_src->entrytype)==HFT_DFT){  // copy drive, dir or playlist
  pds_memset(&pei_tmp,0,sizeof(struct playlist_entry_info));
  switch(pei_src->entrytype){
   case DFT_PLAYLIST:
   case DFT_SUBLIST :pds_strcpy(strtmp,pei_src->filename);
                     pei_tmp.id3info[I3I_ARTIST]=pei_src->id3info[I3I_ARTIST];
                     pei_tmp.id3info[I3I_TITLE]=pei_src->id3info[I3I_TITLE];
		     break;
   case DFT_SUBDIR:pds_strcpy(strtmp,pei_src->filename);
                   pds_strcat(strtmp,"\\*.*\\*.*");
		   break;
   case DFT_DRIVE:pds_strcpy(strtmp,"d:\\*.*\\*.*");
                  strtmp[0]=pei_src->filename[0];
		  break;
   default:return;
  }
  pei_tmp.entrytype=DFT_SUBLIST;
  pei_tmp.filename=&strtmp[0];
  if(!pei_tmp.id3info[I3I_ARTIST] && !pei_tmp.id3info[I3I_TITLE])
   pei_tmp.id3info[I3I_DFT_STORE]="[sub-list]";
  playlist_editlist_addfile_one(psi_src,&pei_tmp,NULL,EDITLIST_MODE_ALL);
 }else{
  if(playlist_editlist_addfile_one(psi_src,pei_src,NULL,EDITLIST_MODE_ALL))
   playlist_order_entry(psi_dest,psi_dest->lastentry);
 }
}

unsigned int playlist_editlist_addfile_one(struct playlist_side_info *psi_src,struct playlist_entry_info *pei_src,struct playlist_entry_info *pei_dest,unsigned int modify)
{
 unsigned int i;
 struct playlist_side_info *psi_dest=psi_src->psio;

 if(!(psi_src->editsidetype&PLT_ENABLED))
  return 0;

 playlist_enable_side(psi_dest);

 if(!pei_dest)
  pei_dest=psi_dest->lastentry+1;
 if(pei_dest>psi_dest->endentry)
  return 0;

 if(modify&EDITLIST_MODE_FILENAME){
  char *flastp=psi_dest->filenameslastp;
  if(flastp<psi_dest->filenamesendp){
   pei_dest->filename=flastp;
   flastp+=pds_strcpy(flastp,pei_src->filename)+1;
   psi_dest->filenameslastp=flastp;
   if(pei_dest>psi_dest->lastentry)
    psi_dest->lastentry=pei_dest;
   if(psi_src->chkfilenum_begin){
    if(pei_src>=psi_src->chkfilenum_begin)
     playlist_chkfile_start_norm(psi_dest,pei_dest);
   }
  }else
   return 0;
 }
 if(modify&EDITLIST_MODE_HEAD){
  pei_dest->entrytype=pei_src->entrytype;
  funcbit_disable(pei_dest->infobits,PEIF_COPYMASK);
  funcbit_copy(pei_dest->infobits,pei_src->infobits,PEIF_COPYMASK);
  pei_dest->timesec=pei_src->timesec;
  pei_dest->filedatalen=pei_src->filedatalen;
  pei_dest->filesize=pei_src->filesize;
  pei_dest->infile_funcs=pei_src->infile_funcs;
  playlist_fulltime_add(psi_dest,pei_dest);
 }
 if(modify&EDITLIST_MODE_ID3){
  char *id3lastp=psi_dest->id3infolastp;
  for(i=0;(i<=I3I_MAX) && (id3lastp<psi_dest->id3infoendp);i++)
   if((pei_src->id3info[i]>=psi_src->id3infobeginp) && (pei_src->id3info[i]<psi_src->id3infoendp)){
    pei_dest->id3info[i]=id3lastp;
    id3lastp+=pds_strcpy(id3lastp,pei_src->id3info[i])+1;
   }else
    pei_dest->id3info[i]=pei_src->id3info[i]; // NULL or mp3-genre
  psi_dest->id3infolastp=id3lastp;
  funcbit_disable(pei_dest->infobits,PEIF_ID3MASK);
  funcbit_copy(pei_dest->infobits,pei_src->infobits,PEIF_ID3MASK);
 }
 return modify;
}

void playlist_editlist_delfile(struct playlist_side_info *psi,struct playlist_entry_info *pei,unsigned int modify)
{
 char *pf;
 unsigned int i,memlen_move,memlen_del;

 if((psi->lastentry<psi->firstentry) || (pei<psi->firstentry)
    || (pei>psi->lastentry) || (GET_HFT(pei->entrytype)==HFT_DFT)
    || ((psi->lastentry==psi->firstentry) && !(psi->psio->editsidetype&PLT_ENABLED)))
  return;

 //delete filename from the filenamesworkarea
 if(modify&EDITLIST_MODE_FILENAME){
  pf=pei->filename;
  pei->filename=NULL;
  if(pf>=psi->filenamesbeginp && pf<psi->filenameslastp){
   struct playlist_entry_info *peii;
   memlen_del=pds_strlen(pf)+1;
   memlen_move=psi->filenameslastp-pf;
   pds_memcpy(pf,pf+memlen_del,memlen_move);
   for(peii=psi->firstentry;peii<=psi->lastentry;peii++)
    if(peii->filename>pf && peii->filename<psi->filenameslastp) // pointer is in filenamesworkarea
     peii->filename-=memlen_del; // move down filename pointer

   psi->filenameslastp-=memlen_del;
  }
 }
 //delete id3infos from the id3infoworkarea
 if(modify&EDITLIST_MODE_ID3){
  i=0;
  do{
   pf=pei->id3info[i];
   pei->id3info[i]=NULL;
   if((pf>=psi->id3infobeginp) && (pf<psi->id3infolastp)){
    struct playlist_entry_info *peii;
    memlen_del=pds_strlen(pf)+1;
    memlen_move=psi->id3infolastp-pf;
    pds_memcpy(pf,pf+memlen_del,memlen_move);
    for(peii=psi->firstentry;peii<=psi->lastentry;peii++){
     char **id3iip=&peii->id3info[0];
     int j=I3I_MAX+1;
     do{
      if((id3iip[0]>pf) && (id3iip[0]<psi->id3infolastp)) // pointer is in id3infoworkarea
       id3iip[0]-=memlen_del; //move down id3info[] pointer
      id3iip++;
     }while(--j);
    }
    psi->id3infolastp-=memlen_del;
   }
  }while(++i<=I3I_MAX);
 }

 if(modify&EDITLIST_MODE_HEAD){
  playlist_randlist_delete(pei);
  playlist_fulltime_del(psi,pei);

  //move down entries
  if(pei<psi->lastentry)
   pds_memcpy(pei,pei+1,(char *)(psi->lastentry)-(char *)pei);

  //clear last entry
  pds_memset(psi->lastentry,0,sizeof(playlist_entry_info));

  //correct pointers in random queue and at pei->myself
  playlist_randlist_correctq(psi,pei,psi->lastentry);
  playlist_peimyself_reset(psi,pei,psi->lastentry);

  //correct some variables (chkfilenum,aktfilenum,newfilenum)
  psi->lastentry--;
  if(psi->lastentry<psi->firstentry){
   //playlist_clear_side(psi); // ???
   playlist_disable_side(psi);
  }else{
   struct mainvars *mvp=psi->mvp;
   if(psi->chkfilenum_begin){
    if(psi->chkfilenum_begin>=pei)
     psi->chkfilenum_begin--;
    psi->chkfilenum_end--;
   }
   if(psi==mvp->psip){
    if(mvp->newfilenum){
     if(mvp->newfilenum>pei)
      mvp->newfilenum--;
     //else
     // if(mvp->newfilenum==pei)
     //  mvp->newfilenum=NULL;
     if(mvp->newfilenum>psi->lastentry)
      mvp->newfilenum=psi->lastentry;
    }
    if(mvp->aktfilenum>=psi->firstsong){
     if(mvp->aktfilenum>pei)
      mvp->aktfilenum--;
     else{
      if(mvp->aktfilenum==pei){
       mvp->aktfilenum=psi->firstsong-1;
       if(!mvp->newfilenum){
        if(pei>psi->lastentry)
         pei=psi->lastentry;
        mvp->newfilenum=pei;
       }
      }
     }
    }
   }
   playlist_editorhighline_check(psi);
  }
 }
}

// copy (add) all playlist entries to the other side
void playlist_editlist_copyside(struct playlist_side_info *psi_src)
{
 struct playlist_entry_info *pei_src;

 for(pei_src=psi_src->firstsong;pei_src<=psi_src->lastentry;pei_src++)
  if(GET_HFT(pei_src->entrytype)!=HFT_DFT)
   playlist_editlist_addfile_one(psi_src,pei_src,NULL,EDITLIST_MODE_ALL);

 playlist_order_side(psi_src->psio);
}

void playlist_editlist_addfile_ins_ehl(struct playlist_side_info *psi_src,struct playlist_entry_info *pei_src)
{
 if(GET_HFT(pei_src->entrytype)==HFT_DFT)
  playlist_editlist_addfile_any(psi_src,pei_src);
 else{
  struct playlist_side_info *psi_dest;
  struct playlist_entry_info *pei_dest;
  if(!playlist_editlist_addfile_one(psi_src,pei_src,NULL,EDITLIST_MODE_ALL))
   return;
  psi_dest=psi_src->psio;
  pei_dest=psi_dest->editorhighline;
  if(pei_dest<psi_dest->firstsong)
   pei_dest=psi_dest->firstsong;
  if(pei_dest<(psi_dest->lastentry-1)){
   playlist_editorhighline_set(psi_dest,psi_dest->lastentry);
   do{
    playlist_editlist_shiftfile(psi_dest,-1);
   }while(psi_dest->editorhighline>pei_dest);
  }else{
   playlist_editorhighline_set(psi_dest,pei_dest);
  }
  playlist_editorhighline_seek(psi_dest,+1,SEEK_CUR);
 }
}

// move/shift entry (up or down) in the playlist (ie: at ctrl-up/ctrl-down)
void playlist_editlist_shiftfile(struct playlist_side_info *psi,int direction)
{
 struct playlist_entry_info *pei_dest;

 pei_dest=psi->editorhighline+direction;
 if(psi->editorhighline>=psi->firstsong && pei_dest>=psi->firstsong && pei_dest<=psi->lastentry){
  playlist_swap_entries(psi,psi->editorhighline,pei_dest);
  playlist_editorhighline_set(psi,pei_dest);
 }
}

//move playlist entry via the mouse (drag & move)
void playlist_editlist_mouse_shiftfile(struct mainvars *mvp,struct playlist_entry_info *ehls)
{
 int mfd;
 unsigned int i;
 struct playlist_side_info *psi=mvp->psie;

 if(ehls!=psi->editorhighline){
  playlist_editorhighline_set(psi,ehls);
  if(psi->editorhighline>ehls){
   i=psi->editorhighline-ehls;
   mfd=1;
  }else{
   i=ehls-psi->editorhighline;
   mfd=-1;
  }
  for(;i;i--)
   playlist_editlist_shiftfile(psi,mfd);
  refdisp|=RDT_EDITOR|RDT_BROWSER;
 }
}

//--------------------------------------------------------------------------
void playlist_editlist_id3filter(struct mainvars *mvp)
{
 struct playlist_side_info *psi=mvp->psip;
 struct playlist_entry_info *pei;
 unsigned int i,found,countf,counti,allfilenums;
 char sout[64];

 if(id3filterkeyword && (psi->editsidetype&PLT_ENABLED)){
  counti=countf=0;
  allfilenums=psi->lastentry-psi->firstsong+1;
  for(pei=psi->lastentry;pei>=psi->firstsong;pei--){
   found=0;
   if(pei->infobits&PEIF_ID3EXIST){
    for(i=0;i<=I3I_MAX;i++){
     if(pei->id3info[i]){
      if(pds_strstri(pei->id3info[i],id3filterkeyword)){
       found=1;
       break;
      }
     }
    }
   }else{
    if(pds_strstri(pei->filename,id3filterkeyword))
     found=1;
   }

   if(!found)
    playlist_editlist_delfile(psi,pei,EDITLIST_MODE_ALL);
   else
    countf++;

   counti++;
   if(!(counti&31)){
    sprintf(sout,"Filtering: %4d/%d, Found: %d",counti,allfilenums,countf);
    display_message(0,0,sout);
    if(pds_look_extgetch()==KEY_ESC){
     pds_extgetch();
     break;
    }
   }
  }
  clear_message();
 }
}
