//**************************************************************************
//*                     This file is part of the                           *
//*                      Mpxplay - audio player.                           *
//*                  The source code of Mpxplay is                         *
//*        (C) copyright 1998-2005 by PDSoft (Attila Padar)                *
//*                    http://mpxplay.cjb.net                              *
//*                  email: mpxplay@freemail.hu                            *
//**************************************************************************
//*  This program is distributed in the hope that it will be useful,       *
//*  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
//*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                  *
//*  Please contact with the author (with me) if you want to use           *
//*  or modify this source.                                                *
//**************************************************************************
//function: routines in newfunc.lib

#ifndef newfunc_h
#define newfunc_h

#include <stdio.h>

#ifdef __WATCOMC__
 #define NEWFUNC_ASM 1
#endif

typedef long long      mpxp_int64_t;
typedef long           mpxp_int32_t;
typedef unsigned long  mpxp_uint32_t;
typedef short          mpxp_int16_t;
typedef unsigned short mpxp_uint16_t;
typedef signed char    mpxp_int8_t;
typedef unsigned char  mpxp_uint8_t;
typedef float          mpxp_float_t;
typedef double         mpxp_double_t;

#ifdef NEWFUNC_ASM
 void pds_ftoi(mpxp_double_t,mpxp_int32_t *);
 #pragma aux pds_ftoi parm [8087][esi] = "fistp dword ptr [esi]"
 void pds_fto64i(mpxp_double_t,mpxp_int64_t *);
 #pragma aux pds_fto64i parm [8087][esi] = "fistp qword ptr [esi]"
 mpxp_uint32_t pds_bswap16(mpxp_uint32_t);
 #pragma aux pds_bswap16 parm [eax] value [eax] = "xchg al,ah"
 mpxp_uint32_t pds_bswap32(mpxp_uint32_t);
 #if (_CPU_ >= 486) || (_M_IX86>=400)
  #pragma aux pds_bswap32 parm [eax] value [eax] = "bswap eax"
 #else
  #pragma aux pds_bswap32 parm [eax] value [eax] = "xchg al,ah" "rol eax,16" "xchg al,ah"
 #endif
 void pds_cpu_hlt(void);
 #pragma aux pds_cpu_hlt ="hlt"
#else
 #define pds_ftoi(ff,ii)   (*ii=(mpxp_int32_t)ff)
 #define pds_fto64i(ff,ii) (*ii=(mpxp_int64_t)ff)
 #define pds_bswap16(a) (((a&0xff)<<8)|((a&0xff00)>>8))
 #define pds_bswap32(a) ((a<<24)|((a&0xff00)<<8)|((a&0xff0000)>>8)|((a>>24)&0xff))
 #define pds_cpu_hlt
#endif

#define funcbit_test(var,bit)       (var&(bit))
#define funcbit_enable(var,bit)     (var|=(bit))
#define funcbit_disable(var,bit)    (var&=~(bit))
#define funcbit_inverse(var,bit)    (var^=(bit))
#define funcbit_copy(var1,var2,bit) (var1|=var2&(bit))
//#define funcbit_copy(var1,var2,bit) (var1=(var1&(~(bit)))|(var2&bit)

// note LE: lowest byte first, highest byte last
#define pds_getb_8s(p)   *((mpxp_int8_t *)p)               // signed 8 bit (1 byte)
#define pds_getb_8u(p)   *((mpxp_uint8_t *)p)              // unsigned 8 bit (1 byte)
#define pds_getb_le16(p) *((mpxp_int16_t *)p)              // 2bytes LE to short
#define pds_getb_be16(p) pds_bswap16(*((mpxp_uint32_t *)p))// 2bytes BE to short (long)
#define pds_getb_le32(p) *((mpxp_int32_t *)p)              // 4bytes LE to long
#define pds_getb_be32(p) pds_bswap32(*((mpxp_uint32_t *)p))// 4bytes BE to long
#define pds_getb_le64(p) *((mpxp_int64_t *)p)              // 8bytes LE to int64

#define pds_newfunc_regs_clear(regs) pds_memset(regs,0,sizeof(union REGS))
#define pds_newfunc_sregs_clear(sregs) pds_memset(sregs,0,sizeof(struct SREGS))

#define TEXTCURSORSHAPE_NORMAL 0x0607
#define TEXTCURSORSHAPE_HIDDEN 0x2000

typedef struct dosmem_t{
 unsigned short selector;
 unsigned short segment;
 char *linearptr;
}dosmem_t;

//to DOS interrupt callings
typedef struct rminfo{
 long EDI;
 long ESI;
 long EBP;
 long reserved_by_system;
 long EBX;
 long EDX;
 long ECX;
 long EAX;
 short flags;
 short ES,DS,FS,GS,IP,CS,SP,SS;
}rminfo;

#define RMINFO_FLAG_CARRY 1

typedef struct pds_find_t{
 void *ff_data;          // lfn_find_t or find_t
 char attrib;            // attribute byte for file
 unsigned short wr_time; // time of last write to file
 unsigned short wr_date; // date of last write to file
 unsigned long  size;    // filesize
 char name[260];         // null-terminated filename
}pds_find_t;

//newfunc.c
extern void newfunc_init(char *);
extern void newfunc_close(void);
extern unsigned long pds_rand(int);
extern unsigned int pds_indos_flag(void);
extern void pds_setapplicationtitle(char *);
extern void pds_fpu_setround_near(void);
extern void pds_fpu_setround_chop(void);
extern void pds_shutdown_atx(void);

#include "dll_load.h"
//dll_load.c
extern mpxplay_module_entry_s *newfunc_dllload_getmodule(unsigned long moduletype_major,unsigned long moduletype_minor,char *modulename_minor,mpxplay_module_entry_s *prev_module);
extern unsigned int newfunc_dllload_reloadmodule(mpxplay_module_entry_s *module);
extern unsigned int newfunc_dllload_disablemodule(unsigned long moduletype_major,unsigned long moduletype_minor,char *modulename_minor,mpxplay_module_entry_s *module);
//extern void newfunc_dllload_unloadmodule(unsigned long moduletype_major,unsigned long moduletype_minor,char *modulename_minor,mpxplay_module_entry_s *module);
//extern void newfunc_dllload_keepmodule(unsigned long moduletype_major,unsigned long moduletype_minor,char *modulename_minor,mpxplay_module_entry_s *module);
extern void newfunc_dllload_list_dlls(void);
extern void newfunc_dllload_closeall(void);

//dpmi.c
extern void far *pds_dpmi_getrmvect(unsigned int intno);
extern void pds_dpmi_setrmvect(unsigned int intno, unsigned int segment,unsigned int offset);
extern void far *pds_dpmi_getexcvect(unsigned int intno);
extern void pds_dpmi_setexcvect(unsigned int intno, void far *vect);
extern void far *pds_dos_getvect(unsigned int intno);
extern void pds_dos_setvect(unsigned int intno, void far *vect);
extern int  pds_dpmi_dos_allocmem(dosmem_t *,unsigned int size);
extern void pds_dpmi_dos_freemem(dosmem_t *);
extern void pds_dpmi_realmodeint_call(unsigned int intnum,struct rminfo *rmi);
#define pds_dpmi_rmi_clear(rmi) pds_memset(rmi,0,sizeof(struct rminfo))

//drivehnd.c
extern void pds_fullpath(char *fullname,char *name);
extern void pds_getcwd(char *pathbuf); // pathbuf must be min. 300 chars long
extern void pds_getdcwd(int drive,char *pathbuf); // pathbuf must be min. 300 chars long
extern int  pds_chdir(char *setdir);
extern int  pds_mkdir(char *newdirname);
extern int  pds_rmdir(char *dirname);
extern int  pds_rename(char *oldfilename,char *newfilename);
extern int  pds_unlink(char *filename);
extern unsigned int pds_findfirst(char *path,int attrib,struct pds_find_t *ffblk);
extern unsigned int pds_findnext(struct pds_find_t *ffblk);
extern void pds_findclose(struct pds_find_t *ffblk);
extern void pds_truename_dos(char *shortname,char *name);
extern void pds_getdrive(unsigned int *currdrive);
extern void pds_setdrive(unsigned int drivenum);
extern void pds_drivesinfo(unsigned int *currdrive,unsigned int *lastdrive);

//filehand.c
extern unsigned int pds_filehand_check_infilehand(void);
extern unsigned int pds_filehand_check_entrance(void);
extern void pds_filehand_lock_entrance(void);
extern void pds_filehand_unlock_entrance(void);
extern int  pds_open_read(char *filename,unsigned int mode);  // mode: O_RDONLY| O_BINARY|O_TEXT
extern int  pds_open_write(char *filename,unsigned int mode); //       O_RDWR| O_BINARY|O_TEXT
extern int  pds_open_create(char *filename,unsigned int mode); //      O_RDWR| O_BINARY|O_TEXT
extern int  pds_dos_read(int,char *,int);
extern int  pds_dos_write(int,char *,int);
extern void pds_close(int);
extern long pds_lseek(int,long,int);
extern long pds_tell(int);
extern int  pds_eof(int);
extern long pds_filelength(int);
extern int  pds_chsize(int filehand,long size);
extern FILE *pds_fopen(char *,char *);
extern void pds_copyfile(char *targetfile,char *srcfile);

//interupt.c
extern void newfunc_error_handlers_init(void);
extern void newfunc_error_handlers_close(void);
extern void newfunc_exception_handlers_close(void);

//keyboard.c
extern unsigned int pds_kbhit(void);
extern unsigned int pds_extgetch(void);
extern unsigned int pds_look_extgetch(void);
extern void pds_pushkey(unsigned int);

//memory.c
#ifdef NEWFUNC_ASM
 extern void pds_memcpy(void *,void *,unsigned int);
 extern void pds_memset(void *,int,unsigned int);
 extern void pds_qmemreset(void *,unsigned int);
 extern void pds_qmemcpy(void *,void *,unsigned int);
 extern void pds_qmemcpyr(void *,void *,unsigned int);
#else
 #include <string.h>
 #define pds_memcpy(t,s,l)   memcpy(t,s,l)
 #define pds_memset(t,v,l)   memset(t,v,l)
 #define pds_qmemreset(t,l)  memset(t,0,l*4)
 #define pds_qmemcpy(t,s,l)  memcpy(t,s,l*4)
 #define pds_qmemcpyr(t,s,l) memmove(t,s,l*4)
#endif
extern void pds_memxch(char *,char *,unsigned int);
extern void *pds_malloc(unsigned int bufsize);
extern void *pds_calloc(unsigned int nitems,unsigned int itemsize);
extern void *pds_realloc(void *bufptr,unsigned int bufsize);
extern void pds_free(void *bufptr);

//string.c
extern unsigned int pds_strcpy(char *,char *); // returns the length of string!
extern void pds_strncpy(char *dest,char *src,unsigned int maxlen);
extern void pds_strcat(char *,char *);
extern int  pds_strcmp(char *strp1,char *strp2);
extern int  pds_stricmp(char *,char *);
extern int  pds_strricmp(char *,char *);
extern int  pds_strlicmp(char *,char *);
extern int  pds_strncmp(char *,char *,unsigned int);
extern int  pds_strnicmp(char *strp1,char *strp2,unsigned int counter);
extern unsigned int pds_strlen(char *);
extern unsigned int pds_strlenc(char *,char);
extern char *pds_strchr(char *,char);
extern char *pds_strrchr(char *,char);
extern char *pds_strstri(char *s1,char *s2);
extern char *pds_strcutspc(char *);
extern void  pds_ltoa(int,char *);
extern void  pds_ltoa16(int,char *);
extern long  pds_atol(char *);
extern long  pds_atol16(char *);
extern char *pds_getfilename_from_fullname(char *);
extern void  pds_getfilename_noext_from_fullname(char *strout,char *fullname);
extern char *pds_getpath_from_fullname(char *,char *);
extern int   pds_getdrivenum_from_path(char *);
extern unsigned int pds_fullpath_check(char *path);

//textdisp.c
extern void newfunc_textdisplay_init(void);
extern void newfunc_textdisplay_close(void);
extern void pds_textdisplay_charxy(unsigned int,unsigned int,unsigned int,char);
#define pds_textdisplay_charxybk(color,bkcolor,outx,outy,c) (pds_textdisplay_charxy((bkcolor<<4)|color,outx,outy,c))
extern unsigned int pds_textdisplay_textxy(unsigned int,unsigned int,unsigned int,char *);
#define pds_textdisplay_textxybk(color,bkcolor,outx,outy,string) (pds_textdisplay_textxy((bkcolor<<4)|color,outx,outy,string))
extern unsigned int pds_textdisplay_textxyn(unsigned int color,unsigned int outx,unsigned int outy,unsigned int maxlen,char *string_s);
#define pds_textdisplay_textxynbk(color,bkcolor,outx,outy,maxlen,string) (pds_textdisplay_textxyn((bkcolor<<4)|color,outx,outy,maxlen,string))
extern void pds_textdisplay_clrscr(void);
extern void pds_textdisplay_scrollup(unsigned int);
extern void pds_textdisplay_printf(char *);
extern unsigned int pds_textdisplay_getbkcolorxy(unsigned int,unsigned int);
extern void pds_textdisplay_setcolorxy(unsigned int,unsigned int,unsigned int);
extern void pds_textdisplay_setbkcolorxy(unsigned int,unsigned int,unsigned int);
extern void pds_textdisplay_spacecxyn(unsigned int,unsigned int,unsigned int,unsigned int);
extern void pds_textdisplay_vidmem_save(void);
extern void pds_textdisplay_vidmem_restore(void);
extern void pds_textdisplay_setresolution(unsigned int lines);
extern void pds_textdisplay_getresolution(void);
extern unsigned int pds_textdisplay_getcursor_y(void);
extern void pds_textdisplay_gotoxy(unsigned int x,unsigned int y);
extern void pds_textdisplay_setcursorshape(long);
extern void pds_textdisplay_resetcolorpalette(void);
//extern void redefine_fonts_8x8(void);
//extern void redefine_fonts_8x16(void);

//time.c
extern unsigned long pds_gettimeh(void);
extern unsigned long pds_gettime(void);
extern unsigned long pds_getdate(void);
extern unsigned long pds_strtime_to_hextime(char *timestr,unsigned int houralign);
extern unsigned long pds_strtime_to_hexhtime(char *timestr);
#define PDS_HEXTIME_TO_SECONDS(t) ((t>>16)*3600+((t>>8)&0xff)*60+(t&0xff))
#define PDS_HEXHTIME_TO_HSECONDS(t) ((t>>24)*360000+((t>>16)&0xff)*6000+((t>>8)&0xff)*100+(t&0xff))
extern void pds_delay_10us(unsigned int ticks);

//timer.c
#define MPXPLAY_TIMERTYPE_WAKEUP    0  // wake up once (delete after running)
#define MPXPLAY_TIMERTYPE_REPEAT    1  // repeat forever (don't delete after running)
#define MPXPLAY_TIMERTYPE_INT08     4  // run from int08 (else run from main_cycle)
#define MPXPLAY_TIMERTYPE_SIGNAL    8  // signalling (call func at mpxplay_signal_events) (cannot use it with INT08)

#define MPXPLAY_TIMERFLAG_MULTIPLY  64  // multiply instance (don't overwrite previous configured (same) function)
#define MPXPLAY_TIMERFLAG_LOWPRIOR 128  // runs in lower priority (check buffers fullness)
#define MPXPLAY_TIMERFLAG_BUSY     256  // busy flag (no re-entrance)
#define MPXPLAY_TIMERFLAG_OWNSTACK 512  // use a separated stack for the function (for int08 functions)
#define MPXPLAY_TIMERFLAG_STI     1024  // disable maskable interrupts while function running (for int08 functions)
#define MPXPLAY_TIMERFLAG_INDOS   2048  // function calls DOS routines (check indos flag before)
#define MPXPLAY_TIMERFLAG_MVPDATA 8192  // passdata=mvp

//mpxplay_signal_events flags
//events at TIMERTYPE_SIGNAL
#define MPXPLAY_SIGNALTYPE_KEYBOARD     1
#define MPXPLAY_SIGNALTYPE_MOUSE        2
#define MPXPLAY_SIGNALTYPE_DESKTOP     16 // not used
#define MPXPLAY_SIGNALTYPE_NEWFILE    256 // not used
#define MPXPLAY_SIGNALTYPE_USER  (MPXPLAY_SIGNALTYPE_KEYBOARD|MPXPLAY_SIGNALTYPE_MOUSE)
#define MPXPLAY_SIGNALMASK_TIMER (MPXPLAY_SIGNALTYPE_KEYBOARD|MPXPLAY_SIGNALTYPE_MOUSE|MPXPLAY_SIGNALTYPE_DESKTOP|MPXPLAY_SIGNALTYPE_NEWFILE)
//other events (not used at TIMERTYPE_SIGNAL)
#define MPXPLAY_SIGNALTYPE_DISKACCESS 8192 // file read/write
#define MPXPLAY_SIGNALMASK_OTHER (MPXPLAY_SIGNALTYPE_DISKACCESS)

extern unsigned long mpxplay_timer_secs_to_counternum(unsigned long secs);
extern int mpxplay_timer_addfunc(void *callback_func,void *callback_data,unsigned int flags,unsigned int refresh_delay); // returns -1 on error, else returns a handlernum_index value
extern void mpxplay_timer_modifyfunc(void *callback_func,int flags,int refresh_delay); // if flags==-1 or refresh_delay==-1, then do not modify that value
extern void mpxplay_timer_deletefunc(void *callback_func);
extern void mpxplay_timer_deletehandler(void *callback_func,int handlernum_index); // used at TIMERFLAG_MULTIPLY
extern void mpxplay_timer_reset_counters(void);
extern void mpxplay_timer_execute_maincycle_funcs(void);
extern void mpxplay_timer_execute_int08_funcs(void);
extern void newfunc_newhandler08_init(void);
extern void newfunc_newhandler08_close(void);

#endif // newfunc_h
