//**************************************************************************
//*                     This file is part of the                           *
//*                      Mpxplay - audio player.                           *
//*                  The source code of Mpxplay is                         *
//*        (C) copyright 1998-2005 by PDSoft (Attila Padar)                *
//*                    http://mpxplay.cjb.net                              *
//*                  email: mpxplay@freemail.hu                            *
//**************************************************************************
//*  This program is distributed in the hope that it will be useful,       *
//*  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
//*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                  *
//*  Please contact with the author (with me) if you want to use           *
//*  or modify this source.                                                *
//**************************************************************************
//function: newfunc (stuffs) main

#include "newfunc.h"
#include "dll_load.h"
#include "mpxplay.h"

#ifdef __DOS__
static char *biosmem=(char *)0;
static char far *indosptr;
#endif
extern unsigned int oldposrow,iswin9x;
extern unsigned int intsoundconfig,intsoundcontrol;

unsigned int is_lfn_support;
dosmem_t dm_int2x_1,dm_int2x_2;

//-------------------------------------------------------------------------
//DOS memory allocations (conventional memory for DOS callings)

static unsigned int allocate_int2x_dosmems(void)
{
 if(!pds_dpmi_dos_allocmem(&dm_int2x_1,512))
  return 0;
 if(!pds_dpmi_dos_allocmem(&dm_int2x_2,512))
  return 0;
 return 1;
}

static void free_int2x_dosmems(void)
{
 pds_dpmi_dos_freemem(&dm_int2x_1);
 pds_dpmi_dos_freemem(&dm_int2x_2);
}

//-------------------------------------------------------------------------
//newfunc init & close

void asm_detect_win9x(void);

void newfunc_init(char *prgname)
{
#if defined(__DOS__) && (!defined(NEWFUNC_ASM) || !defined(__WATCOMC__))
 union REGS regs;
#endif
#ifdef __DOS__
 union REGPACK regp;
#endif

 newfunc_error_handlers_init();

 if(!allocate_int2x_dosmems())
  mpxplay_close_program(MPXERROR_CONVENTIONAL_MEM);

#ifdef __DOS__
 #if defined(NEWFUNC_ASM) && defined(__WATCOMC__)
  #pragma aux asm_detect_win9x=\
  "mov ax,0x160a"\
  "xor ebx,ebx"\
  "int 0x2f"\
  "cmp bx,1024"\
  "jl nowin9x"\
  "mov iswin9x,1"\
  "nowin9x:"\
  modify[eax ebx ecx edx edi esi];
  asm_detect_win9x();
 #else
  pds_newfunc_regs_clear(&regs);
  regs.w.ax=0x160a;
  regs.w.bx=0;
  int386(0x2f, &regs, &regs);
  if(regs.w.bx==1024)
   iswin9x=1;
 #endif
#endif

 if(iswin9x){
  is_lfn_support=1;
 }else{    // detect truename (LFN converter) function
#ifdef __DOS__
  if(prgname){
   struct rminfo RMI;
   pds_dpmi_rmi_clear(&RMI);
   RMI.EAX=0x00007160;
   RMI.ECX=2;
   RMI.DS =dm_int2x_1.segment;
   RMI.ES =dm_int2x_2.segment;
   funcbit_enable(RMI.flags,RMINFO_FLAG_CARRY);
   pds_strcpy(dm_int2x_1.linearptr,prgname);
   *((char *)(dm_int2x_2.linearptr))=0;
   pds_dpmi_realmodeint_call(0x21,&RMI);
   if(!funcbit_test(RMI.flags,RMINFO_FLAG_CARRY) && *((char *)(dm_int2x_2.linearptr))!=0)
    is_lfn_support=1;
  }
#endif
 }
 newfunc_textdisplay_init();
 oldposrow=pds_textdisplay_getcursor_y();

#ifdef __DOS__
 pds_memset((void *)&regp,0,sizeof(union REGPACK));
 regp.x.eax=0x3400;
 intr(0x21,&regp);
 indosptr=MK_FP(regp.x.es,regp.x.ebx);
#endif
}

void newfunc_close(void)
{
 newfunc_dllload_closeall();
 newfunc_newhandler08_close();
 free_int2x_dosmems();
 newfunc_textdisplay_close();
}

//--------------------------------------------------------------------------
//get a random number
unsigned long pds_rand(int maxnum)
{
 unsigned int i,r=0;
 if(maxnum<1)
  return 0;
#ifdef __DOS__
 for(i=(biosmem[0x46c]&127);i;i--)
  r+=(biosmem[0x046c]);
 r+=rand();
#else
 r=rand()*rand()*rand();
#endif
 return (r%maxnum);
}

//--------------------------------------------------------------------------
unsigned int pds_indos_flag(void)
{
#ifdef __DOS__
 if(intsoundcontrol&INTSOUND_DOSSHELL) // !!! because it's allways 1 then
  return 0;                            //
 if(indosptr)
  return (unsigned int)(*indosptr);
#endif
 return 0;
}

//--------------------------------------------------------------------------
void pds_setapplicationtitle(char *title)
{
#ifdef __DOS__
 if(iswin9x && !pds_filehand_check_infilehand()){
  struct rminfo RMI;
  pds_dpmi_rmi_clear(&RMI);
  RMI.EAX=0x0000168E;
  RMI.ECX=80;
  RMI.ES =dm_int2x_1.segment;
  pds_strcpy(dm_int2x_1.linearptr,title);
  pds_dpmi_realmodeint_call(0x2f,&RMI);
 }
#endif
}

//--------------------------------------------------------------------------
// FPU settings
void asm_fpu_setround_near(void);

void pds_fpu_setround_near(void)
{
 unsigned short controlword;
#ifdef __WATCOMC__
 #pragma aux asm_fpu_setround_near=\
  "fstcw word ptr controlword"\
  "and word ptr controlword,0xf3ff"\
  "fldcw word ptr controlword"\
  modify[];
 asm_fpu_setround_near();
#endif
}

void asm_fpu_setround_chop(void);

void pds_fpu_setround_chop(void)
{
 unsigned short controlword;
#ifdef __WATCOMC__
 #pragma aux asm_fpu_setround_chop=\
  "fstcw word ptr controlword"\
  "or word ptr controlword,0x0c00"\
  "fldcw word ptr controlword"\
  modify[];
 asm_fpu_setround_chop();
#endif
}

//--------------------------------------------------------------------------
//shutdown routine
void asm_disk_reset(void);
void asm_apm_shutdown(void);

void pds_shutdown_atx(void)
{
#ifdef __DOS__
 if(iswin9x){
  //system("rundll32.exe User,ExitWindows");
  system("rundll32.exe shell32.dll,SHExitWindowsEx 5");
 }else{
  //1.disks reset
  //2.reset disk system
 #ifdef __WATCOMC__
  #pragma aux asm_disk_reset=\
  "mov ax,0x0d00"\
  "int 0x21"\
  "xor eax,eax"\
  "mov dx,128"\
  "int 0x13"\
  modify[eax edx];
  asm_disk_reset(); // flush caches and reset disks

  //1.RealMode Interface connect
  //2.Engage power management
  //3.Enable APM for all devices
  //4.Force version 1.1 compatibility
  //5 First attempt: using APM 1.1 or later
  //  Shutdown all the devices supported by APM
  //6.Second attempt: using APM 1.0
  //  Shutdown only the system BIOS
  #pragma aux asm_apm_shutdown=\
  "mov ax,0x5301"\
  "mov bx,0"\
  "int 0x15"\
  "mov ax,0x530f"\
  "mov bx,1"\
  "mov cx,1"\
  "int 0x15"\
  "mov ax,0x5308"\
  "mov bx,1"\
  "mov cx,1"\
  "int 0x15"\
  "mov ax,0x530e"\
  "mov bx,0"\
  "mov cx,0x0101"\
  "int 0x15"\
  "mov ax,0x5307"\
  "mov bx,1"\
  "mov cx,3"\
  "int 0x15"\
  "mov ax,0x5307"\
  "mov bx,0"\
  "mov cx,3"\
  "int 0x15"\
  modify[eax ebx ecx];
  asm_apm_shutdown(); // shutdown by advanced power managment (BIOS)
 #endif
 }
#endif
}

//-------------------------------------------------------------------
#include "control\control.h"

extern mainvars mvps;

struct mpxplay_resource_s mpxplay_resources={
 &mvps,                          // 0.
 NULL,
 &intsoundconfig,
 &intsoundcontrol,
 0,
 0,
 0,
 0,
 0,
 0,

 //dpmi.c
 &pds_dpmi_getrmvect,            // 10.
 &pds_dpmi_setrmvect,
 &pds_dpmi_getexcvect,
 &pds_dpmi_setexcvect,
 &pds_dos_getvect,
 &pds_dos_setvect,
 &pds_dpmi_dos_allocmem,
 &pds_dpmi_dos_freemem,
 &pds_dpmi_realmodeint_call,
 NULL,

 //drivehnd.c
 &pds_fullpath,                  // 20.
 &pds_getcwd,
 &pds_getdcwd,
 &pds_chdir,
 &pds_mkdir,
 &pds_rmdir,
 &pds_rename,
 &pds_unlink,
 &pds_findfirst,
 &pds_findnext,
 &pds_findclose,                 // 30.
 &pds_truename_dos,
 &pds_getdrive,
 &pds_setdrive,
 &pds_drivesinfo,
 NULL,
 NULL,
 NULL,
 NULL,
 NULL,

 //filehand.c
 &pds_open_read,                 // 40.
 &pds_open_write,
 &pds_open_create,
 &pds_dos_read,
 &pds_dos_write,
 &pds_close,
 &pds_lseek,
 &pds_tell,
 &pds_eof,
 &pds_filelength,
 &pds_chsize,                    // 50.
 &pds_fopen,
 NULL,
 NULL,
 NULL,
 &pds_copyfile,
 NULL,
 NULL,
 NULL,
 NULL,

 //keyboard.c
 &pds_kbhit,                     // 60.
 &pds_extgetch,
 &pds_look_extgetch,
 &pds_pushkey,
 NULL,
 NULL,
 NULL,
 NULL,
 NULL,
 NULL,

 //memory.c
 &pds_memcpy,                    // 70.
 &pds_memset,
 &pds_qmemreset,
 &pds_qmemcpy,
 &pds_qmemcpyr,
 &pds_memxch,
 &pds_malloc,
 &pds_calloc,
 &pds_realloc,
 &pds_free,

 //string.c
 &pds_strcpy,                    // 80.
 &pds_strncpy,
 &pds_strcat,
 &pds_strcmp,
 &pds_stricmp,
 &pds_strricmp,
 &pds_strlicmp,
 &pds_strncmp,
 &pds_strnicmp,
 &pds_strlen,
 &pds_strlenc,                   //  90.
 &pds_strchr,
 &pds_strrchr,
 &pds_strstri,
 &pds_strcutspc,
 &pds_ltoa,
 NULL, //&pds_ltoa16,
 &pds_atol,
 &pds_atol16,
 &pds_getfilename_from_fullname,
 &pds_getfilename_noext_from_fullname, // 100.
 &pds_getpath_from_fullname,
 &pds_getdrivenum_from_path,
 &pds_fullpath_check,
 NULL,
 NULL,
 NULL,
 NULL,
 NULL,
 NULL,

 //textdisp.c
 &pds_textdisplay_charxy,        // 110.
 &pds_textdisplay_textxy,
 &pds_textdisplay_clrscr,
 &pds_textdisplay_scrollup,
 &pds_textdisplay_printf,
 &pds_textdisplay_getbkcolorxy,
 &pds_textdisplay_setcolorxy,
 &pds_textdisplay_setbkcolorxy,
 &pds_textdisplay_spacecxyn,
 &pds_textdisplay_vidmem_save,
 &pds_textdisplay_vidmem_restore,// 120.
 &pds_textdisplay_setresolution,
 &pds_textdisplay_getresolution,
 &pds_textdisplay_getcursor_y,
 &pds_textdisplay_gotoxy,
 NULL,
 NULL,
 NULL,
 NULL,
 NULL,

 //time.c
 &pds_gettimeh,                  // 130.
 &pds_gettime,
 &pds_getdate,
 &pds_strtime_to_hextime,
 &pds_strtime_to_hexhtime,
 &pds_delay_10us,
 NULL,
 NULL,
 NULL,
 NULL,

 //timer.c
 &mpxplay_timer_secs_to_counternum, //140.
 &mpxplay_timer_addfunc,
 &mpxplay_timer_modifyfunc,
 &mpxplay_timer_deletefunc,
 &mpxplay_timer_deletehandler,
 NULL,
 NULL,
 NULL,
 NULL,
 NULL                            // 149.

};
