//**************************************************************************
//*                     This file is part of the                           *
//*                      Mpxplay - audio player.                           *
//*                  The source code of Mpxplay is                         *
//*        (C) copyright 1998-2005 by PDSoft (Attila Padar)                *
//*                    http://mpxplay.cjb.net                              *
//*                  email: mpxplay@freemail.hu                            *
//**************************************************************************
//*  This program is distributed in the hope that it will be useful,       *
//*  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
//*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                  *
//*  Please contact with the author (with me) if you want to use           *
//*  or modify this source.                                                *
//**************************************************************************
//function: keyboard handling (by bios memory area)

#ifdef __DOS__
static char *biosmem=(char *)0;
#endif

unsigned int pds_kbhit(void)
{
#ifdef __DOS__
 if(*((unsigned short *)&biosmem[0x41a])==*((unsigned short *)&biosmem[0x41c]))
  return 0;
 return 1;
#else
 return kbhit();
#endif
}

unsigned int pds_extgetch(void)
{
#ifdef __DOS__
 unsigned int keybufferpos;
 while(!pds_kbhit());
 keybufferpos=0x400+*((unsigned short *)&biosmem[0x41a]);
 *((unsigned short *)&biosmem[0x41a])+=2;
 if(*((unsigned short *)&biosmem[0x41a])>=*((unsigned short *)&biosmem[0x482]))
  *((unsigned short *)&biosmem[0x41a])=*((unsigned short *)&biosmem[0x480]);
 return *((unsigned short *)&biosmem[keybufferpos]);
#else
 unsigned int keycode=getch(); // ??? possibly bad for Mpxplay
 if(!keycode)
  keycode=getch();
 else
  keycode<<=8;                 // ???
 return keycode;
#endif
}

unsigned int pds_look_extgetch(void)
{
 if(pds_kbhit()){
#ifdef __DOS__
  unsigned int keybufferpos=0x400+*((unsigned short *)&biosmem[0x41a]);
  return *((unsigned short *)&biosmem[keybufferpos]);
#else
  unsigned int keycode=pds_extgetch();
  pds_pushkey(keycode);
  return keycode;
#endif
 }
 return 0;
}

void pds_pushkey(unsigned int newkey)
{
#ifdef __DOS__
 unsigned int keybufferpos=0x400+*((unsigned short *)&biosmem[0x41c]);
 biosmem[keybufferpos]  =newkey&0xff;
 biosmem[keybufferpos+1]=newkey>>8;
 *((unsigned short *)&biosmem[0x41c])+=2;
 if(*((unsigned short *)&biosmem[0x41c])>=*((unsigned short *)&biosmem[0x482]))
  *((unsigned short *)&biosmem[0x41c])=*((unsigned short *)&biosmem[0x480]);
#else
 ungetch(newkey); // ???
#endif
}
