//**************************************************************************
//*                     This file is part of the                           *
//*                      Mpxplay - audio player.                           *
//*                  The source code of Mpxplay is                         *
//*        (C) copyright 1998-2005 by PDSoft (Attila Padar)                *
//*                    http://mpxplay.cjb.net                              *
//*                  email: mpxplay@freemail.hu                            *
//**************************************************************************
//*  This program is distributed in the hope that it will be useful,       *
//*  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
//*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                  *
//*  Please contact with the author (with me) if you want to use           *
//*  or modify this source.                                                *
//**************************************************************************
//function: file handler routines

#include <share.h>
#include "newfunc.h"
#include "mpxplay.h"
#include "display\display.h"

#ifdef __DOS__
extern unsigned int intsoundcontrol;
extern unsigned int is_lfn_support,uselfn;
extern volatile unsigned long mpxplay_signal_events;
extern dosmem_t dm_int2x_1;
static unsigned int in_filehand;

unsigned int pds_filehand_check_infilehand(void)
{
 return in_filehand;
}

unsigned int pds_filehand_check_entrance(void)
{
 if(in_filehand)
  return 1;
 if(intsoundcontrol&INTSOUND_DOSSHELL)
  return 1;
 if(pds_indos_flag())
  return 1;
 return 0;
}

void pds_filehand_lock_entrance(void)
{
 in_filehand=1;
}

void pds_filehand_unlock_entrance(void)
{
 in_filehand=0;
}
#endif

int pds_open_read(char *filename,unsigned int mode)
{
 int filehand=0;
#ifdef __DOS__
 if(pds_filehand_check_entrance())
  return filehand;
 pds_filehand_lock_entrance();
 if(is_lfn_support && uselfn){
  struct rminfo RMI;
  pds_dpmi_rmi_clear(&RMI);
  RMI.EAX=0x0000716C;
  RMI.EDX=0x01;                    // open, fail if not exist
  RMI.EBX=(mode&0x0f)|SH_DENYNO;   // O_RDONLY|O_BINARY
  RMI.DS =dm_int2x_1.segment;
  funcbit_enable(RMI.flags,RMINFO_FLAG_CARRY);
  pds_strcpy(dm_int2x_1.linearptr,filename);
  pds_dpmi_realmodeint_call(0x21,&RMI);
  if(!funcbit_test(RMI.flags,RMINFO_FLAG_CARRY))
   filehand=RMI.EAX&0xffff;
 }else
#endif
  filehand=sopen(filename,mode,SH_DENYNO);

#ifdef __DOS__
 pds_filehand_unlock_entrance();
#endif

 if(filehand<0)
  filehand=0;
 return filehand;
}

int pds_open_write(char *filename,unsigned int mode)
{
 int filehand=0;

#ifdef __DOS__
 if(pds_filehand_check_entrance())
  return filehand;
 pds_filehand_lock_entrance();
 if(is_lfn_support && uselfn){
  struct rminfo RMI;
  pds_dpmi_rmi_clear(&RMI);
  RMI.EAX=0x0000716C;
  RMI.EDX=0x01;                    // open, fail if not exist
  RMI.EBX=(mode&0x0f)|SH_DENYWR;   // O_RDWR|O_BINARY
  RMI.DS =dm_int2x_1.segment;
  funcbit_enable(RMI.flags,RMINFO_FLAG_CARRY);
  pds_strcpy(dm_int2x_1.linearptr,filename);
  pds_dpmi_realmodeint_call(0x21,&RMI);
  if(!funcbit_test(RMI.flags,RMINFO_FLAG_CARRY))
   filehand=RMI.EAX&0xffff;
 }else
#endif
  filehand=sopen(filename,mode,SH_DENYWR);

#ifdef __DOS__
 pds_filehand_unlock_entrance();
#endif

 if(filehand<0)
  filehand=0;
 return filehand;
}

int pds_open_create(char *filename,unsigned int mode)
{
 int filehand=0;

#ifdef __DOS__
 if(pds_filehand_check_entrance())
  return filehand;
 pds_filehand_lock_entrance();
 if(is_lfn_support && uselfn){
  struct rminfo RMI;
  pds_dpmi_rmi_clear(&RMI);
  RMI.EAX=0x0000716C;
  RMI.EDX=0x12;                   // truncate if exist, create if not
  RMI.EBX=(mode&0x0f)|SH_DENYWR;  // O_RDWR|O_BINARY
  RMI.DS =dm_int2x_1.segment;
  funcbit_enable(RMI.flags,RMINFO_FLAG_CARRY);
  pds_strcpy(dm_int2x_1.linearptr,filename);
  pds_dpmi_realmodeint_call(0x21,&RMI);
  if(!funcbit_test(RMI.flags,RMINFO_FLAG_CARRY))
   filehand=RMI.EAX&0xffff;
 }else
#endif
  filehand=sopen(filename,mode|O_CREAT|O_TRUNC,SH_DENYWR,S_IREAD|S_IWRITE);

#ifdef __DOS__
 pds_filehand_unlock_entrance();
#endif

 if(filehand<0)
  filehand=0;
 return filehand;
}

int pds_dos_read(int filehand,char *buf,unsigned int len)
{
 int b;
 if(filehand<1)
  return 0;
#ifdef __DOS__
 if(pds_filehand_check_entrance())
  return 0;
 pds_filehand_lock_entrance();
 funcbit_enable(mpxplay_signal_events,MPXPLAY_SIGNALTYPE_DISKACCESS);
 if(is_lfn_support && uselfn){
  if(_dos_read(filehand,buf,len,(unsigned int *)&b)!=0)
   b=0;
 }else
#endif
  b=read(filehand,buf,len);

#ifdef __DOS__
 pds_filehand_unlock_entrance();
#endif

 return b;
}

int pds_dos_write(int filehand,char *buf,unsigned int len)
{
 int b;
 if(filehand<1)
  return 0;
#ifdef __DOS__
 if(pds_filehand_check_entrance())
  return 0;
 pds_filehand_lock_entrance();
 funcbit_enable(mpxplay_signal_events,MPXPLAY_SIGNALTYPE_DISKACCESS);
 if(is_lfn_support && uselfn){
  if(_dos_write(filehand,buf,len,(unsigned int *)&b)!=0)
   b=0;
 }else
#endif
  b=write(filehand,buf,len);

#ifdef __DOS__
 pds_filehand_unlock_entrance();
#endif

 return b;
}

void pds_close(int filehand)
{
 if(filehand<1)
  return;
#ifdef __DOS__
 if(pds_filehand_check_entrance())
  return;
 pds_filehand_lock_entrance();
 if(is_lfn_support && uselfn)
  _dos_close(filehand);
 else
#endif
  close(filehand);

#ifdef __DOS__
 pds_filehand_unlock_entrance();
#endif
}

long pds_lseek(int filehand,long offset,int fromwhere)
{
 long newpos;
 if(filehand<1)
  return -1;
#ifdef __DOS__
 if(pds_filehand_check_entrance())
  return -1;
 pds_filehand_lock_entrance();
 funcbit_enable(mpxplay_signal_events,MPXPLAY_SIGNALTYPE_DISKACCESS);
#endif
 newpos=lseek(filehand,offset,fromwhere);
 //if(newpos<0)                // ???
 // newpos=pds_tell(filehand); //
#ifdef __DOS__
 pds_filehand_unlock_entrance();
#endif
 return newpos;
}

long pds_tell(int filehand)
{
 long filepos;
 if(filehand<1)
  return -1;
#ifdef __DOS__
 if(pds_filehand_check_entrance())
  return -1;
 pds_filehand_lock_entrance();
#endif
 filepos=tell(filehand);
#ifdef __DOS__
 pds_filehand_unlock_entrance();
#endif
 return filepos;
}

int pds_eof(int filehand)
{
 int flag;
 if(filehand<1)
  return 1;
#ifdef __DOS__
 if(pds_filehand_check_entrance())
  return 1;
 pds_filehand_lock_entrance();
#endif
 flag=eof(filehand);
#ifdef __DOS__
 pds_filehand_unlock_entrance();
#endif
 return flag;
}

long pds_filelength(int filehand)
{
 long filelen;
 if(filehand<1)
  return 0;
#ifdef __DOS__
 if(pds_filehand_check_entrance())
  return 0;
 pds_filehand_lock_entrance();
#endif
 filelen=filelength(filehand);
#ifdef __DOS__
 pds_filehand_unlock_entrance();
#endif
 return filelen;
}

int pds_chsize(int filehand,long size)
{
 int success;
 if(filehand<1)
  return 0;
#ifdef __DOS__
 if(pds_filehand_check_entrance())
  return 0;
 pds_filehand_lock_entrance();
#endif
 success=chsize(filehand,size);
 if(success<0)
  success=0;
 else
  success=1;
#ifdef __DOS__
 pds_filehand_unlock_entrance();
#endif
 return success;
}

// for non-audio files (playlists)
FILE *pds_fopen(char *filename,char *mode)
{
 FILE *fp=NULL;
#ifdef __DOS__
 char shortfname[300];
 if(pds_filehand_check_entrance())
  return fp;
 if(is_lfn_support && uselfn){
  pds_truename_dos(shortfname,filename);
  filename=&shortfname[0];
 }
 pds_filehand_lock_entrance();
#endif
 fp=fopen(filename,mode);
#ifdef __DOS__
 pds_filehand_unlock_entrance();
#endif
 return fp;
}

#define PDS_COPYFILE_BLOCKSIZE 65536

void pds_copyfile(char *targetfile,char *sourcefile)
{
 int srcfilept=pds_open_read(sourcefile,O_RDONLY|O_BINARY);
 char sout[64];

 if(srcfilept){
  int trgtfilept=pds_open_create(targetfile,O_WRONLY|O_BINARY);
  if(trgtfilept){
   char *buffer=pds_malloc(PDS_COPYFILE_BLOCKSIZE);
   if(buffer){
    long b,filelen=pds_filelength(srcfilept);
    b=0;
    do{
     long inbytes,outbytes;
     sprintf(sout,"Copy file : %2.1f%% ",(100.0*(float)b/(float)filelen));
     display_message(1,0,sout);
     if(pds_look_extgetch()==KEY_ESC){
      pds_extgetch();
      pds_free(buffer);
      pds_close(srcfilept);
      pds_close(trgtfilept);
      pds_unlink(targetfile);
      clear_message();
      return;
     }
     inbytes=pds_dos_read(srcfilept,buffer,PDS_COPYFILE_BLOCKSIZE);
     if(inbytes<=0)
      break;
     outbytes=pds_dos_write(trgtfilept,buffer,inbytes);
     if(outbytes<inbytes)
      break;
     b+=outbytes;
    }while(b<filelen);
    pds_free(buffer);
   }
   pds_close(trgtfilept);
  }
  pds_close(srcfilept);
 }
 clear_message();
}
