//**************************************************************************
//*                     This file is part of the                           *
//*                      Mpxplay - audio player.                           *
//*                  The source code of Mpxplay is                         *
//*        (C) copyright 1998-2005 by PDSoft (Attila Padar)                *
//*                    http://mpxplay.cjb.net                              *
//*                  email: mpxplay@freemail.hu                            *
//**************************************************************************
//*  This program is distributed in the hope that it will be useful,       *
//*  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
//*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                  *
//*  Please contact with the author (with me) if you want to use           *
//*  or modify this source.                                                *
//**************************************************************************
//function: DPMI callings

#ifdef __DOS__

#include <i86.h>
#include "newfunc.h"

void far *pds_dpmi_getrmvect(unsigned int intno)
{
 union REGS regs;
 pds_newfunc_regs_clear(&regs);
 regs.w.ax=0x0200;
 regs.h.bl=intno;
 int386(0x31, &regs, &regs);
 return MK_FP(regs.w.cx, regs.x.edx);
}

void pds_dpmi_setrmvect(unsigned int intno, unsigned int segment,unsigned int offset)
{
 union REGS regs;
 pds_newfunc_regs_clear(&regs);
 regs.w.ax=0x0201;
 regs.h.bl=intno;
 regs.w.cx=segment;
 regs.x.edx=offset;
 int386(0x31, &regs, &regs);
}

void far *pds_dpmi_getexcvect(unsigned int intno)
{
 union REGS regs;
 pds_newfunc_regs_clear(&regs);
 regs.w.ax=0x202;
 regs.h.bl=intno;
 int386(0x31, &regs, &regs);
 return MK_FP(regs.w.cx, regs.x.edx);
}

void pds_dpmi_setexcvect(unsigned int intno, void far *vect)
{
 union REGS regs;
 pds_newfunc_regs_clear(&regs);
 regs.w.ax=0x203;
 regs.h.bl=intno;
 regs.w.cx=FP_SEG(vect);
 regs.x.edx=FP_OFF(vect);
 int386(0x31, &regs, &regs);
}

void far *pds_dos_getvect(unsigned int intno)
{
 struct SREGS sregs;
 union REGS regs;
 pds_newfunc_sregs_clear(&sregs);
 pds_newfunc_regs_clear(&regs);
 regs.h.ah=0x35;
 regs.h.al=intno;
 sregs.ds=sregs.es=0;
 int386x(0x21, &regs, &regs, &sregs);
 return MK_FP(sregs.es, regs.x.ebx);
}

void pds_dos_setvect(unsigned int intno, void far *vect)
{
 struct SREGS sregs;
 union REGS regs;
 pds_newfunc_sregs_clear(&sregs);
 pds_newfunc_regs_clear(&regs);
 regs.h.ah=0x25;
 regs.h.al=intno;
 regs.x.edx=FP_OFF(vect);
 sregs.ds=FP_SEG(vect);
 sregs.es=0;
 int386x(0x21, &regs, &regs, &sregs);
}

int pds_dpmi_dos_allocmem(dosmem_t *dm,unsigned int size)
{
 union REGS regs;
 if(dm->selector){
  pds_dpmi_dos_freemem(dm);
  dm->selector=0;
 }
 pds_newfunc_regs_clear(&regs);
 regs.x.eax = 0x0100;
 regs.x.ebx = (size+15)>>4;
 regs.x.cflag=1;
 int386(0x31,&regs,&regs);
 if(regs.x.cflag)
  return 0;
 dm->selector=regs.x.edx;
 dm->segment=(unsigned short)regs.x.eax;
 dm->linearptr=(void *)(regs.x.eax<<4);
 return 1;
}

void pds_dpmi_dos_freemem(dosmem_t *dm)
{
 union REGS regs;
 if(dm->selector){
  pds_newfunc_regs_clear(&regs);
  regs.x.eax = 0x0101;
  regs.x.edx = dm->selector;
  int386(0x31, &regs, &regs);
  dm->selector=dm->segment=0;
  dm->linearptr=NULL;
 }
}

void pds_dpmi_realmodeint_call(unsigned int intnum,struct rminfo *rmi)
{
 union REGS regs;
 pds_newfunc_regs_clear(&regs);
 regs.w.ax=0x0300;
 regs.w.bx=intnum;
 regs.x.edi=(unsigned long)(rmi);
 int386(0x31,&regs,&regs);
}

/*void pds_dpmi_rmi_clear(struct rminfo *rmi)
{
 pds_memset((void *)rmi,0,sizeof(struct rminfo));
}*/

#endif // __DOS__
