//**************************************************************************
//*                     This file is part of the                           *
//*                      Mpxplay - audio player.                           *
//*                  The source code of Mpxplay is                         *
//*        (C) copyright 1998-2005 by PDSoft (Attila Padar)                *
//*                    http://mpxplay.cjb.net                              *
//*                  email: mpxplay@freemail.hu                            *
//**************************************************************************
//*  This program is distributed in the hope that it will be useful,       *
//*  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
//*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                  *
//*  Please contact with the author (with me) if you want to use           *
//*  or modify this source.                                                *
//**************************************************************************
//function: in-file handling - main/common routines

#include "in_file.h"
#include "in_funcs.h"
#include "mpxinbuf.h"
#include "au_mixer\au_mixer.h"
#include "au_mixer\mix_func.h"
#include "au_cards\au_cards.h"
#include "newfunc\dll_load.h"

extern frame fr[3];

static struct mpxplay_infile_func_s *all_infile_funcs[]={
#ifdef MPXPLAY_LINK_INFILE_AAC
 &IN_AAC_funcs,
#endif
#ifdef MPXPLAY_LINK_INFILE_MP4
 &IN_MP4_funcs,
#endif
#ifdef MPXPLAY_LINK_INFILE_AC3
 &IN_AC3_funcs,
#endif
#ifdef MPXPLAY_LINK_INFILE_APE
 &IN_APE_funcs,
#endif
#ifdef MPXPLAY_LINK_INFILE_ASF
 &IN_ASF_funcs,
#endif
#ifdef MPXPLAY_LINK_INFILE_CDW
 &IN_CDW_funcs,
#endif
#ifdef MPXPLAY_LINK_INFILE_DTS
 &IN_DTS_funcs,
#endif
#ifdef MPXPLAY_LINK_INFILE_FLAC
 &IN_FLAC_funcs,
#endif
#ifdef MPXPLAY_LINK_INFILE_MPC
 &IN_MPC_funcs,
#endif
#ifdef MPXPLAY_LINK_INFILE_OGG
 &IN_OGG_funcs,
#endif
#ifdef MPXPLAY_LINK_INFILE_WAV
 &IN_WAV_funcs,
#endif
#ifdef MPXPLAY_LINK_INFILE_MPX // it's last due to the bad autodetection
 &IN_MP3_funcs,
#endif
 NULL
};

#define LAST_INFILE_FUNCNUM (sizeof(all_infile_funcs)/sizeof(mpxplay_infile_func_s *)-2)

#ifdef MPXPLAY_LINK_DLLLOAD

static struct infiledlltype_s{
 unsigned int dlltype;
 unsigned int modulever;
}infiledlltypes[]=
{
 {MPXPLAY_DLLMODULETYPE_FILEIN_PARSER,   MPXPLAY_DLLMODULEVER_FILEIN_PARSER},
 {MPXPLAY_DLLMODULETYPE_FILEIN_CONTAINER,MPXPLAY_DLLMODULEVER_FILEIN_CONTAINER},
 {0,0}
};

#endif

static unsigned int infile_checkhead_by_ext(struct frame *frp,struct mpxplay_infile_func_s *infilefuncs,char *filename,char *extension,unsigned int *extfound);
static void clear_pcmout(struct mpxplay_audio_decoder_info_s *adi);

extern char *id3tagset[I3I_MAX+1];
extern unsigned int crossfadepart,playcontrol;

static struct mpxplay_infile_info_s        infile_infos[3];
static struct mpxplay_audio_decoder_info_s audiodecoder_infos[3];
char mpxplay_tag_year[8];

int infile_decode(struct audio_info *aui)
{
 long retcode;
 unsigned int fileselect;
 struct frame *frp0=aui->mvp->frp0,*frp;

 for(fileselect=0,frp=frp0;fileselect<=((crossfadepart==CROSS_FADE)? 1:0);fileselect++,frp++){
  struct mpxplay_audio_decoder_info_s *adi=frp->infile_infos->audio_decoder_infos;
  if(frp->seektype){
   if(frp->infile_funcs && frp->infile_funcs->seek_postprocess)
    frp->infile_funcs->seek_postprocess(frp->filebuf_funcs,frp,frp->infile_datas,frp->infile_infos,frp->seektype);
   frp->seektype=0;
  }

  retcode=MPXPLAY_ERROR_INFILE_EOF;
  adi->pcmoutsamplenum=0;
  if(frp->infile_funcs && frp->infile_funcs->decode)
   retcode=frp->infile_funcs->decode(frp->filebuf_funcs,frp,frp->infile_datas,frp->infile_infos);

  if(!adi->pcmoutsamplenum && ((retcode==MPXPLAY_ERROR_INFILE_EOF) || (retcode==MPXPLAY_ERROR_INFILE_NODATA))){
   if(fileselect){ // if crossfade
    clear_pcmout(adi);
    crossfade_part_step(aui->mvp);
   }else{
    funcbit_disable(aui->card_controlbits,AUINFOS_CARDCNTRLBIT_DMADONTWAIT);
    return retcode;
   }
  }

  if(adi->pcmoutsamplenum){
   frp->frameNum++;
   frp->framecounter++;
   MIXER_conversion(aui,adi);
  }
 }

 MIXER_main(aui,frp0->infile_infos->audio_decoder_infos);

 AU_writedata(aui);

 return 0;
}

//--------------------------------------------------------------------------
// is extension supported?
unsigned int infile_check_extension(char *filename)
{
 unsigned int i,j;
 char *extension;

 extension=pds_strrchr(filename,'.');
 if(extension && extension[1]){
  extension++;
  for(i=0;i<=LAST_INFILE_FUNCNUM;i++){
   j=0;
   while(all_infile_funcs[i]->file_extensions[j]){
    if(pds_stricmp(all_infile_funcs[i]->file_extensions[j],extension)==0)
     return 1;
    j++;
   }
  }
#ifdef MPXPLAY_LINK_DLLLOAD
  i=0;
  do{
   mpxplay_module_entry_s *dll_infile=NULL;
   do{
    dll_infile=newfunc_dllload_getmodule(infiledlltypes[i].dlltype,0,NULL,dll_infile);
    if(dll_infile){
     if(dll_infile->module_structure_version==infiledlltypes[i].modulever){ // !!!
      struct mpxplay_infile_func_s *inf=(struct mpxplay_infile_func_s *)dll_infile->module_callpoint;
      if(inf->file_extensions[0]){
       j=0;
       do{
        if(pds_stricmp(inf->file_extensions[j],extension)==0)
         return 1;
        j++;
       }while(inf->file_extensions[j]);
      }else{
       if(infile_checkhead_by_ext(&fr[3],inf,filename,extension,&j))
        return 1;
      }
     }
    }
   }while(dll_infile);
   i++;
  }while(infiledlltypes[i].dlltype);
#endif
 }
 return 0;
}

unsigned int infile_get_samplenum_per_frame(unsigned int freq)
{
 unsigned int samplenum;
 if(freq>=32000 && freq<=48000)  // match with MPEG 1.0 and AC3 freqs (samplenum match at crossfade)
  samplenum=PCM_OUTSAMPLES;
 else
  if((freq>=16000 && freq<=24000) || (freq>=8000 && freq<=12000)) // match with MPEG 2.x freqs
   samplenum=PCM_OUTSAMPLES/2;
  else
   samplenum=((PCM_OUTSAMPLES*freq)+22050)/44100;

 if(samplenum>PCM_MAX_SAMPLES)
  samplenum=PCM_MAX_SAMPLES;

 // fixme: round it to get matched samplenums at -cf after freq conversion

 return samplenum;
}

void miis_to_frp(struct mpxplay_infile_info_s *miis,struct frame *frp)
{
 struct mpxplay_audio_decoder_info_s *adi=miis->audio_decoder_infos;
 float timef;

 frp->filetype=HFT_FILE_INT;
 frp->filesize=miis->filesize;

 // calculate samplenum
 if(!adi->pcmsamplenum_frame)
  adi->pcmsamplenum_frame=infile_get_samplenum_per_frame(adi->freq);

 // calculate allframes (if decoder didn't set)
 if(miis->allframes>1)
  frp->allframes=miis->allframes;
 else{
  if(adi->pcmdatalen)
   frp->allframes=(adi->pcmdatalen+(adi->pcmsamplenum_frame/2))/adi->pcmsamplenum_frame;
  else
   if(adi->bitrate)
    pds_ftoi((float)frp->filesize/(float)adi->bitrate*(float)adi->freq/(1000.0/8.0)/(float)adi->pcmsamplenum_frame,&frp->allframes);
   else
    pds_ftoi((float)miis->timesec*(float)adi->freq/(float)adi->pcmsamplenum_frame,&frp->allframes);
  if(frp->allframes<1)
   frp->allframes=1;
  miis->allframes=frp->allframes;
 }
 //if(!adi->pcmdatalen)
 // adi->pcmdatalen=frp->allframes*adi->pcmsamplenum_frame;

 // calculate timesec (if decoder didn't set)
 timef=miis->timesec;
 if(miis->timesec>1)
  frp->timesec=miis->timesec;
 else{
  if(adi->pcmdatalen)
   frp->timesec=(adi->pcmdatalen+(adi->freq/2))/adi->freq;
  else
   if(adi->bitrate){
    timef=(float)frp->filesize/(1000.0/8.0)/(float)adi->bitrate;
    pds_ftoi(timef,&frp->timesec);
   }
  miis->timesec=frp->timesec;
 }
 if(!adi->pcmdatalen)
  adi->pcmdatalen=timef*adi->freq;

 if(adi->infobits&ADI_FLAG_FLOATOUT)
  adi->bytespersample=sizeof(PCM_CV_TYPE_F);
 else
  if(!adi->bytespersample)
   adi->bytespersample=(adi->bits+7) >> 3;
}

static unsigned long infile_get_header_autodetect(struct frame *frp,char *filename)
{
 unsigned int i;

 for(i=0;i<=LAST_INFILE_FUNCNUM;i++){
  if(all_infile_funcs[i]->detect){
   infile_close(frp);
   frp->infile_funcs=all_infile_funcs[i];
   if(frp->infile_funcs->own_filehand_funcs)
    frp->filehand_funcs=frp->infile_funcs->own_filehand_funcs;
   frp->infile_datas=frp->infile_funcs->detect(frp->filebuf_funcs,frp,filename,frp->infile_infos);
   if(frp->infile_datas){
    miis_to_frp(frp->infile_infos,frp); // !!!
    return 1;
   }
  }
 }
 return 0;
}

static unsigned int infile_checkhead_by_ext(struct frame *frp,struct mpxplay_infile_func_s *infilefuncs,char *filename,char *extension,unsigned int *extfound)
{
 unsigned int j=0;
 do{
  if(!infilefuncs->file_extensions[0] || pds_stricmp(infilefuncs->file_extensions[j],extension)==0){
   if(infilefuncs->file_extensions[j])
    *extfound=1;
   if(infilefuncs->check){
    infile_close(frp);
    frp->infile_funcs=infilefuncs;
    if(frp->infile_funcs->own_filehand_funcs)
     frp->filehand_funcs=frp->infile_funcs->own_filehand_funcs;
    frp->infile_datas=frp->infile_funcs->check(frp->filebuf_funcs,frp,filename,frp->infile_infos);
    if(frp->infile_datas){
     miis_to_frp(frp->infile_infos,frp); // !!!
     return 1;
    }else{
     if(frp->infile_funcs==&IN_WAV_funcs){           // hacking
      if(infile_get_header_autodetect(frp,filename)) // WAV may contain other (non-PCM) audio data
       return 1;
     }
    }
   }
  }
  if(!infilefuncs->file_extensions[0])
   break;
  j++;
 }while(infilefuncs->file_extensions[j]);
 return 0;
}

unsigned long infile_get_header_by_ext(struct frame *frp,char *filename)
{
 unsigned int i,extfound=0;
 char *extension;

 infile_close(frp);

 extension=pds_strrchr(filename,'.');
 if(extension && extension[1]){
  extension++;

  //check builtin infiles
  for(i=0;i<=LAST_INFILE_FUNCNUM;i++)
   if(infile_checkhead_by_ext(frp,all_infile_funcs[i],filename,extension,&extfound))
    return 1;

#ifdef MPXPLAY_LINK_DLLLOAD
  // check DLLs
  i=0;
  do{
   mpxplay_module_entry_s *dll_infile=NULL;
   do{
    dll_infile=newfunc_dllload_getmodule(infiledlltypes[i].dlltype,0,NULL,dll_infile);
    if(dll_infile){
     if(dll_infile->module_structure_version==infiledlltypes[i].modulever){ // !!!
      if(infile_checkhead_by_ext(frp,(struct mpxplay_infile_func_s *)dll_infile->module_callpoint,filename,extension,&extfound)){
       frp->filetype=HFT_FILE_DLL;
       //frp->infile_funcs=(struct mpxplay_infile_func_s *)dll_infile;
       //newfunc_dllload_disablemodule(0,0,NULL,dll_infile);
       return 1;
      }
      //newfunc_dllload_disablemodule(0,0,NULL,dll_infile);
     }
    }
   }while(dll_infile);
   i++;
  }while(infiledlltypes[i].dlltype);
#endif
 }

 if(!extfound)  // unknown or missing file extension
  if(infile_get_header_autodetect(frp,filename))
   return 1;

 return 0;
}

static void infile_assign_funcs(struct frame *frp)
{
 if(frp->infile_funcs){
  /*if(frp->filetype==HFT_FILE_DLL){
   mpxplay_module_entry_s *dll_infile=(mpxplay_module_entry_s *)frp->infile_funcs;
   if(newfunc_dllload_reloadmodule(dll_infile))
    frp->infile_funcs=(struct mpxplay_infile_func_s *)dll_infile->module_callpoint;
   else
    frp->infile_funcs=NULL;
  }
  if(frp->infile_funcs)*/
   if(frp->infile_funcs->own_filehand_funcs)
    frp->filehand_funcs=frp->infile_funcs->own_filehand_funcs;
 }
}

char *infile_get_id3tag(struct frame *frp,char **id3ip,char *id3p)
{
 infile_assign_funcs(frp);
 if(frp->infile_funcs && frp->infile_funcs->get_id3tag)
  id3p=frp->infile_funcs->get_id3tag(frp->filebuf_funcs,frp,frp->infile_datas,id3ip,id3p,&mpxplay_playlist_textconv_funcs);
 return id3p;
}

int infile_write_id3tag(struct frame *frp,char *filename,char **id3ip)
{
 int error=MPXPLAY_ERROR_INFILE_CANTOPEN;

 infile_assign_funcs(frp);

 if(frp->infile_funcs){
  if(frp->infile_funcs->write_id3tag){
   struct mpxplay_filehand_buffered_func_s *fbfs=frp->filebuf_funcs;
   unsigned int i;

   if(!fbfs->fopen_write(frp,filename))
    return error;

   for(i=0;i<=I3I_MAX;i++)
    if(id3tagset[i])
     id3ip[i]=id3tagset[i];

   if(!id3ip[I3I_YEAR])
    id3ip[I3I_YEAR]=&mpxplay_tag_year[0];

   error=frp->infile_funcs->write_id3tag(fbfs,frp,id3ip);

   fbfs->fclose(frp);
  }else{
   error=MPXPLAY_ERROR_INFILE_WRITETAG_FILETYPE;
  }
 }

 return error;
}

long infile_fseek(struct frame *frp,long framenum_set)
{
 if(frp->infile_funcs && frp->infile_funcs->fseek)
  framenum_set=frp->infile_funcs->fseek(frp->filebuf_funcs,frp,frp->infile_datas,frp->infile_infos,framenum_set);

 return framenum_set;
}

//--------------------------------------------------------------------------
static void clear_infile_infos(struct mpxplay_infile_info_s *miis)
{
 if(miis){ // it can be NULL at 'soundcard init failed'
  struct mpxplay_audio_decoder_info_s *adi;

  miis->filesize=0;
  miis->timesec=0;
  miis->allframes=1;
  miis->audio_decoder_funcs=NULL;
  miis->audio_decoder_datas=NULL;

  adi=miis->audio_decoder_infos;
  if(adi){
   adi->infobits=0;
   if(playcontrol&PLAYC_BITSTREAMOUT)
    funcbit_enable(adi->infobits,ADI_CNTRLBIT_BITSTREAMOUT);
   adi->wave_id=0;
   adi->freq=0;
   adi->filechannels=0;
   adi->outchannels=0;
   if(adi->chanmatrix)
    pds_memset(adi->chanmatrix,0,MPXPLAY_AUCHAN_MAX*sizeof(*adi->chanmatrix));
   adi->bits=0;
   adi->bitrate=0;
   adi->bytespersample=0;
   adi->pcmdatalen=0;
   adi->longname=NULL;
   adi->shortname=NULL;
   adi->bitratetext=NULL;
   adi->freqtext=NULL;
   adi->channeltext=NULL;
   adi->pcmsamplenum_frame=0;
   adi->pcmoutsamplenum=0;
   clear_pcmout(adi);
  }
 }
}

static void clear_pcmout(struct mpxplay_audio_decoder_info_s *adi)
{
 int i,*p=(int *)adi->pcm_outdatabuf;
 if(p)
  for(i=(adi->pcmoutdatabuf_size/sizeof(int));i;i--)
   *p++=0;
}

static void clear_frame(struct frame *frp)
{
 frp->filetype=0;
 frp->seektype=0;
 frp->mpxfilept=0;
 frp->filesize=0;
 frp->filepos=0;
 frp->frameNum=0;
 frp->framecounter=0;
 frp->pcmdatapos=0;
 frp->allframes=1;      // division by zero bugfix
 frp->timesec=0;

 frp->buffertype=0;
 frp->prebuffergetp=0;
 frp->prebufferputp=0;
 frp->prebufferbytes_rewind=0;
 frp->prebufferbytes_forward=0;

 frp->filehand_funcs=NULL;
 frp->filehand_datas=NULL;

 frp->infile_funcs=NULL;
 frp->infile_datas=NULL;
}

//------------------------------------------------------------------------

int infile_open(struct frame *frp,char *filename)
{
 infile_assign_funcs(frp);

 if(frp->infile_funcs && frp->infile_funcs->open){
  frp->infile_datas=frp->infile_funcs->open(frp->filebuf_funcs,frp,filename,frp->infile_infos);
  if(frp->infile_datas){
   miis_to_frp(frp->infile_infos,frp);
   return 1;
  }
 }
 return 0;
}

void infile_reset(struct frame *frp)
{
 frp->seektype=0;
 frp->prebufferbytes_forward=0;
 frp->prebufferbytes_rewind=0;
}

void infile_close(struct frame *frp)
{
 infile_reset(frp);
 if(frp->infile_funcs && frp->infile_datas && frp->infile_funcs->close)
  frp->infile_funcs->close(frp->filebuf_funcs,frp,frp->infile_datas,frp->infile_infos);
 clear_infile_infos(frp->infile_infos);
 clear_frame(frp);
}

unsigned int infile_realloc_pcmoutdata(struct mpxplay_audio_decoder_info_s *adi,struct audio_info *aui)
{
 long newpcmbufsize;
 //char sout[100];

 pds_ftoi((float)(2*adi->pcmsamplenum_frame*max(adi->outchannels,aui->chan_card)) // *2 speed_control max expansion
          *(float)(max(aui->freq_card,adi->freq))/(float)adi->freq,&newpcmbufsize);
 newpcmbufsize*=sizeof(MPXPLAY_PCMOUT_FLOAT_T); // in bytes (!!! 4-bytes align to clear_pcmout)

 //sprintf(sout,"%d %d %d",newpcmbufsize,adi->pcmoutdatabuf_size,PCM_BUFFER_SIZE);
 //display_message(1,0,sout);
 //getch();

 if(newpcmbufsize>adi->pcmoutdatabuf_size){
  adi->pcmoutdatabuf_size=newpcmbufsize;
  if(adi->pcm_outdatabuf)
   pds_free(adi->pcm_outdatabuf);
  adi->pcm_outdatabuf=pds_malloc(adi->pcmoutdatabuf_size);
  if(!adi->pcm_outdatabuf){
   adi->pcmoutdatabuf_size=0;
   return 0;
  }
 }
 return 1;
}

//-------------------------------------------------------------------------
static unsigned int infile_initialized;

void infile_init(struct mainvars *mvp)
{
 struct frame *frp=mvp->frp0;
 unsigned int i=0;

 do{
  frp->infile_infos=&infile_infos[i];
  clear_infile_infos(frp->infile_infos);
  frp->infile_infos->audio_decoder_infos=&audiodecoder_infos[i];
  if(i<2){
   struct mpxplay_audio_decoder_info_s *adi=frp->infile_infos->audio_decoder_infos;
   if(!adi->pcm_outdatabuf){
    adi->pcm_outdatabuf=pds_malloc(PCM_BUFFER_SIZE);
    if(adi->pcm_outdatabuf)
     adi->pcmoutdatabuf_size=PCM_BUFFER_SIZE;
   }
  }
  frp++;
  i++;
 }while(i<3);

 for(i=0;i<=LAST_INFILE_FUNCNUM;i++){
  if(all_infile_funcs[i]->preinit)
   all_infile_funcs[i]->preinit();
 }

 i=pds_getdate();
 sprintf(&mpxplay_tag_year[0],"%4d/%2.2d",i>>16,(i>>8)&0xff);
 infile_initialized=1;
}

void infile_deinit(void)
{
 unsigned int i;
 struct mpxplay_audio_decoder_info_s *adi;

 if(!infile_initialized)
  return;

 for(i=0;i<2;i++){
  infile_close(&fr[i]);
  adi=fr[i].infile_infos->audio_decoder_infos;
  if(adi){
   if(adi->pcm_outdatabuf){
    pds_free(adi->pcm_outdatabuf);
    adi->pcm_outdatabuf=NULL;
   }
   adi->pcmoutdatabuf_size=0;
  }
 }

 for(i=0;i<=LAST_INFILE_FUNCNUM;i++){
  if(all_infile_funcs[i]->deinit)
   all_infile_funcs[i]->deinit();
 }
}
