//**************************************************************************
//*                     This file is part of the                           *
//*                      Mpxplay - audio player.                           *
//*                  The source code of Mpxplay is                         *
//*        (C) copyright 1998-2005 by PDSoft (Attila Padar)                *
//*                    http://mpxplay.cjb.net                              *
//*                  email: mpxplay@freemail.hu                            *
//**************************************************************************
//*  This program is distributed in the hope that it will be useful,       *
//*  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
//*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                  *
//*  Please contact with the author (with me) if you want to use           *
//*  or modify this source.                                                *
//**************************************************************************
//function: display-screen handling

#include "newfunc\newfunc.h"
#include "display.h"
#include "au_cards\au_cards.h"
#include "control\cntfuncs.h"
#include "playlist\playlist.h"
#include "visualpi.h"

extern struct buttons dk[];
extern struct desktoppos dtp;

static struct editor ed[PLAYLIST_MAX_SIDES];

static void fullscreeninit(void);
static void draw_info_borders(void);
static void draw_button_boxes(void);
static void draw_button_intext(void);
static void draw_analiser_dots(void);
static void draw_editor_borders(void);
static void draw_songpos_line(void);
static void draw_listpos_line(void);
static void refresh_display(struct mainvars *mvp);
       void refresh_desktop(struct mainvars *mvp);
static void draw_songpos_head(struct mainvars *);
static void display_allframes(struct mainvars *);
static void display_timepos(struct mainvars *);
static void display_option_vol(struct mainvars *);
static void display_options(struct mainvars *);
static void draw_one_id3info_line(struct playlist_entry_info *pei,unsigned int lastid,unsigned int col,unsigned int endcol,unsigned int color,unsigned int y,unsigned int showfilename);
static void draw_volume_nofe(void);
static void draw_volume_fe(unsigned int);
static void clear_analiser_peeks(void);
static void draw_spectrum_analiser(unsigned long *analpt);
//static void draw_spectrum_analiser(unsigned int);
static void setmousecursorpalette(void);
static void init_editorpos(struct mainvars *);
static void draw_elevator_pos(struct playlist_side_info *,unsigned int side);
static unsigned int set_editorline_color(struct playlist_side_info *,struct playlist_entry_info *);

extern int MIXER_var_volume,MIXER_var_surround,MIXER_var_speed;
extern int MIXER_var_swapchan,MIXER_var_usehq,MIXER_var_autovolume,MIXER_var_balance;
extern unsigned int intsoundcontrol,playreplay,playrand,playcontrol;
extern unsigned int crossfadepart,editorsideborder;
extern unsigned int refdisp,displaymode,desktopmode,maxx,maxy,oldposrow;
extern unsigned int timemode;
extern unsigned long allcputime,allcpuusage;
extern unsigned int analtabnum,mouse_on,lastmousebox;

static char  editorchars[10]="ĳɻȼ̹";
//static char  editorchars[10]="ĳڿô";
//static char  editorchars[10]="ͺɻȼ̹";
static unsigned int lastmousec,lastmousex,lastmousey,lastsongpos;
static unsigned int allsongnum,currsongnum;
static unsigned int analdiff;
static char souttext[512];
static unsigned long vol_save[2];
unsigned long analtab[5][32],volnum[5][2];

//**************************************************************************
// desktop (display) init and close routines
//**************************************************************************
static unsigned int disp_init_ok;

void mpxplay_display_init(struct mainvars *mvp)
{
 unsigned int i;
 struct editor *edp;
 struct playlist_side_info *psi;
 display_visual_data_s *vds;

 pds_textdisplay_setcursorshape(TEXTCURSORSHAPE_HIDDEN);  // disable cursor
 if(displaymode&DISP_FULLSCREEN){
  pds_textdisplay_vidmem_save();
  if(displaymode&DISP_50LINES)
   pds_textdisplay_setresolution(50);
 }else{
  if(displaymode&DISP_VERBOSE){
   oldposrow+=2;
   if(oldposrow>maxy){
    pds_textdisplay_scrollup(2);
    oldposrow=maxy;
   }
  }
  dtp.timepos_fe=oldposrow;
 }
 analdiff=(mvp->aui->card_controlbits&AUINFOS_CARDCNTRLBIT_DOUBLEDMA)? 1:4;

 psi=mvp->psi0;
 edp=&ed[0];

 for(i=0;i<PLAYLIST_MAX_SIDES;i++,edp++,psi++)
  edp->from=psi->firstentry;

 mpxplay_display_buttons_init();

 mpxplay_timer_addfunc(&refresh_display,mvp,MPXPLAY_TIMERTYPE_REPEAT,mpxplay_timer_secs_to_counternum(1)/18);
 mpxplay_timer_addfunc(&refresh_desktop,mvp,MPXPLAY_TIMERTYPE_REPEAT,0);

 vds=mvp->vds;
 vds->channelnum=PCM_MAX_CHANNELS;
 vds->soundvolumes=&vol_save[0];
 vds->bandnum=32;
 vds->analbands=&analtab[0][0];
 vds->anal_freq_range=22050;
 vds->displaymode=displaymode;

 display_visualpi_init(vds);

 disp_init_ok=1;
}

void mpxplay_display_close(void)
{
 if(disp_init_ok){
  disp_init_ok=0;
  display_visualpi_close();
  if(displaymode&DISP_FULLSCREEN){
   pds_textdisplay_resetcolorpalette();
   pds_textdisplay_vidmem_restore();
  }else{
   if(displaymode&DISP_VERBOSE)
    pds_textdisplay_gotoxy(0,max(oldposrow-1,dtp.timepos_fe));
  }
  pds_textdisplay_setcursorshape(TEXTCURSORSHAPE_NORMAL);    // enable cursor
 }
}

static void dtp_init_values(void)
{
 if(!(displaymode&DISP_FULLSCREEN))
  return;
 lastsongpos=1;
 pds_textdisplay_clrscr();
 if(displaymode&DISP_NOFULLEDIT){
  if((displaymode&DISP_50LINES) || (maxy>=50)){ // maxy>=50 : more than 50 lines (set externally)
   dtp.endofbuttonsy=14;
   dtp.volline=14;
  }else{
   dtp.endofbuttonsy=10;
   dtp.volline=9;
  }
  clear_analiser_peeks();
 }else{
  if(displaymode&DISP_VERBOSE)
   dtp.timepos_fe=2;
  else
   dtp.timepos_fe=0;
  dtp.volline=dtp.timepos_fe;
  dtp.endofbuttonsy=dtp.timepos_fe-1;
  if(displaymode&DISP_TIMEPOS)
   dtp.endofbuttonsy++;
 }
 dtp.songposline_y=dtp.endofbuttonsy+1+dtp.relative_songposline;
 dtp.editorbegin=dtp.songposline_y;
 if(desktopmode&DTM_SONGPOS)
  dtp.editorbegin++;

 dtp.editorend=maxy;
 if(desktopmode&DTM_LISTPOS){
  dtp.listposline_y=dtp.editorend;
  dtp.editorend--;
 }
 if(mouse_on){
  mpxplay_control_mouse_setrange((maxx-1),maxy);
  mpxplay_control_mouse_getpos(&lastmousex,&lastmousey);
  lastmousec=pds_textdisplay_getbkcolorxy(lastmousex,lastmousey);
  pds_textdisplay_setbkcolorxy(CL_MOUSECURSOR,lastmousex,lastmousey);
 }
 pds_textdisplay_setcursorshape(TEXTCURSORSHAPE_HIDDEN);
 lastmousebox=65535;
 display_editor_resize_y(0);
}

static void dtp_init_analiser_browser(void)
{
 draw_analiser_dots();
 generate_browserboxes();
}

static void dtp_init_browser(void)
{
 generate_browserboxes();
}

static void dtp_init_buttons(void)
{
 if((displaymode&DISP_FULLSCREEN) && (displaymode&DISP_NOFULLEDIT)){
  draw_info_borders();
  draw_button_boxes();
  draw_button_intext();
 }
}

static void dtp_init_editor(struct mainvars *mvp)
{
 if(displaymode&DISP_FULLSCREEN){
  init_editorpos(mvp);
  draw_editor_borders();
  draw_listpos_line();
  draw_songpos_line();
 }
}

static void dtp_reset_editor(void)
{
 unsigned int i;
 struct editor *edp=&ed[0];
 for(i=0;i<PLAYLIST_MAX_SIDES;i++,edp++)
  edp->from_prev=NULL;
}

void refresh_desktop(struct mainvars *mvp)
{
 if(!refdisp)
  return;
 if(refdisp&(RDT_HEADER|RDT_VOL|RDT_OPTIONS|RDT_EDITOR)){
  LCD_refresh_once(refdisp);
 }
 if(intsoundcontrol&INTSOUND_DOSSHELL)
  return;
 if(refdisp&RDT_INIT_FULL){
  if(refdisp&RDT_INIT_VALUES)
   dtp_init_values();
  if(refdisp&RDT_INIT_ANABRO)
   dtp_init_analiser_browser();
  if(refdisp&RDT_INIT_BROWS)
   dtp_init_browser();
  if(refdisp&RDT_INIT_BTN)
   dtp_init_buttons();
  if(refdisp&RDT_INIT_EDIT)
   dtp_init_editor(mvp);
  if(refdisp&RDT_RESET_EDIT)
   dtp_reset_editor();
  refdisp&=~RDT_INIT_FULL;
 }
 if(refdisp&RDT_HEADER){
  refdisp&=~RDT_HEADER;
  display_fileinfos(mvp);
  display_allframes(mvp);
 }
 if(refdisp&RDT_VOL){
  refdisp&=~RDT_VOL;
  display_option_vol(mvp);
 }
 if(refdisp&RDT_OPTIONS){
  refdisp&=~RDT_OPTIONS;
  display_options(mvp);
 }
 if(refdisp&RDT_BROWSER){
  struct playlist_side_info *psip=mvp->psip;
  refdisp&=~RDT_BROWSER;
  allsongnum=psip->lastentry-psip->firstsong+1;
  currsongnum=playlist_getsongcounter(mvp);
  playlist_fulltime_getelapsed(mvp,1);
  draw_listpos_line();
  drawbrowser(mvp);
  draw_mouse_desktoppos(mvp,lastmousex,lastmousey);
 }
 if(refdisp&RDT_EDITOR){
  refdisp&=~RDT_EDITOR;
  draweditor(mvp);
 }
}

//------------------------------------------------------------------------
// draw desktop (init)

static void draw_info_borders(void)
{
 static char infoborders[11][49]={
 {"Ŀ"},
 {"                                         "},
 {"Ĵ"},
 {"                                              "},
 {"                                              "},
 {"Ĵ"},
 {"                                           "},
 {"Ĵ        "},
 {"                                              "},
 {"                                              "},
 {"                                      "},
 };

 struct buttons *dp=&dk[0];
 unsigned int i;

 for(i=0;i<11;i++)
  pds_textdisplay_textxybk(CL_INFOBORDER,CLB_INFOBORDER,dp->xpos,dp->ypos+i,infoborders[i]);
}

static void draw_button_boxes(void)
{
 struct buttons *dp=&dk[DK_CONTROL];
 static char boxstr[6]="ĳڿ";
 //static char boxstr[6]="ͺɻȼ";
 while(dp->boxflag!=BF_ENDOFBTN){
  if((dp->boxflag&BF_DRAWBOX) && (dp->ypos<dtp.endofbuttonsy)){
   unsigned int j;
   for(j=0;j<=dp->xsize;j++){
    pds_textdisplay_charxybk(CL_BTNBOX,CLB_BTNBOX,dp->xpos+j,dp->ypos,boxstr[0]);
    pds_textdisplay_charxybk(CL_BTNBOX,CLB_BTNBOX,dp->xpos+j,dp->ypos+dp->ysize,boxstr[0]);
   }
   for(j=0;j<=dp->ysize;j++){
    pds_textdisplay_charxybk(CL_BTNBOX,CLB_BTNBOX,dp->xpos,dp->ypos+j,boxstr[1]);
    pds_textdisplay_charxybk(CL_BTNBOX,CLB_BTNBOX,dp->xpos+dp->xsize,dp->ypos+j,boxstr[1]);
   }
   pds_textdisplay_charxybk(CL_BTNBOX,CLB_BTNBOX,dp->xpos          ,dp->ypos,boxstr[2]);
   pds_textdisplay_charxybk(CL_BTNBOX,CLB_BTNBOX,dp->xpos+dp->xsize,dp->ypos,boxstr[3]);
   pds_textdisplay_charxybk(CL_BTNBOX,CLB_BTNBOX,dp->xpos,dp->ypos+dp->ysize,boxstr[4]);
   pds_textdisplay_charxybk(CL_BTNBOX,CLB_BTNBOX,dp->xpos+dp->xsize,dp->ypos+dp->ysize,boxstr[5]);
  }
  dp++;
 }
}

static void draw_button_intext(void)
{
 struct buttons *dp=&dk[DK_FILEINFO];
 while(dp->boxflag!=BF_ENDOFBTN){
  if((dp->intext!=NULL) && (dp->ypos<dtp.endofbuttonsy)){
   if(dp->boxflag&BF_UPTEXT)
    pds_textdisplay_textxybk(CL_BTNUPTEXT,CLB_BTNUPTEXT,dp->xpos+1,dp->ypos,dp->intext);
   else
    if(dp->boxflag>BF_NONE)
     pds_textdisplay_textxybk(CL_BTNTEXTCNTRL,CLB_BTNTEXT,dp->xpos+1,dp->ypos+1,dp->intext);
    else
     pds_textdisplay_textxybk(CL_INFOTEXT,CLB_INFOTEXT,dp->xpos,dp->ypos,dp->intext);
  }
  dp++;
 }
}

static void draw_analiser_dots(void)
{
 unsigned int i,j;
 if((displaymode&DISP_NOFULLEDIT) && (displaymode&DISP_ANALISER))
  for(j=0;j<32;j++)
   for(i=0;i<=dtp.endofbuttonsy;i++)
    pds_textdisplay_charxybk(CL_ANALISER_DOTS,CLB_ANALISER,j,i,250);
}

static void draw_editor_borders(void)
{
 unsigned int j;
 if(displaymode&DISP_FULLSCREEN){
  for(j=1;j<(maxx-1);j++){
   pds_textdisplay_charxybk(CL_EDITOR_BORDER,CLB_EDITOR_BORDER,j,dtp.editorbegin,editorchars[0]);
   pds_textdisplay_charxybk(CL_EDITOR_BORDER,CLB_EDITOR_BORDER,j,dtp.editorend,editorchars[0]);
  }
  for(j=(dtp.editorbegin+1);j<dtp.editorend;j++){
   pds_textdisplay_charxybk(CL_EDITOR_BORDER,CLB_EDITOR_BORDER,0,j,editorchars[1]);
   pds_textdisplay_charxybk(CL_EDITOR_BORDER,CLB_EDITOR_BORDER,maxx-1,j,editorchars[1]);
  }
  pds_textdisplay_charxybk(CL_EDITOR_BORDER,CLB_EDITOR_BORDER,0,dtp.editorbegin,editorchars[2]);
  pds_textdisplay_charxybk(CL_EDITOR_BORDER,CLB_EDITOR_BORDER,maxx-1,dtp.editorbegin,editorchars[3]);
  pds_textdisplay_charxybk(CL_EDITOR_BORDER,CLB_EDITOR_BORDER,0,dtp.editorend,editorchars[4]);
  pds_textdisplay_charxybk(CL_EDITOR_BORDER,CLB_EDITOR_BORDER,maxx-1,dtp.editorend,editorchars[5]);
 }
}

static void draw_songpos_line(void)
{
 if((displaymode&DISP_FULLSCREEN) && (desktopmode&DTM_SONGPOS)){
  unsigned int i;
  pds_textdisplay_charxybk(CL_SONGPOS_ARROWS,CLB_SONGPOS,0,dtp.songposline_y,27);
  for(i=1;i<maxx;i++)
   pds_textdisplay_charxybk(CL_SONGPOS_DOTS,CLB_SONGPOS,i,dtp.songposline_y,'.');
  pds_textdisplay_charxybk(CL_SONGPOS_HEAD,CLB_SONGPOS,lastsongpos,dtp.songposline_y,2);
  pds_textdisplay_charxybk(CL_SONGPOS_ARROWS,CLB_SONGPOS,maxx-1,dtp.songposline_y,26);
 }
}

static void draw_listpos_line(void)
{
 if((displaymode&DISP_FULLSCREEN) && (desktopmode&DTM_LISTPOS)){
  unsigned int i,x;
  pds_textdisplay_charxybk(CL_LISTPOS_ARROWS,CLB_LISTPOS,0,dtp.listposline_y,27);
  for(i=1;i<maxx;i++)
   pds_textdisplay_charxybk(CL_LISTPOS_DOTS,CLB_LISTPOS,i,dtp.listposline_y,250);
  pds_textdisplay_charxybk(CL_LISTPOS_ARROWS,CLB_LISTPOS,maxx-1,dtp.listposline_y,26);
  if(allsongnum){
   x=(((maxx-2)*(currsongnum-1))/allsongnum)+1;
   if(x>(maxx-2))
    x=maxx-2;
   if(x<1)
    x=1;
   pds_textdisplay_charxybk(CL_LISTPOS_HEAD,CLB_LISTPOS,x,dtp.listposline_y,2);
  }
 }
}

//*************************************************************************
// desktop (display) routines (browser,buttons)
//*************************************************************************

static void refresh_display(struct mainvars *mvp)
{
 unsigned int analpos=(analtabnum+analdiff)&3;

 if(playcontrol&PLAYC_RUNNING){
  vol_save[0]=volnum[analpos][0];
  vol_save[1]=volnum[analpos][1];
 }else{
  clear_volnum();
  vol_save[0]=vol_save[1]=0;
 }

 if(!(intsoundcontrol&INTSOUND_DOSSHELL)){
  display_timepos(mvp);
  if(displaymode&DISP_FULLSCREEN){
   mvp->vds->analbands=&analtab[analpos][0];
   draw_spectrum_analiser(mvp->vds->analbands);
   draw_songpos_head(mvp);
   recolor_lastbuttonbox_key(NULL,0);
   setmousecursorpalette();
   //if(!mouse_on)
   // draw_clock();
  }
 }
 analtabnum=(analtabnum+1)&3;
 LCD_refresh_timer(mvp);
}

static void draw_songpos_head(struct mainvars *mvp)
{
 int x;

 if(desktopmode&DTM_SONGPOS){
  struct frame *frp=mvp->frp0;
  x=(((maxx-1)*frp->frameNum)/frp->allframes)+1;
  if(x>(maxx-2))
   x=maxx-2;
  if(x<1)
   x=1;
  if(x!=lastsongpos){
   pds_textdisplay_charxybk(CL_SONGPOS_DOTS,CLB_SONGPOS,lastsongpos,dtp.songposline_y,'.');
   pds_textdisplay_charxybk(CL_SONGPOS_HEAD,CLB_SONGPOS,x,dtp.songposline_y,2);
   lastsongpos=x;
  }
 }
}

//************************************************************************
// time,options,fileinfos display routines
//************************************************************************

static void display_allframes(struct mainvars *mvp)
{
 if(displaymode&DISP_FRAMES){
  pds_textdisplay_spacecxyn(CLB_BASE,0,dtp.timepos_fe,maxx);
  sprintf(souttext,"{      /%lu}",mvp->frp0->allframes);
  pds_textdisplay_textxybk(CL_BASE,CLB_BASE,0,dtp.timepos_fe,souttext);
 }
}

static void display_timepos(struct mainvars *mvp)
{
 static unsigned int cpushowdelay,cpupercent;
 unsigned int x;
 int i;
 long cframe;
 unsigned long ctime;
 float cftime;
 char sout[100];

 if(displaymode&DISP_TIMEPOS){
  struct frame *frp=mvp->frp0;
  if(!cpushowdelay--){
   cpupercent=((100*allcpuusage)/allcputime);
   cpupercent&=511;
   allcpuusage=0;
   allcputime=1;
   cpushowdelay=9;
  }
  ctime=0;
  switch(timemode){
   case 0:cframe=frp->frameNum;break;
   case 1:cframe=frp->allframes-frp->frameNum;break;
   case 2:cframe=frp->frameNum;ctime=playlist_fulltime_getelapsed(mvp,0);break;
   case 3:cframe=frp->allframes-frp->frameNum;
                 if(mvp->psip->fulltimesec)
                  ctime=mvp->psip->fulltimesec-playlist_fulltime_getelapsed(mvp,0)-frp->timesec;
                 break;
   default:cframe=frp->frameNum;
  }
  if(cframe<0)
   cframe=0;
  if(displaymode&DISP_NOFULLEDIT){
   struct buttons *dp=&dk[DK_TIMEPOS];
   sprintf(sout,"%4d",(timemode==3)? (allsongnum-currsongnum+1):currsongnum);
   pds_textdisplay_textxybk(CL_INFOTEXT,CLB_INFOTEXT,dp->xpos,dp->ypos,sout);
   pds_textdisplay_charxybk(CL_INFOBORDER,CLB_INFOBORDER,dp->xpos+4,dp->ypos,'/');
   dp++;
   sprintf(sout,"%-4d",allsongnum);
   pds_textdisplay_textxybk(CL_INFOTEXT,CLB_INFOTEXT,dp->xpos,dp->ypos,sout);
   dp++;
   ctime*=10;
   cftime=10*(float)cframe*(float)frp->timesec/(float)frp->allframes; // float needed to avoid integer overflow at huge files
   pds_ftoi(cftime,(long *)&i);
   ctime+=i;

   if(timemode<2){
    if(cframe<=999999 && frp->allframes<=999999){
     sprintf(sout,"%6d",cframe);
     pds_textdisplay_textxybk(CL_INFOTEXT,CLB_INFOTEXT,dp->xpos,dp->ypos,sout);
     pds_textdisplay_charxybk(CL_INFOBORDER,CLB_INFOBORDER,dp->xpos+6,dp->ypos,'/');
     sprintf(sout,"%-6d",frp->allframes);
     pds_textdisplay_textxybk(CL_INFOTEXT,CLB_INFOTEXT,dp->xpos+7,dp->ypos,sout);
    }else{
     sprintf(sout,"%13d",cframe);
     pds_textdisplay_textxybk(CL_INFOTEXT,CLB_INFOTEXT,dp->xpos,dp->ypos,sout);
    }
    dp++;
    x=dp->xpos;
    if((frp->timesec<6000) && (ctime<60000)){    // < 100 minutes (3 digits)
     sprintf(sout,"%2d",ctime/600);          // mm:ss.t
     pds_textdisplay_textxybk(CLH_INFOTEXT,CLB_INFOTEXT,x,dp->ypos,sout);
     x+=2;
     pds_textdisplay_charxybk(CL_INFOBORDER,CLB_INFOBORDER,x,dp->ypos,':');
     x++;
     sprintf(sout,"%2.2d",(ctime/10)%60);
     pds_textdisplay_textxybk(CLH_INFOTEXT,CLB_INFOTEXT,x,dp->ypos,sout);
     x+=2;
     pds_textdisplay_charxybk(CL_INFOBORDER,CLB_INFOBORDER,x,dp->ypos,'.');
     x++;
     sprintf(sout,"%1.1d",ctime%10);
     pds_textdisplay_textxybk(CLH_INFOTEXT,CLB_INFOTEXT,x,dp->ypos,sout);
     x++;
     pds_textdisplay_charxybk(CL_INFOBORDER,CLB_INFOBORDER,x,dp->ypos,'/');  // /
     x++;
     sprintf(sout,"%2d",frp->timesec/60);      // mm:ss
     pds_textdisplay_textxybk(CL_INFOTEXT,CLB_INFOTEXT,x,dp->ypos,sout);
     x+=2;
    }else{
     sprintf(sout,"%3d",ctime/600);           // mmm:ss
     pds_textdisplay_textxybk(CLH_INFOTEXT,CLB_INFOTEXT,x,dp->ypos,sout);
     x+=3;
     pds_textdisplay_charxybk(CL_INFOBORDER,CLB_INFOBORDER,x,dp->ypos,':');
     x++;
     sprintf(sout,"%2.2d",(ctime/10)%60);
     pds_textdisplay_textxybk(CLH_INFOTEXT,CLB_INFOTEXT,x,dp->ypos,sout);
     x+=2;
     pds_textdisplay_charxybk(CL_INFOBORDER,CLB_INFOBORDER,x,dp->ypos,'/');  // /
     x++;
     sprintf(sout,"%3d",frp->timesec/60);      // mmm:ss
     pds_textdisplay_textxybk(CL_INFOTEXT,CLB_INFOTEXT,x,dp->ypos,sout);
     x+=3;
    }
    pds_textdisplay_charxybk(CL_INFOBORDER,CLB_INFOBORDER,x,dp->ypos,':');
    x++;
    sprintf(sout,"%2.2d",frp->timesec%60);
    pds_textdisplay_textxybk(CL_INFOTEXT,CLB_INFOTEXT,x,dp->ypos,sout);
   }else{
    sprintf(sout,"%5d",ctime/36000);
    pds_textdisplay_textxybk(CLH_INFOTEXT,CLB_INFOTEXT,dp->xpos,dp->ypos,sout);
    pds_textdisplay_charxybk(CL_INFOBORDER,CLB_INFOBORDER,dp->xpos+5,dp->ypos,':');
    sprintf(sout,"%2.2d",(ctime/600)%60);
    pds_textdisplay_textxybk(CLH_INFOTEXT,CLB_INFOTEXT,dp->xpos+6,dp->ypos,sout);
    pds_textdisplay_charxybk(CL_INFOBORDER,CLB_INFOBORDER,dp->xpos+8,dp->ypos,':');
    sprintf(sout,"%2.2d",(ctime/10)%60);
    pds_textdisplay_textxybk(CLH_INFOTEXT,CLB_INFOTEXT,dp->xpos+9,dp->ypos,sout);
    pds_textdisplay_charxybk(CL_INFOBORDER,CLB_INFOBORDER,dp->xpos+11,dp->ypos,'.');
    sprintf(sout,"%1.1d",ctime%10);
    pds_textdisplay_textxybk(CLH_INFOTEXT,CLB_INFOTEXT,dp->xpos+12,dp->ypos,sout);
    dp++;
    sprintf(sout,"%7d",mvp->psip->fulltimesec/3600);
    pds_textdisplay_textxybk(CL_INFOTEXT,CLB_INFOTEXT,dp->xpos,dp->ypos,sout);
    pds_textdisplay_charxybk(CL_INFOBORDER,CLB_INFOBORDER,dp->xpos+7,dp->ypos,':');
    sprintf(sout,"%2.2d",(mvp->psip->fulltimesec/60)%60);
    pds_textdisplay_textxybk(CL_INFOTEXT,CLB_INFOTEXT,dp->xpos+8,dp->ypos,sout);
    pds_textdisplay_charxybk(CL_INFOBORDER,CLB_INFOBORDER,dp->xpos+10,dp->ypos,':');
    sprintf(sout,"%2.2d",mvp->psip->fulltimesec%60);
    pds_textdisplay_textxybk(CL_INFOTEXT,CLB_INFOTEXT,dp->xpos+11,dp->ypos,sout);
   }
   dp++;
   sprintf(sout,"%3d%%",cpupercent);
   pds_textdisplay_textxybk(CL_INFOTEXT,CLB_INFOTEXT,dp->xpos+4,dp->ypos,sout);
   draw_volume_nofe();
  }else{
   cftime=(float)cframe*(float)frp->timesec/(float)frp->allframes;
   pds_ftoi(cftime,(long *)&i);
   ctime+=i;
   sprintf(sout,"{%d/%d}{%5lu/%lu}{",currsongnum,allsongnum,cframe,frp->allframes);
   x=pds_textdisplay_textxybk(CL_BASE,CLB_BASE,0,dtp.timepos_fe,sout);
   if(timemode<2){
    sprintf(sout,"%2lu:%2.2lu",ctime/60,ctime%60);
    x+=pds_textdisplay_textxybk(CLH_BASE,CLB_BASE,x,dtp.timepos_fe,sout);
    sprintf(sout,"/%d:%2.2d}{CPU:%2lu%%}",frp->timesec/60,frp->timesec%60,cpupercent);
   }else{
    sprintf(sout,"%lu:%2.2lu:%2.2lu",ctime/3600,(ctime/60)%60,ctime%60);
    x+=pds_textdisplay_textxybk(CLH_BASE,CLB_BASE,x,dtp.timepos_fe,sout);
    sprintf(sout,"/%d:%2.2d:%2.2d}",mvp->psip->fulltimesec/3600,(mvp->psip->fulltimesec/60)%60,mvp->psip->fulltimesec%60);
   }
   x+=pds_textdisplay_textxybk(CL_BASE,CLB_BASE,x,dtp.timepos_fe,sout);
   draw_volume_fe(x);
  }
 }else{
  if(displaymode&DISP_FRAMES){
   pds_ltoa(mvp->frp0->frameNum,sout);
   pds_textdisplay_textxybk(CL_BASE,CLB_BASE,1,dtp.timepos_fe,sout);
  }
 }
}

static void display_option_vol(struct mainvars *mvp)
{
 if(displaymode&DISP_NOFULLEDIT){
  struct buttons *dp=&dk[DK_OPTIONS];
#ifdef USE_LSA_SCV
  sprintf(souttext,"%3d",mvp->aui->card_mixer_values[AU_MIXCHAN_MASTERVOL]);
#else
  sprintf(souttext,"%3d",MIXER_var_volume);
#endif
  pds_textdisplay_textxybk(CL_BTNTEXTMIXER,CLB_BTNTEXT,dp->xpos+1,dp->ypos+1,souttext);
 }
}

char *get_playstatus_string(unsigned int *color)
{
 static struct{
  char *text;
  unsigned int color;
 }statustexts[7]={
   {" PAUSED ",CL_FUNCTION|CL_BLINK|(CLB_FUNCTION<<4)},
   {"Fade-Out",CL_FUNCTION|CL_BLINK|(CLB_FUNCTION<<4)},
   {"Fade--In",CL_FUNCTION|CL_BLINK|(CLB_FUNCTION<<4)},
   {"CrosFade",CL_FUNCTION|CL_BLINK|(CLB_FUNCTION<<4)},
   {"        ",CL_FUNCTION|         (CLB_FUNCTION<<4)},
   {"CrosLoad",CL_FUNCTION|CL_BLINK|(CLB_FUNCTION<<4)},
   {"-=SCAN=-",CL_FUNCTION|CL_BLINK|(CLB_FUNCTION<<4)},
  };
 unsigned int status;

 if(!(playcontrol&PLAYC_RUNNING))
  status=0;
 else{
  if(crossfadepart)
   status=crossfadepart;
  else
   if(playcontrol&PLAYC_HIGHSCAN)
    status=6;
   else
    status=4;
 }
 *color=statustexts[status].color;
 return (statustexts[status].text);
}

static void display_options(struct mainvars *mvp) // program control infos
{
 struct buttons *dp;
 unsigned int color;
 char *functext;

 if(displaymode&DISP_NOFULLEDIT){
  display_option_vol(mvp);
  dp=&dk[DK_OPTIONS+3];

  functext=get_playstatus_string(&color);
  pds_textdisplay_textxy(color,dk[DK_FUNCTION].xpos,dk[DK_FUNCTION].ypos,functext);

  if(dp->ypos<dtp.endofbuttonsy){
   color=(playreplay)? (CLA_BTNTEXTOPTION|(CLB_BTNTEXT<<4)):(CL_BTNTEXTOPTION|(CLB_BTNTEXT<<4));
   if(playreplay&1)
    pds_textdisplay_textxy(color,dp->xpos+1,dp->ypos+1,"R1");
   else
    pds_textdisplay_textxy(color,dp->xpos+1,dp->ypos+1,dp->intext);
   dp++;
   color=(playrand)? (CLA_BTNTEXTOPTION|(CLB_BTNTEXT<<4)):(CL_BTNTEXTOPTION|(CLB_BTNTEXT<<4));
   pds_textdisplay_textxy(color,dp->xpos+1,dp->ypos+1,dp->intext);
   dp++;
   color=(MIXER_var_autovolume)? (CLA_BTNTEXTOPTION|(CLB_BTNTEXT<<4)):(CL_BTNTEXTOPTION|(CLB_BTNTEXT<<4));
   pds_textdisplay_textxy(color,dp->xpos+1,dp->ypos+1,dp->intext);
   dp++;
   color=(mvp->cfi->usecrossfade)? (CLA_BTNTEXTOPTION|(CLB_BTNTEXT<<4)):(CL_BTNTEXTOPTION|(CLB_BTNTEXT<<4));
   pds_textdisplay_textxy(color,dp->xpos+1,dp->ypos+1,dp->intext);
   dp++;
   color=(mvp->cfi->crossfadetype&CFT_FADEOUT)? (CLA_BTNTEXTOPTION|(CLB_BTNTEXT<<4)):(CL_BTNTEXTOPTION|(CLB_BTNTEXT<<4));
   pds_textdisplay_textxy(color,dp->xpos+1,dp->ypos+1,"Fo");
   color=(mvp->cfi->crossfadetype&CFT_FADEIN)? (CLA_BTNTEXTOPTION|(CLB_BTNTEXT<<4)):(CL_BTNTEXTOPTION|(CLB_BTNTEXT<<4));
   pds_textdisplay_textxy(color,dp->xpos+1+2,dp->ypos+1,"Fi");
   dp++;
   sprintf(souttext,"%3d",MIXER_var_surround);
   pds_textdisplay_textxybk(CL_BTNTEXTMIXER,CLB_BTNTEXT,dp->xpos+1,dp->ypos+1,souttext);
   dp+=3;
#ifdef MPXPLAY_MIXER_SPEED_1000
   sprintf(souttext,"%4d",MIXER_var_speed);
#else
   sprintf(souttext,"%3d",MIXER_var_speed);
#endif
   pds_textdisplay_textxybk(CL_BTNTEXTMIXER,CLB_BTNTEXT,dp->xpos+1,dp->ypos+1,souttext);
   dp+=3;
   if(MIXER_var_balance!=0){
    sprintf(souttext,"%+2d ",MIXER_var_balance);
    souttext[3]=0;
    //sprintf(souttext,"%c%2d",(MIXER_var_balance<0)? 'L':'R',abs(MIXER_var_balance));
   }else
    pds_strcpy(souttext," 0 ");
   pds_textdisplay_textxybk(CL_BTNTEXTMIXER,CLB_BTNTEXT,dp->xpos+1,dp->ypos+1,souttext);
   dp+=3;
   sprintf(souttext,"%3d",mvp->aui->card_mixer_values[AU_MIXCHAN_BASS]);
   pds_textdisplay_textxybk(CL_BTNTEXTMIXER,CLB_BTNTEXT,dp->xpos+1,dp->ypos+1,souttext);
   dp+=3;
   sprintf(souttext,"%3d",mvp->aui->card_mixer_values[AU_MIXCHAN_TREBLE]);
   pds_textdisplay_textxybk(CL_BTNTEXTMIXER,CLB_BTNTEXT,dp->xpos+1,dp->ypos+1,souttext);
  }
  dp=&dk[DK_BUFCPU];
  if(funcbit_test(intsoundcontrol,INTSOUND_DECODER))
   pds_textdisplay_charxybk(CL_INFOBORDER,CLB_INFOBORDER,dp->xpos+3,dp->ypos,'/');
  else
   pds_textdisplay_textxybk(CL_INFOTEXT,CLB_INFOTEXT,dp->xpos,dp->ypos,"CPU:");
  dp=&dk[DK_SMALLBTNS];
  color=(MIXER_var_swapchan)? (CLA_BTNTEXTOPTION|(CLB_BTNTEXT<<4)):(CL_BTNTEXTOPTION|(CLB_BTNTEXT<<4));
  pds_textdisplay_textxy(color,dp->xpos,dp->ypos,dp->intext);
  dp++;
  color=(MIXER_var_usehq)? (CLA_BTNTEXTOPTION|(CLB_BTNTEXT<<4)):(CL_BTNTEXTOPTION|(CLB_BTNTEXT<<4));
  pds_textdisplay_textxy(color,dp->xpos,dp->ypos,dp->intext);
  dp++;
  color=(playcontrol&PLAYC_AUTOPAUSE)? (CLA_BTNTEXTOPTION|(CLB_BTNTEXT<<4)):(CL_BTNTEXTOPTION|(CLB_BTNTEXT<<4));
  pds_textdisplay_textxy(color,dp->xpos,dp->ypos,dp->intext);
  dp++;
  color=(playcontrol&PLAYC_PAUSENEXT)? (CLA_BTNTEXTOPTION|(CLB_BTNTEXT<<4)):(CL_BTNTEXTOPTION|(CLB_BTNTEXT<<4));
  pds_textdisplay_textxy(color,dp->xpos,dp->ypos,dp->intext);
 }
}

//#define SHOW_TRACKNUM 1

// file (header) and ID3 infos
void display_fileinfos(struct mainvars *mvp)
{
#ifdef SHOW_TRACKNUM
 static char *id3mask[7]={"%s. ","%.30s","%.60s","%.30s ","(%4s) ","[%s] ","%.30s"};
 static unsigned int id3order_nofe[7]={I3I_TRACKNUM,I3I_ARTIST,I3I_TITLE,I3I_ALBUM,I3I_YEAR,I3I_GENRE,I3I_COMMENT};
#else
 static char *id3mask[6]={"%.30s","%.60s","%.30s ","(%4s) ","[%s] ","%.30s"};
 static unsigned int id3order_nofe[6]={I3I_ARTIST,I3I_TITLE,I3I_ALBUM,I3I_YEAR,I3I_GENRE,I3I_COMMENT};
#endif

 struct buttons *dp;
 struct frame *frp;
 struct mpxplay_audio_decoder_info_s *adi;
 struct playlist_entry_info *pei;
 int len;
 unsigned int i,col,basex,color;
 char *shortfname,**id3ip,*channeltext,channumstr[10];

 if(displaymode&DISP_VERBOSE){
  pei=mvp->pei0;  // current song's infos (pointers) are stored here!
  shortfname=pds_getfilename_from_fullname(pei->filename);
  if(shortfname==NULL)
   shortfname=pei->filename;

  id3ip=&pei->id3info[0];

  if(id3ip[I3I_ARTIST] || id3ip[I3I_TITLE]){
   sprintf(souttext,"Mpxplay v1.50 - %s : %s ",
    (id3ip[I3I_ARTIST])? id3ip[I3I_ARTIST]:"",(id3ip[I3I_TITLE])? id3ip[I3I_TITLE]:"");
  }else
   sprintf(souttext,"Mpxplay v1.50 - %-40.40s ",shortfname);
  pds_setapplicationtitle(souttext);

  frp=mvp->frp0;
  adi=frp->infile_infos->audio_decoder_infos;

  if(adi->channeltext)
   channeltext=adi->channeltext;
  else{
   switch(adi->filechannels){
    case 1:channeltext="  Mono  ";break;
    case 2:channeltext=" Stereo ";break;
    default:sprintf(channumstr,"%2d-chan ",adi->filechannels);channeltext=&channumstr[0];break;
   }
  }
  if(displaymode&DISP_NOFULLEDIT){
   dp=&dk[DK_FILEINFO+1];
   basex=dk[0].xpos+1;
   pds_textdisplay_textxybk(CL_INFOTEXT,CLB_INFOTEXT,dp->xpos,dp->ypos,(adi->longname)? adi->longname:"  ----  ");
   dp++;
   if(adi->bitratetext)
    pds_textdisplay_textxybk(CL_INFOTEXT,CLB_INFOTEXT,dp->xpos,dp->ypos,adi->bitratetext);
   else{
    if(adi->bitrate){
     if(adi->bitrate<100)
      sprintf(souttext," %2d kbit",adi->bitrate);
     else
      sprintf(souttext,"%-4dkbit",adi->bitrate);
    }else
     sprintf(souttext," %2d bit ",adi->bits);
    pds_textdisplay_textxybk(CL_INFOTEXT,CLB_INFOTEXT,dp->xpos,dp->ypos,souttext);
   }
   dp++;
   if(adi->freq<100000)
    sprintf(souttext,"%5dHz",adi->freq);
   else
    if(adi->freq<10000000)
     sprintf(souttext,"%4dkHz",adi->freq/1000);
    else
     sprintf(souttext,"%2.1fMHz",(float)adi->freq/1000000);
   pds_textdisplay_textxybk(CL_INFOTEXT,CLB_INFOTEXT,dp->xpos,dp->ypos,souttext);
   dp++;
   pds_textdisplay_textxybk(CL_INFOTEXT,CLB_INFOTEXT,dp->xpos,dp->ypos,channeltext);
   dp++;
   pds_textdisplay_textxybk(CL_INFOTEXT,CLB_INFOTEXT,dp->xpos,dp->ypos,mvp->aui->card_handler->shortname);

#ifdef SHOW_TRACKNUM
   dp=&dk[DK_ID3INFO];
#else
   dp=&dk[DK_ID3INFO+1];
#endif
   col=basex;
   color=CLH_ID3TEXT|(CLB_ID3TEXT<<4);
#ifndef MPX_DEBUG_SERIAL
   pds_textdisplay_spacecxyn(CLB_ID3TEXT,basex,dp->ypos,46);
#ifdef SHOW_TRACKNUM
   for(i=0;i<7;i++){
#else
   for(i=0;i<6;i++){
#endif
    unsigned int index=id3order_nofe[i];
    if(index==I3I_ALBUM){ // then new line
     col=basex;
     color=CL_ID3TEXT|(CLB_ID3TEXT<<4);
     pds_textdisplay_spacecxyn(CLB_ID3TEXT,basex,dp->ypos,46);
    }
    if(id3ip[index] && (col<(maxx-1))){
     if((index==I3I_TITLE) && id3ip[I3I_ARTIST]){
      pds_textdisplay_textxybk(CL_ID3TEXT,CLB_ID3TEXT,col,dp->ypos," - ");
      col+=3;
     }
     len=sprintf(souttext,id3mask[i],id3ip[index]);
     if(len>0){
      dp->xpos=col;
      dp->xsize=len-1;
      if((dp->xpos+dp->xsize)>=(maxx-1)){
       dp->xsize=maxx-dp->xpos-1;
       souttext[dp->xsize]=0;
      }
      pds_textdisplay_textxy(color,dp->xpos,dp->ypos,souttext);
      col+=len;
     }
    }else{
     if((index==I3I_TITLE) && !id3ip[I3I_ARTIST]){
      //shortfname[46]=0;
      //pds_textdisplay_textxy(color,basex,dp->ypos,shortfname);
      pds_textdisplay_textxyn(color,basex,dp->ypos,46,shortfname);
     }
     dp->xsize=0;
     dp->xpos=255;
    }
    dp++;
   }
#endif
   lastmousebox=65535;
   draw_listpos_line();
  }else{
   if(adi->bitratetext){
    sprintf(souttext,"%s, %s, %ld Hz, %s            ",
		      (adi->longname)? adi->longname:"",
		      adi->bitratetext,adi->freq,channeltext);
   }else{
    if(adi->bitrate){
     sprintf(souttext,"%s, %d kbit/s, %ld Hz, %s            ",
		      (adi->longname)? adi->longname:"",
		      adi->bitrate,adi->freq,channeltext);
    }else{
     sprintf(souttext,"%s, %d bit, %ld Hz, %s            ",
		      (adi->longname)? adi->longname:"",
		      adi->bits,adi->freq,channeltext);
    }
   }
   col=pds_textdisplay_textxybk(CL_BASE,CLB_BASE,0,POS_FILEINFO_FE,souttext);
   if(col<maxx)
    pds_textdisplay_spacecxyn(CLB_BASE,col,POS_FILEINFO_FE,maxx-col);
   draw_one_id3info_line(pei,6,0,maxx,CLH_BASE|(CLB_BASE<<4),POS_ID3INFO_FE,0);
  }
 }
}

static void draw_one_id3info_line(struct playlist_entry_info *pei,unsigned int lastid,
                                  unsigned int col,unsigned int endcol,
	                          unsigned int color,unsigned int y,unsigned int showfilename)
{
 static unsigned int id3order_fe[6]={I3I_ARTIST,I3I_TITLE,I3I_GENRE,I3I_ALBUM,I3I_YEAR,I3I_COMMENT};
 static unsigned int id3textlen[6]={1,0,7,6,9,7};
 static char *id3text[6]={":",""," Album:"," Year:"," Comment:"," Genre:"};
 char *shortfname,**id3ip=&pei->id3info[0];
 unsigned int i,k,len,showseparator=0,lengthcol,bkcolor;

 if(col>=endcol)
  return;

 lengthcol=endcol-col;
 bkcolor=color>>4;
 if(showfilename || (id3ip[I3I_ARTIST]==NULL && id3ip[I3I_TITLE]==NULL)){
  pds_strcpy(souttext,pei->filename);
  if((pei->entrytype&(DFTM_DFT|DFTM_DRIVE))==(DFTM_DFT|DFTM_DRIVE))
   shortfname=&souttext[0];
  else
   shortfname=pds_getfilename_from_fullname(souttext);
  len=pds_strlen(shortfname);
  pds_strcat(shortfname,"             ");
  shortfname[lengthcol]=0;
  pds_textdisplay_textxy(color,col,y,shortfname);
  if(len<13)
   col+=13;
  else
   col+=len+2;
 }
 for(k=0;k<lastid;k++){
  i=id3order_fe[k];
  if(id3ip[i]!=NULL){
   len=pds_strlen(id3ip[i]);
   if((col+id3textlen[i])>endcol)
    break;
   if(showseparator && id3textlen[i]){
    pds_textdisplay_textxybk(CL_EDITOR_AT_SEPARATOR,bkcolor,col,y,(char *)id3text[i]);
    col+=id3textlen[i];
   }
   if((col+len)>endcol){
    pds_strcpy(souttext,id3ip[i]);
    souttext[endcol-col]=0;
    pds_textdisplay_textxy(color,col,y,souttext);
    col=endcol;
    break;
   }else{
    pds_textdisplay_textxy(color,col,y,id3ip[i]);
    col+=len;
   }
   showseparator=1;
  }
  if(k==1)
   showseparator=1;
 }
 if(col<endcol)
  pds_textdisplay_spacecxyn(bkcolor,col,y,endcol-col);
}

/*static void draw_clock(void)
{
 unsigned int hextime=pds_gettime();
 sprintf(souttext,"%2d:%2.2d:%2.2d",(hextime>>16),(hextime>>8)&0xff,hextime&0xff);
 pds_textdisplay_textxybk(CLH_INFOTEXT,CLB_INFOTEXT,dk[DK_MOUSEPOS].xpos,dk[DK_MOUSEPOS].ypos,souttext);
}*/

//**************************************************************************
// spectrum analiser & volume meter
//**************************************************************************

static unsigned int log1[32]={100,200,400,
			700,980,1221,1520,
			1893,2358,2936,3656,4552,5669,7059,8790,10945,13629,16971,
			21132,26314,32767,36000,40000,45000,50000,55000,
			60000,65000,70000,75000,80000,85000};
static unsigned int peekvol[2],peeknum[2],peekhold[2];

static void draw_volume_nofe(void)
{
 static struct vol_nofe{
  unsigned int voldiv;
  unsigned int xpos[2];
  unsigned int istep[2];
  unsigned int xlen;
  unsigned int part[2];
  char drawchars[2];
 }sv[2]={ {  16,{32+23-1,32+23+2},{-1,1},23,{10,19},{'',250} },
	  {  7 ,{      0,      0},{ 1,1},32,{12,26},{'#',250} }};

 unsigned int i,ch,cvol[2],y[2];
 struct vol_nofe *svp;

 if(!dtp.volline)
  return;
 if(dtp.volline<dtp.endofbuttonsy){
  if(displaymode&DISP_ANALISER)
   return;
  svp=(struct vol_nofe *)&sv[1];
  y[0]=dtp.volline;
  y[1]=y[0]+1;
 }else{
  svp=(struct vol_nofe *)&sv[0];
  y[0]=y[1]=dtp.volline;
  pds_textdisplay_textxybk(CL_VOLUME_SEPARATOR,CLB_VOLUME,svp->xpos[0]+1,y[0],"--");
 }
 cvol[0]=vol_save[0]/svp->voldiv;
 cvol[1]=vol_save[1]/svp->voldiv;
 for(ch=0;ch<2;ch++){
  if(peekvol[ch]<cvol[ch]){
   peekvol[ch]=cvol[ch];
   peeknum[ch]=32;
   peekhold[ch]=19;
  }else
   if(peekhold[ch]--==0){
    peekvol[ch]=0;
    peeknum[ch]=32;
   }
  for(i=0;i<svp->xlen;i++){
   if(peekvol[ch]<log1[i] && peeknum[ch]==32)
    peeknum[ch]=i-1;
   if(cvol[ch]>log1[i] || (i==peeknum[ch] && peeknum[ch]!=0)){
    unsigned int color=(i<svp->part[0])? (CL_VOLUME_LEVEL0|(CLB_VOLUME<<4))
		      :(i<svp->part[1])? (CL_VOLUME_LEVEL1|(CLB_VOLUME<<4))
		      :                  (CL_VOLUME_LEVEL2|(CLB_VOLUME<<4));
    pds_textdisplay_charxy(color,svp->xpos[ch]+(i*svp->istep[ch]),y[ch],svp->drawchars[0]);
   }else
    pds_textdisplay_charxybk(CL_VOLUME_DOTS,CLB_VOLUME,svp->xpos[ch]+(i*svp->istep[ch]),y[ch],svp->drawchars[1]);
  }
 }
}

static void draw_volume_fe(unsigned int x) // -fe -fl
{
 unsigned int i,cvol,color;

 cvol=(vol_save[0]+vol_save[1])/52;
 if(peekvol[0]<cvol){
  peekvol[0]=cvol;
  peeknum[0]=32;
  peekhold[0]=19;
 }else
  if(peekhold[0]--==0){
   peekvol[0]=0;
   peeknum[0]=32;
  }
 for(i=0;i<20;i++){
  if(peekvol[0]<log1[i] && peeknum[0]==32)
   peeknum[0]=i-1;
  color=(i< 7)? (CL_VOLUME_LEVEL0|(CLB_VOLUME<<4))
       :(i<17)? (CL_VOLUME_LEVEL1|(CLB_VOLUME<<4))
       :        (CL_VOLUME_LEVEL2|(CLB_VOLUME<<4));
  if(cvol>log1[i] || (i==peeknum[0] && peeknum[0]!=0))
   pds_textdisplay_charxy(color,x,dtp.timepos_fe,'#');
  else
   pds_textdisplay_charxy(color,x,dtp.timepos_fe,'.');
  x++;
 }
 if(x<maxx)
  pds_textdisplay_spacecxyn(CLB_BASE,x,dtp.timepos_fe,maxx-x);
}

void clear_volnum(void)
{
 pds_memset(&volnum[0][0],0,5*2*sizeof(unsigned long));
 pds_memset(&analtab[0][0],0,5*32*sizeof(unsigned long));
}

// table for 25 lines display mode (12 analiser lines)
static unsigned int log25[12]={0,100,400,
			980,1520,
			2358,3656,5669,8790,13629,
			21132,32767};

// table for 50 lines display mode (16 analiser lines)
static unsigned int log50[16]={0,100,200,400,
			       700,1024,
			       1448,2048,2896,4096,5792,8192,11585,16384,
			       23170,32768};
static long analpeekvol[32],analpeeknum[32],analpeekhold[32];
static unsigned int anal_endline,*anal_logp;

static void clear_analiser_peeks(void) // 25 <-> 50 lines change
{
 unsigned int i;
 for(i=0;i<32;i++)
  analpeekvol[i]=analpeeknum[i]=analpeekhold[i]=0;
 if((displaymode&DISP_50LINES) || (maxy>=50)){
  anal_endline=15;
  anal_logp=(unsigned int *)&log50[0];
 }else{
  anal_endline=11;
  anal_logp=(unsigned int *)&log25[0];
 }
}

//static void draw_spectrum_analiser(unsigned int analpoint)
static void draw_spectrum_analiser(unsigned long *analpt)
{
 unsigned int i,k,y,endline,endcol,cvol,*logp,color;
 long *analpv,*analpn,*analph;
 //unsigned long *analpt;

 if(!(displaymode&DISP_ANALISER) || !(displaymode&DISP_NOFULLEDIT))
  return;
 //analpt=&analtab[analpoint][0];
 analpv=&analpeekvol[0];
 analpn=&analpeeknum[0];
 analph=&analpeekhold[0];
 endline=anal_endline;
 logp=anal_logp;
 endcol=32;
 analpt[0]>>=3;
 analpt[1]>>=1;
 analpt[2]>>=1;
 for(k=0;k<endcol;k++){
  cvol=analpt[0];
  if(analph[0])
   analph[0]--;
  else{
   if(analpn[0]){
    pds_textdisplay_charxybk(CL_ANALISER_DOTS,CLB_ANALISER,k,endline-analpn[0],250);
    analpn[0]--;
    analpv[0]=logp[analpn[0]];
   }
  }
  if(analpv[0]<cvol && cvol>50){
   for(i=0;i<endline;i++)
    pds_textdisplay_charxybk(CL_ANALISER_DOTS,CLB_ANALISER,k,i,250);
   analpn[0]=0;
   for(i=1;i<=endline;i++){
    if(cvol<logp[i]){
     analpn[0]=i;
     break;
    }
   }

   analph[0]=20;
   analpv[0]=logp[analpn[0]];
  }
  y=analpn[0];
  if(y){
   color=(y< 5)? (CL_ANALISER_LEVEL0|(CLB_ANALISER<<4))
	:(y<15)? (CL_ANALISER_LEVEL1|(CLB_ANALISER<<4))
	:        (CL_ANALISER_LEVEL2|(CLB_ANALISER<<4));
   pds_textdisplay_charxy(color,k,endline-y,(analph[0])? 22:31);
  }else
   y=endline+1;
  for(i=1;i<y;i++){
   if(cvol>logp[i]){
    color=(i< 5)? (CL_ANALISER_LEVEL0|(CLB_ANALISER<<4))
	 :(i<15)? (CL_ANALISER_LEVEL1|(CLB_ANALISER<<4))
	 :        (CL_ANALISER_LEVEL2|(CLB_ANALISER<<4));
    pds_textdisplay_charxy(color,k,endline-i,186);
   }else
    pds_textdisplay_charxybk(CL_ANALISER_DOTS,CLB_ANALISER,k,endline-i,250);
  }
  analpt++;analpv++;analpn++;analph++;
 }
}

static void setmousecursorpalette(void)
{
 static unsigned int palettec=0;
 unsigned char *ppal;
 static unsigned char palette[18][3]={{63,30,30},{63,41,30},{63,52,30},{63,63,30},
			    {52,63,30},{41,63,30},{30,63,30},{30,63,41},
			    {30,63,52},{30,63,63},{30,52,63},{30,41,63},
			    {30,30,63},{41,30,63},{52,30,63},{63,30,63},
			    {63,30,52},{63,30,41}};

 if(mouse_on){
  ppal=(char *)(&palette[palettec][0]);
  outp(0x03c8,CL_MOUSECURSOR);
  outp(0x03c9,ppal[0]);
  ppal++;
  outp(0x03c9,ppal[0]);
  ppal++;
  outp(0x03c9,ppal[0]);
  palettec++;
  if(palettec>=18)
   palettec=0;
 }
}

//*************************************************************************
// playlist editor routines
//*************************************************************************

static void init_editorpos(struct mainvars *mvp)
{
 if(desktopmode&DTM_EDIT_VERTICAL){
  ed[0].begincol=1;
  if(mvp->psie==mvp->psi0)
   ed[1].begincol=ed[0].begincol+editorsideborder+1;
  else
   ed[1].begincol=maxx-1-editorsideborder-ed[0].begincol;
  ed[0].lengthcol=ed[1].begincol-ed[0].begincol-1;
  ed[1].lengthcol=maxx-ed[1].begincol-1;
  ed[0].beginline=ed[1].beginline=dtp.editorbegin+1;
  ed[0].lengthline=ed[1].lengthline=dtp.editorend-ed[0].beginline;
 }else{
  ed[0].begincol=ed[1].begincol=1;
  ed[0].lengthcol=ed[1].lengthcol=maxx-2;
  ed[0].beginline=dtp.editorbegin+1;
  ed[1].beginline=dtp.editorbegin+1+((dtp.editorend-dtp.editorbegin)>>1);
  ed[0].lengthline=ed[1].beginline-ed[0].beginline-1;
  ed[1].lengthline=dtp.editorend-ed[1].beginline;
 }
}

static void draw_elevator_pos(struct playlist_side_info *psi,unsigned int side)
{
 static unsigned int last_elevatorpos;
 struct editor *edp=&ed[side];
 struct mainvars *mvp=psi->mvp;

 if((desktopmode&DTM_EDIT_ELEVATOR) && (psi==mvp->psie) && (edp->lengthline>1)){
  unsigned int listlines=(psi->lastentry-psi->firstentry)+1;
  unsigned int lfrom=edp->from-psi->firstentry;
  unsigned int lines=edp->lengthline,elevatorpos;
  int remainlines=listlines-lines;

  lines--;
  if(remainlines>0)
   elevatorpos=((lfrom*lines)/remainlines);
  else
   elevatorpos=0;

  elevatorpos+=edp->beginline;
  if(last_elevatorpos>dtp.editorbegin)
   pds_textdisplay_charxybk(CL_EDITOR_BORDER,CLB_EDITOR_BORDER,maxx-1,last_elevatorpos,editorchars[1]);
  if(elevatorpos<edp->beginline)
   elevatorpos=edp->beginline;
  if(elevatorpos>(edp->beginline+edp->lengthline))
   elevatorpos=edp->beginline+edp->lengthline;
  pds_textdisplay_charxybk(CL_EDITOR_ELEVATOR,CLB_EDITOR_ELEVATOR,maxx-1,elevatorpos,18);
  last_elevatorpos=elevatorpos;
 }
}

void set_mousepos_on_elevator(struct mainvars *mvp,unsigned int mousey)
{
 if(desktopmode&DTM_EDIT_ELEVATOR){
  struct playlist_side_info *psi=mvp->psie;
  struct editor *edp=&ed[psi - mvp->psi0];
  unsigned int listlines=(psi->lastentry-psi->firstentry)+1;
  unsigned int elevatorpos=mousey-edp->beginline,fe;
  int lines=edp->lengthline;
  int remainlines=listlines-lines;
  lines--;

  if(lines>0 && remainlines>0){
   struct playlist_entry_info *pei;
   if(elevatorpos)
    fe=(elevatorpos*remainlines)/lines+1;
   else
    fe=0;
   pei=psi->firstentry+fe;
   edp->from=pei;
   if(psi->editorhighline<pei)
    playlist_editorhighline_set(psi,pei);
   else
    if(psi->editorhighline>(pei+lines))
     playlist_editorhighline_set(psi,pei+lines);
   refdisp|=RDT_EDITOR;
  }
 }
}

void set_mousepos_on_editor(struct mainvars *mvp,unsigned int mousex,unsigned int mousey)
{
 struct playlist_side_info *psi=mvp->psi0;
 struct editor *edp=&ed[0];
 unsigned int side;

 for(side=0;side<PLAYLIST_MAX_SIDES;side++,psi++,edp++){
  if(mousex>=edp->begincol && mousex<(edp->begincol+edp->lengthcol)
     && mousey>=edp->beginline && mousey<(edp->beginline+edp->lengthline))
   break;
 }
 if(side>=PLAYLIST_MAX_SIDES)
  return;

 if(psi->editsidetype&PLT_ENABLED){
  if(psi!=mvp->psie)
   playlist_change_editorside(mvp);
  psi=mvp->psie;
  playlist_editorhighline_seek(psi,edp->from-psi->firstentry+mousey-dtp.editorbegin-1,SEEK_SET);
  refdisp|=RDT_EDITOR;
 }
}

void draweditor(struct mainvars *mvp)
{
 unsigned int j,listlines,editor_rows,displayed_rows,len;
 unsigned int colpos,side,begincol,endcol,endcol_id3,lengthcol;
 unsigned int color,lineposy,showfilenum,showfilename;
 struct playlist_side_info *psi=mvp->psie;
 struct playlist_entry_info *pei;
 struct editor *edp;

 for(side=0,psi=mvp->psi0;side<PLAYLIST_MAX_SIDES;side++,psi++) // is it necessary here?
  playlist_editorhighline_check(psi);

 psi=mvp->psie;

 playlist_chkfile_start_ehline(psi,psi->editorhighline);

 if(!(displaymode&DISP_FULLSCREEN))
  return;

 for(j=1;j<(maxx-1);j++){
  pds_textdisplay_charxybk(CL_EDITOR_BORDER,CLB_EDITOR_BORDER,j,dtp.editorbegin,editorchars[0]);
  pds_textdisplay_charxybk(CL_EDITOR_BORDER,CLB_EDITOR_BORDER,j,dtp.editorend,editorchars[0]);
 }
 if(desktopmode&DTM_EDIT_VERTICAL){
  for(j=ed[0].beginline;j<(ed[0].beginline+ed[0].lengthline);j++)
   pds_textdisplay_charxybk(CL_EDITOR_BORDER,CLB_EDITOR_BORDER,ed[1].begincol-1,j,editorchars[1]);
  pds_textdisplay_charxybk(CL_EDITOR_BORDER,CLB_EDITOR_BORDER,ed[1].begincol-1,dtp.editorbegin,editorchars[6]);
  pds_textdisplay_charxybk(CL_EDITOR_BORDER,CLB_EDITOR_BORDER,ed[1].begincol-1,dtp.editorend,editorchars[7]);
 }else{
  for(j=1;j<(maxx-1);j++)
   pds_textdisplay_charxybk(CL_EDITOR_BORDER,CLB_EDITOR_BORDER,j,ed[1].beginline-1,editorchars[0]);
  pds_textdisplay_charxybk(CL_EDITOR_BORDER,CLB_EDITOR_BORDER,0     ,ed[1].beginline-1,editorchars[8]);
  pds_textdisplay_charxybk(CL_EDITOR_BORDER,CLB_EDITOR_BORDER,maxx-1,ed[1].beginline-1,editorchars[9]);
 }

 psi=mvp->psie;
 pei=psi->editorhighline;
 if(desktopmode&DTM_EDIT_FULLPATH){
  len=sprintf(souttext,"%s (%d)",pei->filename,pei-psi->firstentry+1);
  if(len<(maxx-5))
   pds_textdisplay_textxybk(CL_EDITOR_FULLPATH,CLB_EDITOR_FULLPATH,(maxx>>1)-(len>>1),dtp.editorbegin,souttext);
  else{
   pds_textdisplay_textxybk(CL_EDITOR_FULLPATH,CLB_EDITOR_FULLPATH,1,dtp.editorbegin,"...");
   pds_textdisplay_textxybk(CL_EDITOR_FULLPATH,CLB_EDITOR_FULLPATH,4,dtp.editorbegin,&souttext[len-(maxx-5)]);
  }
 }
 //if(desktopmode&DTM_EDIT_TOTALS){
 // len=sprintf(souttext,"[Total songs: %d  Time: %d:%2.2d:%2.2d]",allsongnum,mvp->psip->fulltimesec/3600,(mvp->psip->fulltimesec/60)%60,mvp->psip->fulltimesec%60);
 // pds_textdisplay_textxy(11,maxx-len-1,dtp.editorend,souttext);
 //}else
 if(desktopmode&DTM_EDIT_FULLTIME){
  unsigned int fulltimesec=mvp->psip->fulltimesec;
  len=sprintf(souttext,"[%d:%2.2d:%2.2d]",fulltimesec/3600,(fulltimesec/60)%60,fulltimesec%60);
  pds_textdisplay_textxybk(CL_EDITOR_FULLTIME,CLB_EDITOR_FULLTIME,maxx-len-1,dtp.editorend,souttext);
 }

 psi=mvp->psi0;
 edp=&ed[0];
 for(side=0;side<PLAYLIST_MAX_SIDES;side++,psi++,edp++){
  begincol=edp->begincol;
  lengthcol=edp->lengthcol;
  endcol=begincol+lengthcol;

  lineposy=edp->beginline;
  editor_rows=edp->lengthline-1;

  j=0;
  if(psi->editsidetype&PLT_ENABLED){
   listlines=psi->lastentry-psi->firstentry;
   if(listlines<=editor_rows){
    displayed_rows=listlines;
    pei=psi->firstentry;
   }else{
    displayed_rows=editor_rows;
    pei=edp->from;
    if(pei>=(psi->lastentry-editor_rows))
     pei=psi->lastentry-editor_rows;
    else
     if(pei<psi->firstentry) // ???
      pei=psi->firstentry;
   }
   if(pei<(psi->editorhighline-editor_rows)){
    pei=psi->editorhighline-editor_rows;
   }else{
    if(pei>psi->editorhighline)
     pei=psi->editorhighline;
   }
   edp->from=pei;
   if(edp->from_prev!=pei){
    edp->from_prev=pei;
    playlist_chkfile_start_disp(psi,pei,pei+displayed_rows);
   }
   draw_elevator_pos(psi,side);
   for(;j<=displayed_rows;j++,lineposy++,pei++){
    colpos=begincol;
    color=set_editorline_color(psi,pei);
    if((psi==mvp->psie) && (pei==psi->editorhighline))
     color|=CLB_EDITOR_HIGHLINE<<4;
    else
     color|=CLB_EDITOR_BASE<<4;
    if(desktopmode&DTM_EDIT_SONGNUM)
     showfilenum=1;
    else
     showfilenum=0;
    if((pei->infobits&PEIF_ENABLED) || (pei->entrytype>=DFT_AUDIOFILE)){
     showfilename=0;
    }else{
     showfilenum=0;
     showfilename=1;
    }
    if(desktopmode&DTM_EDIT_FILENAMES)
     showfilename=1;
    if(showfilenum && lengthcol){
     sprintf(souttext,"%2.2d.  ",pei-psi->firstsong+1);
     souttext[5]=0;
     if(lengthcol<7) // 7=max. length of filenum (9999.  )
      souttext[lengthcol]=0;
     pds_textdisplay_textxy(color,colpos,lineposy,souttext);
     colpos+=5;      // artist:title begins on a fixed position
    }
    endcol_id3=endcol;
    if((desktopmode&DTM_EDIT_SONGTIME) && (lengthcol>20) && (pei->infobits&PEIF_ENABLED)){
     unsigned int timesec=pei->timesec;
     len=sprintf(souttext,"(%d:%2.2d)",timesec/60,timesec%60);
     if(len<=lengthcol){
      endcol_id3-=len;
      pds_textdisplay_textxy(color,endcol_id3,lineposy,souttext);
     }
    }
    draw_one_id3info_line(pei,2,colpos,endcol_id3,color,lineposy,showfilename);
   }
  }
  for(;j<=editor_rows;j++,lineposy++)
   pds_textdisplay_spacecxyn(CLB_EDITOR_BASE,begincol,lineposy,lengthcol);
 }
}

static unsigned int set_editorline_color(struct playlist_side_info *psi,struct playlist_entry_info *pei)
{
 unsigned int color=CL_EDITOR_PLAYED; // gray
 struct mainvars *mvp=psi->mvp;

 if((psi==mvp->psip) && (GET_HFT(pei->entrytype)!=HFT_DFT) && (pei->infobits&PEIF_ENABLED)){
  if(pei==mvp->newfilenum)
   color=CL_EDITOR_NEWFILENUM;    // light green
  else{
   if(pei==mvp->aktfilenum){
    color=CL_EDITOR_AKTFILENUM;  // yellow
   }else{
    if((pei->entrytype>=DFT_AUDIOFILE) || (pei->entrytype==DFT_NOTCHECKED)){
     if(playrand){
      if(!(pei->infobits&PEIF_RNDPLAYED))
       color=CL_EDITOR_NOTPLAYED; // white
     }else{
      if(pei>=mvp->aktfilenum)
       color=CL_EDITOR_NOTPLAYED; // white
     }
    }
   }
  }
 }
 return color;
}

unsigned int display_editor_resize_x(struct mainvars *mvp,int direction)
{
 struct playlist_side_info *psie=mvp->psie;
 if((psie==mvp->psi0 && direction<0) || (psie!=mvp->psi0 && direction>0)){
  if(editorsideborder>EDITOR_SIDE_SIZE_MIN){
   editorsideborder--;
   return 1;
  }
 }else{
  if(editorsideborder<(maxx-EDITOR_SIDE_SIZE_MIN-3)){
   editorsideborder++;
   return 1;
  }
 }
 return 0;
}

void display_editor_resize_y(int direction)
{
 int maxline=dtp.editorend-4-dtp.endofbuttonsy;
 dtp.relative_songposline+=direction;

 if(dtp.relative_songposline<0)
  dtp.relative_songposline=0;
 if(dtp.relative_songposline>maxline)
  dtp.relative_songposline=maxline;

 dtp.relative_songposline-=dtp.relative_songposline%3;

 dtp.songposline_y=dtp.editorbegin=dtp.endofbuttonsy+1+dtp.relative_songposline;
 if(desktopmode&DTM_SONGPOS)
  dtp.editorbegin++;
}

void scroll_editorside(struct mainvars *mvp,struct playlist_entry_info *ehls)
{
 struct playlist_side_info *psi=mvp->psie;
 struct editor *edp=&ed[psi - mvp->psi0];
 unsigned int listlines=(psi->lastentry-psi->firstentry)+1;
 int editor_rows=edp->lengthline;
 int remainlines=listlines-editor_rows;
 struct playlist_entry_info *newfrom;
 editor_rows--;

 if(editor_rows>0 && remainlines>0){
  int diff=ehls-psi->editorhighline;
  newfrom=edp->from+diff;
  if(newfrom>=(psi->lastentry-editor_rows))
   newfrom=psi->lastentry-editor_rows;
  if(newfrom<psi->firstentry)
   newfrom=psi->firstentry;
  edp->from=newfrom;
  playlist_editorhighline_set(psi,ehls);
  refdisp|=RDT_EDITOR;
 }
}

//*************************************************************************
// mousepos functions
//*************************************************************************

void clear_mousepos_text(void)
{
 if(displaymode&DISP_NOFULLEDIT)
  pds_textdisplay_spacecxyn(CLB_INFOTEXT,dk[DK_MOUSEPOS].xpos,dk[DK_MOUSEPOS].ypos,8);
}

void draw_mousepos_text(unsigned int isbutton,char *text)
{
 short color;
 if(displaymode&DISP_NOFULLEDIT){
  if(isbutton)
   color=CLH_INFOTEXTB;
  else
   color=CLH_INFOTEXT;
  text[8]=0; // cut to window
  clear_mousepos_text();
  pds_textdisplay_textxybk(color,CLB_INFOTEXT,dk[DK_MOUSEPOS].xpos,dk[DK_MOUSEPOS].ypos,text);
 }
}

void draw_mouse_listpos(struct mainvars *mvp,unsigned int i)
{
 struct playlist_side_info *psi=mvp->psip;
 struct playlist_entry_info *pei=psi->firstsong+i;

 if(pei>=psi->firstsong && pei<=psi->lastentry){
  pds_getfilename_noext_from_fullname(souttext,pei->filename);
  draw_mousepos_text(1,souttext);
  if((desktopmode&DTM_EDIT_FOLLOWBROWSER) && (psi==mvp->psie)){
   playlist_editorhighline_set(psi,pei);
   refdisp|=RDT_EDITOR;
  }
 }
}

void draw_mouse_desktoppos(struct mainvars *mvp,unsigned int mousex,unsigned int mousey)
{
 unsigned int mousec,i;

 if(!(displaymode&DISP_FULLSCREEN) || !mouse_on)
  return;
 mousec=pds_textdisplay_getbkcolorxy(lastmousex,lastmousey);
 if(mousec!=CL_MOUSECURSOR)
  lastmousec=mousec;
 if((lastmousex!=mousex) || (lastmousey!=mousey) || (lastmousebox==65535)){
  i=65535;
  if((desktopmode&DTM_SONGPOS) && (mousey==dtp.songposline_y) && (mousex!=0) && (mousex!=(maxx-1))){
   recolor_lastbuttonbox_mousepos(mvp,NULL);
   i=(mvp->frp0->timesec*(mousex-1))/(maxx-2);
   sprintf(souttext," %2lu:%2.2lu   ",i/60,i%60);
   draw_mousepos_text(1,souttext);
  }else{
   if((desktopmode&DTM_LISTPOS) && (mousey==dtp.listposline_y) && (mousex!=0) && (mousex!=(maxx-1))){
    recolor_lastbuttonbox_mousepos(mvp,NULL);
    draw_mouse_listpos(mvp,allsongnum*mousex/(maxx-2));
    i=0;
   }else{
    if((displaymode&(DISP_NOFULLEDIT|DISP_ANALISER))==(DISP_NOFULLEDIT|DISP_ANALISER)
      && (mousey<anal_endline) && (mousex<32)){
     recolor_lastbuttonbox_mousepos(mvp,NULL);
     sprintf(souttext,"%5d Hz",(mousex+1)*22050/32);
     draw_mousepos_text(0,souttext);
     i=0;
    }else{
     if(mpxplay_control_mouse_xy_to_dp(mvp,mousex,mousey)!=NULL)
      i=0;
    }
   }
  }
  if(i==65535)
   recolor_lastbuttonbox_mousepos(mvp,NULL);
  pds_textdisplay_setbkcolorxy(lastmousec,lastmousex,lastmousey);
  lastmousec=pds_textdisplay_getbkcolorxy(mousex,mousey);
  lastmousex=mousex;lastmousey=mousey;
  lastmousebox=0;
 }
 pds_textdisplay_setbkcolorxy(CL_MOUSECURSOR,lastmousex,lastmousey);
}

void draw_mouse_cursor_refresh(void)
{
 unsigned int mousec;
 if(displaymode&DISP_FULLSCREEN){
  mousec=pds_textdisplay_getbkcolorxy(lastmousex,lastmousey);
  if(mousec!=CL_MOUSECURSOR)
   lastmousec=mousec;
  pds_textdisplay_setbkcolorxy(CL_MOUSECURSOR,lastmousex,lastmousey);
 }
}

//************************************************************************

void display_message(unsigned int linepos,unsigned int blink,char *msg)
{
 static char msg0[64];
 unsigned int color;
 char line[128];

 if(displaymode){
  color=CLH_ID3TEXT|(CLB_ID3TEXT<<4);
  if(blink)
   color|=CL_BLINK;
  sprintf(souttext,"%-50s",msg);
  souttext[46]=0;
  if(displaymode&DISP_NOFULLEDIT){
   pds_textdisplay_textxy(color,dk[0].xpos+1,dk[DK_ID3INFO].ypos+linepos,souttext);
  }else{
   if(displaymode&DISP_TIMEPOS)
    if(!linepos){
     pds_textdisplay_textxy(color,0,dtp.timepos_fe,souttext);
     pds_strcpy(msg0,souttext);
    }else{
     pds_strcpy(line,msg0);
     pds_strcat(line,souttext);
     line[maxx-1]=0;
     pds_textdisplay_textxy(color,0,dtp.timepos_fe,line);
    }
  }
 }
}

void clear_message(void)
{
 refdisp|=RDT_HEADER;
}

void display_warning_message(char *message)
{
 if(displaymode){
  pds_textdisplay_printf(message);
  //delay(2000);
 }
}

void display_bufpos_int08(struct mainvars *mvp)
{
 float f;
 long i;
 char sout[32];

 if(displaymode&DISP_FULLSCREEN){
  struct frame *frp=mvp->frp0;
  int color;
  if(!funcbit_test(intsoundcontrol,INTSOUND_DOSSHELL) || !funcbit_test(intsoundcontrol,INTSOUND_TSR)){
   f=100*(float)frp->prebufferbytes_forward/(float)frp->prebuffersize;
   pds_ftoi(f,&i);
   if(i>99)
    i=99;
   sprintf(sout,"%2d%%",i); // buffer left in %
   if(i<20)
    color=12;
   else
    color=CL_INFOTEXT;
  }else{
   f=100*(float)frp->frameNum/(float)frp->allframes;
   pds_ftoi(f,&i);
   if(i>99)
    i=99;
   sprintf(sout,"Pos:%2d%%",i); // song position in %
   color=15;
  }
  if(funcbit_test(intsoundcontrol,INTSOUND_DOSSHELL))
   pds_textdisplay_textxybk(color,1,0,0,sout);
  else
   if(displaymode&DISP_NOFULLEDIT)
    pds_textdisplay_textxybk(color,CLB_INFOTEXT,dk[DK_BUFCPU].xpos,dk[DK_BUFCPU].ypos,sout);
 }
}
