//**************************************************************************
//*                     This file is part of the                           *
//*                      Mpxplay - audio player.                           *
//*                  The source code of Mpxplay is                         *
//*        (C) copyright 1998-2005 by PDSoft (Attila Padar)                *
//*                    http://mpxplay.cjb.net                              *
//*                  email: mpxplay@freemail.hu                            *
//**************************************************************************
//*  This program is distributed in the hope that it will be useful,       *
//*  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
//*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                  *
//*  Please contact with the author (with me) if you want to use           *
//*  or modify this source.                                                *
//**************************************************************************
//function: Audio MPEG Layer II decoding
//based on the MPG123 MPEG decoder source

#include <math.h>
#include "mp3dec.h"

typedef struct
{
 short bits;
 short d;
}al_table;

static al_table alloc_0[] = {
	{4,0},{5,3},{3,-3},{4,-7},{5,-15},{6,-31},{7,-63},{8,-127},{9,-255},{10,-511},
	{11,-1023},{12,-2047},{13,-4095},{14,-8191},{15,-16383},{16,-32767},
	{4,0},{5,3},{3,-3},{4,-7},{5,-15},{6,-31},{7,-63},{8,-127},{9,-255},{10,-511},
	{11,-1023},{12,-2047},{13,-4095},{14,-8191},{15,-16383},{16,-32767},
	{4,0},{5,3},{3,-3},{4,-7},{5,-15},{6,-31},{7,-63},{8,-127},{9,-255},{10,-511},
	{11,-1023},{12,-2047},{13,-4095},{14,-8191},{15,-16383},{16,-32767},
	{4,0},{5,3},{7,5},{3,-3},{10,9},{4,-7},{5,-15},{6,-31},{7,-63},{8,-127},
	{9,-255},{10,-511},{11,-1023},{12,-2047},{13,-4095},{16,-32767},
	{4,0},{5,3},{7,5},{3,-3},{10,9},{4,-7},{5,-15},{6,-31},{7,-63},{8,-127},
	{9,-255},{10,-511},{11,-1023},{12,-2047},{13,-4095},{16,-32767},
	{4,0},{5,3},{7,5},{3,-3},{10,9},{4,-7},{5,-15},{6,-31},{7,-63},{8,-127},
	{9,-255},{10,-511},{11,-1023},{12,-2047},{13,-4095},{16,-32767},
	{4,0},{5,3},{7,5},{3,-3},{10,9},{4,-7},{5,-15},{6,-31},{7,-63},{8,-127},
	{9,-255},{10,-511},{11,-1023},{12,-2047},{13,-4095},{16,-32767},
	{4,0},{5,3},{7,5},{3,-3},{10,9},{4,-7},{5,-15},{6,-31},{7,-63},{8,-127},
	{9,-255},{10,-511},{11,-1023},{12,-2047},{13,-4095},{16,-32767},
	{4,0},{5,3},{7,5},{3,-3},{10,9},{4,-7},{5,-15},{6,-31},{7,-63},{8,-127},
	{9,-255},{10,-511},{11,-1023},{12,-2047},{13,-4095},{16,-32767},
	{4,0},{5,3},{7,5},{3,-3},{10,9},{4,-7},{5,-15},{6,-31},{7,-63},{8,-127},
	{9,-255},{10,-511},{11,-1023},{12,-2047},{13,-4095},{16,-32767},
	{4,0},{5,3},{7,5},{3,-3},{10,9},{4,-7},{5,-15},{6,-31},{7,-63},{8,-127},
	{9,-255},{10,-511},{11,-1023},{12,-2047},{13,-4095},{16,-32767},
	{3,0},{5,3},{7,5},{3,-3},{10,9},{4,-7},{5,-15},{16,-32767},
	{3,0},{5,3},{7,5},{3,-3},{10,9},{4,-7},{5,-15},{16,-32767},
	{3,0},{5,3},{7,5},{3,-3},{10,9},{4,-7},{5,-15},{16,-32767},
	{3,0},{5,3},{7,5},{3,-3},{10,9},{4,-7},{5,-15},{16,-32767},
	{3,0},{5,3},{7,5},{3,-3},{10,9},{4,-7},{5,-15},{16,-32767},
	{3,0},{5,3},{7,5},{3,-3},{10,9},{4,-7},{5,-15},{16,-32767},
	{3,0},{5,3},{7,5},{3,-3},{10,9},{4,-7},{5,-15},{16,-32767},
	{3,0},{5,3},{7,5},{3,-3},{10,9},{4,-7},{5,-15},{16,-32767},
	{3,0},{5,3},{7,5},{3,-3},{10,9},{4,-7},{5,-15},{16,-32767},
	{3,0},{5,3},{7,5},{3,-3},{10,9},{4,-7},{5,-15},{16,-32767},
	{3,0},{5,3},{7,5},{3,-3},{10,9},{4,-7},{5,-15},{16,-32767},
	{3,0},{5,3},{7,5},{3,-3},{10,9},{4,-7},{5,-15},{16,-32767},
	{2,0},{5,3},{7,5},{16,-32767},
	{2,0},{5,3},{7,5},{16,-32767},
	{2,0},{5,3},{7,5},{16,-32767},
	{2,0},{5,3},{7,5},{16,-32767} };

static al_table alloc_1[] = {
	{4,0},{5,3},{3,-3},{4,-7},{5,-15},{6,-31},{7,-63},{8,-127},{9,-255},{10,-511},
	{11,-1023},{12,-2047},{13,-4095},{14,-8191},{15,-16383},{16,-32767},
	{4,0},{5,3},{3,-3},{4,-7},{5,-15},{6,-31},{7,-63},{8,-127},{9,-255},{10,-511},
	{11,-1023},{12,-2047},{13,-4095},{14,-8191},{15,-16383},{16,-32767},
	{4,0},{5,3},{3,-3},{4,-7},{5,-15},{6,-31},{7,-63},{8,-127},{9,-255},{10,-511},
	{11,-1023},{12,-2047},{13,-4095},{14,-8191},{15,-16383},{16,-32767},
	{4,0},{5,3},{7,5},{3,-3},{10,9},{4,-7},{5,-15},{6,-31},{7,-63},{8,-127},
	{9,-255},{10,-511},{11,-1023},{12,-2047},{13,-4095},{16,-32767},
	{4,0},{5,3},{7,5},{3,-3},{10,9},{4,-7},{5,-15},{6,-31},{7,-63},{8,-127},
	{9,-255},{10,-511},{11,-1023},{12,-2047},{13,-4095},{16,-32767},
	{4,0},{5,3},{7,5},{3,-3},{10,9},{4,-7},{5,-15},{6,-31},{7,-63},{8,-127},
	{9,-255},{10,-511},{11,-1023},{12,-2047},{13,-4095},{16,-32767},
	{4,0},{5,3},{7,5},{3,-3},{10,9},{4,-7},{5,-15},{6,-31},{7,-63},{8,-127},
	{9,-255},{10,-511},{11,-1023},{12,-2047},{13,-4095},{16,-32767},
	{4,0},{5,3},{7,5},{3,-3},{10,9},{4,-7},{5,-15},{6,-31},{7,-63},{8,-127},
	{9,-255},{10,-511},{11,-1023},{12,-2047},{13,-4095},{16,-32767},
	{4,0},{5,3},{7,5},{3,-3},{10,9},{4,-7},{5,-15},{6,-31},{7,-63},{8,-127},
	{9,-255},{10,-511},{11,-1023},{12,-2047},{13,-4095},{16,-32767},
	{4,0},{5,3},{7,5},{3,-3},{10,9},{4,-7},{5,-15},{6,-31},{7,-63},{8,-127},
	{9,-255},{10,-511},{11,-1023},{12,-2047},{13,-4095},{16,-32767},
	{4,0},{5,3},{7,5},{3,-3},{10,9},{4,-7},{5,-15},{6,-31},{7,-63},{8,-127},
	{9,-255},{10,-511},{11,-1023},{12,-2047},{13,-4095},{16,-32767},
	{3,0},{5,3},{7,5},{3,-3},{10,9},{4,-7},{5,-15},{16,-32767},
	{3,0},{5,3},{7,5},{3,-3},{10,9},{4,-7},{5,-15},{16,-32767},
	{3,0},{5,3},{7,5},{3,-3},{10,9},{4,-7},{5,-15},{16,-32767},
	{3,0},{5,3},{7,5},{3,-3},{10,9},{4,-7},{5,-15},{16,-32767},
	{3,0},{5,3},{7,5},{3,-3},{10,9},{4,-7},{5,-15},{16,-32767},
	{3,0},{5,3},{7,5},{3,-3},{10,9},{4,-7},{5,-15},{16,-32767},
	{3,0},{5,3},{7,5},{3,-3},{10,9},{4,-7},{5,-15},{16,-32767},
	{3,0},{5,3},{7,5},{3,-3},{10,9},{4,-7},{5,-15},{16,-32767},
	{3,0},{5,3},{7,5},{3,-3},{10,9},{4,-7},{5,-15},{16,-32767},
	{3,0},{5,3},{7,5},{3,-3},{10,9},{4,-7},{5,-15},{16,-32767},
	{3,0},{5,3},{7,5},{3,-3},{10,9},{4,-7},{5,-15},{16,-32767},
	{3,0},{5,3},{7,5},{3,-3},{10,9},{4,-7},{5,-15},{16,-32767},
	{2,0},{5,3},{7,5},{16,-32767},
	{2,0},{5,3},{7,5},{16,-32767},
	{2,0},{5,3},{7,5},{16,-32767},
	{2,0},{5,3},{7,5},{16,-32767},
	{2,0},{5,3},{7,5},{16,-32767},
	{2,0},{5,3},{7,5},{16,-32767},
	{2,0},{5,3},{7,5},{16,-32767} };

static al_table alloc_2[] = {
	{4,0},{5,3},{7,5},{10,9},{4,-7},{5,-15},{6,-31},{7,-63},{8,-127},{9,-255},
	{10,-511},{11,-1023},{12,-2047},{13,-4095},{14,-8191},{15,-16383},
	{4,0},{5,3},{7,5},{10,9},{4,-7},{5,-15},{6,-31},{7,-63},{8,-127},{9,-255},
	{10,-511},{11,-1023},{12,-2047},{13,-4095},{14,-8191},{15,-16383},
	{3,0},{5,3},{7,5},{10,9},{4,-7},{5,-15},{6,-31},{7,-63},
	{3,0},{5,3},{7,5},{10,9},{4,-7},{5,-15},{6,-31},{7,-63},
	{3,0},{5,3},{7,5},{10,9},{4,-7},{5,-15},{6,-31},{7,-63},
	{3,0},{5,3},{7,5},{10,9},{4,-7},{5,-15},{6,-31},{7,-63},
	{3,0},{5,3},{7,5},{10,9},{4,-7},{5,-15},{6,-31},{7,-63},
	{3,0},{5,3},{7,5},{10,9},{4,-7},{5,-15},{6,-31},{7,-63} };

static al_table alloc_3[] = {
	{4,0},{5,3},{7,5},{10,9},{4,-7},{5,-15},{6,-31},{7,-63},{8,-127},{9,-255},
	{10,-511},{11,-1023},{12,-2047},{13,-4095},{14,-8191},{15,-16383},
	{4,0},{5,3},{7,5},{10,9},{4,-7},{5,-15},{6,-31},{7,-63},{8,-127},{9,-255},
	{10,-511},{11,-1023},{12,-2047},{13,-4095},{14,-8191},{15,-16383},
	{3,0},{5,3},{7,5},{10,9},{4,-7},{5,-15},{6,-31},{7,-63},
	{3,0},{5,3},{7,5},{10,9},{4,-7},{5,-15},{6,-31},{7,-63},
	{3,0},{5,3},{7,5},{10,9},{4,-7},{5,-15},{6,-31},{7,-63},
	{3,0},{5,3},{7,5},{10,9},{4,-7},{5,-15},{6,-31},{7,-63},
	{3,0},{5,3},{7,5},{10,9},{4,-7},{5,-15},{6,-31},{7,-63},
	{3,0},{5,3},{7,5},{10,9},{4,-7},{5,-15},{6,-31},{7,-63},
	{3,0},{5,3},{7,5},{10,9},{4,-7},{5,-15},{6,-31},{7,-63},
	{3,0},{5,3},{7,5},{10,9},{4,-7},{5,-15},{6,-31},{7,-63},
	{3,0},{5,3},{7,5},{10,9},{4,-7},{5,-15},{6,-31},{7,-63},
	{3,0},{5,3},{7,5},{10,9},{4,-7},{5,-15},{6,-31},{7,-63} };

/*static al_table alloc_4[] = {
	{4,0},{5,3},{7,5},{3,-3},{10,9},{4,-7},{5,-15},{6,-31},{7,-63},{8,-127},
		{9,-255},{10,-511},{11,-1023},{12,-2047},{13,-4095},{14,-8191},
	{4,0},{5,3},{7,5},{3,-3},{10,9},{4,-7},{5,-15},{6,-31},{7,-63},{8,-127},
		{9,-255},{10,-511},{11,-1023},{12,-2047},{13,-4095},{14,-8191},
	{4,0},{5,3},{7,5},{3,-3},{10,9},{4,-7},{5,-15},{6,-31},{7,-63},{8,-127},
		{9,-255},{10,-511},{11,-1023},{12,-2047},{13,-4095},{14,-8191},
	{4,0},{5,3},{7,5},{3,-3},{10,9},{4,-7},{5,-15},{6,-31},{7,-63},{8,-127},
		{9,-255},{10,-511},{11,-1023},{12,-2047},{13,-4095},{14,-8191},
	{3,0},{5,3},{7,5},{10,9},{4,-7},{5,-15},{6,-31},{7,-63},
	{3,0},{5,3},{7,5},{10,9},{4,-7},{5,-15},{6,-31},{7,-63},
	{3,0},{5,3},{7,5},{10,9},{4,-7},{5,-15},{6,-31},{7,-63},
	{3,0},{5,3},{7,5},{10,9},{4,-7},{5,-15},{6,-31},{7,-63},
	{3,0},{5,3},{7,5},{10,9},{4,-7},{5,-15},{6,-31},{7,-63},
	{3,0},{5,3},{7,5},{10,9},{4,-7},{5,-15},{6,-31},{7,-63},
	{3,0},{5,3},{7,5},{10,9},{4,-7},{5,-15},{6,-31},{7,-63},
	{2,0},{5,3},{7,5},{10,9},
	{2,0},{5,3},{7,5},{10,9},
	{2,0},{5,3},{7,5},{10,9},
	{2,0},{5,3},{7,5},{10,9},
	{2,0},{5,3},{7,5},{10,9},
	{2,0},{5,3},{7,5},{10,9},
	{2,0},{5,3},{7,5},{10,9},
	{2,0},{5,3},{7,5},{10,9},
	{2,0},{5,3},{7,5},{10,9},
	{2,0},{5,3},{7,5},{10,9},
	{2,0},{5,3},{7,5},{10,9},
    {2,0},{5,3},{7,5},{10,9},
    {2,0},{5,3},{7,5},{10,9},
    {2,0},{5,3},{7,5},{10,9},
    {2,0},{5,3},{7,5},{10,9},
    {2,0},{5,3},{7,5},{10,9},
    {2,0},{5,3},{7,5},{10,9},
    {2,0},{5,3},{7,5},{10,9},
    {2,0},{5,3},{7,5},{10,9}  };*/

static FLOAT muls[27][64];
static unsigned int grp_3tab[32*3];
static unsigned int grp_5tab[128*3];
static unsigned int grp_9tab[1024*3];
static int II_sblimit,II_jsbound;
static al_table *alloc;

extern int bitindex;
extern unsigned char *wordpointer;
extern unsigned int MIXER_var_usehq;

void mpxdec_layer2_getstuff(struct mp3_decoder_data *mp3i)
{
 static unsigned char translate[3][2][16] =
   { { { 0,2,2,2,2,2,2,0,0,0,1,1,1,1,1,0 } ,
       { 0,2,2,0,0,0,1,1,1,1,1,1,1,1,1,0 } } ,
     { { 0,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0 } ,
       { 0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0 } } ,
     { { 0,3,3,3,3,3,3,0,0,0,1,1,1,1,1,0 } ,
       { 0,3,3,0,0,0,1,1,1,1,1,1,1,1,1,0 } } };
 static unsigned int sblims[5]={27,30,8,12,30};
 static al_table *tables[5]={alloc_0,alloc_1,alloc_2,alloc_3/*,alloc_4*/};
 int table;

 /*if(frp->lsf) // it seems this doesn't work
  table = 4;
 else*/
  table=translate[mp3i->frequency_index][2-mp3i->filechannels][mp3i->bitrate_index];
 alloc=tables[table];
 II_sblimit=sblims[table];
 II_jsbound=(mp3i->mpg_chmode==1)? ((mp3i->mpg_chmode_ext<<2)+4):II_sblimit;
}

void mpxdec_layer2_init(void)
{
 static FLOAT mulmul[27] = {
    0.0 , -2.0/3.0 , 2.0/3.0 ,
    2.0/7.0 , 2.0/15.0 , 2.0/31.0, 2.0/63.0 , 2.0/127.0 , 2.0/255.0 ,
    2.0/511.0 , 2.0/1023.0 , 2.0/2047.0 , 2.0/4095.0 , 2.0/8191.0 ,
    2.0/16383.0 , 2.0/32767.0 , 2.0/65535.0 ,
    -4.0/5.0 , -2.0/5.0 , 2.0/5.0, 4.0/5.0 ,
    -8.0/9.0 , -4.0/9.0 , -2.0/9.0 , 2.0/9.0 , 4.0/9.0 , 8.0/9.0 };
 static int base[3][9] = {
     { 1 , 0, 2 , } ,
     { 17, 18, 0 , 19, 20 , } ,
     { 21, 1, 22, 23, 0, 24, 25, 2, 26 } };
 static unsigned int tablen[3] = { 3 , 5 , 9 };
 static unsigned int *tables[3] = { grp_3tab , grp_5tab , grp_9tab };
 int i,j,k,l,len;
 FLOAT *table;
 unsigned int *itable;

 for(i=0;i<3;i++){
  itable = tables[i];
  len = tablen[i];
  for(j=0;j<len;j++)
   for(k=0;k<len;k++)
    for(l=0;l<len;l++){
     *itable++ = base[i][l];
     *itable++ = base[i][k];
     *itable++ = base[i][j];
    }
 }

 for(k=0;k<27;k++){
  const FLOAT m=mulmul[k];
  table = muls[k];
  for(j=3,i=0;i<63;i++,j--)
   *table++ = pow(2.0,(double) j / 3.0) * m;
  *table = 0.0;
 }
}

unsigned int getbits_one(int);

static void II_step_one(unsigned int *bit_alloc,int *scale,int stereo)
{
 int sblimit = II_sblimit;
 int jsbound = II_jsbound;
 int sblimit2 = II_sblimit<<stereo;
 al_table *alloc1 = alloc;
 int i;
 unsigned int scfsi_buf[64];
 register unsigned int *scfsi,*bita;
 register int sc,step;
 int loc_bitindex=bitindex;
 unsigned char *loc_wordpointer=wordpointer;

#pragma aux getbits_one=\
	"mov  eax,loc_bitindex"\
	"mov  ecx,eax"\
	"shr  eax,3"\
	"add  eax,loc_wordpointer"\
	"mov  eax,dword ptr [eax]"\
	"and  ecx,7"\
	"bswap eax"\
	"shl  eax,cl"\
	"mov  cl,32"\
	"sub  cl,bl"\
	"shr  eax,cl"\
	"add  loc_bitindex,ebx"\
	parm [ebx] value [eax] modify [ecx];

#define getbits_fast(x) getbits_one(x)

 bita=bit_alloc;
 if(stereo){
  for(i=jsbound;i;i--){
   step=alloc1->bits;
   alloc1+=(1<<step);
   bita[0]=getbits_one(step);
   bita[1]=getbits_one(step);
   bita+=2;
  }
  for(i=sblimit-jsbound;i;i--){
   step=alloc1->bits;
   bita[0]=bita[1]=getbits_one(step);
   bita+=2;
   alloc1+=(1<<step);
  }
  bita=bit_alloc;
  scfsi=scfsi_buf;
  for(i=sblimit2;i;i--){
   if(*bita++)
    *scfsi++=getbits_fast(2);
  }
 }else{
  for(i=sblimit;i;i--){
   step=alloc1->bits;
   *bita++=getbits_one(step);
   alloc1+=(1<<step);
  }
  bita=bit_alloc;
  scfsi=scfsi_buf;
  for(i=sblimit;i;i--){
   if(*bita++)
    *scfsi++=getbits_fast(2);
  }
 }
 bita=bit_alloc;
 scfsi=scfsi_buf;
 for(i=sblimit2;i;i--){
  if(*bita++){
   switch(*scfsi){
    case 0:
	   scale[0]=getbits_fast(6);
	   scale[1]=getbits_fast(6);
	   scale[2]=getbits_fast(6);
	   break;
    case 1:
	   sc=getbits_fast(6);
	   scale[0]=sc;
	   scale[1]=sc;
	   scale[2]=getbits_fast(6);
	   break;
    case 2:
	   sc=getbits_fast(6);
	   scale[0]=sc;
	   scale[1]=sc;
	   scale[2]=sc;
	   break;
    default:
	   scale[0]=getbits_fast(6);
	   sc=getbits_fast(6);
	   scale[1]=sc;
	   scale[2]=sc;
	   break;
   }
   scale+=3;
   scfsi++;
  }
 }
 bitindex=loc_bitindex;
}

unsigned int getbits_two(int);

static void II_step_two(unsigned int *bita,int *scale,FLOAT *fracti,int stereo)
{
 static unsigned int *table[] = { 0,0,0,grp_3tab,0,grp_5tab,0,0,0,grp_9tab };
 register FLOAT *frac0,*frac1;
 int sb,ch,k,d1;
 int sblimit = II_sblimit;
 int jsbound = II_jsbound;
 al_table *alloc2,*alloc1 = alloc;
 int loc_bitindex=bitindex,lastnonzero[2];
 unsigned char *loc_wordpointer=wordpointer;

#pragma aux getbits_two=\
	"mov  eax,loc_bitindex"\
	"mov  ecx,eax"\
	"shr  eax,3"\
	"add  eax,loc_wordpointer"\
	"mov  eax,dword ptr [eax]"\
	"and  ecx,7"\
	"bswap eax"\
	"shl  eax,cl"\
	"mov  cl,32"\
	"sub  cl,bl"\
	"shr  eax,cl"\
	"add  loc_bitindex,ebx"\
	parm [ebx] value [eax] modify [ecx];

 lastnonzero[0]=lastnonzero[1]=0;
 frac0=fracti;
 for(sb=0;sb<jsbound;sb++){
  frac1=frac0;
  for(ch=0;ch<stereo;ch++){
   if(bita[0]){
    k=(alloc2=alloc1+bita[0])->bits;
    if((d1=alloc2->d)<0){
     const FLOAT cm=muls[k][scale[0]];
     frac1[ 0]= ((FLOAT) ((int)getbits_two(k) + d1)) * cm;
     frac1[32]= ((FLOAT) ((int)getbits_two(k) + d1)) * cm;
     frac1[64]= ((FLOAT) ((int)getbits_two(k) + d1)) * cm;
    }else{
     unsigned int idx,*tab,m;
     idx=getbits_two(k);
     tab=table[d1]+idx+idx+idx;
     m=scale[0];
     frac1[ 0]= muls[tab[0]][m];
     frac1[32]= muls[tab[1]][m];
     frac1[64]= muls[tab[2]][m];
    }
    lastnonzero[ch]=sb;
    scale+=3;
   }else
    frac1[0]=frac1[32]=frac1[64]=0.0;
   bita++;
   frac1+=576;
  }
  alloc1+=(1<<alloc1->bits);
  frac0++;
 }
 frac1=frac0+576;
 bita++;
 for(sb=jsbound;sb<sblimit;sb++){
  if(bita[0]){
   k=(alloc2=alloc1+bita[0])->bits;
   if((d1=alloc2->d)<0){
    const FLOAT cm0=muls[k][scale[0]];
    const FLOAT cm1=muls[k][scale[3]];
    int b;
    b=getbits_two(k)+d1;
    frac0[ 0]=((FLOAT)b)*cm0;
    frac1[ 0]=((FLOAT)b)*cm1;
    b=getbits_two(k)+d1;
    frac0[32]=((FLOAT)b)*cm0;
    frac1[32]=((FLOAT)b)*cm1;
    b=getbits_two(k)+d1;
    frac0[64]=((FLOAT)b)*cm0;
    frac1[64]=((FLOAT)b)*cm1;
   }else{
    unsigned int idx,*tab,m1,m2;
    idx=getbits_two(k);
    tab=table[d1]+idx+idx+idx;
    m1 =scale[0];
    m2 =scale[3];
    frac0[ 0] = muls[tab[0]][m1];
    frac1[ 0] = muls[tab[0]][m2];
    frac0[32] = muls[tab[1]][m1];
    frac1[32] = muls[tab[1]][m2];
    frac0[64] = muls[tab[2]][m1];
    frac1[64] = muls[tab[2]][m2];
   }
   scale+=6;
   lastnonzero[0]=lastnonzero[1]=sb;
  }else
   frac0[0]=frac0[32]=frac0[64]=frac1[0]=frac1[32]=frac1[64]=0.0;
  bita+=2;
  alloc1+=(1<<alloc1->bits);
  frac0++;frac1++;
 }
 if(MIXER_var_usehq){
  for(ch=0;ch<stereo;ch++){
   frac0=fracti+lastnonzero[ch];
   frac1=frac0+1;
   k=1;
   for(sb=lastnonzero[ch]+1;sb<SBLIMIT;sb++){
    const FLOAT cm=(FLOAT)(k++)*(FLOAT)(1.4);
    frac1[0] =frac0[0]/cm;
    frac1[32]=frac0[32]/cm;
    frac1[64]=frac0[64]/cm;
    frac1++;
   }
  }
 }else{
  for(ch=0;ch<stereo;ch++){
   frac1=frac0;
   for(sb=sblimit;sb<SBLIMIT;sb++){
    frac1[0]=frac1[32]=frac1[64]=0.0;
    frac1++;
   }
   frac0+=576;
  }
 }
 bitindex=loc_bitindex;
}

void mpxdec_layer2_decode_part1(struct mp3_decoder_data *mp3i)
{
 int i,stereo=mp3i->filechannels;
 FLOAT *hybridout=mp3i->hybridp;
 unsigned int bit_alloc[64];
 int scale[192];

 II_step_one(bit_alloc,scale,stereo-1);
 for(i=0;i<6;i++){
  II_step_two(bit_alloc,&scale[i>>2],hybridout,stereo);
  hybridout+=3*SBLIMIT;
 }
 hybridout+=(18*SBLIMIT);
 for(;i<12;i++){
  II_step_two(bit_alloc,&scale[i>>2],hybridout,stereo);
  hybridout+=3*SBLIMIT;
 }
}
