/* 
 *	Copyright (C) Aaron Holtzman - May 1999
 *
 *  This file is part of ac3dec, a free Dolby AC-3 stream decoder.
 *	
 *  ac3dec is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  ac3dec is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */

// modifications: - Mpxplay (error check) (Jan 2002)

#include "ac3.h"
#include "exponent.h"

static sint_16 EXPT[125][3];

static unsigned int exp_unpack_ch(uint_16 exp_acc,uint_16 exps[], uint_16 *dest,uint_16 ngrps,uint_16 type,uint_16 expstr);

void ac3dec_exponent_init()
{
 int i;

 for(i=0; i<125; i++){
  sint_16 *ep=&EXPT[i][0];
  ep[0] = i / 25;
  ep[1] = (i - ep[0] * 25) / 5;
  ep[2] =  i - ep[0] * 25 - ep[1] * 5 - 2;
  ep[0] -= 2;
  ep[1] -= 2;
 }
}

unsigned int ac3dec_exponent_unpack(bsi_t *bsi, audblk_t *audblk)
{
 uint_16 i;

 for(i=0; i< bsi->nfchans; i++){
  if(!exp_unpack_ch(audblk->exps[i][0],&audblk->exps[i][1],audblk->fbw_exp[i],audblk->nchgrps[i],UNPACK_FBW,audblk->chexpstr[i]))
   return 0;

  //check
  if(audblk->fbw_exp[i][255] || audblk->fbw_exp[i][254] || audblk->fbw_exp[i][253]){
   audblk->fbw_exp[i][255]=audblk->fbw_exp[i][254]=audblk->fbw_exp[i][253]=0;
   return 0;
  }
 }

 if(audblk->cplinu){
  if(!exp_unpack_ch(audblk->cplabsexp<<1,audblk->cplexps,&audblk->cpl_exp[audblk->cplstrtmant],audblk->ncplgrps,UNPACK_CPL, audblk->cplexpstr))
   return 0;

  //check
  if(audblk->cpl_exp[255] || audblk->cpl_exp[254] || audblk->cpl_exp[253]){
   audblk->cpl_exp[255]=audblk->cpl_exp[254]=audblk->cpl_exp[253]=0;
   return 0;
  }
 }

 if(bsi->lfeon)
  if(!exp_unpack_ch(audblk->lfeexps[0],&audblk->lfeexps[1],audblk->lfe_exp,2,UNPACK_LFE,audblk->lfeexpstr))
   return 0;

 return 1;
}

static unsigned int exp_unpack_ch(uint_16 exp_acc,uint_16 exps[], uint_16 *dest, uint_16 ngrps,
                                  uint_16 type,uint_16 expstr)
{
 if((expstr == EXP_REUSE) || !ngrps)
  return 1;

 // In the case of a fbw channel then the initial absolute values is also an exponent
 if(type != UNPACK_CPL)
  *dest++ = exp_acc;

 // Loop through the groups and fill the dest array appropriately
 switch(expstr){
  case EXP_D15:
   {
    do{
     sint_16 *ep;
     if(*exps>124){
      return 0;
     }
     ep=&EXPT[*exps++][0];

     exp_acc += ep[0];
     dest[0]=exp_acc;

     exp_acc += ep[1];
     dest[1]=exp_acc;

     exp_acc += ep[2];
     dest[2]=exp_acc;

     dest+=3;
    }while(--ngrps);
   }
   break;
  case EXP_D25:
   {
    do{
     sint_16 *ep;
     if(*exps>124){
      return 0;
     }
     ep=&EXPT[*exps++][0];

     exp_acc += ep[0];
     dest[0]=exp_acc;
     dest[1]=exp_acc;

     exp_acc += ep[1];
     dest[2]=exp_acc;
     dest[3]=exp_acc;

     exp_acc += ep[2];
     dest[4]=exp_acc;
     dest[5]=exp_acc;

     dest+=6;
    }while(--ngrps);
   }
   break;
  case EXP_D45:
   {
    do{
     sint_16 *ep;
     if(*exps>124){
      return 0;
     }
     ep=&EXPT[*exps++][0];

     exp_acc += ep[0];
     dest[0]=exp_acc;
     dest[1]=exp_acc;
     dest[2]=exp_acc;
     dest[3]=exp_acc;

     exp_acc += ep[1];
     dest[4]=exp_acc;
     dest[5]=exp_acc;
     dest[6]=exp_acc;
     dest[7]=exp_acc;

     exp_acc += ep[2];
     dest[8]=exp_acc;
     dest[9]=exp_acc;
     dest[10]=exp_acc;
     dest[11]=exp_acc;

     dest+=12;
    }while(--ngrps);
   }
   break;
 }
 return 1;
}
