//**************************************************************************
//*                     This file is part of the                           *
//*                      Mpxplay - audio player.                           *
//*                  The source code of Mpxplay is                         *
//*        (C) copyright 1998-2005 by PDSoft (Attila Padar)                *
//*                    http://mpxplay.cjb.net                              *
//*                  email: mpxplay@freemail.hu                            *
//**************************************************************************
//*  This program is distributed in the hope that it will be useful,       *
//*  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
//*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                  *
//*  Please contact with the author (with me) if you want to use           *
//*  or modify this source.                                                *
//**************************************************************************
//function: AC3 bistream/frame reading
//
//based on the ac3dec by Aaron Holtzman

#include <string.h>
#include "ac3.h"

//read 1 byte from the bs->buffer (if available) or from the file
unsigned long ac3dec_bitstream_readbyte(ac3_decoder_data *amip)
{
 char readbuf;
 unsigned int getbytenum;
 bitstream_t *bs=amip->bs;
 if(bs->stored_bytes){
  readbuf=bs->buffer[bs->store_ptr];
  bs->stored_bytes--;
  bs->store_ptr++;
 }else{
  getbytenum=amip->readfunc_callback(amip->readfunc_passinfo,&readbuf,1);
  if(!getbytenum){
   amip->bs->file=0;
   return 0;
  }
 }
 return ((unsigned long)readbuf);
}

//fill the bs->buffer with the requested number of bytes minus the already stored bytes
unsigned int ac3dec_bitstream_loadframe(ac3_decoder_data *amip,unsigned int bytenum)
{
 bitstream_t *bs=amip->bs;
 unsigned long bytes_read;
 if(bytenum>AC3_FRAMESIZE_MAX)
  return 0;
 if(bs->stored_bytes){
  memcpy(bs->buffer,&bs->buffer[bs->store_ptr],bs->stored_bytes);
  bs->store_ptr=0;
  if(bytenum>bs->stored_bytes)
   bytenum-=bs->stored_bytes;
  else
   return 1;
 }else
  bs->store_ptr=0;
 bytes_read = (amip->readfunc_callback)(amip->readfunc_passinfo,&bs->buffer[bs->stored_bytes],bytenum);
 bs->stored_bytes+=bytes_read;
 if(bytes_read!=bytenum)
  return 0;
 return bytenum;
}

// getbits function for max. 24 bits (I think so the decoder never wants to read more at once)
#ifdef __WATCOMC__

uint_32 asm_getbits(bitstream_t *bs,uint_32 num_bits);
#pragma aux asm_getbits=\
 "test edx,edx"\
 "jnz beginget"\
 "error:"\
  "xor eax,eax"\
 "jmp endget"\
 "beginget:"\
 "mov  ebx,dword ptr [eax]"\
 "add  dword ptr [eax],edx"\
 "mov  ecx,ebx"\
 "shr  ebx,3"\
 "cmp  ebx,dword ptr 8[eax]"\
 "ja error"\
 "add  ebx,dword ptr 4[eax]"\
 "mov  eax,dword ptr [ebx]"\
 "bswap eax"\
 "and  ecx,7"\
 "shl  eax,cl"\
 "mov  cl,32"\
 "sub  cl,dl"\
 "shr  eax,cl"\
 "endget:"\
 parm [eax][edx] value[eax] modify [eax ebx ecx];

uint_32 ac3dec_getbits(bitstream_t *bs,uint_32 num_bits)
{
 return (asm_getbits(bs,num_bits));
}

#else

#define SWAP_ENDIAN32(x) ( (((unsigned long)x[0])<<24) | \
			   (((unsigned long)x[1])<<16) | \
			   (((unsigned long)x[2])<<8) |  \
			    ((unsigned long)x[3]) )

uint_32 ac3dec_getbits(bitstream_t *bs,uint_32 num_bits)
{
 unsigned long bitindex,tmp,bytepos;
 char *getpos;
 if(!num_bits)
  return 0;
 //if(num_bits&(~31)) // num_bits>31
 // return 0;
 bitindex=bs->bitindex;
 bs->bitindex+=num_bits;
 bytepos=bitindex>>3;
 if(bytepos>bs->stored_bytes)
  return 0;
 getpos=&bs->buffer[bytepos];
 tmp=SWAP_ENDIAN32(getpos);
 bitindex&=7;
 tmp<<=bitindex;
 tmp>>=(32-num_bits);
 return tmp;
}
#endif

void ac3dec_bitstream_reset(bitstream_t *bs)
{
 uint_32 tmp;

 tmp=(bs->bitindex>>3)+1;
 if(bs->stored_bytes>tmp){    // save the left bytes from the previous frame (at bitstream errors)
  bs->store_ptr=tmp;
  bs->stored_bytes-=tmp;
 }else
  bs->stored_bytes=bs->store_ptr=0;
 bs->bitindex=0;
 bs->file = 1;
}
